# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class SoftwareInventoriesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_software_inventory(self, software_inventory, api_version, **kwargs):  # noqa: E501
        """Create a Software Inventory  # noqa: E501

        Request the creation of a new software inventory to use in creating shared rulesets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_software_inventory(software_inventory, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareInventory software_inventory: The settings of the new software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_software_inventory_with_http_info(software_inventory, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_software_inventory_with_http_info(software_inventory, api_version, **kwargs)  # noqa: E501
            return data

    def create_software_inventory_with_http_info(self, software_inventory, api_version, **kwargs):  # noqa: E501
        """Create a Software Inventory  # noqa: E501

        Request the creation of a new software inventory to use in creating shared rulesets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_software_inventory_with_http_info(software_inventory, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareInventory software_inventory: The settings of the new software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_software_inventory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory' is set
        if ('software_inventory' not in params or
                params['software_inventory'] is None):
            raise ValueError("Missing the required parameter `software_inventory` when calling `create_software_inventory`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_software_inventory`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'software_inventory' in params:
            body_params = params['software_inventory']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareInventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_software_inventory(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Delete a Software Inventory  # noqa: E501

        Delete a software inventory by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_software_inventory(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_software_inventory_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_software_inventory_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_software_inventory_with_http_info(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Delete a Software Inventory  # noqa: E501

        Delete a software inventory by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_software_inventory_with_http_info(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_software_inventory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory_id' is set
        if ('software_inventory_id' not in params or
                params['software_inventory_id'] is None):
            raise ValueError("Missing the required parameter `software_inventory_id` when calling `delete_software_inventory`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_software_inventory`")  # noqa: E501

        if 'software_inventory_id' in params and not re.search('\\d+', str(params['software_inventory_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `software_inventory_id` when calling `delete_software_inventory`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'software_inventory_id' in params:
            path_params['softwareInventoryID'] = params['software_inventory_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/{softwareInventoryID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_software_inventory(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Describe a Software Inventory  # noqa: E501

        Describe a software inventory by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_software_inventory(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_software_inventory_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_software_inventory_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_software_inventory_with_http_info(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Describe a Software Inventory  # noqa: E501

        Describe a software inventory by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_software_inventory_with_http_info(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_software_inventory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory_id' is set
        if ('software_inventory_id' not in params or
                params['software_inventory_id'] is None):
            raise ValueError("Missing the required parameter `software_inventory_id` when calling `describe_software_inventory`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_software_inventory`")  # noqa: E501

        if 'software_inventory_id' in params and not re.search('\\d+', str(params['software_inventory_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `software_inventory_id` when calling `describe_software_inventory`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'software_inventory_id' in params:
            path_params['softwareInventoryID'] = params['software_inventory_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/{softwareInventoryID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareInventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_software_inventory_item(self, software_inventory_id, inventory_item_id, api_version, **kwargs):  # noqa: E501
        """Describe a Software Inventory Item  # noqa: E501

        Describe a software inventory item by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_software_inventory_item(software_inventory_id, inventory_item_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param int inventory_item_id: The ID number of the inventory item to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: InventoryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_software_inventory_item_with_http_info(software_inventory_id, inventory_item_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_software_inventory_item_with_http_info(software_inventory_id, inventory_item_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_software_inventory_item_with_http_info(self, software_inventory_id, inventory_item_id, api_version, **kwargs):  # noqa: E501
        """Describe a Software Inventory Item  # noqa: E501

        Describe a software inventory item by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_software_inventory_item_with_http_info(software_inventory_id, inventory_item_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param int inventory_item_id: The ID number of the inventory item to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: InventoryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory_id', 'inventory_item_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_software_inventory_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory_id' is set
        if ('software_inventory_id' not in params or
                params['software_inventory_id'] is None):
            raise ValueError("Missing the required parameter `software_inventory_id` when calling `describe_software_inventory_item`")  # noqa: E501
        # verify the required parameter 'inventory_item_id' is set
        if ('inventory_item_id' not in params or
                params['inventory_item_id'] is None):
            raise ValueError("Missing the required parameter `inventory_item_id` when calling `describe_software_inventory_item`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_software_inventory_item`")  # noqa: E501

        if 'software_inventory_id' in params and not re.search('\\d+', str(params['software_inventory_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `software_inventory_id` when calling `describe_software_inventory_item`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'inventory_item_id' in params and not re.search('\\d+', str(params['inventory_item_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `inventory_item_id` when calling `describe_software_inventory_item`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'software_inventory_id' in params:
            path_params['softwareInventoryID'] = params['software_inventory_id']  # noqa: E501
        if 'inventory_item_id' in params:
            path_params['inventoryItemID'] = params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/{softwareInventoryID}/items/{inventoryItemID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InventoryItem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_software_inventories(self, api_version, **kwargs):  # noqa: E501
        """List Software Inventories  # noqa: E501

        Lists all software inventories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_software_inventories(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_software_inventories_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_software_inventories_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_software_inventories_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Software Inventories  # noqa: E501

        Lists all software inventories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_software_inventories_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: SoftwareInventories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_software_inventories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_software_inventories`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareInventories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_software_inventory_items(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """List Software Inventory Items  # noqa: E501

        Lists all items of a software inventory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_software_inventory_items(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :return: InventoryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_software_inventory_items_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_software_inventory_items_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
            return data

    def list_software_inventory_items_with_http_info(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """List Software Inventory Items  # noqa: E501

        Lists all items of a software inventory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_software_inventory_items_with_http_info(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :return: InventoryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_software_inventory_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory_id' is set
        if ('software_inventory_id' not in params or
                params['software_inventory_id'] is None):
            raise ValueError("Missing the required parameter `software_inventory_id` when calling `list_software_inventory_items`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_software_inventory_items`")  # noqa: E501

        if 'software_inventory_id' in params and not re.search('\\d+', str(params['software_inventory_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `software_inventory_id` when calling `list_software_inventory_items`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'software_inventory_id' in params:
            path_params['softwareInventoryID'] = params['software_inventory_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/{softwareInventoryID}/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InventoryItems',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_software_inventories(self, api_version, **kwargs):  # noqa: E501
        """Search Software Inventories  # noqa: E501

        Search for a software inventory using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_software_inventories(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: SoftwareInventories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_software_inventories_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_software_inventories_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_software_inventories_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search Software Inventories  # noqa: E501

        Search for a software inventory using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_software_inventories_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: SoftwareInventories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_software_inventories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_software_inventories`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareInventories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_software_inventory_items(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Search Software Inventory Items  # noqa: E501

        Search for items of a software inventory using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_software_inventory_items(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: InventoryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_software_inventory_items_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_software_inventory_items_with_http_info(software_inventory_id, api_version, **kwargs)  # noqa: E501
            return data

    def search_software_inventory_items_with_http_info(self, software_inventory_id, api_version, **kwargs):  # noqa: E501
        """Search Software Inventory Items  # noqa: E501

        Search for items of a software inventory using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_software_inventory_items_with_http_info(software_inventory_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int software_inventory_id: The ID number of the software inventory. (required)
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: InventoryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['software_inventory_id', 'api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_software_inventory_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'software_inventory_id' is set
        if ('software_inventory_id' not in params or
                params['software_inventory_id'] is None):
            raise ValueError("Missing the required parameter `software_inventory_id` when calling `search_software_inventory_items`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_software_inventory_items`")  # noqa: E501

        if 'software_inventory_id' in params and not re.search('\\d+', str(params['software_inventory_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `software_inventory_id` when calling `search_software_inventory_items`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'software_inventory_id' in params:
            path_params['softwareInventoryID'] = params['software_inventory_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/softwareinventories/{softwareInventoryID}/items/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InventoryItems',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
