# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class RulesetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ruleset(self, ruleset, softwareinventoryid, api_version, **kwargs):  # noqa: E501
        """Create a Shared Ruleset  # noqa: E501

        Create a new shared ruleset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ruleset(ruleset, softwareinventoryid, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Ruleset ruleset: The settings of the new ruleset. (required)
        :param int softwareinventoryid: ID of the software inventory to base the ruleset on. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ruleset_with_http_info(ruleset, softwareinventoryid, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ruleset_with_http_info(ruleset, softwareinventoryid, api_version, **kwargs)  # noqa: E501
            return data

    def create_ruleset_with_http_info(self, ruleset, softwareinventoryid, api_version, **kwargs):  # noqa: E501
        """Create a Shared Ruleset  # noqa: E501

        Create a new shared ruleset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ruleset_with_http_info(ruleset, softwareinventoryid, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Ruleset ruleset: The settings of the new ruleset. (required)
        :param int softwareinventoryid: ID of the software inventory to base the ruleset on. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset', 'softwareinventoryid', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ruleset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset' is set
        if ('ruleset' not in params or
                params['ruleset'] is None):
            raise ValueError("Missing the required parameter `ruleset` when calling `create_ruleset`")  # noqa: E501
        # verify the required parameter 'softwareinventoryid' is set
        if ('softwareinventoryid' not in params or
                params['softwareinventoryid'] is None):
            raise ValueError("Missing the required parameter `softwareinventoryid` when calling `create_ruleset`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'softwareinventoryid' in params:
            query_params.append(('softwareinventoryid', params['softwareinventoryid']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ruleset' in params:
            body_params = params['ruleset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ruleset(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Delete a Ruleset  # noqa: E501

        Delete a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ruleset_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ruleset_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_ruleset_with_http_info(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Delete a Ruleset  # noqa: E501

        Delete a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset_with_http_info(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ruleset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `delete_ruleset`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_ruleset`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `delete_ruleset`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ruleset_rule(self, ruleset_id, rule_id, api_version, **kwargs):  # noqa: E501
        """Delete a Ruleset Rule  # noqa: E501

        Delete a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset_rule(ruleset_id, rule_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_ruleset_rule_with_http_info(self, ruleset_id, rule_id, api_version, **kwargs):  # noqa: E501
        """Delete a Ruleset Rule  # noqa: E501

        Delete a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'rule_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ruleset_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `delete_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params or
                params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_ruleset_rule`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `delete_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'rule_id' in params and not re.search('\\d+', str(params['rule_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `rule_id` when calling `delete_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501
        if 'rule_id' in params:
            path_params['ruleID'] = params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}/rules/{ruleID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_ruleset(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Describe a Ruleset  # noqa: E501

        Describe a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_ruleset(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_ruleset_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_ruleset_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_ruleset_with_http_info(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Describe a Ruleset  # noqa: E501

        Describe a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_ruleset_with_http_info(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_ruleset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `describe_ruleset`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_ruleset`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `describe_ruleset`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_ruleset_rule(self, ruleset_id, rule_id, api_version, **kwargs):  # noqa: E501
        """Describe a Ruleset Rule  # noqa: E501

        Describe a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_ruleset_rule(ruleset_id, rule_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_ruleset_rule_with_http_info(self, ruleset_id, rule_id, api_version, **kwargs):  # noqa: E501
        """Describe a Ruleset Rule  # noqa: E501

        Describe a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_ruleset_rule_with_http_info(ruleset_id, rule_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'rule_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_ruleset_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `describe_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params or
                params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `describe_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_ruleset_rule`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `describe_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'rule_id' in params and not re.search('\\d+', str(params['rule_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `rule_id` when calling `describe_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501
        if 'rule_id' in params:
            path_params['ruleID'] = params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}/rules/{ruleID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationControlRule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ruleset_rules(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """List Ruleset Rules  # noqa: E501

        List all rules of a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ruleset_rules(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ruleset_rules_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_ruleset_rules_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
            return data

    def list_ruleset_rules_with_http_info(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """List Ruleset Rules  # noqa: E501

        List all rules of a ruleset by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ruleset_rules_with_http_info(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ruleset_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `list_ruleset_rules`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_ruleset_rules`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `list_ruleset_rules`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationControlRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_rulesets(self, api_version, **kwargs):  # noqa: E501
        """List Rulesets  # noqa: E501

        Lists all rulesets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rulesets(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: Rulesets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_rulesets_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_rulesets_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_rulesets_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Rulesets  # noqa: E501

        Lists all rulesets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rulesets_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: Rulesets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_rulesets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_rulesets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rulesets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_ruleset_rule(self, ruleset_id, rule_id, rule, api_version, **kwargs):  # noqa: E501
        """Modify a Ruleset Rule  # noqa: E501

        Modify a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_ruleset_rule(ruleset_id, rule_id, rule, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to modify. (required)
        :param ApplicationControlRule rule: The settings of the rule to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_ruleset_rule_with_http_info(ruleset_id, rule_id, rule, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_ruleset_rule_with_http_info(ruleset_id, rule_id, rule, api_version, **kwargs)  # noqa: E501
            return data

    def modify_ruleset_rule_with_http_info(self, ruleset_id, rule_id, rule, api_version, **kwargs):  # noqa: E501
        """Modify a Ruleset Rule  # noqa: E501

        Modify a ruleset rule by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_ruleset_rule_with_http_info(ruleset_id, rule_id, rule, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param int rule_id: The ID number of the rule to modify. (required)
        :param ApplicationControlRule rule: The settings of the rule to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ApplicationControlRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'rule_id', 'rule', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_ruleset_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `modify_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params or
                params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `modify_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'rule' is set
        if ('rule' not in params or
                params['rule'] is None):
            raise ValueError("Missing the required parameter `rule` when calling `modify_ruleset_rule`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_ruleset_rule`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `modify_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'rule_id' in params and not re.search('\\d+', str(params['rule_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `rule_id` when calling `modify_ruleset_rule`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501
        if 'rule_id' in params:
            path_params['ruleID'] = params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule' in params:
            body_params = params['rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}/rules/{ruleID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationControlRule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_ruleset_rules(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Search Ruleset Rules  # noqa: E501

        Search for ruleset rules using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ruleset_rules(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: ApplicationControlRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_ruleset_rules_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_ruleset_rules_with_http_info(ruleset_id, api_version, **kwargs)  # noqa: E501
            return data

    def search_ruleset_rules_with_http_info(self, ruleset_id, api_version, **kwargs):  # noqa: E501
        """Search Ruleset Rules  # noqa: E501

        Search for ruleset rules using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ruleset_rules_with_http_info(ruleset_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ruleset_id: The ID number of the ruleset. (required)
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: ApplicationControlRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ruleset_id', 'api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_ruleset_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ruleset_id' is set
        if ('ruleset_id' not in params or
                params['ruleset_id'] is None):
            raise ValueError("Missing the required parameter `ruleset_id` when calling `search_ruleset_rules`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_ruleset_rules`")  # noqa: E501

        if 'ruleset_id' in params and not re.search('\\d+', str(params['ruleset_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ruleset_id` when calling `search_ruleset_rules`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ruleset_id' in params:
            path_params['rulesetID'] = params['ruleset_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/{rulesetID}/rules/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationControlRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_rulesets(self, api_version, **kwargs):  # noqa: E501
        """Search Rulesets  # noqa: E501

        Search for rulesets using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_rulesets(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: Rulesets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_rulesets_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_rulesets_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_rulesets_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search Rulesets  # noqa: E501

        Search for rulesets using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_rulesets_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: Rulesets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_rulesets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_rulesets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/rulesets/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rulesets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
