# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class GCPConnectorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_gcp_connector(self, gcp_connector, api_version, **kwargs):  # noqa: E501
        """Create a GCP Connector  # noqa: E501

        Create a new GCP Connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gcp_connector(gcp_connector, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GCPConnector gcp_connector: The settings of the new GCP connector. (required)
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_gcp_connector_with_http_info(gcp_connector, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_gcp_connector_with_http_info(gcp_connector, api_version, **kwargs)  # noqa: E501
            return data

    def create_gcp_connector_with_http_info(self, gcp_connector, api_version, **kwargs):  # noqa: E501
        """Create a GCP Connector  # noqa: E501

        Create a new GCP Connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gcp_connector_with_http_info(gcp_connector, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GCPConnector gcp_connector: The settings of the new GCP connector. (required)
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gcp_connector', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gcp_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gcp_connector' is set
        if ('gcp_connector' not in params or
                params['gcp_connector'] is None):
            raise ValueError("Missing the required parameter `gcp_connector` when calling `create_gcp_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_gcp_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gcp_connector' in params:
            body_params = params['gcp_connector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GCPConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_gcp_connector(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Delete a GCP Connector  # noqa: E501

        Delete a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_gcp_connector(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP Connector to be deleted. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_gcp_connector_with_http_info(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Delete a GCP Connector  # noqa: E501

        Delete a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_gcp_connector_with_http_info(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP Connector to be deleted. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gcp_connector_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_gcp_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gcp_connector_id' is set
        if ('gcp_connector_id' not in params or
                params['gcp_connector_id'] is None):
            raise ValueError("Missing the required parameter `gcp_connector_id` when calling `delete_gcp_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_gcp_connector`")  # noqa: E501

        if 'gcp_connector_id' in params and not re.search('\\d+', str(params['gcp_connector_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gcp_connector_id` when calling `delete_gcp_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gcp_connector_id' in params:
            path_params['gcpConnectorID'] = params['gcp_connector_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors/{gcpConnectorID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_gcp_connector(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Describe a GCP Connector  # noqa: E501

        Describe a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_gcp_connector(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP connector to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_gcp_connector_with_http_info(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Describe a GCP Connector  # noqa: E501

        Describe a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_gcp_connector_with_http_info(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP connector to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gcp_connector_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_gcp_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gcp_connector_id' is set
        if ('gcp_connector_id' not in params or
                params['gcp_connector_id'] is None):
            raise ValueError("Missing the required parameter `gcp_connector_id` when calling `describe_gcp_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_gcp_connector`")  # noqa: E501

        if 'gcp_connector_id' in params and not re.search('\\d+', str(params['gcp_connector_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gcp_connector_id` when calling `describe_gcp_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gcp_connector_id' in params:
            path_params['gcpConnectorID'] = params['gcp_connector_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors/{gcpConnectorID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GCPConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_gcp_connectors(self, api_version, **kwargs):  # noqa: E501
        """List GCP Connectors  # noqa: E501

        List all GCP connectors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_gcp_connectors(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_gcp_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_gcp_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_gcp_connectors_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List GCP Connectors  # noqa: E501

        List all GCP connectors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_gcp_connectors_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: GCPConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_gcp_connectors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_gcp_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GCPConnectors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_gcp_connector(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Modify a GCP Connector  # noqa: E501

        Modify a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_gcp_connector(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP Connector to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :param GCPConnector gcp_connector: The settings of the GCP connector to modify.
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_gcp_connector_with_http_info(gcp_connector_id, api_version, **kwargs)  # noqa: E501
            return data

    def modify_gcp_connector_with_http_info(self, gcp_connector_id, api_version, **kwargs):  # noqa: E501
        """Modify a GCP Connector  # noqa: E501

        Modify a GCP connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_gcp_connector_with_http_info(gcp_connector_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gcp_connector_id: ID number of the GCP Connector to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :param GCPConnector gcp_connector: The settings of the GCP connector to modify.
        :return: GCPConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gcp_connector_id', 'api_version', 'gcp_connector']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_gcp_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gcp_connector_id' is set
        if ('gcp_connector_id' not in params or
                params['gcp_connector_id'] is None):
            raise ValueError("Missing the required parameter `gcp_connector_id` when calling `modify_gcp_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_gcp_connector`")  # noqa: E501

        if 'gcp_connector_id' in params and not re.search('\\d+', str(params['gcp_connector_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gcp_connector_id` when calling `modify_gcp_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gcp_connector_id' in params:
            path_params['gcpConnectorID'] = params['gcp_connector_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gcp_connector' in params:
            body_params = params['gcp_connector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors/{gcpConnectorID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GCPConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_gcp_connectors(self, api_version, **kwargs):  # noqa: E501
        """Search GCP Connectors  # noqa: E501

        Search for GCP connectors using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_gcp_connectors(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: GCPConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_gcp_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_gcp_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_gcp_connectors_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search GCP Connectors  # noqa: E501

        Search for GCP connectors using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_gcp_connectors_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: GCPConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_gcp_connectors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_gcp_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/gcpconnectors/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GCPConnectors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
