# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class ContextsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_context(self, context, api_version, **kwargs):  # noqa: E501
        """Create a Context  # noqa: E501

        Create a new context.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_context(context, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Context context: The settings of the new context. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_context_with_http_info(context, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_context_with_http_info(context, api_version, **kwargs)  # noqa: E501
            return data

    def create_context_with_http_info(self, context, api_version, **kwargs):  # noqa: E501
        """Create a Context  # noqa: E501

        Create a new context.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_context_with_http_info(context, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Context context: The settings of the new context. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context' is set
        if ('context' not in params or
                params['context'] is None):
            raise ValueError("Missing the required parameter `context` when calling `create_context`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_context`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'context' in params:
            body_params = params['context']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Context',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_context(self, context_id, api_version, **kwargs):  # noqa: E501
        """Delete a Context  # noqa: E501

        Delete a context by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_context(context_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_context_with_http_info(context_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_context_with_http_info(context_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_context_with_http_info(self, context_id, api_version, **kwargs):  # noqa: E501
        """Delete a Context  # noqa: E501

        Delete a context by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_context_with_http_info(context_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params or
                params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `delete_context`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_context`")  # noqa: E501

        if 'context_id' in params and not re.search('\\d+', str(params['context_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `context_id` when calling `delete_context`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextID'] = params['context_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts/{contextID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_context(self, context_id, api_version, **kwargs):  # noqa: E501
        """Describe a Context  # noqa: E501

        Describe a context by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_context(context_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_context_with_http_info(context_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_context_with_http_info(context_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_context_with_http_info(self, context_id, api_version, **kwargs):  # noqa: E501
        """Describe a Context  # noqa: E501

        Describe a context by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_context_with_http_info(context_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params or
                params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `describe_context`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_context`")  # noqa: E501

        if 'context_id' in params and not re.search('\\d+', str(params['context_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `context_id` when calling `describe_context`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextID'] = params['context_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts/{contextID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Context',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_contexts(self, api_version, **kwargs):  # noqa: E501
        """List Contexts  # noqa: E501

        Lists all contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_contexts(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: Contexts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_contexts_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_contexts_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_contexts_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Contexts  # noqa: E501

        Lists all contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_contexts_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: Contexts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_contexts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_contexts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contexts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_context(self, context_id, context, api_version, **kwargs):  # noqa: E501
        """Modify a Context  # noqa: E501

        Modify a context by ID. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_context(context_id, context, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to modify. (required)
        :param Context context: The settings of the context to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_context_with_http_info(context_id, context, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_context_with_http_info(context_id, context, api_version, **kwargs)  # noqa: E501
            return data

    def modify_context_with_http_info(self, context_id, context, api_version, **kwargs):  # noqa: E501
        """Modify a Context  # noqa: E501

        Modify a context by ID. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_context_with_http_info(context_id, context, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int context_id: The ID number of the context to modify. (required)
        :param Context context: The settings of the context to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: Context
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'context', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params or
                params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `modify_context`")  # noqa: E501
        # verify the required parameter 'context' is set
        if ('context' not in params or
                params['context'] is None):
            raise ValueError("Missing the required parameter `context` when calling `modify_context`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_context`")  # noqa: E501

        if 'context_id' in params and not re.search('\\d+', str(params['context_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `context_id` when calling `modify_context`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextID'] = params['context_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'context' in params:
            body_params = params['context']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts/{contextID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Context',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_contexts(self, api_version, **kwargs):  # noqa: E501
        """Search Contexts  # noqa: E501

        Search for contexts using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_contexts(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: Contexts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_contexts_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_contexts_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_contexts_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search Contexts  # noqa: E501

        Search for contexts using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_contexts_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: Contexts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_contexts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_contexts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/contexts/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contexts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
