# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient
from deepsecurity.models import ComputerSettings


class ComputersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_computer(self, computer, api_version, **kwargs):  # noqa: E501
        """Create a Computer  # noqa: E501

        Create a new computer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_computer(computer, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Computer computer: The settings of the new computer. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_computer_with_http_info(computer, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_computer_with_http_info(computer, api_version, **kwargs)  # noqa: E501
            return data

    def create_computer_with_http_info(self, computer, api_version, **kwargs):  # noqa: E501
        """Create a Computer  # noqa: E501

        Create a new computer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_computer_with_http_info(computer, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Computer computer: The settings of the new computer. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer', 'api_version', 'expand', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_computer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer' is set
        if ('computer' not in params or
                params['computer'] is None):
            raise ValueError("Missing the required parameter `computer` when calling `create_computer`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_computer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            collection_formats['expand'] = 'multi'  # noqa: E501
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'computer' in params:
            body_params = params['computer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Computer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_computer(self, computer_id, api_version, **kwargs):  # noqa: E501
        """Delete a Computer  # noqa: E501

        Delete a computer by ID. You cannot use this operation to delete a computer that is managed by a connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_computer(computer_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_computer_with_http_info(computer_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_computer_with_http_info(computer_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_computer_with_http_info(self, computer_id, api_version, **kwargs):  # noqa: E501
        """Delete a Computer  # noqa: E501

        Delete a computer by ID. You cannot use this operation to delete a computer that is managed by a connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_computer_with_http_info(computer_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_computer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `delete_computer`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_computer`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `delete_computer`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_computer(self, computer_id, api_version, **kwargs):  # noqa: E501
        """Describe a Computer  # noqa: E501

        Describe a computer by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer(computer_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_computer_with_http_info(computer_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_computer_with_http_info(computer_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_computer_with_http_info(self, computer_id, api_version, **kwargs):  # noqa: E501
        """Describe a Computer  # noqa: E501

        Describe a computer by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer_with_http_info(computer_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'api_version', 'expand', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_computer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `describe_computer`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_computer`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `describe_computer`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            collection_formats['expand'] = 'multi'  # noqa: E501
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Computer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_computer_setting(self, computer_id, name, api_version, **kwargs):  # noqa: E501
        """Describe a Computer Setting  # noqa: E501

        Return the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer_setting(computer_id, name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer. (required)
        :param str name: The name of the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_computer_setting_with_http_info(computer_id, name, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_computer_setting_with_http_info(computer_id, name, api_version, **kwargs)  # noqa: E501
            return data

    def describe_computer_setting_with_http_info(self, computer_id, name, api_version, **kwargs):  # noqa: E501
        """Describe a Computer Setting  # noqa: E501

        Return the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer_setting_with_http_info(computer_id, name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer. (required)
        :param str name: The name of the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'name', 'api_version', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_computer_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `describe_computer_setting`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `describe_computer_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_computer_setting`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `describe_computer_setting`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = ComputerSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in ComputerSettings.attribute_map:
                params['name'] = ComputerSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}/settings/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_computers(self, api_version, **kwargs):  # noqa: E501
        """List Computers  # noqa: E501

        Lists all computers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_computers(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_computers_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_computers_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_computers_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Computers  # noqa: E501

        Lists all computers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_computers_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'expand', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_computers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_computers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            collection_formats['expand'] = 'multi'  # noqa: E501
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Computers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_computer(self, computer_id, computer, api_version, **kwargs):  # noqa: E501
        """Modify a Computer  # noqa: E501

        Modify a computer by ID. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_computer(computer_id, computer, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to modify. (required)
        :param Computer computer: The settings of the computer to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_computer_with_http_info(computer_id, computer, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_computer_with_http_info(computer_id, computer, api_version, **kwargs)  # noqa: E501
            return data

    def modify_computer_with_http_info(self, computer_id, computer, api_version, **kwargs):  # noqa: E501
        """Modify a Computer  # noqa: E501

        Modify a computer by ID. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_computer_with_http_info(computer_id, computer, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the computer to modify. (required)
        :param Computer computer: The settings of the computer to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'computer', 'api_version', 'expand', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_computer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `modify_computer`")  # noqa: E501
        # verify the required parameter 'computer' is set
        if ('computer' not in params or
                params['computer'] is None):
            raise ValueError("Missing the required parameter `computer` when calling `modify_computer`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_computer`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `modify_computer`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            collection_formats['expand'] = 'multi'  # noqa: E501
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'computer' in params:
            body_params = params['computer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Computer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_computer_setting(self, computer_id, name, value, api_version, **kwargs):  # noqa: E501
        """Modify a Computer Setting  # noqa: E501

        Modify the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_computer_setting(computer_id, name, value, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the policy. (required)
        :param str name: The name of the setting. (required)
        :param SettingValue value: The new value for the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_computer_setting_with_http_info(computer_id, name, value, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_computer_setting_with_http_info(computer_id, name, value, api_version, **kwargs)  # noqa: E501
            return data

    def modify_computer_setting_with_http_info(self, computer_id, name, value, api_version, **kwargs):  # noqa: E501
        """Modify a Computer Setting  # noqa: E501

        Modify the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_computer_setting_with_http_info(computer_id, name, value, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the policy. (required)
        :param str name: The name of the setting. (required)
        :param SettingValue value: The new value for the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'name', 'value', 'api_version', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_computer_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `modify_computer_setting`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `modify_computer_setting`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `modify_computer_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_computer_setting`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `modify_computer_setting`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = ComputerSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in ComputerSettings.attribute_map:
                params['name'] = ComputerSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in params:
            body_params = params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}/settings/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_computer_setting(self, computer_id, name, api_version, **kwargs):  # noqa: E501
        """Reset a Computer Setting  # noqa: E501

        Reset the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_computer_setting(computer_id, name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the policy. (required)
        :param str name: The name of the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_computer_setting_with_http_info(computer_id, name, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_computer_setting_with_http_info(computer_id, name, api_version, **kwargs)  # noqa: E501
            return data

    def reset_computer_setting_with_http_info(self, computer_id, name, api_version, **kwargs):  # noqa: E501
        """Reset a Computer Setting  # noqa: E501

        Reset the value for a computer setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_computer_setting_with_http_info(computer_id, name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_id: The ID number of the policy. (required)
        :param str name: The name of the setting. (required)
        :param str api_version: The version of the api being called. (required)
        :param bool overrides: Show the value only if defined for the current computer.
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_id', 'name', 'api_version', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_computer_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_id' is set
        if ('computer_id' not in params or
                params['computer_id'] is None):
            raise ValueError("Missing the required parameter `computer_id` when calling `reset_computer_setting`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `reset_computer_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `reset_computer_setting`")  # noqa: E501

        if 'computer_id' in params and not re.search('\\d+', str(params['computer_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_id` when calling `reset_computer_setting`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_id' in params:
            path_params['computerID'] = params['computer_id']  # noqa: E501
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = ComputerSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in ComputerSettings.attribute_map:
                params['name'] = ComputerSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/{computerID}/settings/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_computers(self, api_version, **kwargs):  # noqa: E501
        """Search Computers  # noqa: E501

        Search for computers using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_computers(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_computers_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_computers_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_computers_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search Computers  # noqa: E501

        Search for computers using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_computers_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :param list[str] expand: Determines the computer information to include in the response. Use \"none\" to retrieve only basic computer information such as policyID and hostName. Use one or several expand options to retrieve a tailored response in addition to the basic information. Use \"all\" to retrieve all of the computer information. The default is \"all\", but we recommend using \"none\" or a limited set of options on all requests to improve performance.
        :param bool overrides: Show only overrides defined for the current computer.
        :return: Computers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter', 'expand', 'overrides']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_computers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_computers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            collection_formats['expand'] = 'multi'  # noqa: E501
        if 'overrides' in params:
            query_params.append(('overrides', params['overrides']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computers/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Computers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
