# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class ComputerMoveTasksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_computer_move_task(self, computer_move_task, api_version, **kwargs):  # noqa: E501
        """Create a Computer Move Task  # noqa: E501

        Create a new computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_computer_move_task(computer_move_task, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComputerMoveTask computer_move_task: The task to move the computers. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_computer_move_task_with_http_info(computer_move_task, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_computer_move_task_with_http_info(computer_move_task, api_version, **kwargs)  # noqa: E501
            return data

    def create_computer_move_task_with_http_info(self, computer_move_task, api_version, **kwargs):  # noqa: E501
        """Create a Computer Move Task  # noqa: E501

        Create a new computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_computer_move_task_with_http_info(computer_move_task, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComputerMoveTask computer_move_task: The task to move the computers. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_move_task', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_computer_move_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_move_task' is set
        if ('computer_move_task' not in params or
                params['computer_move_task'] is None):
            raise ValueError("Missing the required parameter `computer_move_task` when calling `create_computer_move_task`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_computer_move_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'computer_move_task' in params:
            body_params = params['computer_move_task']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computermovetasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComputerMoveTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_computer_move_task(self, computer_move_task_id, api_version, **kwargs):  # noqa: E501
        """Describe a Computer Move Task  # noqa: E501

        Describe a computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer_move_task(computer_move_task_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_move_task_id: The ID number of the computer move task to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_computer_move_task_with_http_info(computer_move_task_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_computer_move_task_with_http_info(computer_move_task_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_computer_move_task_with_http_info(self, computer_move_task_id, api_version, **kwargs):  # noqa: E501
        """Describe a Computer Move Task  # noqa: E501

        Describe a computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_computer_move_task_with_http_info(computer_move_task_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int computer_move_task_id: The ID number of the computer move task to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['computer_move_task_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_computer_move_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'computer_move_task_id' is set
        if ('computer_move_task_id' not in params or
                params['computer_move_task_id'] is None):
            raise ValueError("Missing the required parameter `computer_move_task_id` when calling `describe_computer_move_task`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_computer_move_task`")  # noqa: E501

        if 'computer_move_task_id' in params and not re.search('\\d+', str(params['computer_move_task_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `computer_move_task_id` when calling `describe_computer_move_task`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'computer_move_task_id' in params:
            path_params['computerMoveTaskID'] = params['computer_move_task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computermovetasks/{computerMoveTaskID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComputerMoveTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_computer_move_tasks(self, api_version, **kwargs):  # noqa: E501
        """List Computer Move Tasks  # noqa: E501

        Describe a computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_computer_move_tasks(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_computer_move_tasks_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_computer_move_tasks_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_computer_move_tasks_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Computer Move Tasks  # noqa: E501

        Describe a computer move task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_computer_move_tasks_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: ComputerMoveTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_computer_move_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_computer_move_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computermovetasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComputerMoveTasks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_computer_move_tasks(self, api_version, **kwargs):  # noqa: E501
        """Search Computer Move Tasks  # noqa: E501

        Search for computer move task using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_computer_move_tasks(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: ComputerMoveTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_computer_move_tasks_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.search_computer_move_tasks_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def search_computer_move_tasks_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """Search Computer Move Tasks  # noqa: E501

        Search for computer move task using optional filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_computer_move_tasks_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :param SearchFilter search_filter: A collection of options used to filter the search results.
        :return: ComputerMoveTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version', 'search_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_computer_move_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `search_computer_move_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'search_filter' in params:
            body_params = params['search_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/computermovetasks/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComputerMoveTasks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
