# auto generated by update_py.py

import queue
import time

from collections import defaultdict
from concurrent.futures import ThreadPoolExecutor
from google.protobuf.json_format import MessageToDict, ParseDict

from .helpers.oms_helper import OMSHelper
from .helpers.sqlite_helper import DBHelper
from .pb_msg import message_pb, ErrType, MsgType

from tlclient.linker.constant import FistType
from tlclient.linker.event import Event
from tlclient.linker.fist import Fist

class OrderManagerService(Fist):

    def __init__(self, name, env_name, addr, db_path):
        Fist.__init__(self, name, FistType.ORDER_MANAGER, env_name)

        self.set_master_addr(addr)
        self.create_fist()

        self.set_rep()
        self.set_pub()

        self.oms_helper = OMSHelper()
        self.db_helper = DBHelper(db_path)
        self.msg_queue = queue.Queue()

        # self.oms_helper.init_cached_order(self.db_helper.get_history_order_info())
        # self.oms_helper.init_cached_position(self.db_helper.get_history_position())
        # self.oms_helper.init_cached_capital(self.db_helper.get_history_capital())

        self.thread_pool = ThreadPoolExecutor(5)
        self.thread_pool.submit(self._proc_msg_queue)

    def init_trade(self, router_name):
        self.reg_sub(router_name)
        self.reg_req(router_name)
        self.trade_router = router_name

    def init_market(self, router_name):
        self.reg_sub(router_name)
        self.reg_req(router_name)
        self.market_router = router_name

    def _proc_msg_queue(self):
        while not self.is_stopped() or not self.msg_queue.empty():
            try:
                obj = self.msg_queue.get(timeout=0.1)
                self.logger.debug('[on_pub_frame] (obj){}'.format(obj))
            except queue.Empty:
                time.sleep(0.01)
                continue

            order = None

            if isinstance(obj, message_pb.ReqOrderInsert):
                order = self.oms_helper.on_req_order_insert(obj)
            elif isinstance(obj, message_pb.RspOrderInsert):
                order = self.oms_helper.on_rsp_order_insert(obj)
            elif isinstance(obj, message_pb.ReqOrderCancel):
                self.oms_helper.on_req_order_cancel(obj)
            elif isinstance(obj, message_pb.RspOrderCancel):
                order = self.oms_helper.on_rsp_order_cancel(obj)
            elif isinstance(obj, message_pb.RtnOrder):
                order = self.oms_helper.on_rtn_order(obj)
            elif isinstance(obj, message_pb.RtnTrade):
                self.db_helper.save(obj)
                self.oms_helper.on_rtn_trade(obj)
            elif isinstance(obj, message_pb.GatewayPosition):
                self.db_helper.save(obj)
                self.oms_helper.on_rsp_position(obj)
            elif isinstance(obj, message_pb.RspAccount):
                self.db_helper.save(obj)
                self.oms_helper.on_rsp_account(obj)
            else:
                self.logger.warning("[_proc_msg_queue] cann't parse obj (type){}".format(type(obj)))
                continue

            if order is not None:
                self.db_helper.save(order)

    def on_pub_frame(self, f):
        msg_type = f.get_msg_type()

        if msg_type == MsgType.MSG_TYPE_REQ_ORDER_INSERT:
            obj = f.get_obj(message_pb.ReqOrderInsert)
        elif msg_type == MsgType.MSG_TYPE_RSP_ORDER_INSERT:
            obj = f.get_obj(message_pb.RspOrderInsert)
        elif msg_type == MsgType.MSG_TYPE_REQ_ORDER_CANCEL:
            obj = f.get_obj(message_pb.ReqOrderCancel)
        elif msg_type == MsgType.MSG_TYPE_RSP_ORDER_CANCEL:
            obj = f.get_obj(message_pb.RspOrderCancel)
        elif msg_type == MsgType.MSG_TYPE_RTN_ORDER:
            obj = f.get_obj(message_pb.RtnOrder)
        elif msg_type == MsgType.MSG_TYPE_RTN_TRADE:
            obj = f.get_obj(message_pb.RtnTrade)
        elif msg_type == MsgType.MSG_TYPE_RSP_POSITION:
            obj = f.get_obj(message_pb.GatewayPosition)
        elif msg_type == MsgType.MSG_TYPE_RSP_ACCOUNT:
            obj = f.get_obj(message_pb.RspAccount)
        else:
            return

        self.msg_queue.put(obj)

    def on_req_frame(self, f):
        frame = Event.new_pb_frame()
        msg_type = f.get_msg_type()

        if msg_type == MsgType.MSG_TYPE_REQ_ORDER_INFO:
            obj = f.get_obj(message_pb.ReqOrderInfo)
            data = self.oms_helper.get_order_info(obj.order_id)

            frame.set_msg_type(MsgType.MSG_TYPE_RSP_ORDER_INFO)

        elif msg_type == MsgType.MSG_TYPE_REQ_POSITION:
            obj = f.get_obj(message_pb.ReqPosition)
            data = self.oms_helper.get_position_info(obj.account_id, obj.sub_account)

            frame.set_msg_type(MsgType.MSG_TYPE_RSP_POSITION)

        elif msg_type == MsgType.MSG_TYPE_REQ_ACCOUNT:
            obj = f.get_obj(message_pb.ReqAccount)
            data = self.oms_helper.get_capital_info(obj.account_id, obj.sub_account)

            frame.set_msg_type(MsgType.MSG_TYPE_RSP_ACCOUNT)

        elif msg_type == MsgType.MSG_TYPE_REQ_ACTIVE_ORDERS:
            obj = f.get_obj(message_pb.ReqActiveOrders)
            data = self.oms_helper.get_init_orders(obj.account_id, obj.sub_account)

            frame.set_msg_type(MsgType.MSG_TYPE_RSP_ACTIVE_ORDERS)

        else:
            frame.set_err_id(ErrType.ERR_TYPE_REQ_NOT_IMPLEMENTED)
            return frame

        if data is not None:
            frame.set_err_id(0)
            frame.set_data(data)
        else:
            # TODO: err_id
            frame.set_err_id(-1)

        return frame

    def on_close(self):
        self.db_helper.close()
