import { RemovalPolicy } from 'aws-cdk-lib';
import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
import { Construct } from 'constructs';
/**
 * Properties to initialize an instance of `MicroAppsTable`.
 */
export interface MicroAppsTableProps {
    /**
     * RemovalPolicy override for child resources
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * Application environment, passed as `NODE_ENV`
     * to the Router and Deployer Lambda functions
     */
    readonly appEnv: string;
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
    /**
     * Path prefix on the root of the deployment
     *
     * @example dev/
     * @default none
     */
    readonly rootPathPrefix?: string;
}
/**
 * Represents a MicroAppsTable
 */
export interface IMicroAppsTable {
    /**
     * DynamoDB table used by Router, Deployer, and Release console app
     */
    readonly table: dynamodb.Table;
}
/**
 * Create a new MicroApps Table for apps / versions / rules
 */
export declare class MicroAppsTable extends Construct implements IMicroAppsTable {
    private _table;
    get table(): dynamodb.Table;
    constructor(scope: Construct, id: string, props?: MicroAppsTableProps);
}
//# sourceMappingURL=MicroAppsTable.d.ts.map