"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroApps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const MicroAppsAPIGwy_1 = require("./MicroAppsAPIGwy");
const MicroAppsCF_1 = require("./MicroAppsCF");
const MicroAppsEdgeToOrigin_1 = require("./MicroAppsEdgeToOrigin");
const MicroAppsS3_1 = require("./MicroAppsS3");
const MicroAppsSvcs_1 = require("./MicroAppsSvcs");
const ReverseDomain_1 = require("./utils/ReverseDomain");
/**
 * Create a new MicroApps "turnkey" construct for simple
 * deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a PoC working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 * @warning This construct is not intended for production use.
 * In a production stack the DynamoDB Table, API Gateway, S3 Buckets,
 * etc. should be created in a "durable" stack where the IDs will not
 * change and where changes to the MicroApps construct will not
 * cause failures to deploy or data to be deleted.
 *
 *  @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 */
class MicroApps extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { domainNameEdge, domainNameOrigin, assetNameRoot, assetNameSuffix, r53Zone, certEdge, appEnv = 'dev', certOrigin, removalPolicy, s3PolicyBypassAROAs, s3PolicyBypassPrincipalARNs, s3StrictBucketPolicy, rootPathPrefix, createAPIPathRoute = true, addXForwardedHostHeader = true, replaceHostHeader = true, signingMode = 'sign', originRegion, table, } = props;
        this._s3 = new MicroAppsS3_1.MicroAppsS3(this, 's3', {
            removalPolicy,
            bucketLogsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-logs` : undefined,
            bucketAppsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}` : undefined,
            bucketAppsStagingName: domainNameEdge
                ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-staging`
                : undefined,
            assetNameRoot,
            assetNameSuffix,
        });
        this._apigwy = new MicroAppsAPIGwy_1.MicroAppsAPIGwy(this, 'api', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            r53Zone,
            certOrigin,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
        });
        if (signingMode !== 'none' || replaceHostHeader || addXForwardedHostHeader) {
            this._edgeToOrigin = new MicroAppsEdgeToOrigin_1.MicroAppsEdgeToOrigin(this, 'edgeToOrigin', {
                assetNameRoot,
                assetNameSuffix,
                removalPolicy,
                addXForwardedHostHeader,
                replaceHostHeader,
                originRegion,
                signingMode,
            });
        }
        this._cf = new MicroAppsCF_1.MicroAppsCF(this, 'cft', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            httpApi: this._apigwy.httpApi,
            r53Zone,
            certEdge,
            bucketAppsOrigin: this._s3.bucketAppsOrigin,
            bucketLogs: this._s3.bucketLogs,
            rootPathPrefix,
            createAPIPathRoute,
            edgeToOriginLambdas: this._edgeToOrigin ? this._edgeToOrigin.edgeToOriginLambdas : undefined,
        });
        this._svcs = new MicroAppsSvcs_1.MicroAppsSvcs(this, 'svcs', {
            httpApi: this.apigwy.httpApi,
            removalPolicy,
            bucketApps: this._s3.bucketApps,
            bucketAppsOAI: this._s3.bucketAppsOAI,
            bucketAppsStaging: this._s3.bucketAppsStaging,
            assetNameRoot,
            assetNameSuffix,
            appEnv,
            s3PolicyBypassAROAs,
            s3PolicyBypassPrincipalARNs,
            s3StrictBucketPolicy,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
            table,
        });
    }
    get cf() {
        return this._cf;
    }
    get edgeToOrigin() {
        return this._edgeToOrigin;
    }
    get s3() {
        return this._s3;
    }
    get apigwy() {
        return this._apigwy;
    }
    get svcs() {
        return this._svcs;
    }
}
exports.MicroApps = MicroApps;
_a = JSII_RTTI_SYMBOL_1;
MicroApps[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroApps", version: "0.2.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWljcm9BcHBzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL01pY3JvQXBwcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLDJDQUF1QztBQUN2Qyx1REFBc0U7QUFDdEUsK0NBQTBEO0FBQzFELG1FQUF3RjtBQUN4RiwrQ0FBMEQ7QUFDMUQsbURBQWdFO0FBQ2hFLHlEQUFzRDtBQXdRdEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FtQkc7QUFDSCxNQUFhLFNBQVUsU0FBUSxzQkFBUztJQTBCdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixNQUFNLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUM7U0FDdEM7UUFFRCxNQUFNLEVBQ0osY0FBYyxFQUNkLGdCQUFnQixFQUNoQixhQUFhLEVBQ2IsZUFBZSxFQUNmLE9BQU8sRUFDUCxRQUFRLEVBQ1IsTUFBTSxHQUFHLEtBQUssRUFDZCxVQUFVLEVBQ1YsYUFBYSxFQUNiLG1CQUFtQixFQUNuQiwyQkFBMkIsRUFDM0Isb0JBQW9CLEVBQ3BCLGNBQWMsRUFDZCxrQkFBa0IsR0FBRyxJQUFJLEVBQ3pCLHVCQUF1QixHQUFHLElBQUksRUFDOUIsaUJBQWlCLEdBQUcsSUFBSSxFQUN4QixXQUFXLEdBQUcsTUFBTSxFQUNwQixZQUFZLEVBQ1osS0FBSyxHQUNOLEdBQUcsS0FBSyxDQUFDO1FBRVYsSUFBSSxDQUFDLEdBQUcsR0FBRyxJQUFJLHlCQUFXLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRTtZQUNyQyxhQUFhO1lBQ2IsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDLENBQUMsR0FBRyw2QkFBYSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDcEYsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDLENBQUMsR0FBRyw2QkFBYSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDL0UscUJBQXFCLEVBQUUsY0FBYztnQkFDbkMsQ0FBQyxDQUFDLEdBQUcsNkJBQWEsQ0FBQyxjQUFjLENBQUMsVUFBVTtnQkFDNUMsQ0FBQyxDQUFDLFNBQVM7WUFDYixhQUFhO1lBQ2IsZUFBZTtTQUNoQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksaUNBQWUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQzlDLGFBQWE7WUFDYixhQUFhO1lBQ2IsZUFBZTtZQUNmLGNBQWM7WUFDZCxnQkFBZ0I7WUFDaEIsT0FBTztZQUNQLFVBQVU7WUFDVixjQUFjO1lBQ2QsdUJBQXVCLEVBQUUsV0FBVyxLQUFLLE1BQU07U0FDaEQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxXQUFXLEtBQUssTUFBTSxJQUFJLGlCQUFpQixJQUFJLHVCQUF1QixFQUFFO1lBQzFFLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSw2Q0FBcUIsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUNuRSxhQUFhO2dCQUNiLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYix1QkFBdUI7Z0JBQ3ZCLGlCQUFpQjtnQkFDakIsWUFBWTtnQkFDWixXQUFXO2FBQ1osQ0FBQyxDQUFDO1NBQ0o7UUFDRCxJQUFJLENBQUMsR0FBRyxHQUFHLElBQUkseUJBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQ3RDLGFBQWE7WUFDYixhQUFhO1lBQ2IsZUFBZTtZQUNmLGNBQWM7WUFDZCxnQkFBZ0I7WUFDaEIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTztZQUM3QixPQUFPO1lBQ1AsUUFBUTtZQUNSLGdCQUFnQixFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCO1lBQzNDLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVU7WUFDL0IsY0FBYztZQUNkLGtCQUFrQjtZQUNsQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQzdGLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSw2QkFBYSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDM0MsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTztZQUM1QixhQUFhO1lBQ2IsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVTtZQUMvQixhQUFhLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxhQUFhO1lBQ3JDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsaUJBQWlCO1lBQzdDLGFBQWE7WUFDYixlQUFlO1lBQ2YsTUFBTTtZQUNOLG1CQUFtQjtZQUNuQiwyQkFBMkI7WUFDM0Isb0JBQW9CO1lBQ3BCLGNBQWM7WUFDZCx1QkFBdUIsRUFBRSxXQUFXLEtBQUssTUFBTTtZQUMvQyxLQUFLO1NBQ04sQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQXBIRCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUdELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUdELElBQVcsRUFBRTtRQUNYLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBR0QsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFHRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQzs7QUF4QkgsOEJBdUhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGFjbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcbmltcG9ydCAqIGFzIGR5bmFtb2RiIGZyb20gJ2F3cy1jZGstbGliL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgKiBhcyByNTMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJTWljcm9BcHBzQVBJR3d5LCBNaWNyb0FwcHNBUElHd3kgfSBmcm9tICcuL01pY3JvQXBwc0FQSUd3eSc7XG5pbXBvcnQgeyBJTWljcm9BcHBzQ0YsIE1pY3JvQXBwc0NGIH0gZnJvbSAnLi9NaWNyb0FwcHNDRic7XG5pbXBvcnQgeyBJTWljcm9BcHBzRWRnZVRvT3JpZ2luLCBNaWNyb0FwcHNFZGdlVG9PcmlnaW4gfSBmcm9tICcuL01pY3JvQXBwc0VkZ2VUb09yaWdpbic7XG5pbXBvcnQgeyBJTWljcm9BcHBzUzMsIE1pY3JvQXBwc1MzIH0gZnJvbSAnLi9NaWNyb0FwcHNTMyc7XG5pbXBvcnQgeyBJTWljcm9BcHBzU3ZjcywgTWljcm9BcHBzU3ZjcyB9IGZyb20gJy4vTWljcm9BcHBzU3Zjcyc7XG5pbXBvcnQgeyByZXZlcnNlRG9tYWluIH0gZnJvbSAnLi91dGlscy9SZXZlcnNlRG9tYWluJztcblxuLyoqXG4gKiBBIENESyBDb25zdHJ1Y3QgZm9yIGNyZWF0aW5nIGEgTWljcm9BcHBzIHJ1bnRpbWUgZW52aXJvbm1lbnQgdXNlZFxuICogdG8gaG9zdCBOZXh0LmpzLCBSZWFjdCwgb3IgYW55IG90aGVyIHNvcnQgb2Ygd2ViIGFwcGxpY2F0aW9uIHdpdGhcbiAqIG11bHRpcGxlIHZlcnNpb25zIGF2YWlsYWJsZSBmb3IgY29tcGFyaXNvbiwgcXVpY2sgcm9sbGJhY2tzLCBxdWlja1xuICogcmVsZWFzZXMsIGFuZCBhIGNvbXBsZXRlIGxhY2sgb2YgdXNlciBkaXN0dXJiYW5jZSBvbiBkZXBsb3lzLlxuICpcbiAqIEByZW1hcmtzXG4gKlxuICoge0BsaW5rIE1pY3JvQXBwc30gcHJvdmlkZXMgYSB0dXJuLWtleSBjb25zdHJ1Y3QgdGhhdCBjcmVhdGVzIGFsbFxuICogZGVwZW5kZW5jaWVzIHdpdGggbGltaXRlZCBleHBvc3VyZSBvZiB1bmRlcmx5aW5nIEFXUyBSZXNvdXJjZSBvcHRpb25zLlxuICogVGhpcyBjb25zdHJ1Y3QgaXMgdGhlIGVhc2llc3QgdG8gdXNlIHdoZW4gZXhwbG9yaW5nIE1pY3JvQXBwcyBmb3IgdGhlXG4gKiBmaXJzdCB0aW1lLlxuICpcbiAqIHtAbGluayBNaWNyb0FwcHNBUElHd3l9LCB7QGxpbmsgTWljcm9BcHBzQ0Z9LCB7QGxpbmsgTWljcm9BcHBzUzN9LFxuICogYW5kIHtAbGluayBNaWNyb0FwcHNTdmNzfSwgYW5kIHRoZWlyIGhlbHBlciBzdGF0aWMgbWV0aG9kcywgY2FuIGJlIHVzZWRcbiAqIHRvIGNyZWF0ZSBBV1MgUmVzb3VyY2VzIG1vcmUgZGlyZWN0bHksIHRvIHByb3ZpZGUgeW91ciBvd24gQVdTIFJlc291cmNlc1xuICogKGUuZy4gYW4gZXhpc3RpbmcgQ2xvdWRGcm9udCBEaXN0cmlidXRpb24pLCBhbmQgdG8gaGF2ZSBtb3JlIGZsZXhpYmlsaXR5XG4gKiB0aGFuIHRoZSB7QGxpbmsgTWljcm9BcHBzfSBjb25zdHJ1Y3Qgb2ZmZXJzLlxuICpcbiAqIEBwYWNrYWdlRG9jdW1lbnRhdGlvblxuICovXG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGFuIGluc3RhbmNlIG9mIGBNaWNyb0FwcHNgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE1pY3JvQXBwc1Byb3BzIHtcbiAgLyoqXG4gICAqIFJlbW92YWxQb2xpY3kgb3ZlcnJpZGUgZm9yIGNoaWxkIHJlc291cmNlc1xuICAgKlxuICAgKiBOb3RlOiBpZiBzZXQgdG8gREVTVFJPWSB0aGUgUzMgYnVja2VzIHdpbGwgaGF2ZSBgYXV0b0RlbGV0ZU9iamVjdHNgIHNldCB0byBgdHJ1ZWBcbiAgICpcbiAgICogQGRlZmF1bHQgLSBwZXIgcmVzb3VyY2UgZGVmYXVsdFxuICAgKi9cbiAgcmVhZG9ubHkgcmVtb3ZhbFBvbGljeT86IFJlbW92YWxQb2xpY3k7XG5cbiAgLyoqXG4gICAqIFBhc3NlZCB0byBOT0RFX0VOViBvZiBSb3V0ZXIgYW5kIERlcGxveWVyIExhbWJkYSBmdW5jdGlvbnMuXG4gICAqXG4gICAqIEBkZWZhdWx0IGRldlxuICAgKi9cbiAgcmVhZG9ubHkgYXBwRW52OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIGFzc2V0IG5hbWUgcm9vdFxuICAgKlxuICAgKiBAZXhhbXBsZSBtaWNyb2FwcHNcbiAgICogQGRlZmF1bHQgLSByZXNvdXJjZSBuYW1lcyBhdXRvIGFzc2lnbmVkXG4gICAqL1xuICByZWFkb25seSBhc3NldE5hbWVSb290Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBhc3NldCBuYW1lIHN1ZmZpeFxuICAgKlxuICAgKiBAZXhhbXBsZSAtZGV2LXByLTEyXG4gICAqIEBkZWZhdWx0IG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGFzc2V0TmFtZVN1ZmZpeD86IHN0cmluZztcblxuICAvKipcbiAgICogUm91dGU1MyB6b25lIGluIHdoaWNoIHRvIGNyZWF0ZSBvcHRpb25hbCBgZG9tYWluTmFtZUVkZ2VgIHJlY29yZFxuICAgKi9cbiAgcmVhZG9ubHkgcjUzWm9uZT86IHI1My5JSG9zdGVkWm9uZTtcblxuICAvKipcbiAgICogQ2VydGlmaWNhdGUgaW4gVVMtRWFzdC0xIGZvciB0aGUgQ2xvdWRGcm9udCBkaXN0cmlidXRpb24uXG4gICAqL1xuICByZWFkb25seSBjZXJ0RWRnZT86IGFjbS5JQ2VydGlmaWNhdGU7XG5cbiAgLyoqXG4gICAqIENlcnRpZmljYXRlIGluIGRlcGxveWVkIHJlZ2lvbiBmb3IgdGhlIEFQSSBHYXRld2F5LlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydE9yaWdpbj86IGFjbS5JQ2VydGlmaWNhdGU7XG5cbiAgLyoqXG4gICAqIFVzZSBhIHN0cmljdCBTMyBCdWNrZXQgUG9saWN5IHRoYXQgcHJldmVudHMgYXBwbGljYXRpb25zXG4gICAqIGZyb20gcmVhZGluZy93cml0aW5nL21vZGlmeWluZy9kZWxldGluZyBmaWxlcyBpbiB0aGUgUzMgQnVja2V0XG4gICAqIG91dHNpZGUgb2YgdGhlIHBhdGggdGhhdCBpcyBzcGVjaWZpYyB0byB0aGVpciBhcHAvdmVyc2lvbi5cbiAgICpcbiAgICogVGhpcyBzZXR0aW5nIHNob3VsZCBiZSB1c2VkIHdoZW4gYXBwbGljYXRpb25zIGFyZSBsZXNzIHRoYW5cbiAgICogZnVsbHkgdHJ1c3RlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHMzU3RyaWN0QnVja2V0UG9saWN5PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQXBwbGllcyB3aGVuIHVzaW5nIHMzU3RyaWN0QnVja2V0UG9saWN5ID0gdHJ1ZVxuICAgKlxuICAgKiBJQU0gUm9sZSBvciBJQU0gVXNlciBuYW1lcyB0byBleGNsdWRlIGZyb20gdGhlIERFTlkgcnVsZXMgb24gdGhlIFMzIEJ1Y2tldCBQb2xpY3kuXG4gICAqXG4gICAqIFJvbGVzIHRoYXQgYXJlIEFzc3VtZWQgbXVzdCBpbnN0ZWFkIGhhdmUgdGhlaXIgQVJPQSBhZGRlZCB0byBgczNQb2xpY3lCeXBhc3NBUk9Bc2AuXG4gICAqXG4gICAqIFR5cGljYWxseSBhbnkgYWRtaW4gcm9sZXMgLyB1c2VycyB0aGF0IG5lZWQgdG8gdmlldyBvciBtYW5hZ2UgdGhlIFMzIEJ1Y2tldFxuICAgKiB3b3VsZCBiZSBhZGRlZCB0byB0aGlzIGxpc3QuXG4gICAqXG4gICAqIEBleGFtcGxlIFsnYXJuOmF3czppYW06OjEyMzQ1Njc4OTAxMjM6cm9sZS9BZG1pbkFjY2VzcycsICdhcm46YXdzOmlhbTo6MTIzNDU2Nzg5MDEyMzp1c2VyL015QWRtaW5Vc2VyJ11cbiAgICpcbiAgICogQHNlZSBzM1BvbGljeUJ5cGFzc0FST0FzXG4gICAqL1xuICByZWFkb25seSBzM1BvbGljeUJ5cGFzc1ByaW5jaXBhbEFSTnM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogQXBwbGllcyB3aGVuIHVzaW5nIHMzU3RyaWN0QnVja2V0UG9saWN5ID0gdHJ1ZVxuICAgKlxuICAgKiBBUk9BcyBvZiB0aGUgSUFNIFJvbGUgdG8gZXhjbHVkZSBmcm9tIHRoZSBERU5ZIHJ1bGVzIG9uIHRoZSBTMyBCdWNrZXQgUG9saWN5LlxuICAgKiBUaGlzIGFsbG93cyBzZXNzaW9ucyB0aGF0IGFzc3VtZSB0aGUgSUFNIFJvbGUgdG8gYmUgZXhjbHVkZWQgZnJvbSB0aGVcbiAgICogREVOWSBydWxlcyBvbiB0aGUgUzMgQnVja2V0IFBvbGljeS5cbiAgICpcbiAgICogVHlwaWNhbGx5IGFueSBhZG1pbiByb2xlcyAvIHVzZXJzIHRoYXQgbmVlZCB0byB2aWV3IG9yIG1hbmFnZSB0aGUgUzMgQnVja2V0XG4gICAqIHdvdWxkIGJlIGFkZGVkIHRvIHRoaXMgbGlzdC5cbiAgICpcbiAgICogUm9sZXMgLyB1c2VycyB0aGF0IGFyZSB1c2VkIGRpcmVjdGx5LCBub3QgYXNzdW1lZCwgY2FuIGJlIGFkZGVkIHRvIGBzM1BvbGljeUJ5cGFzc1JvbGVOYW1lc2AgaW5zdGVhZC5cbiAgICpcbiAgICogTm90ZTogVGhpcyBBUk9BIG11c3QgYmUgc3BlY2lmaWVkIHRvIHByZXZlbnQgdGhpcyBwb2xpY3kgZnJvbSBsb2NraW5nXG4gICAqIG91dCBub24tcm9vdCBzZXNzaW9ucyB0aGF0IGhhdmUgYXNzdW1lZCB0aGUgYWRtaW4gcm9sZS5cbiAgICpcbiAgICogVGhlIG5vdFByaW5jaXBhbHMgd2lsbCBvbmx5IG1hdGNoIHRoZSByb2xlIG5hbWUgZXhhY3RseSBhbmQgd2lsbCBub3QgbWF0Y2hcbiAgICogYW55IHNlc3Npb24gdGhhdCBoYXMgYXNzdW1lZCB0aGUgcm9sZSBzaW5jZSBub3RQcmluY2lwYWxzIGRvZXMgbm90IGFsbG93XG4gICAqIHdpbGRjYXJkIG1hdGNoZXMgYW5kIGRvZXMgbm90IGRvIHdpbGRjYXJkIG1hdGNoZXMgaW1wbGljaXRseSBlaXRoZXIuXG4gICAqXG4gICAqIFRoZSBBUk9BIG11c3QgYmUgdXNlZCBiZWNhdXNlIHRoZXJlIGFyZSBvbmx5IDMgUHJpbmNpcGFsIHZhcmlhYmxlcyBhdmFpbGFibGU6XG4gICAqICBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX3ZhcmlhYmxlcy5odG1sI3ByaW5jaXBhbHRhYmxlXG4gICAqICBhd3M6dXNlcm5hbWUsIGF3czp1c2VyaWQsIGF3czpQcmluY2lwYWxUYWdcbiAgICpcbiAgICogRm9yIGFuIGFzc3VtZWQgcm9sZSwgYXdzOnVzZXJuYW1lIGlzIGJsYW5rLCBhd3M6dXNlcmlkIGlzOlxuICAgKiAgW3VuaXF1ZSBpZCBBS0EgQVJPQSBmb3IgUm9sZV06W3Nlc3Npb24gbmFtZV1cbiAgICpcbiAgICogVGFibGUgb2YgdW5pcXVlIElEIHByZWZpeGVzIHN1Y2ggYXMgQVJPQTpcbiAgICogIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfaWRlbnRpZmllcnMuaHRtbCNpZGVudGlmaWVycy1wcmVmaXhlc1xuICAgKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgcm9sZSBpcyBzaW1wbHkgbm90IGF2YWlsYWJsZSBmb3IgYW4gYXNzdW1lZCByb2xlIGFuZCwgaWYgaXQgd2FzLFxuICAgKiBhIGNvbXBsaWNhdGVkIGNvbXBhcmlzb24gd291bGQgYmUgcmVxdWllcmQgdG8gcHJldmVudCBleGNsdXNpb25cbiAgICogb2YgYXBwbHlpbmcgdGhlIERlbnkgUnVsZSB0byByb2xlcyBmcm9tIG90aGVyIGFjY291bnRzLlxuICAgKlxuICAgKiBUbyBnZXQgdGhlIEFST0Egd2l0aCB0aGUgQVdTIENMSTpcbiAgICogICBhd3MgaWFtIGdldC1yb2xlIC0tcm9sZS1uYW1lIFJPTEUtTkFNRVxuICAgKiAgIGF3cyBpYW0gZ2V0LXVzZXIgLeKAk3VzZXItbmFtZSBVU0VSLU5BTUVcbiAgICpcbiAgICogQGV4YW1wbGUgWyAnQVJPQTEyMzQ1Njc4OTAxMjMnIF1cbiAgICpcbiAgICogQHNlZSBzM1N0cmljdEJ1Y2tldFBvbGljeVxuICAgKi9cbiAgcmVhZG9ubHkgczNQb2xpY3lCeXBhc3NBUk9Bcz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBjdXN0b20gZG9tYWluIG5hbWUgZm9yIHRoZSBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogQGV4YW1wbGUgYXBwcy5wd3JkcnZyLmNvbVxuICAgKiBAZGVmYXVsdCBhdXRvLWFzc2lnbmVkXG4gICAqL1xuICByZWFkb25seSBkb21haW5OYW1lRWRnZT86IHN0cmluZztcblxuICAvKipcbiAgICogT3B0aW9uYWwgY3VzdG9tIGRvbWFpbiBuYW1lIGZvciB0aGUgQVBJIEdhdGV3YXkgSFRUUHYyIEFQSS5cbiAgICpcbiAgICogQGV4YW1wbGUgYXBwcy1vcmlnaW4ucHdyZHJ2ci5jb21cbiAgICogQGRlZmF1bHQgYXV0by1hc3NpZ25lZFxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZU9yaWdpbj86IHN0cmluZztcblxuICAvKipcbiAgICogUGF0aCBwcmVmaXggb24gdGhlIHJvb3Qgb2YgdGhlIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uXG4gICAqXG4gICAqIEBleGFtcGxlIGRldi9cbiAgICovXG4gIHJlYWRvbmx5IHJvb3RQYXRoUHJlZml4Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDcmVhdGUgYW4gZXh0cmEgQmVoYXZpb3IgKFJvdXRlKSBmb3IgL2FwaS8gdGhhdCBhbGxvd3NcbiAgICogQVBJIHJvdXRlcyB0byBoYXZlIGEgcGVyaW9kIGluIHRoZW0uXG4gICAqXG4gICAqIFdoZW4gZmFsc2UgQVBJIHJvdXRlcyB3aXRoIGEgcGVyaW9kIGluIHRoZSBwYXRoIHdpbGwgZ2V0IHJvdXRlZCB0byBTMy5cbiAgICpcbiAgICogV2hlbiB0cnVlIEFQSSByb3V0ZXMgdGhhdCBjb250YWluIC9hcGkvIGluIHRoZSBwYXRoIHdpbGwgZ2V0IHJvdXRlZCB0byBBUEkgR2F0ZXdheVxuICAgKiBldmVuIGlmIHRoZXkgaGF2ZSBhIHBlcmlvZCBpbiB0aGUgcGF0aC5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRlQVBJUGF0aFJvdXRlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQWRkcyBhbiBYLUZvcndhcmRlZC1Ib3N0LUhlYWRlciB3aGVuIGNhbGxpbmcgQVBJIEdhdGV3YXlcbiAgICpcbiAgICogQ2FuIG9ubHkgYmUgdHJ1c3RlZCBpZiBgc2lnbmluZ01vZGVgIGlzIGVuYWJsZWQsIHdoaWNoIHJlc3RyaWN0c1xuICAgKiBhY2Nlc3MgdG8gQVBJIEdhdGV3YXkgdG8gb25seSBJQU0gc2lnbmVkIHJlcXVlc3RzLlxuICAgKlxuICAgKiBOb3RlOiBpZiB0cnVlLCBjcmVhdGVzIE9yaWdpblJlcXVlc3QgTGFtYmRhIEAgRWRnZSBmdW5jdGlvbiBmb3IgQVBJIEdhdGV3YXkgT3JpZ2luXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGFkZFhGb3J3YXJkZWRIb3N0SGVhZGVyPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogUmVwbGFjZXMgSG9zdCBoZWFkZXIgKHdoaWNoIHdpbGwgYmUgdGhlIEVkZ2UgZG9tYWluIG5hbWUpIHdpdGggdGhlIE9yaWdpbiBkb21haW4gbmFtZVxuICAgKiB3aGVuIGVuYWJsZWQuICBUaGlzIGlzIG5lY2Vzc2FyeSB3aGVuIEFQSSBHYXRld2F5IGhhcyBub3QgYmVlbiBjb25maWd1cmVkXG4gICAqIHdpdGggYSBjdXN0b20gZG9tYWluIG5hbWUgdGhhdCBtYXRjaGVzIHRoZSBleGFjdCBkb21haW4gbmFtZSB1c2VkIGJ5IHRoZSBDbG91ZEZyb250XG4gICAqIERpc3RyaWJ1dGlvbiBBTkQgd2hlbiB0aGUgT3JpZ2luUmVxdWVzdFBvbGljeS5IZWFkZXJzQmVoYXZpb3IgaXMgc2V0XG4gICAqIHRvIHBhc3MgYWxsIGhlYWRlcnMgdG8gdGhlIG9yaWdpbi5cbiAgICpcbiAgICogTm90ZTogaWYgdHJ1ZSwgY3JlYXRlcyBPcmlnaW5SZXF1ZXN0IExhbWJkYSBAIEVkZ2UgZnVuY3Rpb24gZm9yIEFQSSBHYXRld2F5IE9yaWdpblxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSByZXBsYWNlSG9zdEhlYWRlcj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFJlcXVpcmVzIElBTSBhdXRoIG9uIHRoZSBBUEkgR2F0ZXdheSBvcmlnaW4gaWYgbm90IHNldCB0byAnbm9uZScuXG4gICAqXG4gICAqICdzaWduJyAtIFVzZXMgcmVxdWVzdCBoZWFkZXJzIGZvciBhdXRoLlxuICAgKiAncHJlc2lnbicgLSBVc2VzIHF1ZXJ5IHN0cmluZyBmb3IgYXV0aC5cbiAgICpcbiAgICogSWYgZW5hYmxlZCxcbiAgICpcbiAgICogTm90ZTogaWYgJ3NpZ24nIG9yICdwcmVzaWduJywgY3JlYXRlcyBPcmlnaW5SZXF1ZXN0IExhbWJkYSBAIEVkZ2UgZnVuY3Rpb24gZm9yIEFQSSBHYXRld2F5IE9yaWdpblxuICAgKiBAZGVmYXVsdCAnc2lnbidcbiAgICovXG4gIHJlYWRvbmx5IHNpZ25pbmdNb2RlPzogJ3NpZ24nIHwgJ3ByZXNpZ24nIHwgJ25vbmUnO1xuXG4gIC8qKlxuICAgKiBPcmlnaW4gcmVnaW9uIHRoYXQgQVBJIEdhdGV3YXkgd2lsbCBiZSBkZXBsb3llZCB0bywgdXNlZFxuICAgKiBmb3IgdGhlIGNvbmZpZy55bWwgb24gdGhlIEVkZ2UgZnVuY3Rpb24gdG8gc2lnbiByZXF1ZXN0cyBmb3JcbiAgICogdGhlIGNvcnJlY3QgcmVnaW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZFxuICAgKi9cbiAgcmVhZG9ubHkgb3JpZ2luUmVnaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBFeGlzdGluZyB0YWJsZSBmb3IgYXBwcy92ZXJzaW9ucy9ydWxlc1xuICAgKlxuICAgKiBAd2FybmluZyAtIEl0IGlzICpzdHJvbmdseSogc3VnZ2VzdGVkIHRoYXQgcHJvZHVjdGlvbiBzdGFja3MgY3JlYXRlXG4gICAqIHRoZWlyIG93biBEeW5hbW9EQiBUYWJsZSBhbmQgcGFzcyBpdCBpbnRvIHRoaXMgY29uc3RydWN0LCBmb3IgcHJvdGVjdGlvblxuICAgKiBhZ2FpbnN0IGRhdGEgbG9zcyBkdWUgdG8gbG9naWNhbCBJRCBjaGFuZ2VzLCB0aGUgYWJpbGl0eSB0byBjb25maWd1cmVcbiAgICogUHJvdmlzaW9uZWQgY2FwYWNpdHkgd2l0aCBBdXRvIFNjYWxpbmcsIHRoZSBhYmlsaXR5IHRvIGFkZCBhZGRpdGlvbmFsIGluZGljZXMsIGV0Yy5cbiAgICpcbiAgICogUmVxdWlyZW1lbnRzOlxuICAgKiAtIEhhc2ggS2V5OiBgUEtgXG4gICAqIC0gU29ydCBLZXk6IGBTS2BcbiAgICpcbiAgICogQGRlZmF1bHQgY3JlYXRlZCBieSBjb25zdHJ1Y3RcbiAgICovXG4gIHJlYWRvbmx5IHRhYmxlPzogZHluYW1vZGIuSVRhYmxlO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBNaWNyb0FwcHNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTWljcm9BcHBzIHtcbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzQ0Z9ICovXG4gIHJlYWRvbmx5IGNmOiBJTWljcm9BcHBzQ0Y7XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzRWRnZVRvT3JpZ2lufSAqL1xuICByZWFkb25seSBlZGdlVG9PcmlnaW4/OiBJTWljcm9BcHBzRWRnZVRvT3JpZ2luO1xuXG4gIC8qKiB7QGluaGVyaXRkb2MgSU1pY3JvQXBwc1MzfSAqL1xuICByZWFkb25seSBzMzogSU1pY3JvQXBwc1MzO1xuXG4gIC8qKiB7QGluaGVyaXRkb2MgSU1pY3JvQXBwc1N2Y3N9ICovXG4gIHJlYWRvbmx5IHN2Y3M6IElNaWNyb0FwcHNTdmNzO1xuXG4gIC8qKiB7QGluaGVyaXRkb2MgSU1pY3JvQXBwc0FQSUd3eX0gKi9cbiAgcmVhZG9ubHkgYXBpZ3d5OiBJTWljcm9BcHBzQVBJR3d5O1xufVxuXG4vKipcbiAqIENyZWF0ZSBhIG5ldyBNaWNyb0FwcHMgXCJ0dXJua2V5XCIgY29uc3RydWN0IGZvciBzaW1wbGVcbiAqIGRlcGxveW1lbnRzIGFuZCBmb3IgaW5pdGlhbCBldmF1bGF0aW9uIG9mIHRoZSBNaWNyb0FwcHMgZnJhbWV3b3JrLlxuICpcbiAqIFVzZSB0aGlzIGNvbnN0cnVjdCB0byBjcmVhdGUgYSBQb0Mgd29ya2luZyBlbnRpcmUgc3RhY2suXG4gKlxuICogRG8gbm90IHVzZSB0aGlzIGNvbnN0cnVjdCB3aGVuIGFkZGluZyBNaWNyb0FwcHMgdG8gYW4gZXhpc3RpbmdcbiAqIENsb3VkRnJvbnQsIEFQSSBHYXRld2F5LCBTMyBCdWNrZXQsIGV0Yy4gb3Igd2hlcmUgYWNjZXNzXG4gKiB0byBhbGwgZmVhdHVyZXMgb2YgdGhlIEFXUyBSZXNvdXJjZXMgYXJlIG5lZWRlZCAoZS5nLiB0b1xuICogYWRkIGFkZGl0aW9uYWwgQmVoYXZpb3JzIHRvIHRoZSBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbiwgc2V0IGF1dGhvcml6b3JzXG4gKiBvbiBBUEkgR2F0ZXdheSwgZXRjLikuXG4gKlxuICogQHdhcm5pbmcgVGhpcyBjb25zdHJ1Y3QgaXMgbm90IGludGVuZGVkIGZvciBwcm9kdWN0aW9uIHVzZS5cbiAqIEluIGEgcHJvZHVjdGlvbiBzdGFjayB0aGUgRHluYW1vREIgVGFibGUsIEFQSSBHYXRld2F5LCBTMyBCdWNrZXRzLFxuICogZXRjLiBzaG91bGQgYmUgY3JlYXRlZCBpbiBhIFwiZHVyYWJsZVwiIHN0YWNrIHdoZXJlIHRoZSBJRHMgd2lsbCBub3RcbiAqIGNoYW5nZSBhbmQgd2hlcmUgY2hhbmdlcyB0byB0aGUgTWljcm9BcHBzIGNvbnN0cnVjdCB3aWxsIG5vdFxuICogY2F1c2UgZmFpbHVyZXMgdG8gZGVwbG95IG9yIGRhdGEgdG8gYmUgZGVsZXRlZC5cbiAqXG4gKiAgQHNlZSB7QGxpbmsgaHR0cHM6Ly9naXRodWIuY29tL3B3cmRydnIvbWljcm9hcHBzLWNvcmUvYmxvYi9tYWluL3BhY2thZ2VzL2Nkay9saWIvTWljcm9BcHBzLnRzIHwgZXhhbXBsZSB1c2FnZSBpbiBhIENESyBTdGFjayB9XG4gKi9cbmV4cG9ydCBjbGFzcyBNaWNyb0FwcHMgZXh0ZW5kcyBDb25zdHJ1Y3QgaW1wbGVtZW50cyBJTWljcm9BcHBzIHtcbiAgcHJpdmF0ZSBfY2Y6IE1pY3JvQXBwc0NGO1xuICBwdWJsaWMgZ2V0IGNmKCk6IElNaWNyb0FwcHNDRiB7XG4gICAgcmV0dXJuIHRoaXMuX2NmO1xuICB9XG5cbiAgcHJpdmF0ZSBfZWRnZVRvT3JpZ2luPzogTWljcm9BcHBzRWRnZVRvT3JpZ2luO1xuICBwdWJsaWMgZ2V0IGVkZ2VUb09yaWdpbigpOiBJTWljcm9BcHBzRWRnZVRvT3JpZ2luIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fZWRnZVRvT3JpZ2luO1xuICB9XG5cbiAgcHJpdmF0ZSBfczM6IE1pY3JvQXBwc1MzO1xuICBwdWJsaWMgZ2V0IHMzKCk6IElNaWNyb0FwcHNTMyB7XG4gICAgcmV0dXJuIHRoaXMuX3MzO1xuICB9XG5cbiAgcHJpdmF0ZSBfYXBpZ3d5OiBNaWNyb0FwcHNBUElHd3k7XG4gIHB1YmxpYyBnZXQgYXBpZ3d5KCk6IElNaWNyb0FwcHNBUElHd3kge1xuICAgIHJldHVybiB0aGlzLl9hcGlnd3k7XG4gIH1cblxuICBwcml2YXRlIF9zdmNzOiBNaWNyb0FwcHNTdmNzO1xuICBwdWJsaWMgZ2V0IHN2Y3MoKTogSU1pY3JvQXBwc1N2Y3Mge1xuICAgIHJldHVybiB0aGlzLl9zdmNzO1xuICB9XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBNaWNyb0FwcHNQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBpZiAocHJvcHMgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdwcm9wcyBtdXN0IGJlIHNldCcpO1xuICAgIH1cblxuICAgIGNvbnN0IHtcbiAgICAgIGRvbWFpbk5hbWVFZGdlLFxuICAgICAgZG9tYWluTmFtZU9yaWdpbixcbiAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICBhc3NldE5hbWVTdWZmaXgsXG4gICAgICByNTNab25lLFxuICAgICAgY2VydEVkZ2UsXG4gICAgICBhcHBFbnYgPSAnZGV2JyxcbiAgICAgIGNlcnRPcmlnaW4sXG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgczNQb2xpY3lCeXBhc3NBUk9BcyxcbiAgICAgIHMzUG9saWN5QnlwYXNzUHJpbmNpcGFsQVJOcyxcbiAgICAgIHMzU3RyaWN0QnVja2V0UG9saWN5LFxuICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICBjcmVhdGVBUElQYXRoUm91dGUgPSB0cnVlLFxuICAgICAgYWRkWEZvcndhcmRlZEhvc3RIZWFkZXIgPSB0cnVlLFxuICAgICAgcmVwbGFjZUhvc3RIZWFkZXIgPSB0cnVlLFxuICAgICAgc2lnbmluZ01vZGUgPSAnc2lnbicsXG4gICAgICBvcmlnaW5SZWdpb24sXG4gICAgICB0YWJsZSxcbiAgICB9ID0gcHJvcHM7XG5cbiAgICB0aGlzLl9zMyA9IG5ldyBNaWNyb0FwcHNTMyh0aGlzLCAnczMnLCB7XG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgYnVja2V0TG9nc05hbWU6IGRvbWFpbk5hbWVFZGdlID8gYCR7cmV2ZXJzZURvbWFpbihkb21haW5OYW1lRWRnZSl9LWxvZ3NgIDogdW5kZWZpbmVkLFxuICAgICAgYnVja2V0QXBwc05hbWU6IGRvbWFpbk5hbWVFZGdlID8gYCR7cmV2ZXJzZURvbWFpbihkb21haW5OYW1lRWRnZSl9YCA6IHVuZGVmaW5lZCxcbiAgICAgIGJ1Y2tldEFwcHNTdGFnaW5nTmFtZTogZG9tYWluTmFtZUVkZ2VcbiAgICAgICAgPyBgJHtyZXZlcnNlRG9tYWluKGRvbWFpbk5hbWVFZGdlKX0tc3RhZ2luZ2BcbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgIH0pO1xuICAgIHRoaXMuX2FwaWd3eSA9IG5ldyBNaWNyb0FwcHNBUElHd3kodGhpcywgJ2FwaScsIHtcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgZG9tYWluTmFtZUVkZ2UsXG4gICAgICBkb21haW5OYW1lT3JpZ2luLFxuICAgICAgcjUzWm9uZSxcbiAgICAgIGNlcnRPcmlnaW4sXG4gICAgICByb290UGF0aFByZWZpeCxcbiAgICAgIHJlcXVpcmVJQU1BdXRob3JpemF0aW9uOiBzaWduaW5nTW9kZSAhPT0gJ25vbmUnLFxuICAgIH0pO1xuICAgIGlmIChzaWduaW5nTW9kZSAhPT0gJ25vbmUnIHx8IHJlcGxhY2VIb3N0SGVhZGVyIHx8IGFkZFhGb3J3YXJkZWRIb3N0SGVhZGVyKSB7XG4gICAgICB0aGlzLl9lZGdlVG9PcmlnaW4gPSBuZXcgTWljcm9BcHBzRWRnZVRvT3JpZ2luKHRoaXMsICdlZGdlVG9PcmlnaW4nLCB7XG4gICAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICAgIGFzc2V0TmFtZVN1ZmZpeCxcbiAgICAgICAgcmVtb3ZhbFBvbGljeSxcbiAgICAgICAgYWRkWEZvcndhcmRlZEhvc3RIZWFkZXIsXG4gICAgICAgIHJlcGxhY2VIb3N0SGVhZGVyLFxuICAgICAgICBvcmlnaW5SZWdpb24sXG4gICAgICAgIHNpZ25pbmdNb2RlLFxuICAgICAgfSk7XG4gICAgfVxuICAgIHRoaXMuX2NmID0gbmV3IE1pY3JvQXBwc0NGKHRoaXMsICdjZnQnLCB7XG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgYXNzZXROYW1lUm9vdCxcbiAgICAgIGFzc2V0TmFtZVN1ZmZpeCxcbiAgICAgIGRvbWFpbk5hbWVFZGdlLFxuICAgICAgZG9tYWluTmFtZU9yaWdpbixcbiAgICAgIGh0dHBBcGk6IHRoaXMuX2FwaWd3eS5odHRwQXBpLFxuICAgICAgcjUzWm9uZSxcbiAgICAgIGNlcnRFZGdlLFxuICAgICAgYnVja2V0QXBwc09yaWdpbjogdGhpcy5fczMuYnVja2V0QXBwc09yaWdpbixcbiAgICAgIGJ1Y2tldExvZ3M6IHRoaXMuX3MzLmJ1Y2tldExvZ3MsXG4gICAgICByb290UGF0aFByZWZpeCxcbiAgICAgIGNyZWF0ZUFQSVBhdGhSb3V0ZSxcbiAgICAgIGVkZ2VUb09yaWdpbkxhbWJkYXM6IHRoaXMuX2VkZ2VUb09yaWdpbiA/IHRoaXMuX2VkZ2VUb09yaWdpbi5lZGdlVG9PcmlnaW5MYW1iZGFzIDogdW5kZWZpbmVkLFxuICAgIH0pO1xuICAgIHRoaXMuX3N2Y3MgPSBuZXcgTWljcm9BcHBzU3Zjcyh0aGlzLCAnc3ZjcycsIHtcbiAgICAgIGh0dHBBcGk6IHRoaXMuYXBpZ3d5Lmh0dHBBcGksXG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgYnVja2V0QXBwczogdGhpcy5fczMuYnVja2V0QXBwcyxcbiAgICAgIGJ1Y2tldEFwcHNPQUk6IHRoaXMuX3MzLmJ1Y2tldEFwcHNPQUksXG4gICAgICBidWNrZXRBcHBzU3RhZ2luZzogdGhpcy5fczMuYnVja2V0QXBwc1N0YWdpbmcsXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgYXBwRW52LFxuICAgICAgczNQb2xpY3lCeXBhc3NBUk9BcyxcbiAgICAgIHMzUG9saWN5QnlwYXNzUHJpbmNpcGFsQVJOcyxcbiAgICAgIHMzU3RyaWN0QnVja2V0UG9saWN5LFxuICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICByZXF1aXJlSUFNQXV0aG9yaXphdGlvbjogc2lnbmluZ01vZGUgIT09ICdub25lJyxcbiAgICAgIHRhYmxlLFxuICAgIH0pO1xuICB9XG59XG4iXX0=