# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['matterapi',
 'matterapi.driver',
 'matterapi.endpoints',
 'matterapi.endpoints.async_api',
 'matterapi.endpoints.sync_api']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.21.0,<0.22.0',
 'pydantic>=1.9.0,<2.0.0',
 'python-dateutil>=2.8.0,<3.0.0',
 'websockets>=10.0,<11.0']

setup_kwargs = {
    'name': 'matterapi',
    'version': '0.1.0',
    'description': 'A client library for accessing Mattermost API supporting sync/async',
    'long_description': '# MatterApi\n\nA python client library for accessing the Mattermost API with sync/async support.\n\n\n## Features\n+ Endpoints generated from the [API documentation](https://api.mattermost.com/)\n  - However: if the description is wrong, this library will be wrong\n+ Based on [httpx](https://www.python-httpx.org/) and supports sync and async operation\n+ Response parsing into models with [pydantic](https://pydantic-docs.helpmanual.io/)\n+ Typing support\n+ Websocket handling to connect to the Mattermost event stream.\n\n## Getting Started\n\nThe driver has synch and async support. Depending on your workflow you will want to choose between\nthe `SyncDriver` and `AsyncDriver`.\n\n\n### SyncDriver\n\nFirst, let\'s look at an example on how to use the SyncDriver:\n\n```python\n\nfrom matterapi import SyncDriver\n\n# set the options for the driver\noptions = { \'url\' : \'http://localhost:8095\',\n    \'auth\' : { \n      \'token\' : \'<yourtokenhere>\' \n      }\n}\n\n# Create a sync driver\nsd = SyncDriver(options=options)\n\n# Call login to:\n# 1. Get a session token if you use user:password based auth\n# 2. Populate the driver with the corresponding user object\nsd.login()\n\n# The drivers `user` object will hold information on the current user/bot\nprint(sd.user.id)\n\n# Use the driver\n\n## Get your own user object\nsd.users.get_user("me")\n\n## Get channels\nchannels = sd.channels.get_all_channels(per_page=20)\nprint(channels[0])\n\n## Get posts for channel\npost_list = sd.posts.get_posts_for_channel("<channel_id>")\nfor post in post_list.posts:\n  print(post, post_list.posts[post].id)\n\n```\n\n### AsyncDriver\n\nAnd this is how you can use the AsyncDriver\n\n\n```python\n\nimport asyncio\nfrom matterapi import AsyncDriver\n\n# set the options for the driver\noptions = { \'url\' : \'https://localhost:8095\',\n    # User username and password authentication\n    \'auth\' : { \n      \'login_id\' : \'hansolo\', \n      \'password\' : \'lea1234\' \n      },\n    # Disable TLS verification for the client\n    \'client_options\' : {\n      \'verify\' : False\n    }\n}\n\n# Create a async driver\nad = AsyncDriver(options=options)\n\nasync def do_something():\n  # Call login to:\n  # 1. Get a session token if you user user:password based auth\n  # 2. Populate the driver with the corresponding user object\n  await ad.login()\n\n  # Use the driver\n  users = await ad.users.get_users()\n  print(users)\n\n  # To upload files, you could for example use the following request\n  data = {\n          "files": {\n              "test1.png": open("testfile1.png", "rb"),\n              "test2.png": open("testfile2.png", "rb"),\n          }\n      }\n\n  file_infos = await ad.files.upload_file(\n      channel_id="7bzsijaqopfczygxm1qc3r63do",\n      multipart_data=data)\n\n  print(file_info)\n\nasyncio.run(do_something())\n```\n\n## Websocket connection\n\nYou can also listen for event data from Mattermost\n\n```python\n\ndef handler(message):\n  print(message)\n\n# either use the sync version\nsd.start_ws_sync(handler)\n\n# or the async version with \nasync def wrapper():\n  await ad.start_ws(handler)\n\n```\n\n\nContributing\n------------\n\nThe actual endpoints in Matterapi are autogenerated with a fork of [openapi-python-client](https://github.com/gmerz/openapi-python-client). If anything there needs changing, please refer to the generator project.\n\nSome endpoints might return wrong results or miss parameters. Currently, I can image the following two reasons:\n\n1. The generator is broken and/or does not support the required feature set.\n    - Create an issue in the [matterapi-generator](https://github.com/gmerz/matterapi-generator) repository\n    - If you know how to fix it, consider to do a pull request\n\n2. The [mattermost api documentation](https://github.com/mattermost/mattermost-api-reference), which this client is generated from, is not correct\n    - Sometimes entries in the documentation might not be completely correct\n    - Consider fixing the API documentation/do a pull request/post an issue there\n    - This will help everybody who is using the documentation\n\n3. The API documentation changed or included new endpoints, but the library was not updated.\n    - Currently creation of the api client is not automated, so you have two options:\n        1. Help with the automation so that this proejct is automatically updated with changes\n        2. Create a new issue here that the client is out of sync\n        3. Clone the generator repo, update the mattermost api with the generator and do a pull request here. (This is currently the only save way to get changes into the matterapi folder)\n\n\nCredits\n-------\n\nCredits where credits are due:\n\n+ This library is autogenerated from the Mattermost API documentation using a fork of [openapi-python-client](https://github.com/triaxtec/openapi-python-client). \n+ It\'s heavily inspired by (but not a 1:1 drop-in replacement for) [mattermostdriver](https://github.com/Vaelor/python-mattermost-driver), which I used for several years already. This is still your go-to if you look for something stable that has been in use for years by lot\'s of people.\n\n',
    'author': 'Georg Merzdovnik',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://matterapi.readthedocs.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
