# Cloudspot API wrapper
Basic wrapper for the Cloudspot ERP API.

# Use cases
This wrapper has two use cases:
~~1. Authenticate and authorize users on an external app, linked to Cloudspot ERP~~
2. Get data (products, clients,...) from a company that is present on the Cloudspot ERP

:warning:
**Warning**

**The authentication and authorization for external apps is migrated to Cloudspot License server as of 2023-03-14.**
[You can find the new wrapper here.](https://github.com/Ecosy-EU/cloudspot-license-api)

# Getting started

### Install

Install with pip.

```python
pip install cloudspot-erp-api
```

### Import

Depending on your use case, you'll need to import either ```CloudspotERP_UserAPI``` or ```CloudspotERP_CompanyAPI```.

```python
# Use case 1
from cloudspot.api import CloudspotERP_UserAPI

# Use case 2
from cloudspot.api import CloudspotERP_CompanyAPI
```

# Functionalities

## CloudspotERP_UserAPI

:warning:
**Warning**

**The authentication and authorization for external apps is migrated to Cloudspot License server as of 2023-03-14.**
[You can find the new wrapper here.](https://github.com/Ecosy-EU/cloudspot-license-api)

## CloudspotERP_CompanyAPI

**This class is used to retrieve data from a company.**

### Setup

When setting up the class, one parameter is expected: the generated API token of the company.
This token can be generated by an ERP administrator for a specific company.
A token can have the right to:
- See all products
- See all clients

```python
from cloudspot.api import CloudspotERP_CompanyAPI
api = CloudspotERP_CompanyAPI('[TOKEN]')
```

After setting up the connection, you can use the ```api``` to send requests to the Cloudspot ERP.

### All products
Below method will allow you to retrieve all the products that are available inside the ERP and are linked to the company by the token.
The ```.list()``` method will return one ```Artikels``` object, which is a list containing one or multiple ```Artikel``` objects.

```python
artikels = api.artikels.list()

for artikel in artikels.items():
    print('naam: ', artikel.naam)
```

#### Available attributes

Following attributes are available for the ```Artikel``` object:

| Attribute        | Type | Remarks |
| ------------- | ------------- | ------------- |
| naam  | string | Name of the product |
| beschrijving  | text | Long description of the product |
| SKU  | string | Stock Keeping Unit |
| voorraad_bijhouden  | string | Can only contain one of these three values: "NIET" / "FYSIEK" / "DIGITAAL" |
| op_voorraad  | float | How many units are currently in stock, only applicable of voorraad_bijhouden is "FYSIEK" |
| product_url  | url | External URL with the product information |
| verkoopprijs_excl  | float | Sales price, excl. VAT |
| verkoopprijs_incl  | float | Sales price, incl. VAT |
| inkoopprijs_excl  | float | Purchase price, excl. VAT |
| inkoopprijs_incl  | float | Purchase price, incl. VAT |
| BTW  | float | Percentage of VAT applicable to the product |
| bestellingtype  | string | Can only contain one of these two values: "IDEAAL" / "BESTELLING" |
| units_per_bestelling  | float | Minimum amount of units needed for an order to the vendor |
| status  | string | Can only contain one of these three values: "ZICHTBAAR" / "NIET_VERKOOPBAAR" / "GEDEACTIVEERD" |

### Specific product
Below method will allow you to retrieve a specific product by ID. Will only return the article if the article is in the company that is linked to the token.
The ```.get(id)``` method will return one ```Artikel``` object.

```python
artikel = api.artikels.get(125) # Retrieve artikel with ID 125
print('naam: ', artikel.naam)
```

### All clients
Below method will allow you to retrieve all the clients that are available inside the ERP and are linked to the company by the token.
The ```.list()``` method will return one ```Klanten``` object, which is a list containing one or multiple ```Klant``` objects.

```python
klanten = api.klanten.list()

for klant in klanten.items():
    print('voornaam: ', klant.voornaam)
```

#### Available attributes

Following attributes are available for the ```Klant``` object:

| Attribute        | Type | Remarks |
| ------------- | ------------- | ------------- |
| klantennummer  | integer | Client number/reference |
| aanspreektitel  | string | Can only contain one of these two values: "Mijnh." / "Mevr." |
| voornaam  | string | First name of client |
| achternaam  | string | Last name of client |
| straat  | string | Street |
| huisnummer  | string | House number |
| busnummer  | string | Box number |
| postcode  | string | Zipcode |
| plaats  | string | Place/region |
| land  | string | Two letter country code (ex. BE/NL/FR/...) |
| geboortedatum  | date | Birthday of client |
| geboorteplaats  | string | Place of birth |
| is_bedrijf  | boolean | Indicates wether the client is a company or not. True = client is a company, False = client is not a company |
| bedrijfsnaam  | string | Name of the company. Only applicable if is_bedrijf is True |
| BTW_nummer  | string | VAT number of the company. Only applicable if is_bedrijf is True |
| ondernemingsnummer  | string | KBO number of the company. Only applicable if is_bedrijf is True |


### Error handling
Basic error handling has been added.
You can check if an error has occured during a call by checking the hasError attribute on the object.
If the hasError attribute has been set to True, an Error object will be attached to the error attribute of the same object.
The Error object contains one attribute: message. This will contain the error message.

```python
artikels = api.artikels.list()

if artikels.hasError:
    print('error: ', artikels.error.message)
```
