# coding: utf-8

"""
    IcoTest Voice

    IcoTest Voice API  # noqa: E501

    The version of the OpenAPI document: 1.0.30
    Contact: shaun.hirst@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from icotest_voice.configuration import Configuration


class Request(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'request_id': 'str',
        'device_id': 'str',
        'status': 'str',
        'message': 'str',
        'action': 'str',
        'request_params': 'list[object]',
        'created': 'datetime',
        'updated': 'datetime',
        'controller_id': 'str'
    }

    attribute_map = {
        'request_id': 'request_id',
        'device_id': 'device_id',
        'status': 'status',
        'message': 'message',
        'action': 'action',
        'request_params': 'request_params',
        'created': 'created',
        'updated': 'updated',
        'controller_id': 'controller_id'
    }

    def __init__(self, request_id=None, device_id=None, status=None, message=None, action=None, request_params=None, created=None, updated=None, controller_id=None, local_vars_configuration=None):  # noqa: E501
        """Request - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._request_id = None
        self._device_id = None
        self._status = None
        self._message = None
        self._action = None
        self._request_params = None
        self._created = None
        self._updated = None
        self._controller_id = None
        self.discriminator = None

        self.request_id = request_id
        if device_id is not None:
            self.device_id = device_id
        self.status = status
        if message is not None:
            self.message = message
        self.action = action
        if request_params is not None:
            self.request_params = request_params
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated
        if controller_id is not None:
            self.controller_id = controller_id

    @property
    def request_id(self):
        """Gets the request_id of this Request.  # noqa: E501

        the unique id of the request  # noqa: E501

        :return: The request_id of this Request.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this Request.

        the unique id of the request  # noqa: E501

        :param request_id: The request_id of this Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and request_id is None:  # noqa: E501
            raise ValueError("Invalid value for `request_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                request_id is not None and len(request_id) > 36):
            raise ValueError("Invalid value for `request_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                request_id is not None and len(request_id) < 36):
            raise ValueError("Invalid value for `request_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                request_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', request_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `request_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._request_id = request_id

    @property
    def device_id(self):
        """Gets the device_id of this Request.  # noqa: E501

        the uuid of the device  # noqa: E501

        :return: The device_id of this Request.  # noqa: E501
        :rtype: str
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """Sets the device_id of this Request.

        the uuid of the device  # noqa: E501

        :param device_id: The device_id of this Request.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) > 36):
            raise ValueError("Invalid value for `device_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) < 36):
            raise ValueError("Invalid value for `device_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', device_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `device_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._device_id = device_id

    @property
    def status(self):
        """Gets the status of this Request.  # noqa: E501

        The status of a request  # noqa: E501

        :return: The status of this Request.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Request.

        The status of a request  # noqa: E501

        :param status: The status of this Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["pending", "inprogress", "completed", "failed", "suspended"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def message(self):
        """Gets the message of this Request.  # noqa: E501

        The message for a request  # noqa: E501

        :return: The message of this Request.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Request.

        The message for a request  # noqa: E501

        :param message: The message of this Request.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                message is not None and len(message) > 256):
            raise ValueError("Invalid value for `message`, length must be less than or equal to `256`")  # noqa: E501

        self._message = message

    @property
    def action(self):
        """Gets the action of this Request.  # noqa: E501

        The action of the request  # noqa: E501

        :return: The action of this Request.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this Request.

        The action of the request  # noqa: E501

        :param action: The action of this Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["register", "deregister", "make_call", "receive_call", "scan", "end_call", "send_command", "retrieve_file", "delete_playback_file", "upload_playback_file", "delete_resuts_file", "delete_results_files_in_range"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def request_params(self):
        """Gets the request_params of this Request.  # noqa: E501


        :return: The request_params of this Request.  # noqa: E501
        :rtype: list[object]
        """
        return self._request_params

    @request_params.setter
    def request_params(self, request_params):
        """Sets the request_params of this Request.


        :param request_params: The request_params of this Request.  # noqa: E501
        :type: list[object]
        """

        self._request_params = request_params

    @property
    def created(self):
        """Gets the created of this Request.  # noqa: E501

        The date time the request was created  # noqa: E501

        :return: The created of this Request.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Request.

        The date time the request was created  # noqa: E501

        :param created: The created of this Request.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def updated(self):
        """Gets the updated of this Request.  # noqa: E501

        The date time the request was last updated  # noqa: E501

        :return: The updated of this Request.  # noqa: E501
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this Request.

        The date time the request was last updated  # noqa: E501

        :param updated: The updated of this Request.  # noqa: E501
        :type: datetime
        """

        self._updated = updated

    @property
    def controller_id(self):
        """Gets the controller_id of this Request.  # noqa: E501

        the unique id of the controller  # noqa: E501

        :return: The controller_id of this Request.  # noqa: E501
        :rtype: str
        """
        return self._controller_id

    @controller_id.setter
    def controller_id(self, controller_id):
        """Sets the controller_id of this Request.

        the unique id of the controller  # noqa: E501

        :param controller_id: The controller_id of this Request.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and len(controller_id) > 36):
            raise ValueError("Invalid value for `controller_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and len(controller_id) < 36):
            raise ValueError("Invalid value for `controller_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', controller_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `controller_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._controller_id = controller_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Request):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Request):
            return True

        return self.to_dict() != other.to_dict()
