# coding: utf-8

"""
    IcoTest Voice

    IcoTest Voice API  # noqa: E501

    The version of the OpenAPI document: 1.0.30
    Contact: shaun.hirst@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from icotest_voice.api_client import ApiClient
from icotest_voice.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RequestsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_audio_playback_file(self, controller_id, playback_file, **kwargs):  # noqa: E501
        """DELETE audio playback file  # noqa: E501

        Delete audio playback file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audio_playback_file(controller_id, playback_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param str playback_file: the filename of the playback file (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_audio_playback_file_with_http_info(controller_id, playback_file, **kwargs)  # noqa: E501

    def delete_audio_playback_file_with_http_info(self, controller_id, playback_file, **kwargs):  # noqa: E501
        """DELETE audio playback file  # noqa: E501

        Delete audio playback file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audio_playback_file_with_http_info(controller_id, playback_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param str playback_file: the filename of the playback file (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id',
            'playback_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_audio_playback_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `delete_audio_playback_file`")  # noqa: E501
        # verify the required parameter 'playback_file' is set
        if self.api_client.client_side_validation and ('playback_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_file` when calling `delete_audio_playback_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_audio_playback_file`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_audio_playback_file`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_audio_playback_file`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []
        if 'playback_file' in local_var_params and local_var_params['playback_file'] is not None:  # noqa: E501
            query_params.append(('playback_file', local_var_params['playback_file']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{controller_id}/delete_audio_playback_file', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_request(self, request_id, **kwargs):  # noqa: E501
        """DELETE request  # noqa: E501

        Delete an existing request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_request(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of a request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_request_with_http_info(request_id, **kwargs)  # noqa: E501

    def delete_request_with_http_info(self, request_id, **kwargs):  # noqa: E501
        """DELETE request  # noqa: E501

        Delete an existing request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_request_with_http_info(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of a request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_request" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `delete_request`")  # noqa: E501

        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `delete_request`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'request_id' in local_var_params and local_var_params['request_id'] is not None:  # noqa: E501
            query_params.append(('request_id', local_var_params['request_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_result_file(self, request_id, **kwargs):  # noqa: E501
        """DELETE result file  # noqa: E501

        Delete a test result file (recording file)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_result_file(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_result_file_with_http_info(request_id, **kwargs)  # noqa: E501

    def delete_result_file_with_http_info(self, request_id, **kwargs):  # noqa: E501
        """DELETE result file  # noqa: E501

        Delete a test result file (recording file)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_result_file_with_http_info(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_result_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `delete_result_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `delete_result_file`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `delete_result_file`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `delete_result_file`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{request_id}/delete_result_file', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_result_files_in_range(self, controller_id, start_date, end_date, **kwargs):  # noqa: E501
        """DELETE result files in date-time range  # noqa: E501

        Delete result files in a date-time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_result_files_in_range(controller_id, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param datetime start_date: start date (required)
        :param datetime end_date: end date (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_result_files_in_range_with_http_info(controller_id, start_date, end_date, **kwargs)  # noqa: E501

    def delete_result_files_in_range_with_http_info(self, controller_id, start_date, end_date, **kwargs):  # noqa: E501
        """DELETE result files in date-time range  # noqa: E501

        Delete result files in a date-time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_result_files_in_range_with_http_info(controller_id, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param datetime start_date: start date (required)
        :param datetime end_date: end date (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id',
            'start_date',
            'end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_result_files_in_range" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `delete_result_files_in_range`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if self.api_client.client_side_validation and ('start_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_date` when calling `delete_result_files_in_range`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if self.api_client.client_side_validation and ('end_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_date` when calling `delete_result_files_in_range`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_result_files_in_range`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_result_files_in_range`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_result_files_in_range`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{controller_id}/delete_result_files_in_range', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audio_playback_file_list(self, controller_id, **kwargs):  # noqa: E501
        """GET audio playback file list  # noqa: E501

        Get a list of all audio playback files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audio_playback_file_list(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_audio_playback_file_list_with_http_info(controller_id, **kwargs)  # noqa: E501

    def get_audio_playback_file_list_with_http_info(self, controller_id, **kwargs):  # noqa: E501
        """GET audio playback file list  # noqa: E501

        Get a list of all audio playback files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audio_playback_file_list_with_http_info(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audio_playback_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `get_audio_playback_file_list`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_audio_playback_file_list`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_audio_playback_file_list`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_audio_playback_file_list`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{controller_id}/get_audio_playback_file_list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_requests(self, **kwargs):  # noqa: E501
        """GET requests  # noqa: E501

        Get a list of requests  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_requests(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device
        :param str request_id: the unique id of the request
        :param str status: the status of the request
        :param str controller_id: the unique id of the controller
        :param str action: the action requested
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Request]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_requests_with_http_info(**kwargs)  # noqa: E501

    def get_requests_with_http_info(self, **kwargs):  # noqa: E501
        """GET requests  # noqa: E501

        Get a list of requests  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_requests_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device
        :param str request_id: the unique id of the request
        :param str status: the status of the request
        :param str controller_id: the unique id of the controller
        :param str action: the action requested
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Request], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'request_id',
            'status',
            'controller_id',
            'action'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_requests" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_requests`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_requests`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_requests`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_requests`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_requests`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_requests`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('status' in local_var_params and  # noqa: E501
                                                        len(local_var_params['status']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `status` when calling `get_requests`, length must be less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_requests`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_requests`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_requests`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('action' in local_var_params and  # noqa: E501
                                                        len(local_var_params['action']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `action` when calling `get_requests`, length must be less than or equal to `32`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'device_id' in local_var_params and local_var_params['device_id'] is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501
        if 'request_id' in local_var_params and local_var_params['request_id'] is not None:  # noqa: E501
            query_params.append(('request_id', local_var_params['request_id']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'controller_id' in local_var_params and local_var_params['controller_id'] is not None:  # noqa: E501
            query_params.append(('controller_id', local_var_params['controller_id']))  # noqa: E501
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Request]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_retrieve_test_result_file(self, request_id, **kwargs):  # noqa: E501
        """GET test result file  # noqa: E501

        Retrieves the test result file (i.e. the recording of your call)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_retrieve_test_result_file(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_retrieve_test_result_file_with_http_info(request_id, **kwargs)  # noqa: E501

    def get_retrieve_test_result_file_with_http_info(self, request_id, **kwargs):  # noqa: E501
        """GET test result file  # noqa: E501

        Retrieves the test result file (i.e. the recording of your call)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_retrieve_test_result_file_with_http_info(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_retrieve_test_result_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `get_retrieve_test_result_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_retrieve_test_result_file`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_retrieve_test_result_file`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `get_retrieve_test_result_file`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{request_id}/retrieve_result_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_result_file_list(self, controller_id, **kwargs):  # noqa: E501
        """GET test result file list  # noqa: E501

        Gets a list of all test result files (recordings)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_result_file_list(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_result_file_list_with_http_info(controller_id, **kwargs)  # noqa: E501

    def get_test_result_file_list_with_http_info(self, controller_id, **kwargs):  # noqa: E501
        """GET test result file list  # noqa: E501

        Gets a list of all test result files (recordings)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_result_file_list_with_http_info(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_result_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `get_test_result_file_list`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_test_result_file_list`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_test_result_file_list`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_test_result_file_list`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{controller_id}/get_result_file_list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_requests_heartbeat(self, request_id, **kwargs):  # noqa: E501
        """POST request heartbeat  # noqa: E501

        Request heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_requests_heartbeat(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_requests_heartbeat_with_http_info(request_id, **kwargs)  # noqa: E501

    def post_requests_heartbeat_with_http_info(self, request_id, **kwargs):  # noqa: E501
        """POST request heartbeat  # noqa: E501

        Request heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_requests_heartbeat_with_http_info(request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_requests_heartbeat" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `post_requests_heartbeat`")  # noqa: E501

        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `post_requests_heartbeat`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `post_requests_heartbeat`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `post_requests_heartbeat`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{request_id}/heartbeat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_request(self, **kwargs):  # noqa: E501
        """PUT request  # noqa: E501

        Add or update a request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_request(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Request request: the model of a request
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_request_with_http_info(**kwargs)  # noqa: E501

    def put_request_with_http_info(self, **kwargs):  # noqa: E501
        """PUT request  # noqa: E501

        Add or update a request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_request_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Request request: the model of a request
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_request" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in local_var_params:
            body_params = local_var_params['request']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_request_status(self, request_id, status, **kwargs):  # noqa: E501
        """PUT request status  # noqa: E501

        Put request status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_request_status(request_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param str status: status (required)
        :param str message: message body
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_request_status_with_http_info(request_id, status, **kwargs)  # noqa: E501

    def put_request_status_with_http_info(self, request_id, status, **kwargs):  # noqa: E501
        """PUT request status  # noqa: E501

        Put request status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_request_status_with_http_info(request_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: the unique id of the request (required)
        :param str status: status (required)
        :param str message: message body
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'status',
            'message'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_request_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `put_request_status`")  # noqa: E501
        # verify the required parameter 'status' is set
        if self.api_client.client_side_validation and ('status' not in local_var_params or  # noqa: E501
                                                        local_var_params['status'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `status` when calling `put_request_status`")  # noqa: E501

        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `put_request_status`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('request_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['request_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `put_request_status`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'request_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['request_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `request_id` when calling `put_request_status`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'message' in local_var_params and local_var_params['message'] is not None:  # noqa: E501
            query_params.append(('message', local_var_params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{request_id}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_upload_audio_playback_file(self, controller_id, playback_file, **kwargs):  # noqa: E501
        """PUT upload audio playback file  # noqa: E501

        Upload audio playback file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_upload_audio_playback_file(controller_id, playback_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param file playback_file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_upload_audio_playback_file_with_http_info(controller_id, playback_file, **kwargs)  # noqa: E501

    def put_upload_audio_playback_file_with_http_info(self, controller_id, playback_file, **kwargs):  # noqa: E501
        """PUT upload audio playback file  # noqa: E501

        Upload audio playback file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_upload_audio_playback_file_with_http_info(controller_id, playback_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param file playback_file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id',
            'playback_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_upload_audio_playback_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `put_upload_audio_playback_file`")  # noqa: E501
        # verify the required parameter 'playback_file' is set
        if self.api_client.client_side_validation and ('playback_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_file` when calling `put_upload_audio_playback_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `put_upload_audio_playback_file`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `put_upload_audio_playback_file`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `put_upload_audio_playback_file`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'playback_file' in local_var_params:
            local_var_files['playback_file'] = local_var_params['playback_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/requests/{controller_id}/upload_audio_playback_file', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
