import { RunInstanceStep } from '../../parent-steps/automation/run-instance-step';
import { AutomationSimulationBase } from './automation-simulation-base';
import { AwsInvocationSimulationProps } from './aws-api-simulation';
/**
 * AutomationStep implemenation for aws:runInstance
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runinstance.html
 */
export declare class RunInstanceSimulation extends AutomationSimulationBase {
    private static readonly DefaultNumberOfInstances;
    readonly action: string;
    private runInstanceStep;
    private props;
    constructor(step: RunInstanceStep, props: AwsInvocationSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private runInstances;
    private waitForInstanceRunning;
}
