"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteStackSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const stack_status_1 = require("../../domain/stack-status");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
const aws_service_1 = require("../../domain/aws-service");
/**
 * AutomationStep implemenation for aws:deleteStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-deletestack.html
 */
class DeleteStackSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:deleteStack';
        this.deleteStackStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stackName = this.deleteStackStep.stackNameVariable.resolve(inputs);
        const clientToken = stackName + inputs['automation:EXECUTION_ID'];
        console.log(`DeleteStack: Querying stack id for ${stackName}`);
        const stackId = this.getStackId(stackName);
        console.log(`DeleteStack: StackId for StackName ${stackName} determine ${stackId}`);
        this.deleteStack(stackId, clientToken);
        console.log(`DeleteStack: Initiated deletion of ${stackId}`);
        this.waitForStackDeletion(stackId);
        console.log(`DeleteStack: Stack ${stackName} successfully deleted`);
        return {};
    }
    getStackId(stackName) {
        const apiParams = { StackName: stackName };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const describeResponse = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'describeResponse', {
            service: aws_service_1.AwsService.CLOUD_FORMATION,
            pascalCaseApi: 'DescribeStacks',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'StackId',
                    selector: '$.Stacks[0].StackId',
                }],
        }), this.props).invoke({});
        if (describeResponse.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Describe stack failed for ${stackName}: ${describeResponse.stackTrace}`);
        }
        return (describeResponse.outputs ?? {})['describeResponse.StackId'];
    }
    deleteStack(stackId, clientToken) {
        const apiParams = { StackName: stackId };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'executeDelete', {
            service: aws_service_1.AwsService.CLOUD_FORMATION,
            pascalCaseApi: 'DeleteStack',
            apiParams: {
                RoleARN: this.deleteStackStep.roleArn,
                ClientRequestToken: clientToken,
                StackName: stackId,
            },
            outputs: [],
        }), this.props).invoke({});
        if (result.responseCode != response_code_1.ResponseCode.SUCCESS) {
            throw new Error('Delete stack failed for ' + stackId);
        }
    }
    waitForStackDeletion(stackId) {
        wait_for_and_assert_1.waitForAndAssertStackStatus({
            stackName: stackId,
            waitForStatus: [stack_status_1.StackStatus.DELETE_FAILED, stack_status_1.StackStatus.DELETE_COMPLETE],
            assertStatus: stack_status_1.StackStatus.DELETE_COMPLETE,
        }, this.props);
    }
}
exports.DeleteStackSimulation = DeleteStackSimulation;
_a = JSII_RTTI_SYMBOL_1;
DeleteStackSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DeleteStackSimulation", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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