"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PsModuleStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:psmodule
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-psModule
 */
class PsModuleStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:psModule';
        this.runCommand = props.runCommand;
        this.source = props.source;
        this.sourceHash = props.sourceHash;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        return [
            ...this.runCommand?.flatMap(v => v.requiredInputs()) ?? [],
            ...this.source.requiredInputs(),
            ...this.workingDirectory?.requiredInputs() ?? [],
            ...this.sourceHash?.requiredInputs() ?? [],
        ];
    }
    toSsmEntry() {
        const inputs = { source: this.source };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        if (this.sourceHash != undefined) {
            inputs.sourceHash = this.sourceHash;
        }
        if (this.runCommand != undefined) {
            inputs.runCommand = this.runCommand;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.PsModuleStep = PsModuleStep;
_a = JSII_RTTI_SYMBOL_1;
PsModuleStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.PsModuleStep", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHMtbW9kdWxlLXN0ZXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcGFyZW50LXN0ZXBzL2NvbW1hbmQvcHMtbW9kdWxlLXN0ZXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxvREFBaUQ7QUFFakQsa0RBQWdFO0FBb0NoRTs7O0dBR0c7QUFDSCxNQUFhLFlBQWEsU0FBUSwwQkFBVztJQVczQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBSmpCLGNBQVMsR0FBRyxDQUFDLG1CQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDL0IsV0FBTSxHQUFHLGNBQWMsQ0FBQztRQUkvQixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7O1NBRUs7SUFDRSxVQUFVO1FBQ2YsT0FBTztZQUNMLEdBQUcsSUFBSSxDQUFDLFVBQVUsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsY0FBYyxFQUFFLENBQUMsSUFBSSxFQUFFO1lBQzFELEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLEVBQUU7WUFDL0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRTtZQUNoRCxHQUFHLElBQUksQ0FBQyxVQUFVLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRTtTQUMzQyxDQUFDO0lBQ0osQ0FBQztJQUVNLFVBQVU7UUFDZixNQUFNLE1BQU0sR0FBNEIsRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO1FBQ2hFLElBQUksSUFBSSxDQUFDLGdCQUFnQixJQUFJLFNBQVMsRUFBRTtZQUN0QyxNQUFNLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1NBQ2pEO1FBQ0QsSUFBSSxJQUFJLENBQUMsY0FBYyxJQUFJLFNBQVMsRUFBRTtZQUNwQyxNQUFNLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDN0M7UUFDRCxJQUFJLElBQUksQ0FBQyxVQUFVLElBQUksU0FBUyxFQUFFO1lBQ2hDLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztTQUNyQztRQUNELElBQUksSUFBSSxDQUFDLFVBQVUsSUFBSSxTQUFTLEVBQUU7WUFDaEMsTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1NBQ3JDO1FBQ0QsT0FBTyxLQUFLLENBQUMsZUFBZSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7O0FBL0NILG9DQWlEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgUGxhdGZvcm0gfSBmcm9tICcuLi8uLi9kb21haW4vcGxhdGZvcm0nO1xuaW1wb3J0IHsgSVN0cmluZ1ZhcmlhYmxlIH0gZnJvbSAnLi4vLi4vaW50ZXJmYWNlL3ZhcmlhYmxlcy9zdHJpbmctdmFyaWFibGUnO1xuaW1wb3J0IHsgQ29tbWFuZFN0ZXAsIENvbW1hbmRTdGVwUHJvcHMgfSBmcm9tICcuLi9jb21tYW5kLXN0ZXAnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIHBzIE1vZHVsZSBzdGVwLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFBzTW9kdWxlU3RlcFByb3BzIGV4dGVuZHMgQ29tbWFuZFN0ZXBQcm9wcyB7XG5cbiAgLyoqXG4gICAgICogU3BlY2lmeSB0aGUgY29tbWFuZHMgdG8gcnVuIG9yIHRoZSBwYXRoIHRvIGFuIGV4aXN0aW5nIHNjcmlwdCBvbiB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gIHJlYWRvbmx5IHJ1bkNvbW1hbmQ/OiBJU3RyaW5nVmFyaWFibGVbXTtcblxuICAvKipcbiAgICAgKiBUaGUgVVJMIG9yIGxvY2FsIHBhdGggb24gdGhlIGluc3RhbmNlIHRvIHRoZSBhcHBsaWNhdGlvbiAuemlwIGZpbGUuXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIHppcCBmaWxlIG11c3QgYmUgdGhlIG5hbWUgb2YgdGhlIG1vZHVsZSB0byBiZSBpbnN0YWxsZWRcbiAgICAgKi9cbiAgcmVhZG9ubHkgc291cmNlOiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgU0hBMjU2IGhhc2ggb2YgdGhlIC56aXAgZmlsZVxuICAgICAqL1xuICByZWFkb25seSBzb3VyY2VIYXNoPzogSVN0cmluZ1ZhcmlhYmxlO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgVGhlIHRpbWUgaW4gc2Vjb25kcyBmb3IgYSBjb21tYW5kIHRvIGJlIGNvbXBsZXRlZCBiZWZvcmUgaXQncyBjb25zaWRlcmVkIHRvIGhhdmUgZmFpbGVkLlxuICAgICAqIFdoZW4gdGhlIHRpbWVvdXQgaXMgcmVhY2hlZCwgU3lzdGVtcyBNYW5hZ2VyIHN0b3BzIHRoZSBjb21tYW5kIGV4ZWN1dGlvbi5cbiAgICAgKi9cbiAgcmVhZG9ubHkgdGltZW91dFNlY29uZHM/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgcGF0aCB0byB0aGUgd29ya2luZyBkaXJlY3Rvcnkgb24geW91ciBpbnN0YW5jZS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgd29ya2luZ0RpcmVjdG9yeT86IElTdHJpbmdWYXJpYWJsZTtcblxufVxuXG4vKipcbiAqIEF1dG9tYXRpb25TdGVwIGltcGxlbWVuYXRpb24gZm9yIGF3czpwc21vZHVsZVxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N5c3RlbXMtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL3NzbS1wbHVnaW5zLmh0bWwjYXdzLXBzTW9kdWxlXG4gKi9cbmV4cG9ydCBjbGFzcyBQc01vZHVsZVN0ZXAgZXh0ZW5kcyBDb21tYW5kU3RlcCB7XG5cbiAgcmVhZG9ubHkgcnVuQ29tbWFuZD86IElTdHJpbmdWYXJpYWJsZVtdO1xuICByZWFkb25seSBzb3VyY2U6IElTdHJpbmdWYXJpYWJsZTtcbiAgcmVhZG9ubHkgc291cmNlSGFzaD86IElTdHJpbmdWYXJpYWJsZTtcbiAgcmVhZG9ubHkgdGltZW91dFNlY29uZHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHdvcmtpbmdEaXJlY3Rvcnk/OiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgcmVhZG9ubHkgcGxhdGZvcm1zID0gW1BsYXRmb3JtLldJTkRPV1NdO1xuICByZWFkb25seSBhY3Rpb24gPSAnYXdzOnBzTW9kdWxlJztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUHNNb2R1bGVTdGVwUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLnJ1bkNvbW1hbmQgPSBwcm9wcy5ydW5Db21tYW5kO1xuICAgIHRoaXMuc291cmNlID0gcHJvcHMuc291cmNlO1xuICAgIHRoaXMuc291cmNlSGFzaCA9IHByb3BzLnNvdXJjZUhhc2g7XG4gICAgdGhpcy50aW1lb3V0U2Vjb25kcyA9IHByb3BzLnRpbWVvdXRTZWNvbmRzO1xuICAgIHRoaXMud29ya2luZ0RpcmVjdG9yeSA9IHByb3BzLndvcmtpbmdEaXJlY3Rvcnk7XG4gIH1cblxuICAvKipcbiAgICAgKiBJbnB1dHMgcmVxdWlyZWQgZm9yIHRoaXMgY29tbWFuZCBpbmNsdWRlcyBib3RoIHRoZSBydW5Db21tYW5kIHZhcmlhYmxlcyBhbmQgd29ya2luZ0RpcmVjdG9yeSBpZiBwcm92aWRlZC5cbiAgICAgKi9cbiAgcHVibGljIGxpc3RJbnB1dHMoKTogc3RyaW5nW10ge1xuICAgIHJldHVybiBbXG4gICAgICAuLi50aGlzLnJ1bkNvbW1hbmQ/LmZsYXRNYXAodiA9PiB2LnJlcXVpcmVkSW5wdXRzKCkpID8/IFtdLFxuICAgICAgLi4udGhpcy5zb3VyY2UucmVxdWlyZWRJbnB1dHMoKSxcbiAgICAgIC4uLnRoaXMud29ya2luZ0RpcmVjdG9yeT8ucmVxdWlyZWRJbnB1dHMoKSA/PyBbXSxcbiAgICAgIC4uLnRoaXMuc291cmNlSGFzaD8ucmVxdWlyZWRJbnB1dHMoKSA/PyBbXSxcbiAgICBdO1xuICB9XG5cbiAgcHVibGljIHRvU3NtRW50cnkoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIGNvbnN0IGlucHV0czogeyBbbmFtZTogc3RyaW5nXTogYW55IH0gPSB7IHNvdXJjZTogdGhpcy5zb3VyY2UgfTtcbiAgICBpZiAodGhpcy53b3JraW5nRGlyZWN0b3J5ICE9IHVuZGVmaW5lZCkge1xuICAgICAgaW5wdXRzLndvcmtpbmdEaXJlY3RvcnkgPSB0aGlzLndvcmtpbmdEaXJlY3Rvcnk7XG4gICAgfVxuICAgIGlmICh0aGlzLnRpbWVvdXRTZWNvbmRzICE9IHVuZGVmaW5lZCkge1xuICAgICAgaW5wdXRzLnRpbWVvdXRTZWNvbmRzID0gdGhpcy50aW1lb3V0U2Vjb25kcztcbiAgICB9XG4gICAgaWYgKHRoaXMuc291cmNlSGFzaCAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGlucHV0cy5zb3VyY2VIYXNoID0gdGhpcy5zb3VyY2VIYXNoO1xuICAgIH1cbiAgICBpZiAodGhpcy5ydW5Db21tYW5kICE9IHVuZGVmaW5lZCkge1xuICAgICAgaW5wdXRzLnJ1bkNvbW1hbmQgPSB0aGlzLnJ1bkNvbW1hbmQ7XG4gICAgfVxuICAgIHJldHVybiBzdXBlci5wcmVwYXJlU3NtRW50cnkoaW5wdXRzKTtcbiAgfVxuXG59Il19