"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyImageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:copyImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-copyimage.html
 */
class CopyImageStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:copyImage';
        this.sourceRegion = props.sourceRegion;
        this.sourceImageId = props.sourceImageId;
        this.imageName = props.imageName;
        this.imageDescription = props.imageDescription;
        this.encrypted = props.encrypted;
        this.kmsKeyId = props.kmsKeyId;
        this.clientToken = props.clientToken;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageId',
                selector: '$.ImageId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageState',
                selector: '$.ImageState',
            }];
    }
    listInputs() {
        const inputs = [
            this.sourceRegion,
            this.sourceImageId,
            this.imageName,
            this.imageDescription,
            this.encrypted,
            this.kmsKeyId,
            this.clientToken,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            SourceRegion: this.sourceRegion,
            SourceImageId: this.sourceImageId,
            ImageName: this.imageName,
            ImageDescription: this.imageDescription,
            Encrypted: this.encrypted,
            KmsKeyId: this.kmsKeyId,
            ClientToken: this.clientToken,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CopyImageStep = CopyImageStep;
_a = JSII_RTTI_SYMBOL_1;
CopyImageStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CopyImageStep", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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