"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangeInstanceStateStep = exports.DesiredStateVariable = exports.HardCodedDesiredState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedDesiredState extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedDesiredState = HardCodedDesiredState;
_a = JSII_RTTI_SYMBOL_1;
HardCodedDesiredState[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedDesiredState", version: "0.0.31" };
HardCodedDesiredState.RUNNING = new HardCodedDesiredState('running');
HardCodedDesiredState.STOPPED = new HardCodedDesiredState('stopped');
HardCodedDesiredState.TERMINATED = new HardCodedDesiredState('terminated');
class DesiredStateVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['running', 'stopped', 'terminated'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.DesiredStateVariable = DesiredStateVariable;
_b = JSII_RTTI_SYMBOL_1;
DesiredStateVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.DesiredStateVariable", version: "0.0.31" };
/**
 * AutomationStep implemenation for aws:changeInstanceState
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-changestate.html
 */
class ChangeInstanceStateStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:changeInstanceState';
        this.instanceIds = props.instanceIds;
        this.desiredState = props.desiredState;
        this.checkStateOnly = props.checkStateOnly;
        this.force = props.force;
        this.additionalInfo = props.additionalInfo;
    }
    /**
       * This step has no outputs.
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.instanceIds,
            this.desiredState,
            this.checkStateOnly,
            this.force,
            this.additionalInfo,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            InstanceIds: this.instanceIds,
            DesiredState: this.desiredState,
            CheckStateOnly: this.checkStateOnly,
            Force: this.force,
            AdditionalInfo: this.additionalInfo,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.ChangeInstanceStateStep = ChangeInstanceStateStep;
_c = JSII_RTTI_SYMBOL_1;
ChangeInstanceStateStep[_c] = { fqn: "@cdklabs/cdk-ssm-documents.ChangeInstanceStateStep", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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