import { IBooleanVariable } from '../';
import { AuthMethod } from './auth-method';
import { SecureVariable } from './variables/secure-string-variable';
import { IStringVariable } from './variables/string-variable';
export interface IDownloadableContent {
    readonly sourceType: string;
    requiredInputs(): string[];
    formatSourceInfo(): {
        [name: string]: any;
    };
}
/**
 * Properties for sourceType GitHub
 */
export interface GitHubContentProps {
    /**
     * The repository owner.
     */
    readonly owner: IStringVariable;
    /**
     * The name of the repository.
     */
    readonly repository: IStringVariable;
    /**
     * The path to the file or directory you want to download.
     */
    readonly path: IStringVariable;
    /**
     * The Systems Manager parameter (a SecureString parameter) where you store your GitHub access token information.
     */
    readonly tokenInfo: SecureVariable;
    /**
     * The default is master.
     * branch parameter is required only if your SSM document is stored in a branch other than master.
     * Supply either commitId or branch (or neither).
     * @example main
     */
    readonly branch?: string;
    /**
     * The default is head.
     * To use the version of your SSM document in a commit other than the latest, specify the full commit ID.
     * For example: "bbc1ddb94...b76d3bEXAMPLE".
     * Supply either commitId or branch (or neither).
     */
    readonly commitId?: string;
}
export declare class GitHubContent implements IDownloadableContent {
    readonly sourceType = "GitHub";
    readonly owner: IStringVariable;
    readonly repository: IStringVariable;
    readonly path: IStringVariable;
    readonly tokenInfo: SecureVariable;
    readonly branch?: string;
    readonly commitId?: string;
    constructor(props: GitHubContentProps);
    requiredInputs(): string[];
    formatSourceInfo(): {
        [name: string]: any;
    };
}
/**
 * Properties for sourceType Git
 */
export interface GitContentProps {
    /**
     * The username to use when connecting to the repository you specify using HTTP.
     */
    readonly userName?: SecureVariable;
    /**
     * The password to use when connecting to the repository you specify using HTTP.
     */
    readonly password?: SecureVariable;
    /**
     * The Git repository URL to the file or directory you want to download.
     */
    readonly repository: IStringVariable;
    /**
     * The SSH key to use when connecting to the repository you specify.
     */
    readonly privateSshKey?: SecureVariable;
    /**
     * Determines the value of the StrictHostKeyChecking option when connecting to the repository you specify.
     * The default value is false.
     */
    readonly skipHostKeyChecking?: IBooleanVariable;
    /**
     * The default is master.
     * branch parameter is required only if your SSM document is stored in a branch other than master.
     * Supply either commitId or branch (or neither).
     * @example main
     */
    readonly branch?: string;
    /**
     * The default is head.
     * To use the version of your SSM document in a commit other than the latest, specify the full commit ID.
     * For example: "bbc1ddb94...b76d3bEXAMPLE".
     * Supply either commitId or branch (or neither).
     */
    readonly commitId?: string;
}
export declare class GitContent implements IDownloadableContent {
    readonly sourceType = "Git";
    readonly userName?: SecureVariable;
    readonly password?: SecureVariable;
    readonly repository: IStringVariable;
    readonly privateSshKey?: SecureVariable;
    readonly skipHostKeyChecking?: IBooleanVariable;
    readonly branch?: string;
    readonly commitId?: string;
    constructor(props: GitContentProps);
    requiredInputs(): string[];
    formatSourceInfo(): {
        [name: string]: any;
    };
}
/**
 * Properties for sourceType HTTP
 */
export interface HttpContentProps {
    /**
     * The URL to the file or directory you want to download.
     */
    readonly url: IStringVariable;
    /**
     * Determines whether a download can be performed over a connection that isn't encrypted with Secure Socket Layer (SSL) or Transport Layer Security (TLS).
     * The default value is false. We don't recommend performing downloads without encryption. If you choose to do so, you assume all associated risks.
     * Security is a shared responsibility between AWS and you. This is described as the shared responsibility model. To learn more, see the shared responsibility model.
     */
    readonly allowInsecureDownload?: IBooleanVariable;
    /**
     * Determines whether a username and password are used for authentication when connecting to the url you specify.
     * If you specify Basic or Digest, you must provide values for the username and password parameters.
     * To use the Digest method, SSM Agent version 3.0.1181.0 or later must be installed on your instance. The Digest method supports MD5 and SHA256 encryption.
     */
    readonly authMethod?: AuthMethod;
}
export declare class HttpContent implements IDownloadableContent {
    readonly sourceType = "HTTP";
    readonly url: IStringVariable;
    readonly allowInsecureDownload?: IBooleanVariable;
    readonly authMethod?: AuthMethod;
    constructor(props: HttpContentProps);
    requiredInputs(): string[];
    formatSourceInfo(): {
        [p: string]: any;
    };
}
/**
 * Properties.json for sourceType GitHub
 */
export interface S3ContentProps {
    /**
     * The URL to the file or directory you want to download.
     */
    readonly path: IStringVariable;
}
export declare class S3Content implements IDownloadableContent {
    readonly sourceType = "S3";
    readonly path: IStringVariable;
    constructor(props: S3ContentProps);
    requiredInputs(): string[];
    formatSourceInfo(): {
        [p: string]: any;
    };
}
/**
 * Properties.json for sourceType SsmDocument
 */
export interface SsmDocumentContentProps {
    /**
     * specify one of the following
     * The name and version of the document in the following format: name:version. Version is optional.
     * or The ARN for the document in the following format: arn:aws:ssm:region:account_id:document/document_name
     */
    readonly documentSource: DocumentSource;
}
export declare abstract class DocumentSource {
    static fromArn(arn: IStringVariable): DocumentSource;
    static fromName(name: IStringVariable, version?: IStringVariable): DocumentSource;
    abstract formatRequest(): {
        [name: string]: any;
    };
    abstract requiredInputs(): string[];
}
export declare class ArnDoc extends DocumentSource {
    readonly arn: IStringVariable;
    constructor(arn: IStringVariable);
    formatRequest(): {
        [name: string]: any;
    };
    requiredInputs(): string[];
}
export declare class NameDoc extends DocumentSource {
    readonly name: IStringVariable;
    readonly version?: IStringVariable;
    constructor(name: IStringVariable, version?: IStringVariable);
    formatRequest(): {
        [name: string]: any;
    };
    requiredInputs(): string[];
}
export declare class SSMDocumentContent implements IDownloadableContent {
    readonly sourceType = "SSMDocument";
    readonly documentSource: DocumentSource;
    constructor(props: SsmDocumentContentProps);
    formatSourceInfo(): {
        [p: string]: any;
    };
    requiredInputs(): string[];
}
