"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents an AWS service.
 * The namespace which is meant to be used for the service declaration in SSM may be difficult to guess.
 * The name provided for simulation may at times be different.
 * This class provides many ready-to-use implementations of AWS services.
 * If a service is not on the list, you can fall back to constructing this object on your own.
 * In other words, you can reference S3 using `AwsService.S3`
 * For a NewService, you can reference it using `new AwsService('new-service', 'NewService')`.
 * It is risky to auto convert between namespace and javaScriptName because they are not consistent in all cases.
 */
class AwsService {
    constructor(namespace, javaScriptName) {
        this.namespace = namespace;
        this.javaScriptName = javaScriptName;
    }
    toJSON() {
        return this.namespace;
    }
}
exports.AwsService = AwsService;
_a = JSII_RTTI_SYMBOL_1;
AwsService[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AwsService", version: "0.0.31" };
AwsService.ACCESS_ANALYZER = new AwsService('accessanalyzer', 'AccessAnalyzer');
AwsService.ACCOUNT = new AwsService('account', 'Account');
AwsService.ACM = new AwsService('acm', 'ACM');
AwsService.ACMPCA = new AwsService('acm-pca', 'ACMPCA');
AwsService.ALEXA_FOR_BUSINESS = new AwsService('alexaforbusiness', 'AlexaForBusiness');
AwsService.AMP = new AwsService('amp', 'Amp');
AwsService.AMPLIFY = new AwsService('amplify', 'Amplify');
AwsService.AMPLIFY_BACKEND = new AwsService('amplifybackend', 'AmplifyBackend');
AwsService.AMPLIFY_UI_BUILDER = new AwsService('amplifyuibuilder', 'AmplifyUIBuilder');
AwsService.APIGATEWAY = new AwsService('apigateway', 'APIGateway');
AwsService.API_GATEWAY_MANAGEMENT_API = new AwsService('apigatewaymanagementapi', 'ApiGatewayManagementApi');
AwsService.API_GATEWAY_V2 = new AwsService('apigatewayv2', 'ApiGatewayV2');
AwsService.APP_CONFIG = new AwsService('appconfig', 'AppConfig');
AwsService.APP_CONFIG_DATA = new AwsService('appconfigdata', 'AppConfigData');
AwsService.APPFLOW = new AwsService('appflow', 'Appflow');
AwsService.APP_INTEGRATIONS = new AwsService('appintegrations', 'AppIntegrations');
AwsService.APPLICATION_AUTO_SCALING = new AwsService('application-autoscaling', 'ApplicationAutoScaling');
AwsService.APPLICATION_COST_PROFILER = new AwsService('applicationcostprofiler', 'ApplicationCostProfiler');
AwsService.APPLICATION_INSIGHTS = new AwsService('application-insights', 'ApplicationInsights');
AwsService.APP_MESH = new AwsService('appmesh', 'AppMesh');
AwsService.APP_RUNNER = new AwsService('apprunner', 'AppRunner');
AwsService.APP_STREAM = new AwsService('appstream', 'AppStream');
AwsService.APP_SYNC = new AwsService('appsync', 'AppSync');
AwsService.ATHENA = new AwsService('athena', 'Athena');
AwsService.AUDIT_MANAGER = new AwsService('auditmanager', 'AuditManager');
AwsService.AUTO_SCALING = new AwsService('autoscaling', 'AutoScaling');
AwsService.AUTO_SCALING_PLANS = new AwsService('autoscaling-plans', 'AutoScalingPlans');
AwsService.BACKUP = new AwsService('backup', 'Backup');
AwsService.BACKUP_GATEWAY = new AwsService('backup-gateway', 'BackupGateway');
AwsService.BACKUP_STORAGE = new AwsService('backupstorage', 'BackupStorage');
AwsService.BATCH = new AwsService('batch', 'Batch');
AwsService.BILLINGCONDUCTOR = new AwsService('billingconductor', 'Billingconductor');
AwsService.BRAKET = new AwsService('braket', 'Braket');
AwsService.BUDGETS = new AwsService('budgets', 'Budgets');
AwsService.CHIME = new AwsService('chime', 'Chime');
AwsService.CHIME_SDK_IDENTITY = new AwsService('chime-sdk-identity', 'ChimeSDKIdentity');
AwsService.CHIME_SDK_MEDIA_PIPELINES = new AwsService('chime-sdk-media-pipelines', 'ChimeSDKMediaPipelines');
AwsService.CHIME_SDK_MEETINGS = new AwsService('chime-sdk-meetings', 'ChimeSDKMeetings');
AwsService.CHIME_SDK_MESSAGING = new AwsService('chime-sdk-messaging', 'ChimeSDKMessaging');
AwsService.CLOUD9 = new AwsService('cloud9', 'Cloud9');
AwsService.CLOUD_CONTROL = new AwsService('cloudcontrol', 'CloudControl');
AwsService.CLOUD_DIRECTORY = new AwsService('clouddirectory', 'CloudDirectory');
AwsService.CLOUD_FORMATION = new AwsService('cloudformation', 'CloudFormation');
AwsService.CLOUD_FRONT = new AwsService('cloudfront', 'CloudFront');
AwsService.CLOUD_HS_M = new AwsService('cloudhsm', 'CloudHSM');
AwsService.CLOUD_HSM_V2 = new AwsService('cloudhsmv2', 'CloudHSMV2');
AwsService.CLOUD_SEARCH = new AwsService('cloudsearch', 'CloudSearch');
AwsService.CLOUD_SEARCH_DOMAIN = new AwsService('cloudsearchdomain', 'CloudSearchDomain');
AwsService.CLOUD_TRAIL = new AwsService('cloudtrail', 'CloudTrail');
AwsService.CLOUD_WATCH = new AwsService('cloudwatch', 'CloudWatch');
AwsService.CODE_ARTIFACT = new AwsService('codeartifact', 'CodeArtifact');
AwsService.CODE_BUILD = new AwsService('codebuild', 'CodeBuild');
AwsService.CODE_COMMIT = new AwsService('codecommit', 'CodeCommit');
AwsService.CODE_DEPLOY = new AwsService('codedeploy', 'CodeDeploy');
AwsService.CODE_GURU_PROFILER = new AwsService('codeguruprofiler', 'CodeGuruProfiler');
AwsService.CODE_GURU_REVIEWER = new AwsService('codeguru-reviewer', 'CodeGuruReviewer');
AwsService.CODE_PIPELINE = new AwsService('codepipeline', 'CodePipeline');
AwsService.CODE_STAR = new AwsService('codestar', 'CodeStar');
AwsService.CODE_STARCONNECTIONS = new AwsService('codestar-connections', 'CodeStarconnections');
AwsService.CODE_STAR_NOTIFICATIONS = new AwsService('codestar-notifications', 'CodeStarNotifications');
AwsService.COGNITO_IDENTITY = new AwsService('cognito-identity', 'CognitoIdentity');
AwsService.COGNITO_SYNC = new AwsService('cognito-sync', 'CognitoSync');
AwsService.COMPREHEND = new AwsService('comprehend', 'Comprehend');
AwsService.COMPREHEND_MEDICAL = new AwsService('comprehendmedical', 'ComprehendMedical');
AwsService.COMPUTE_OPTIMIZER = new AwsService('compute-optimizer', 'ComputeOptimizer');
AwsService.CONNECT = new AwsService('connect', 'Connect');
AwsService.CONNECT_CAMPAIGNS = new AwsService('connectcampaigns', 'ConnectCampaigns');
AwsService.CONNECT_CASES = new AwsService('connectcases', 'ConnectCases');
AwsService.CONNECT_CONTACT_LENS = new AwsService('connect-contact-lens', 'ConnectContactLens');
AwsService.CONNECT_PARTICIPANT = new AwsService('connectparticipant', 'ConnectParticipant');
AwsService.CONTROL_TOWER = new AwsService('controltower', 'ControlTower');
AwsService.CUR = new AwsService('cur', 'CUR');
AwsService.CUSTOMER_PROFILES = new AwsService('customer-profiles', 'CustomerProfiles');
AwsService.DATA_BREW = new AwsService('databrew', 'DataBrew');
AwsService.DATA_EXCHANGE = new AwsService('dataexchange', 'DataExchange');
AwsService.DATA_PIPELINE = new AwsService('datapipeline', 'DataPipeline');
AwsService.DATA_SYNC = new AwsService('datasync', 'DataSync');
AwsService.DAX = new AwsService('dax', 'DAX');
AwsService.DETECTIVE = new AwsService('detective', 'Detective');
AwsService.DEVICE_FARM = new AwsService('devicefarm', 'DeviceFarm');
AwsService.DEV_OPS_GURU = new AwsService('devops-guru', 'DevOpsGuru');
AwsService.DIRECT_CONNECT = new AwsService('directconnect', 'DirectConnect');
AwsService.DISCOVERY = new AwsService('discovery', 'Discovery');
AwsService.DLM = new AwsService('dlm', 'DLM');
AwsService.DMS = new AwsService('dms', 'DMS');
AwsService.DOC_DB = new AwsService('docdb', 'DocDB');
AwsService.DRS = new AwsService('drs', 'Drs');
AwsService.DYNAMO_DB = new AwsService('dynamodb', 'DynamoDB');
AwsService.DYNAMO_DB_STREAMS = new AwsService('dynamodbstreams', 'DynamoDBStreams');
AwsService.EBS = new AwsService('ebs', 'EBS');
AwsService.EC2 = new AwsService('ec2', 'EC2');
AwsService.EC2_INSTANCE_CONNECT = new AwsService('ec2-instance-connect', 'EC2InstanceConnect');
AwsService.ECR = new AwsService('ecr', 'ECR');
AwsService.ECRPUBLIC = new AwsService('ecr-public', 'ECRPUBLIC');
AwsService.ECS = new AwsService('ecs', 'ECS');
AwsService.EFS = new AwsService('efs', 'EFS');
AwsService.EKS = new AwsService('eks', 'EKS');
AwsService.ELASTI_CACHE = new AwsService('elasticache', 'ElastiCache');
AwsService.ELASTIC_BEANSTALK = new AwsService('elasticbeanstalk', 'ElasticBeanstalk');
AwsService.ELASTIC_INFERENCE = new AwsService('elastic-inference', 'ElasticInference');
AwsService.ELASTIC_TRANSCODER = new AwsService('elastictranscoder', 'ElasticTranscoder');
AwsService.ELB = new AwsService('elb', 'ELB');
AwsService.ELBV2 = new AwsService('elbv2', 'ELBv2');
AwsService.EMR = new AwsService('emr', 'EMR');
AwsService.EMRCONTAINERS = new AwsService('emr-containers', 'EMRcontainers');
AwsService.EMRSERVERLESS = new AwsService('emr-serverless', 'EMRServerless');
AwsService.ES = new AwsService('es', 'ES');
AwsService.EVIDENTLY = new AwsService('evidently', 'Evidently');
AwsService.FINSPACE = new AwsService('finspace', 'Finspace');
AwsService.FINSPACEDATA = new AwsService('finspace-data', 'Finspacedata');
AwsService.FIREHOSE = new AwsService('firehose', 'Firehose');
AwsService.FIS = new AwsService('fis', 'Fis');
AwsService.FMS = new AwsService('fms', 'FMS');
AwsService.FRAUD_DETECTOR = new AwsService('frauddetector', 'FraudDetector');
AwsService.FSX = new AwsService('fsx', 'FSx');
AwsService.GAME_LIFT = new AwsService('gamelift', 'GameLift');
AwsService.GAME_SPARKS = new AwsService('gamesparks', 'GameSparks');
AwsService.GLACIER = new AwsService('glacier', 'Glacier');
AwsService.GLOBAL_ACCELERATOR = new AwsService('globalaccelerator', 'GlobalAccelerator');
AwsService.GLUE = new AwsService('glue', 'Glue');
AwsService.GRAFANA = new AwsService('grafana', 'Grafana');
AwsService.GREENGRASS = new AwsService('greengrass', 'Greengrass');
AwsService.GREENGRASS_V2 = new AwsService('greengrassv2', 'GreengrassV2');
AwsService.GROUND_STATION = new AwsService('groundstation', 'GroundStation');
AwsService.GUARD_DUTY = new AwsService('guardduty', 'GuardDuty');
AwsService.HEALTH = new AwsService('health', 'Health');
AwsService.HEALTH_LAKE = new AwsService('healthlake', 'HealthLake');
AwsService.HONEYCODE = new AwsService('honeycode', 'Honeycode');
AwsService.IAM = new AwsService('iam', 'IAM');
AwsService.IDENTITY_STORE = new AwsService('identitystore', 'IdentityStore');
AwsService.IMAGEBUILDER = new AwsService('imagebuilder', 'Imagebuilder');
AwsService.IMPORT_EXPORT = new AwsService('importexport', 'ImportExport');
AwsService.INSPECTOR = new AwsService('inspector', 'Inspector');
AwsService.INSPECTOR2 = new AwsService('inspector2', 'Inspector2');
AwsService.IOT = new AwsService('iot', 'Iot');
AwsService.IO_T1_CLICK_PROJECTS = new AwsService('iot1click-projects', 'IoT1ClickProjects');
AwsService.IO_T_ANALYTICS = new AwsService('iotanalytics', 'IoTAnalytics');
AwsService.IOT_DATA = new AwsService('iot-data', 'IotData');
AwsService.IOT_DEVICE_ADVISOR = new AwsService('iotdeviceadvisor', 'IotDeviceAdvisor');
AwsService.IOT_EVENTS = new AwsService('iotevents', 'IoTEvents');
AwsService.IOT_EVENTS_DATA = new AwsService('iotevents-data', 'IoTEventsData');
AwsService.IOT_FLEET_HUB = new AwsService('iotfleethub', 'IoTFleetHub');
AwsService.IOT_FLEET_WISE = new AwsService('iotfleetwise', 'IoTFleetWise');
AwsService.IOT_SECURE_TUNNELING = new AwsService('iotsecuretunneling', 'IoTSecureTunneling');
AwsService.IOT_SITE_WISE = new AwsService('iotsitewise', 'IoTSiteWise');
AwsService.IOT_THINGS_GRAPH = new AwsService('iotthingsgraph', 'IoTThingsGraph');
AwsService.IOT_TWIN_MAKER = new AwsService('iottwinmaker', 'IoTTwinMaker');
AwsService.IOT_WIRELESS = new AwsService('iotwireless', 'IoTWireless');
AwsService.IVS = new AwsService('ivs', 'IVS');
AwsService.IVSCHAT = new AwsService('ivschat', 'Ivschat');
AwsService.KAFKA = new AwsService('kafka', 'Kafka');
AwsService.KAFKA_CONNECT = new AwsService('kafkaconnect', 'KafkaConnect');
AwsService.KENDRA = new AwsService('kendra', 'Kendra');
AwsService.KEYSPACES = new AwsService('keyspaces', 'Keyspaces');
AwsService.KINESIS = new AwsService('kinesis', 'Kinesis');
AwsService.KINESIS_ANALYTICS = new AwsService('kinesisanalytics', 'KinesisAnalytics');
AwsService.KINESIS_ANALYTICS_V2 = new AwsService('kinesisanalyticsv2', 'KinesisAnalyticsV2');
AwsService.KINESIS_VIDEO = new AwsService('kinesisvideo', 'KinesisVideo');
AwsService.KINESIS_VIDEO_ARCHIVED_MEDIA = new AwsService('kinesis-video-archived-media', 'KinesisVideoArchivedMedia');
AwsService.KINESIS_VIDEO_MEDIA = new AwsService('kinesis-video-media', 'KinesisVideoMedia');
AwsService.KMS = new AwsService('kms', 'KMS');
AwsService.LAKE_FORMATION = new AwsService('lakeformation', 'LakeFormation');
AwsService.LAMBDA = new AwsService('lambda', 'Lambda');
AwsService.LEX_RUNTIME = new AwsService('lex-runtime', 'LexRuntime');
AwsService.LICENSE_MANAGER = new AwsService('license-manager', 'LicenseManager');
AwsService.LICENSE_MANAGER_USER_SUBSCRIPTIONS = new AwsService('license-manager-user-subscriptions', 'LicenseManagerUserSubscriptions');
AwsService.LIGHTSAIL = new AwsService('lightsail', 'Lightsail');
AwsService.LOCATION = new AwsService('location', 'Location');
AwsService.LOOKOUT_EQUIPMENT = new AwsService('lookoutequipment', 'LookoutEquipment');
AwsService.LOOKOUT_METRICS = new AwsService('lookoutmetrics', 'LookoutMetrics');
AwsService.LOOKOUT_VISION = new AwsService('lookoutvision', 'LookoutVision');
AwsService.M2 = new AwsService('m2', 'M2');
AwsService.MACHINE_LEARNING = new AwsService('machinelearning', 'MachineLearning');
AwsService.MACIE = new AwsService('macie', 'Macie');
AwsService.MACIE2 = new AwsService('macie2', 'Macie2');
AwsService.MANAGED_BLOCKCHAIN = new AwsService('managedblockchain', 'ManagedBlockchain');
AwsService.MARKETPLACE_CATALOG = new AwsService('marketplace-catalog', 'MarketplaceCatalog');
AwsService.MARKETPLACE_COMMERCE_ANALYTICS = new AwsService('marketplacecommerceanalytics', 'MarketplaceCommerceAnalytics');
AwsService.MEDIA_CONNECT = new AwsService('mediaconnect', 'MediaConnect');
AwsService.MEDIA_CONVERT = new AwsService('mediaconvert', 'MediaConvert');
AwsService.MEDIA_LIVE = new AwsService('medialive', 'MediaLive');
AwsService.MEDIA_PACKAGE = new AwsService('mediapackage', 'MediaPackage');
AwsService.MEDIA_PACKAGE_VOD = new AwsService('mediapackage-vod', 'MediaPackageVod');
AwsService.MEDIA_STORE = new AwsService('mediastore', 'MediaStore');
AwsService.MEDIA_STORE_DATA = new AwsService('mediastore-data', 'MediaStoreData');
AwsService.MEDIA_TAILOR = new AwsService('mediatailor', 'MediaTailor');
AwsService.MEMORY_DB = new AwsService('memorydb', 'MemoryDB');
AwsService.MGN = new AwsService('mgn', 'Mgn');
AwsService.MIGRATION_HUB_CONFIG = new AwsService('migrationhub-config', 'MigrationHubConfig');
AwsService.MIGRATION_HUB_ORCHESTRATOR = new AwsService('migrationhuborchestrator', 'MigrationHubOrchestrator');
AwsService.MIGRATION_HUB_REFACTOR_SPACES = new AwsService('migration-hub-refactor-spaces', 'MigrationHubRefactorSpaces');
AwsService.MIGRATION_HUB_STRATEGY = new AwsService('migrationhubstrategy', 'MigrationHubStrategy');
AwsService.MOBILE = new AwsService('mobile', 'Mobile');
AwsService.MQ = new AwsService('mq', 'MQ');
AwsService.MTURK = new AwsService('mturk', 'MTurk');
AwsService.MWAA = new AwsService('mwaa', 'MWAA');
AwsService.NEPTUNE = new AwsService('neptune', 'Neptune');
AwsService.NETWORK_FIREWALL = new AwsService('network-firewall', 'NetworkFirewall');
AwsService.NETWORK_MANAGER = new AwsService('networkmanager', 'NetworkManager');
AwsService.NIMBLE = new AwsService('nimble', 'Nimble');
AwsService.OPEN_SEARCH = new AwsService('opensearch', 'OpenSearch');
AwsService.OPS_WORKS = new AwsService('opsworks', 'OpsWorks');
AwsService.OPS_WORKS_C_M = new AwsService('opsworkscm', 'OpsWorksCM');
AwsService.ORGANIZATIONS = new AwsService('organizations', 'Organizations');
AwsService.OUTPOSTS = new AwsService('outposts', 'Outposts');
AwsService.PANORAMA = new AwsService('panorama', 'Panorama');
AwsService.PERSONALIZE = new AwsService('personalize', 'Personalize');
AwsService.PERSONALIZE_EVENTS = new AwsService('personalize-events', 'PersonalizeEvents');
AwsService.PERSONALIZE_RUNTIME = new AwsService('personalize-runtime', 'PersonalizeRuntime');
AwsService.PI = new AwsService('pi', 'PI');
AwsService.PINPOINT = new AwsService('pinpoint', 'Pinpoint');
AwsService.PINPOINT_EMAIL = new AwsService('pinpoint-email', 'PinpointEmail');
AwsService.PINPOINT_SMS_VOICE = new AwsService('pinpoint-sms-voice', 'PinpointSMSVoice');
AwsService.PINPOINT_SMS_VOICE_V2 = new AwsService('pinpoint-sms-voice-v2', 'PinpointSMSVoiceV2');
AwsService.POLLY = new AwsService('polly', 'Polly');
AwsService.PRICING = new AwsService('pricing', 'Pricing');
AwsService.PRIVATE_NETWORKS = new AwsService('privatenetworks', 'PrivateNetworks');
AwsService.PROTON = new AwsService('proton', 'Proton');
AwsService.QLDB = new AwsService('qldb', 'QLDB');
AwsService.QLDB_SESSION = new AwsService('qldb-session', 'QLDBSession');
AwsService.QUICK_SIGHT = new AwsService('quicksight', 'QuickSight');
AwsService.RAM = new AwsService('ram', 'RAM');
AwsService.RBIN = new AwsService('rbin', 'Rbin');
AwsService.RDS = new AwsService('rds', 'RDS');
AwsService.REDSHIFT = new AwsService('redshift', 'Redshift');
AwsService.REDSHIFT_DATA = new AwsService('redshift-data', 'RedshiftData');
AwsService.REDSHIFT_SERVERLESS = new AwsService('redshift-serverless', 'RedshiftServerless');
AwsService.REKOGNITION = new AwsService('rekognition', 'Rekognition');
AwsService.RESILIENCEHUB = new AwsService('resiliencehub', 'Resiliencehub');
AwsService.RESOURCE_EXPLORER2 = new AwsService('resource-explorer-2', 'ResourceExplorer2');
AwsService.RESOURCE_GROUPS = new AwsService('resource-groups', 'ResourceGroups');
AwsService.RESOURCE_GROUPS_TAGGING_AP_I = new AwsService('resourcegroupstaggingapi', 'ResourceGroupsTaggingAPI');
AwsService.ROBO_MAKER = new AwsService('robomaker', 'RoboMaker');
AwsService.ROLES_ANYWHERE = new AwsService('rolesanywhere', 'RolesAnywhere');
AwsService.ROUTE53 = new AwsService('route53', 'Route53');
AwsService.ROUTE53_DOMAINS = new AwsService('route53domains', 'Route53Domains');
AwsService.ROUTE53_RECOVERY_CLUSTER = new AwsService('route53-recovery-cluster', 'Route53RecoveryCluster');
AwsService.ROUTE53_RECOVERY_CONTROL_CONFIG = new AwsService('route53-recovery-control-config', 'Route53RecoveryControlConfig');
AwsService.ROUTE53_RECOVERY_READINESS = new AwsService('route53-recovery-readiness', 'Route53RecoveryReadiness');
AwsService.ROUTE53_RESOLVER = new AwsService('route53resolver', 'Route53Resolver');
AwsService.RUM = new AwsService('rum', 'RUM');
AwsService.S3 = new AwsService('s3', 'S3');
AwsService.S3_CONTROL = new AwsService('s3control', 'S3Control');
AwsService.S3_OUTPOSTS = new AwsService('s3outposts', 'S3Outposts');
AwsService.SAGE_MAKER = new AwsService('sagemaker', 'SageMaker');
AwsService.SAGEMAKER_EDGE = new AwsService('sagemaker-edge', 'SagemakerEdge');
AwsService.SAGE_MAKER_FEATURE_STORE_RUNTIME = new AwsService('sagemaker-featurestore-runtime', 'SageMakerFeatureStoreRuntime');
AwsService.SAGE_MAKER_RUNTIME = new AwsService('sagemaker-runtime', 'SageMakerRuntime');
AwsService.SAVINGS_PLANS = new AwsService('savingsplans', 'SavingsPlans');
AwsService.SCHEDULER = new AwsService('scheduler', 'Scheduler');
AwsService.SCHEMAS = new AwsService('schemas', 'Schemas');
AwsService.SECRETS_MANAGER = new AwsService('secretsmanager', 'SecretsManager');
AwsService.SECURITY_HUB = new AwsService('securityhub', 'SecurityHub');
AwsService.SERVICE_CATALOG = new AwsService('servicecatalog', 'ServiceCatalog');
AwsService.SERVICE_CATALOG_APP_REGISTRY = new AwsService('servicecatalog-appregistry', 'ServiceCatalogAppRegistry');
AwsService.SERVICE_DISCOVERY = new AwsService('servicediscovery', 'ServiceDiscovery');
AwsService.SERVICE_QUOTAS = new AwsService('service-quotas', 'ServiceQuotas');
AwsService.SES = new AwsService('ses', 'SES');
AwsService.SES_V2 = new AwsService('sesv2', 'SESV2');
AwsService.SHIELD = new AwsService('shield', 'Shield');
AwsService.SIGNER = new AwsService('signer', 'Signer');
AwsService.SMS = new AwsService('sms', 'SMS');
AwsService.SNOWBALL = new AwsService('snowball', 'Snowball');
AwsService.SNOW_DEVICE_MANAGEMENT = new AwsService('snow-device-management', 'SnowDeviceManagement');
AwsService.SNS = new AwsService('sns', 'SNS');
AwsService.SQS = new AwsService('sqs', 'SQS');
AwsService.SSM = new AwsService('ssm', 'SSM');
AwsService.SSM_CONTACTS = new AwsService('ssm-contacts', 'SSMContacts');
AwsService.SSM_INCIDENTS = new AwsService('ssm-incidents', 'SSMIncidents');
AwsService.SSO = new AwsService('sso', 'SSO');
AwsService.SSO_ADMIN = new AwsService('sso-admin', 'SSOAdmin');
AwsService.SSO_OIDC = new AwsService('sso-oidc', 'SSOOIDC');
AwsService.STEP_FUNCTIONS = new AwsService('stepfunctions', 'StepFunctions');
AwsService.STORAGE_GATEWAY = new AwsService('storagegateway', 'StorageGateway');
AwsService.STS = new AwsService('sts', 'STS');
AwsService.SUPPORT = new AwsService('support', 'Support');
AwsService.SUPPORT_APP = new AwsService('support-app', 'SupportApp');
AwsService.SWF = new AwsService('swf', 'SWF');
AwsService.SYNTHETICS = new AwsService('synthetics', 'Synthetics');
AwsService.TEXTRACT = new AwsService('textract', 'Textract');
AwsService.TIMESTREAM_QUERY = new AwsService('timestream-query', 'TimestreamQuery');
AwsService.TIMESTREAM_WRITE = new AwsService('timestream-write', 'TimestreamWrite');
AwsService.TRANSFER = new AwsService('transfer', 'Transfer');
AwsService.TRANSLATE = new AwsService('translate', 'Translate');
AwsService.VOICE_I_D = new AwsService('voice-id', 'VoiceID');
AwsService.WAF = new AwsService('waf', 'WAF');
AwsService.WAF_REGIONAL = new AwsService('waf-regional', 'WAFRegional');
AwsService.WAF_V2 = new AwsService('wafv2', 'WAFV2');
AwsService.WELL_ARCHITECTED = new AwsService('wellarchitected', 'WellArchitected');
AwsService.WISDOM = new AwsService('wisdom', 'Wisdom');
AwsService.WORK_DOCS = new AwsService('workdocs', 'WorkDocs');
AwsService.WORK_LINK = new AwsService('worklink', 'WorkLink');
AwsService.WORK_MAIL = new AwsService('workmail', 'WorkMail');
AwsService.WORK_MAIL_MESSAGE_FLOW = new AwsService('workmailmessageflow', 'WorkMailMessageFlow');
AwsService.WORK_SPACES = new AwsService('workspaces', 'WorkSpaces');
AwsService.WORK_SPACES_WEB = new AwsService('workspaces-web', 'WorkSpacesWeb');
AwsService.XRAY = new AwsService('xray', 'XRay');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLXNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZG9tYWluL2F3cy1zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxVQUFVO0lBcVRyQixZQUFZLFNBQWlCLEVBQUUsY0FBc0I7UUFDbkQsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUM7SUFDdkMsQ0FBQztJQUVELE1BQU07UUFDSixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUE1VEgsZ0NBOFRDOzs7QUE1VGlCLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNqRixrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLGlCQUFNLEdBQWUsSUFBSSxVQUFVLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0FBQ3pELDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDeEYsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCwwQkFBZSxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixDQUFDLENBQUM7QUFDakYsNkJBQWtCLEdBQWUsSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN4RixxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNwRSxxQ0FBMEIsR0FBZSxJQUFJLFVBQVUsQ0FBQyx5QkFBeUIsRUFBRSx5QkFBeUIsQ0FBQyxDQUFDO0FBQzlHLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzVFLHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2xFLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQy9FLGtCQUFPLEdBQWUsSUFBSSxVQUFVLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBQzNELDJCQUFnQixHQUFlLElBQUksVUFBVSxDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixDQUFDLENBQUM7QUFDcEYsbUNBQXdCLEdBQWUsSUFBSSxVQUFVLENBQUMseUJBQXlCLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztBQUMzRyxvQ0FBeUIsR0FBZSxJQUFJLFVBQVUsQ0FBQyx5QkFBeUIsRUFBRSx5QkFBeUIsQ0FBQyxDQUFDO0FBQzdHLCtCQUFvQixHQUFlLElBQUksVUFBVSxDQUFDLHNCQUFzQixFQUFFLHFCQUFxQixDQUFDLENBQUM7QUFDakcsbUJBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDNUQscUJBQVUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDbEUscUJBQVUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDbEUsbUJBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDNUQsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFDeEQsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDM0UsdUJBQVksR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDeEUsNkJBQWtCLEdBQWUsSUFBSSxVQUFVLENBQUMsbUJBQW1CLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN6RixpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4RCx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQy9FLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQzlFLGdCQUFLLEdBQWUsSUFBSSxVQUFVLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ3JELDJCQUFnQixHQUFlLElBQUksVUFBVSxDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDdEYsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFDeEQsa0JBQU8sR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDM0QsZ0JBQUssR0FBZSxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckQsNkJBQWtCLEdBQWUsSUFBSSxVQUFVLENBQUMsb0JBQW9CLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUMxRixvQ0FBeUIsR0FBZSxJQUFJLFVBQVUsQ0FBQywyQkFBMkIsRUFBRSx3QkFBd0IsQ0FBQyxDQUFDO0FBQzlHLDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLG9CQUFvQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDMUYsOEJBQW1CLEdBQWUsSUFBSSxVQUFVLENBQUMscUJBQXFCLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUM3RixpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4RCx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSwwQkFBZSxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixDQUFDLENBQUM7QUFDakYsMEJBQWUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ2pGLHNCQUFXLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3JFLHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQ2hFLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3RFLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsYUFBYSxFQUFFLGFBQWEsQ0FBQyxDQUFDO0FBQ3hFLDhCQUFtQixHQUFlLElBQUksVUFBVSxDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixDQUFDLENBQUM7QUFDM0Ysc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDM0UscUJBQVUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDbEUsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsNkJBQWtCLEdBQWUsSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN4Riw2QkFBa0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxtQkFBbUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO0FBQ3pGLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzNFLG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9ELCtCQUFvQixHQUFlLElBQUksVUFBVSxDQUFDLHNCQUFzQixFQUFFLHFCQUFxQixDQUFDLENBQUM7QUFDakcsa0NBQXVCLEdBQWUsSUFBSSxVQUFVLENBQUMsd0JBQXdCLEVBQUUsdUJBQXVCLENBQUMsQ0FBQztBQUN4RywyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3JGLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGFBQWEsQ0FBQyxDQUFDO0FBQ3pFLHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3BFLDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixDQUFDLENBQUM7QUFDMUYsNEJBQWlCLEdBQWUsSUFBSSxVQUFVLENBQUMsbUJBQW1CLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN4RixrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCw0QkFBaUIsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO0FBQ3ZGLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzNFLCtCQUFvQixHQUFlLElBQUksVUFBVSxDQUFDLHNCQUFzQixFQUFFLG9CQUFvQixDQUFDLENBQUM7QUFDaEcsOEJBQW1CLEdBQWUsSUFBSSxVQUFVLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUM3Rix3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLDRCQUFpQixHQUFlLElBQUksVUFBVSxDQUFDLG1CQUFtQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDeEYsb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDL0Qsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDM0Usd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDM0Usb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDL0QsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNqRSxzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNyRSx1QkFBWSxHQUFlLElBQUksVUFBVSxDQUFDLGFBQWEsRUFBRSxZQUFZLENBQUMsQ0FBQztBQUN2RSx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGVBQWUsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM5RSxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNqRSxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDdEQsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUMvRCw0QkFBaUIsR0FBZSxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3JGLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQywrQkFBb0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxzQkFBc0IsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0FBQ2hHLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0Msb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDbEUsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsdUJBQVksR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDeEUsNEJBQWlCLEdBQWUsSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN2Riw0QkFBaUIsR0FBZSxJQUFJLFVBQVUsQ0FBQyxtQkFBbUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO0FBQ3hGLDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixDQUFDLENBQUM7QUFDMUYsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxnQkFBSyxHQUFlLElBQUksVUFBVSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNyRCxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFDOUUsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM5RSxhQUFFLEdBQWUsSUFBSSxVQUFVLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQzVDLG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2pFLG1CQUFRLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQzlELHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzNFLG1CQUFRLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQzlELGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGVBQWUsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM5RSxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9ELHNCQUFXLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3JFLGtCQUFPLEdBQWUsSUFBSSxVQUFVLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBQzNELDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixDQUFDLENBQUM7QUFDMUYsZUFBSSxHQUFlLElBQUksVUFBVSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNsRCxrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNwRSx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGVBQWUsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM5RSxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNsRSxpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4RCxzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNyRSxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNqRSxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQzlFLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzFFLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzNFLG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2pFLHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3BFLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsK0JBQW9CLEdBQWUsSUFBSSxVQUFVLENBQUMsb0JBQW9CLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUM3Rix5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUM1RSxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUM3RCw2QkFBa0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO0FBQ3hGLHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2xFLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFDaEYsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDekUseUJBQWMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDNUUsK0JBQW9CLEdBQWUsSUFBSSxVQUFVLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUM5Rix3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGFBQWEsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUN6RSwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ2xGLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzVFLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsYUFBYSxFQUFFLGFBQWEsQ0FBQyxDQUFDO0FBQ3hFLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0Msa0JBQU8sR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDM0QsZ0JBQUssR0FBZSxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckQsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDM0UsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFDeEQsb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDakUsa0JBQU8sR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDM0QsNEJBQWlCLEdBQWUsSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN2RiwrQkFBb0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxvQkFBb0IsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0FBQzlGLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzNFLHVDQUE0QixHQUFlLElBQUksVUFBVSxDQUFDLDhCQUE4QixFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFDdkgsOEJBQW1CLEdBQWUsSUFBSSxVQUFVLENBQUMscUJBQXFCLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUM3RixjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQzlFLGlCQUFNLEdBQWUsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0FBQ3hELHNCQUFXLEdBQWUsSUFBSSxVQUFVLENBQUMsYUFBYSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3RFLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsaUJBQWlCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNsRiw2Q0FBa0MsR0FBZSxJQUFJLFVBQVUsQ0FBQyxvQ0FBb0MsRUFBRSxpQ0FBaUMsQ0FBQyxDQUFDO0FBQ3pJLG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2pFLG1CQUFRLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQzlELDRCQUFpQixHQUFlLElBQUksVUFBVSxDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDdkYsMEJBQWUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ2pGLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQzlFLGFBQUUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDNUMsMkJBQWdCLEdBQWUsSUFBSSxVQUFVLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztBQUNwRixnQkFBSyxHQUFlLElBQUksVUFBVSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNyRCxpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4RCw2QkFBa0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0FBQzFGLDhCQUFtQixHQUFlLElBQUksVUFBVSxDQUFDLHFCQUFxQixFQUFFLG9CQUFvQixDQUFDLENBQUM7QUFDOUYseUNBQThCLEdBQWUsSUFBSSxVQUFVLENBQUMsOEJBQThCLEVBQUUsOEJBQThCLENBQUMsQ0FBQztBQUM1SCx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNsRSx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSw0QkFBaUIsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3RGLHNCQUFXLEdBQWUsSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQ3JFLDJCQUFnQixHQUFlLElBQUksVUFBVSxDQUFDLGlCQUFpQixFQUFFLGdCQUFnQixDQUFDLENBQUM7QUFDbkYsdUJBQVksR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDeEUsb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDL0QsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQywrQkFBb0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxxQkFBcUIsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0FBQy9GLHFDQUEwQixHQUFlLElBQUksVUFBVSxDQUFDLDBCQUEwQixFQUFFLDBCQUEwQixDQUFDLENBQUM7QUFDaEgsd0NBQTZCLEdBQWUsSUFBSSxVQUFVLENBQUMsK0JBQStCLEVBQUUsNEJBQTRCLENBQUMsQ0FBQztBQUMxSCxpQ0FBc0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO0FBQ3BHLGlCQUFNLEdBQWUsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0FBQ3hELGFBQUUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDNUMsZ0JBQUssR0FBZSxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckQsZUFBSSxHQUFlLElBQUksVUFBVSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNsRCxrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3JGLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNqRixpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztBQUN4RCxzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNyRSxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUMvRCx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUN2RSx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGVBQWUsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM3RSxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM5RCxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM5RCxzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLGFBQWEsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUN2RSw2QkFBa0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxvQkFBb0IsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0FBQzNGLDhCQUFtQixHQUFlLElBQUksVUFBVSxDQUFDLHFCQUFxQixFQUFFLG9CQUFvQixDQUFDLENBQUM7QUFDOUYsYUFBRSxHQUFlLElBQUksVUFBVSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztBQUM1QyxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM5RCx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQy9FLDZCQUFrQixHQUFlLElBQUksVUFBVSxDQUFDLG9CQUFvQixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFDMUYsZ0NBQXFCLEdBQWUsSUFBSSxVQUFVLENBQUMsdUJBQXVCLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUNsRyxnQkFBSyxHQUFlLElBQUksVUFBVSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNyRCxrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3BGLGlCQUFNLEdBQWUsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0FBQ3hELGVBQUksR0FBZSxJQUFJLFVBQVUsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDbEQsdUJBQVksR0FBZSxJQUFJLFVBQVUsQ0FBQyxjQUFjLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDekUsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxlQUFJLEdBQWUsSUFBSSxVQUFVLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2xELGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsbUJBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDOUQsd0JBQWEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxlQUFlLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDNUUsOEJBQW1CLEdBQWUsSUFBSSxVQUFVLENBQUMscUJBQXFCLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUM5RixzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLGFBQWEsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUN2RSx3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGVBQWUsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUM3RSw2QkFBa0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxxQkFBcUIsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0FBQzVGLDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsaUJBQWlCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNsRix1Q0FBNEIsR0FBZSxJQUFJLFVBQVUsQ0FBQywwQkFBMEIsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO0FBQ2xILHFCQUFVLEdBQWUsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ2xFLHlCQUFjLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQzlFLGtCQUFPLEdBQWUsSUFBSSxVQUFVLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBQzNELDBCQUFlLEdBQWUsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNqRixtQ0FBd0IsR0FBZSxJQUFJLFVBQVUsQ0FBQywwQkFBMEIsRUFBRSx3QkFBd0IsQ0FBQyxDQUFDO0FBQzVHLDBDQUErQixHQUFlLElBQUksVUFBVSxDQUFDLGlDQUFpQyxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFDaEkscUNBQTBCLEdBQWUsSUFBSSxVQUFVLENBQUMsNEJBQTRCLEVBQUUsMEJBQTBCLENBQUMsQ0FBQztBQUNsSCwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3BGLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsYUFBRSxHQUFlLElBQUksVUFBVSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztBQUM1QyxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNsRSxzQkFBVyxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNyRSxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNsRSx5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQy9FLDJDQUFnQyxHQUFlLElBQUksVUFBVSxDQUFDLGdDQUFnQyxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFDaEksNkJBQWtCLEdBQWUsSUFBSSxVQUFVLENBQUMsbUJBQW1CLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN6Rix3QkFBYSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQztBQUMzRSxvQkFBUyxHQUFlLElBQUksVUFBVSxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUNqRSxrQkFBTyxHQUFlLElBQUksVUFBVSxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztBQUMzRCwwQkFBZSxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixDQUFDLENBQUM7QUFDakYsdUJBQVksR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDeEUsMEJBQWUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ2pGLHVDQUE0QixHQUFlLElBQUksVUFBVSxDQUFDLDRCQUE0QixFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFDckgsNEJBQWlCLEdBQWUsSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUN2Rix5QkFBYyxHQUFlLElBQUksVUFBVSxDQUFDLGdCQUFnQixFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQy9FLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDdEQsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFDeEQsaUJBQU0sR0FBZSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFDeEQsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM5RCxpQ0FBc0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyx3QkFBd0IsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO0FBQ3RHLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0MsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxjQUFHLEdBQWUsSUFBSSxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQy9DLHVCQUFZLEdBQWUsSUFBSSxVQUFVLENBQUMsY0FBYyxFQUFFLGFBQWEsQ0FBQyxDQUFDO0FBQ3pFLHdCQUFhLEdBQWUsSUFBSSxVQUFVLENBQUMsZUFBZSxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBQzVFLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0Msb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDaEUsbUJBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDN0QseUJBQWMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxlQUFlLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFDOUUsMEJBQWUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ2pGLGNBQUcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDL0Msa0JBQU8sR0FBZSxJQUFJLFVBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDM0Qsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxhQUFhLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDdEUsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyxxQkFBVSxHQUFlLElBQUksVUFBVSxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztBQUNwRSxtQkFBUSxHQUFlLElBQUksVUFBVSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM5RCwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3JGLDJCQUFnQixHQUFlLElBQUksVUFBVSxDQUFDLGtCQUFrQixFQUFFLGlCQUFpQixDQUFDLENBQUM7QUFDckYsbUJBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFDOUQsb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDakUsb0JBQVMsR0FBZSxJQUFJLFVBQVUsQ0FBQyxVQUFVLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDOUQsY0FBRyxHQUFlLElBQUksVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMvQyx1QkFBWSxHQUFlLElBQUksVUFBVSxDQUFDLGNBQWMsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUN6RSxpQkFBTSxHQUFlLElBQUksVUFBVSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUN0RCwyQkFBZ0IsR0FBZSxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBQ3BGLGlCQUFNLEdBQWUsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0FBQ3hELG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9ELG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9ELG9CQUFTLEdBQWUsSUFBSSxVQUFVLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9ELGlDQUFzQixHQUFlLElBQUksVUFBVSxDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixDQUFDLENBQUM7QUFDbEcsc0JBQVcsR0FBZSxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFDckUsMEJBQWUsR0FBZSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsRUFBRSxlQUFlLENBQUMsQ0FBQztBQUNoRixlQUFJLEdBQWUsSUFBSSxVQUFVLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZXByZXNlbnRzIGFuIEFXUyBzZXJ2aWNlLlxuICogVGhlIG5hbWVzcGFjZSB3aGljaCBpcyBtZWFudCB0byBiZSB1c2VkIGZvciB0aGUgc2VydmljZSBkZWNsYXJhdGlvbiBpbiBTU00gbWF5IGJlIGRpZmZpY3VsdCB0byBndWVzcy5cbiAqIFRoZSBuYW1lIHByb3ZpZGVkIGZvciBzaW11bGF0aW9uIG1heSBhdCB0aW1lcyBiZSBkaWZmZXJlbnQuXG4gKiBUaGlzIGNsYXNzIHByb3ZpZGVzIG1hbnkgcmVhZHktdG8tdXNlIGltcGxlbWVudGF0aW9ucyBvZiBBV1Mgc2VydmljZXMuXG4gKiBJZiBhIHNlcnZpY2UgaXMgbm90IG9uIHRoZSBsaXN0LCB5b3UgY2FuIGZhbGwgYmFjayB0byBjb25zdHJ1Y3RpbmcgdGhpcyBvYmplY3Qgb24geW91ciBvd24uXG4gKiBJbiBvdGhlciB3b3JkcywgeW91IGNhbiByZWZlcmVuY2UgUzMgdXNpbmcgYEF3c1NlcnZpY2UuUzNgXG4gKiBGb3IgYSBOZXdTZXJ2aWNlLCB5b3UgY2FuIHJlZmVyZW5jZSBpdCB1c2luZyBgbmV3IEF3c1NlcnZpY2UoJ25ldy1zZXJ2aWNlJywgJ05ld1NlcnZpY2UnKWAuXG4gKiBJdCBpcyByaXNreSB0byBhdXRvIGNvbnZlcnQgYmV0d2VlbiBuYW1lc3BhY2UgYW5kIGphdmFTY3JpcHROYW1lIGJlY2F1c2UgdGhleSBhcmUgbm90IGNvbnNpc3RlbnQgaW4gYWxsIGNhc2VzLlxuICovXG5leHBvcnQgY2xhc3MgQXdzU2VydmljZSB7XG5cbiAgc3RhdGljIHJlYWRvbmx5IEFDQ0VTU19BTkFMWVpFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhY2Nlc3NhbmFseXplcicsICdBY2Nlc3NBbmFseXplcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgQUNDT1VOVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhY2NvdW50JywgJ0FjY291bnQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFDTTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhY20nLCAnQUNNJyk7XG4gIHN0YXRpYyByZWFkb25seSBBQ01QQ0E6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYWNtLXBjYScsICdBQ01QQ0EnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFMRVhBX0ZPUl9CVVNJTkVTUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhbGV4YWZvcmJ1c2luZXNzJywgJ0FsZXhhRm9yQnVzaW5lc3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFNUDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhbXAnLCAnQW1wJyk7XG4gIHN0YXRpYyByZWFkb25seSBBTVBMSUZZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FtcGxpZnknLCAnQW1wbGlmeScpO1xuICBzdGF0aWMgcmVhZG9ubHkgQU1QTElGWV9CQUNLRU5EOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FtcGxpZnliYWNrZW5kJywgJ0FtcGxpZnlCYWNrZW5kJyk7XG4gIHN0YXRpYyByZWFkb25seSBBTVBMSUZZX1VJX0JVSUxERVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYW1wbGlmeXVpYnVpbGRlcicsICdBbXBsaWZ5VUlCdWlsZGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBBUElHQVRFV0FZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwaWdhdGV3YXknLCAnQVBJR2F0ZXdheScpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVBJX0dBVEVXQVlfTUFOQUdFTUVOVF9BUEk6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXBpZ2F0ZXdheW1hbmFnZW1lbnRhcGknLCAnQXBpR2F0ZXdheU1hbmFnZW1lbnRBcGknKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQSV9HQVRFV0FZX1YyOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwaWdhdGV3YXl2MicsICdBcGlHYXRld2F5VjInKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUF9DT05GSUc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXBwY29uZmlnJywgJ0FwcENvbmZpZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVBQX0NPTkZJR19EQVRBOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcGNvbmZpZ2RhdGEnLCAnQXBwQ29uZmlnRGF0YScpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVBQRkxPVzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhcHBmbG93JywgJ0FwcGZsb3cnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUF9JTlRFR1JBVElPTlM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXBwaW50ZWdyYXRpb25zJywgJ0FwcEludGVncmF0aW9ucycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVBQTElDQVRJT05fQVVUT19TQ0FMSU5HOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcGxpY2F0aW9uLWF1dG9zY2FsaW5nJywgJ0FwcGxpY2F0aW9uQXV0b1NjYWxpbmcnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUExJQ0FUSU9OX0NPU1RfUFJPRklMRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXBwbGljYXRpb25jb3N0cHJvZmlsZXInLCAnQXBwbGljYXRpb25Db3N0UHJvZmlsZXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUExJQ0FUSU9OX0lOU0lHSFRTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcGxpY2F0aW9uLWluc2lnaHRzJywgJ0FwcGxpY2F0aW9uSW5zaWdodHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUF9NRVNIOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcG1lc2gnLCAnQXBwTWVzaCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVBQX1JVTk5FUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdhcHBydW5uZXInLCAnQXBwUnVubmVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBBUFBfU1RSRUFNOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcHN0cmVhbScsICdBcHBTdHJlYW0nKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFQUF9TWU5DOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2FwcHN5bmMnLCAnQXBwU3luYycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVRIRU5BOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2F0aGVuYScsICdBdGhlbmEnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEFVRElUX01BTkFHRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXVkaXRtYW5hZ2VyJywgJ0F1ZGl0TWFuYWdlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgQVVUT19TQ0FMSU5HOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2F1dG9zY2FsaW5nJywgJ0F1dG9TY2FsaW5nJyk7XG4gIHN0YXRpYyByZWFkb25seSBBVVRPX1NDQUxJTkdfUExBTlM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYXV0b3NjYWxpbmctcGxhbnMnLCAnQXV0b1NjYWxpbmdQbGFucycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQkFDS1VQOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2JhY2t1cCcsICdCYWNrdXAnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEJBQ0tVUF9HQVRFV0FZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2JhY2t1cC1nYXRld2F5JywgJ0JhY2t1cEdhdGV3YXknKTtcbiAgc3RhdGljIHJlYWRvbmx5IEJBQ0tVUF9TVE9SQUdFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2JhY2t1cHN0b3JhZ2UnLCAnQmFja3VwU3RvcmFnZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgQkFUQ0g6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYmF0Y2gnLCAnQmF0Y2gnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEJJTExJTkdDT05EVUNUT1I6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYmlsbGluZ2NvbmR1Y3RvcicsICdCaWxsaW5nY29uZHVjdG9yJyk7XG4gIHN0YXRpYyByZWFkb25seSBCUkFLRVQ6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnYnJha2V0JywgJ0JyYWtldCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQlVER0VUUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdidWRnZXRzJywgJ0J1ZGdldHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENISU1FOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NoaW1lJywgJ0NoaW1lJyk7XG4gIHN0YXRpYyByZWFkb25seSBDSElNRV9TREtfSURFTlRJVFk6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2hpbWUtc2RrLWlkZW50aXR5JywgJ0NoaW1lU0RLSWRlbnRpdHknKTtcbiAgc3RhdGljIHJlYWRvbmx5IENISU1FX1NES19NRURJQV9QSVBFTElORVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2hpbWUtc2RrLW1lZGlhLXBpcGVsaW5lcycsICdDaGltZVNES01lZGlhUGlwZWxpbmVzJyk7XG4gIHN0YXRpYyByZWFkb25seSBDSElNRV9TREtfTUVFVElOR1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2hpbWUtc2RrLW1lZXRpbmdzJywgJ0NoaW1lU0RLTWVldGluZ3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENISU1FX1NES19NRVNTQUdJTkc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2hpbWUtc2RrLW1lc3NhZ2luZycsICdDaGltZVNES01lc3NhZ2luZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ0xPVUQ5OiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3VkOScsICdDbG91ZDknKTtcbiAgc3RhdGljIHJlYWRvbmx5IENMT1VEX0NPTlRST0w6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2xvdWRjb250cm9sJywgJ0Nsb3VkQ29udHJvbCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ0xPVURfRElSRUNUT1JZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3VkZGlyZWN0b3J5JywgJ0Nsb3VkRGlyZWN0b3J5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBDTE9VRF9GT1JNQVRJT046IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY2xvdWRmb3JtYXRpb24nLCAnQ2xvdWRGb3JtYXRpb24nKTtcbiAgc3RhdGljIHJlYWRvbmx5IENMT1VEX0ZST05UOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3VkZnJvbnQnLCAnQ2xvdWRGcm9udCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ0xPVURfSFNfTTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjbG91ZGhzbScsICdDbG91ZEhTTScpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ0xPVURfSFNNX1YyOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3VkaHNtdjInLCAnQ2xvdWRIU01WMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ0xPVURfU0VBUkNIOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3Vkc2VhcmNoJywgJ0Nsb3VkU2VhcmNoJyk7XG4gIHN0YXRpYyByZWFkb25seSBDTE9VRF9TRUFSQ0hfRE9NQUlOOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3Vkc2VhcmNoZG9tYWluJywgJ0Nsb3VkU2VhcmNoRG9tYWluJyk7XG4gIHN0YXRpYyByZWFkb25seSBDTE9VRF9UUkFJTDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjbG91ZHRyYWlsJywgJ0Nsb3VkVHJhaWwnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENMT1VEX1dBVENIOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nsb3Vkd2F0Y2gnLCAnQ2xvdWRXYXRjaCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09ERV9BUlRJRkFDVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjb2RlYXJ0aWZhY3QnLCAnQ29kZUFydGlmYWN0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0RFX0JVSUxEOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvZGVidWlsZCcsICdDb2RlQnVpbGQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENPREVfQ09NTUlUOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvZGVjb21taXQnLCAnQ29kZUNvbW1pdCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09ERV9ERVBMT1k6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29kZWRlcGxveScsICdDb2RlRGVwbG95Jyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0RFX0dVUlVfUFJPRklMRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29kZWd1cnVwcm9maWxlcicsICdDb2RlR3VydVByb2ZpbGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0RFX0dVUlVfUkVWSUVXRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29kZWd1cnUtcmV2aWV3ZXInLCAnQ29kZUd1cnVSZXZpZXdlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09ERV9QSVBFTElORTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjb2RlcGlwZWxpbmUnLCAnQ29kZVBpcGVsaW5lJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0RFX1NUQVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29kZXN0YXInLCAnQ29kZVN0YXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IENPREVfU1RBUkNPTk5FQ1RJT05TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvZGVzdGFyLWNvbm5lY3Rpb25zJywgJ0NvZGVTdGFyY29ubmVjdGlvbnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENPREVfU1RBUl9OT1RJRklDQVRJT05TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvZGVzdGFyLW5vdGlmaWNhdGlvbnMnLCAnQ29kZVN0YXJOb3RpZmljYXRpb25zJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0dOSVRPX0lERU5USVRZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvZ25pdG8taWRlbnRpdHknLCAnQ29nbml0b0lkZW50aXR5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBDT0dOSVRPX1NZTkM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29nbml0by1zeW5jJywgJ0NvZ25pdG9TeW5jJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT01QUkVIRU5EOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvbXByZWhlbmQnLCAnQ29tcHJlaGVuZCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09NUFJFSEVORF9NRURJQ0FMOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvbXByZWhlbmRtZWRpY2FsJywgJ0NvbXByZWhlbmRNZWRpY2FsJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT01QVVRFX09QVElNSVpFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjb21wdXRlLW9wdGltaXplcicsICdDb21wdXRlT3B0aW1pemVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT05ORUNUOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nvbm5lY3QnLCAnQ29ubmVjdCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09OTkVDVF9DQU1QQUlHTlM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnY29ubmVjdGNhbXBhaWducycsICdDb25uZWN0Q2FtcGFpZ25zJyk7XG4gIHN0YXRpYyByZWFkb25seSBDT05ORUNUX0NBU0VTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nvbm5lY3RjYXNlcycsICdDb25uZWN0Q2FzZXMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IENPTk5FQ1RfQ09OVEFDVF9MRU5TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Nvbm5lY3QtY29udGFjdC1sZW5zJywgJ0Nvbm5lY3RDb250YWN0TGVucycpO1xuICBzdGF0aWMgcmVhZG9ubHkgQ09OTkVDVF9QQVJUSUNJUEFOVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjb25uZWN0cGFydGljaXBhbnQnLCAnQ29ubmVjdFBhcnRpY2lwYW50Jyk7XG4gIHN0YXRpYyByZWFkb25seSBDT05UUk9MX1RPV0VSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2NvbnRyb2x0b3dlcicsICdDb250cm9sVG93ZXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IENVUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjdXInLCAnQ1VSJyk7XG4gIHN0YXRpYyByZWFkb25seSBDVVNUT01FUl9QUk9GSUxFUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdjdXN0b21lci1wcm9maWxlcycsICdDdXN0b21lclByb2ZpbGVzJyk7XG4gIHN0YXRpYyByZWFkb25seSBEQVRBX0JSRVc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGF0YWJyZXcnLCAnRGF0YUJyZXcnKTtcbiAgc3RhdGljIHJlYWRvbmx5IERBVEFfRVhDSEFOR0U6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGF0YWV4Y2hhbmdlJywgJ0RhdGFFeGNoYW5nZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgREFUQV9QSVBFTElORTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdkYXRhcGlwZWxpbmUnLCAnRGF0YVBpcGVsaW5lJyk7XG4gIHN0YXRpYyByZWFkb25seSBEQVRBX1NZTkM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGF0YXN5bmMnLCAnRGF0YVN5bmMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IERBWDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdkYXgnLCAnREFYJyk7XG4gIHN0YXRpYyByZWFkb25seSBERVRFQ1RJVkU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGV0ZWN0aXZlJywgJ0RldGVjdGl2ZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgREVWSUNFX0ZBUk06IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGV2aWNlZmFybScsICdEZXZpY2VGYXJtJyk7XG4gIHN0YXRpYyByZWFkb25seSBERVZfT1BTX0dVUlU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGV2b3BzLWd1cnUnLCAnRGV2T3BzR3VydScpO1xuICBzdGF0aWMgcmVhZG9ubHkgRElSRUNUX0NPTk5FQ1Q6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGlyZWN0Y29ubmVjdCcsICdEaXJlY3RDb25uZWN0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBESVNDT1ZFUlk6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZGlzY292ZXJ5JywgJ0Rpc2NvdmVyeScpO1xuICBzdGF0aWMgcmVhZG9ubHkgRExNOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2RsbScsICdETE0nKTtcbiAgc3RhdGljIHJlYWRvbmx5IERNUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdkbXMnLCAnRE1TJyk7XG4gIHN0YXRpYyByZWFkb25seSBET0NfREI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZG9jZGInLCAnRG9jREInKTtcbiAgc3RhdGljIHJlYWRvbmx5IERSUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdkcnMnLCAnRHJzJyk7XG4gIHN0YXRpYyByZWFkb25seSBEWU5BTU9fREI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZHluYW1vZGInLCAnRHluYW1vREInKTtcbiAgc3RhdGljIHJlYWRvbmx5IERZTkFNT19EQl9TVFJFQU1TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2R5bmFtb2Ric3RyZWFtcycsICdEeW5hbW9EQlN0cmVhbXMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVCUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdlYnMnLCAnRUJTJyk7XG4gIHN0YXRpYyByZWFkb25seSBFQzI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWMyJywgJ0VDMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUMyX0lOU1RBTkNFX0NPTk5FQ1Q6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWMyLWluc3RhbmNlLWNvbm5lY3QnLCAnRUMySW5zdGFuY2VDb25uZWN0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBFQ1I6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWNyJywgJ0VDUicpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUNSUFVCTElDOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Vjci1wdWJsaWMnLCAnRUNSUFVCTElDJyk7XG4gIHN0YXRpYyByZWFkb25seSBFQ1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWNzJywgJ0VDUycpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUZTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2VmcycsICdFRlMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVLUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdla3MnLCAnRUtTJyk7XG4gIHN0YXRpYyByZWFkb25seSBFTEFTVElfQ0FDSEU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWxhc3RpY2FjaGUnLCAnRWxhc3RpQ2FjaGUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVMQVNUSUNfQkVBTlNUQUxLOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2VsYXN0aWNiZWFuc3RhbGsnLCAnRWxhc3RpY0JlYW5zdGFsaycpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19JTkZFUkVOQ0U6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWxhc3RpYy1pbmZlcmVuY2UnLCAnRWxhc3RpY0luZmVyZW5jZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19UUkFOU0NPREVSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2VsYXN0aWN0cmFuc2NvZGVyJywgJ0VsYXN0aWNUcmFuc2NvZGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBFTEI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWxiJywgJ0VMQicpO1xuICBzdGF0aWMgcmVhZG9ubHkgRUxCVjI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZWxidjInLCAnRUxCdjInKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVNUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdlbXInLCAnRU1SJyk7XG4gIHN0YXRpYyByZWFkb25seSBFTVJDT05UQUlORVJTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2Vtci1jb250YWluZXJzJywgJ0VNUmNvbnRhaW5lcnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVNUlNFUlZFUkxFU1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZW1yLXNlcnZlcmxlc3MnLCAnRU1SU2VydmVybGVzcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgRVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZXMnLCAnRVMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEVWSURFTlRMWTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdldmlkZW50bHknLCAnRXZpZGVudGx5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBGSU5TUEFDRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdmaW5zcGFjZScsICdGaW5zcGFjZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgRklOU1BBQ0VEQVRBOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2ZpbnNwYWNlLWRhdGEnLCAnRmluc3BhY2VkYXRhJyk7XG4gIHN0YXRpYyByZWFkb25seSBGSVJFSE9TRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdmaXJlaG9zZScsICdGaXJlaG9zZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgRklTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2ZpcycsICdGaXMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEZNUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdmbXMnLCAnRk1TJyk7XG4gIHN0YXRpYyByZWFkb25seSBGUkFVRF9ERVRFQ1RPUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdmcmF1ZGRldGVjdG9yJywgJ0ZyYXVkRGV0ZWN0b3InKTtcbiAgc3RhdGljIHJlYWRvbmx5IEZTWDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdmc3gnLCAnRlN4Jyk7XG4gIHN0YXRpYyByZWFkb25seSBHQU1FX0xJRlQ6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZ2FtZWxpZnQnLCAnR2FtZUxpZnQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEdBTUVfU1BBUktTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2dhbWVzcGFya3MnLCAnR2FtZVNwYXJrcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgR0xBQ0lFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdnbGFjaWVyJywgJ0dsYWNpZXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IEdMT0JBTF9BQ0NFTEVSQVRPUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdnbG9iYWxhY2NlbGVyYXRvcicsICdHbG9iYWxBY2NlbGVyYXRvcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgR0xVRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdnbHVlJywgJ0dsdWUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEdSQUZBTkE6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZ3JhZmFuYScsICdHcmFmYW5hJyk7XG4gIHN0YXRpYyByZWFkb25seSBHUkVFTkdSQVNTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2dyZWVuZ3Jhc3MnLCAnR3JlZW5ncmFzcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgR1JFRU5HUkFTU19WMjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdncmVlbmdyYXNzdjInLCAnR3JlZW5ncmFzc1YyJyk7XG4gIHN0YXRpYyByZWFkb25seSBHUk9VTkRfU1RBVElPTjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdncm91bmRzdGF0aW9uJywgJ0dyb3VuZFN0YXRpb24nKTtcbiAgc3RhdGljIHJlYWRvbmx5IEdVQVJEX0RVVFk6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnZ3VhcmRkdXR5JywgJ0d1YXJkRHV0eScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSEVBTFRIOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2hlYWx0aCcsICdIZWFsdGgnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEhFQUxUSF9MQUtFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2hlYWx0aGxha2UnLCAnSGVhbHRoTGFrZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSE9ORVlDT0RFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2hvbmV5Y29kZScsICdIb25leWNvZGUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IElBTTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpYW0nLCAnSUFNJyk7XG4gIHN0YXRpYyByZWFkb25seSBJREVOVElUWV9TVE9SRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpZGVudGl0eXN0b3JlJywgJ0lkZW50aXR5U3RvcmUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IElNQUdFQlVJTERFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpbWFnZWJ1aWxkZXInLCAnSW1hZ2VidWlsZGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBJTVBPUlRfRVhQT1JUOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2ltcG9ydGV4cG9ydCcsICdJbXBvcnRFeHBvcnQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IElOU1BFQ1RPUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpbnNwZWN0b3InLCAnSW5zcGVjdG9yJyk7XG4gIHN0YXRpYyByZWFkb25seSBJTlNQRUNUT1IyOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2luc3BlY3RvcjInLCAnSW5zcGVjdG9yMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2lvdCcsICdJb3QnKTtcbiAgc3RhdGljIHJlYWRvbmx5IElPX1QxX0NMSUNLX1BST0pFQ1RTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2lvdDFjbGljay1wcm9qZWN0cycsICdJb1QxQ2xpY2tQcm9qZWN0cycpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9fVF9BTkFMWVRJQ1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90YW5hbHl0aWNzJywgJ0lvVEFuYWx5dGljcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX0RBVEE6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90LWRhdGEnLCAnSW90RGF0YScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX0RFVklDRV9BRFZJU09SOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2lvdGRldmljZWFkdmlzb3InLCAnSW90RGV2aWNlQWR2aXNvcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX0VWRU5UUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpb3RldmVudHMnLCAnSW9URXZlbnRzJyk7XG4gIHN0YXRpYyByZWFkb25seSBJT1RfRVZFTlRTX0RBVEE6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90ZXZlbnRzLWRhdGEnLCAnSW9URXZlbnRzRGF0YScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX0ZMRUVUX0hVQjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpb3RmbGVldGh1YicsICdJb1RGbGVldEh1YicpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX0ZMRUVUX1dJU0U6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90ZmxlZXR3aXNlJywgJ0lvVEZsZWV0V2lzZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX1NFQ1VSRV9UVU5ORUxJTkc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90c2VjdXJldHVubmVsaW5nJywgJ0lvVFNlY3VyZVR1bm5lbGluZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX1NJVEVfV0lTRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpb3RzaXRld2lzZScsICdJb1RTaXRlV2lzZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX1RISU5HU19HUkFQSDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpb3R0aGluZ3NncmFwaCcsICdJb1RUaGluZ3NHcmFwaCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX1RXSU5fTUFLRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaW90dHdpbm1ha2VyJywgJ0lvVFR3aW5NYWtlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgSU9UX1dJUkVMRVNTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2lvdHdpcmVsZXNzJywgJ0lvVFdpcmVsZXNzJyk7XG4gIHN0YXRpYyByZWFkb25seSBJVlM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnaXZzJywgJ0lWUycpO1xuICBzdGF0aWMgcmVhZG9ubHkgSVZTQ0hBVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdpdnNjaGF0JywgJ0l2c2NoYXQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEtBRktBOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2thZmthJywgJ0thZmthJyk7XG4gIHN0YXRpYyByZWFkb25seSBLQUZLQV9DT05ORUNUOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2thZmthY29ubmVjdCcsICdLYWZrYUNvbm5lY3QnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEtFTkRSQTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdrZW5kcmEnLCAnS2VuZHJhJyk7XG4gIHN0YXRpYyByZWFkb25seSBLRVlTUEFDRVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgna2V5c3BhY2VzJywgJ0tleXNwYWNlcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgS0lORVNJUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdraW5lc2lzJywgJ0tpbmVzaXMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IEtJTkVTSVNfQU5BTFlUSUNTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2tpbmVzaXNhbmFseXRpY3MnLCAnS2luZXNpc0FuYWx5dGljcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgS0lORVNJU19BTkFMWVRJQ1NfVjI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgna2luZXNpc2FuYWx5dGljc3YyJywgJ0tpbmVzaXNBbmFseXRpY3NWMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgS0lORVNJU19WSURFTzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdraW5lc2lzdmlkZW8nLCAnS2luZXNpc1ZpZGVvJyk7XG4gIHN0YXRpYyByZWFkb25seSBLSU5FU0lTX1ZJREVPX0FSQ0hJVkVEX01FRElBOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2tpbmVzaXMtdmlkZW8tYXJjaGl2ZWQtbWVkaWEnLCAnS2luZXNpc1ZpZGVvQXJjaGl2ZWRNZWRpYScpO1xuICBzdGF0aWMgcmVhZG9ubHkgS0lORVNJU19WSURFT19NRURJQTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdraW5lc2lzLXZpZGVvLW1lZGlhJywgJ0tpbmVzaXNWaWRlb01lZGlhJyk7XG4gIHN0YXRpYyByZWFkb25seSBLTVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgna21zJywgJ0tNUycpO1xuICBzdGF0aWMgcmVhZG9ubHkgTEFLRV9GT1JNQVRJT046IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbGFrZWZvcm1hdGlvbicsICdMYWtlRm9ybWF0aW9uJyk7XG4gIHN0YXRpYyByZWFkb25seSBMQU1CREE6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbGFtYmRhJywgJ0xhbWJkYScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTEVYX1JVTlRJTUU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbGV4LXJ1bnRpbWUnLCAnTGV4UnVudGltZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTElDRU5TRV9NQU5BR0VSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2xpY2Vuc2UtbWFuYWdlcicsICdMaWNlbnNlTWFuYWdlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTElDRU5TRV9NQU5BR0VSX1VTRVJfU1VCU0NSSVBUSU9OUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdsaWNlbnNlLW1hbmFnZXItdXNlci1zdWJzY3JpcHRpb25zJywgJ0xpY2Vuc2VNYW5hZ2VyVXNlclN1YnNjcmlwdGlvbnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IExJR0hUU0FJTDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdsaWdodHNhaWwnLCAnTGlnaHRzYWlsJyk7XG4gIHN0YXRpYyByZWFkb25seSBMT0NBVElPTjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdsb2NhdGlvbicsICdMb2NhdGlvbicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTE9PS09VVF9FUVVJUE1FTlQ6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbG9va291dGVxdWlwbWVudCcsICdMb29rb3V0RXF1aXBtZW50Jyk7XG4gIHN0YXRpYyByZWFkb25seSBMT09LT1VUX01FVFJJQ1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbG9va291dG1ldHJpY3MnLCAnTG9va291dE1ldHJpY3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IExPT0tPVVRfVklTSU9OOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ2xvb2tvdXR2aXNpb24nLCAnTG9va291dFZpc2lvbicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTTI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbTInLCAnTTInKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1BQ0hJTkVfTEVBUk5JTkc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWFjaGluZWxlYXJuaW5nJywgJ01hY2hpbmVMZWFybmluZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUFDSUU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWFjaWUnLCAnTWFjaWUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1BQ0lFMjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdtYWNpZTInLCAnTWFjaWUyJyk7XG4gIHN0YXRpYyByZWFkb25seSBNQU5BR0VEX0JMT0NLQ0hBSU46IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWFuYWdlZGJsb2NrY2hhaW4nLCAnTWFuYWdlZEJsb2NrY2hhaW4nKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1BUktFVFBMQUNFX0NBVEFMT0c6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWFya2V0cGxhY2UtY2F0YWxvZycsICdNYXJrZXRwbGFjZUNhdGFsb2cnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1BUktFVFBMQUNFX0NPTU1FUkNFX0FOQUxZVElDUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdtYXJrZXRwbGFjZWNvbW1lcmNlYW5hbHl0aWNzJywgJ01hcmtldHBsYWNlQ29tbWVyY2VBbmFseXRpY3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1FRElBX0NPTk5FQ1Q6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWVkaWFjb25uZWN0JywgJ01lZGlhQ29ubmVjdCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUVESUFfQ09OVkVSVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdtZWRpYWNvbnZlcnQnLCAnTWVkaWFDb252ZXJ0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBNRURJQV9MSVZFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21lZGlhbGl2ZScsICdNZWRpYUxpdmUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1FRElBX1BBQ0tBR0U6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWVkaWFwYWNrYWdlJywgJ01lZGlhUGFja2FnZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUVESUFfUEFDS0FHRV9WT0Q6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWVkaWFwYWNrYWdlLXZvZCcsICdNZWRpYVBhY2thZ2VWb2QnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1FRElBX1NUT1JFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21lZGlhc3RvcmUnLCAnTWVkaWFTdG9yZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUVESUFfU1RPUkVfREFUQTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdtZWRpYXN0b3JlLWRhdGEnLCAnTWVkaWFTdG9yZURhdGEnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1FRElBX1RBSUxPUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdtZWRpYXRhaWxvcicsICdNZWRpYVRhaWxvcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUVNT1JZX0RCOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21lbW9yeWRiJywgJ01lbW9yeURCJyk7XG4gIHN0YXRpYyByZWFkb25seSBNR046IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWduJywgJ01nbicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTUlHUkFUSU9OX0hVQl9DT05GSUc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbWlncmF0aW9uaHViLWNvbmZpZycsICdNaWdyYXRpb25IdWJDb25maWcnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1JR1JBVElPTl9IVUJfT1JDSEVTVFJBVE9SOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21pZ3JhdGlvbmh1Ym9yY2hlc3RyYXRvcicsICdNaWdyYXRpb25IdWJPcmNoZXN0cmF0b3InKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1JR1JBVElPTl9IVUJfUkVGQUNUT1JfU1BBQ0VTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21pZ3JhdGlvbi1odWItcmVmYWN0b3Itc3BhY2VzJywgJ01pZ3JhdGlvbkh1YlJlZmFjdG9yU3BhY2VzJyk7XG4gIHN0YXRpYyByZWFkb25seSBNSUdSQVRJT05fSFVCX1NUUkFURUdZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ21pZ3JhdGlvbmh1YnN0cmF0ZWd5JywgJ01pZ3JhdGlvbkh1YlN0cmF0ZWd5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBNT0JJTEU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbW9iaWxlJywgJ01vYmlsZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTVE6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbXEnLCAnTVEnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE1UVVJLOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ210dXJrJywgJ01UdXJrJyk7XG4gIHN0YXRpYyByZWFkb25seSBNV0FBOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ213YWEnLCAnTVdBQScpO1xuICBzdGF0aWMgcmVhZG9ubHkgTkVQVFVORTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCduZXB0dW5lJywgJ05lcHR1bmUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE5FVFdPUktfRklSRVdBTEw6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnbmV0d29yay1maXJld2FsbCcsICdOZXR3b3JrRmlyZXdhbGwnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE5FVFdPUktfTUFOQUdFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCduZXR3b3JrbWFuYWdlcicsICdOZXR3b3JrTWFuYWdlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgTklNQkxFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ25pbWJsZScsICdOaW1ibGUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE9QRU5fU0VBUkNIOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ29wZW5zZWFyY2gnLCAnT3BlblNlYXJjaCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgT1BTX1dPUktTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ29wc3dvcmtzJywgJ09wc1dvcmtzJyk7XG4gIHN0YXRpYyByZWFkb25seSBPUFNfV09SS1NfQ19NOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ29wc3dvcmtzY20nLCAnT3BzV29ya3NDTScpO1xuICBzdGF0aWMgcmVhZG9ubHkgT1JHQU5JWkFUSU9OUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdvcmdhbml6YXRpb25zJywgJ09yZ2FuaXphdGlvbnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IE9VVFBPU1RTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ291dHBvc3RzJywgJ091dHBvc3RzJyk7XG4gIHN0YXRpYyByZWFkb25seSBQQU5PUkFNQTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdwYW5vcmFtYScsICdQYW5vcmFtYScpO1xuICBzdGF0aWMgcmVhZG9ubHkgUEVSU09OQUxJWkU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncGVyc29uYWxpemUnLCAnUGVyc29uYWxpemUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFBFUlNPTkFMSVpFX0VWRU5UUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdwZXJzb25hbGl6ZS1ldmVudHMnLCAnUGVyc29uYWxpemVFdmVudHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFBFUlNPTkFMSVpFX1JVTlRJTUU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncGVyc29uYWxpemUtcnVudGltZScsICdQZXJzb25hbGl6ZVJ1bnRpbWUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFBJOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3BpJywgJ1BJJyk7XG4gIHN0YXRpYyByZWFkb25seSBQSU5QT0lOVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdwaW5wb2ludCcsICdQaW5wb2ludCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgUElOUE9JTlRfRU1BSUw6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncGlucG9pbnQtZW1haWwnLCAnUGlucG9pbnRFbWFpbCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgUElOUE9JTlRfU01TX1ZPSUNFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3BpbnBvaW50LXNtcy12b2ljZScsICdQaW5wb2ludFNNU1ZvaWNlJyk7XG4gIHN0YXRpYyByZWFkb25seSBQSU5QT0lOVF9TTVNfVk9JQ0VfVjI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncGlucG9pbnQtc21zLXZvaWNlLXYyJywgJ1BpbnBvaW50U01TVm9pY2VWMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgUE9MTFk6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncG9sbHknLCAnUG9sbHknKTtcbiAgc3RhdGljIHJlYWRvbmx5IFBSSUNJTkc6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncHJpY2luZycsICdQcmljaW5nJyk7XG4gIHN0YXRpYyByZWFkb25seSBQUklWQVRFX05FVFdPUktTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3ByaXZhdGVuZXR3b3JrcycsICdQcml2YXRlTmV0d29ya3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFBST1RPTjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdwcm90b24nLCAnUHJvdG9uJyk7XG4gIHN0YXRpYyByZWFkb25seSBRTERCOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3FsZGInLCAnUUxEQicpO1xuICBzdGF0aWMgcmVhZG9ubHkgUUxEQl9TRVNTSU9OOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3FsZGItc2Vzc2lvbicsICdRTERCU2Vzc2lvbicpO1xuICBzdGF0aWMgcmVhZG9ubHkgUVVJQ0tfU0lHSFQ6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncXVpY2tzaWdodCcsICdRdWlja1NpZ2h0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBSQU06IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncmFtJywgJ1JBTScpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkJJTjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyYmluJywgJ1JiaW4nKTtcbiAgc3RhdGljIHJlYWRvbmx5IFJEUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyZHMnLCAnUkRTJyk7XG4gIHN0YXRpYyByZWFkb25seSBSRURTSElGVDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyZWRzaGlmdCcsICdSZWRzaGlmdCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfREFUQTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyZWRzaGlmdC1kYXRhJywgJ1JlZHNoaWZ0RGF0YScpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfU0VSVkVSTEVTUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyZWRzaGlmdC1zZXJ2ZXJsZXNzJywgJ1JlZHNoaWZ0U2VydmVybGVzcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkVLT0dOSVRJT046IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncmVrb2duaXRpb24nLCAnUmVrb2duaXRpb24nKTtcbiAgc3RhdGljIHJlYWRvbmx5IFJFU0lMSUVOQ0VIVUI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncmVzaWxpZW5jZWh1YicsICdSZXNpbGllbmNlaHViJyk7XG4gIHN0YXRpYyByZWFkb25seSBSRVNPVVJDRV9FWFBMT1JFUjI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncmVzb3VyY2UtZXhwbG9yZXItMicsICdSZXNvdXJjZUV4cGxvcmVyMicpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkVTT1VSQ0VfR1JPVVBTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3Jlc291cmNlLWdyb3VwcycsICdSZXNvdXJjZUdyb3VwcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgUkVTT1VSQ0VfR1JPVVBTX1RBR0dJTkdfQVBfSTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyZXNvdXJjZWdyb3Vwc3RhZ2dpbmdhcGknLCAnUmVzb3VyY2VHcm91cHNUYWdnaW5nQVBJJyk7XG4gIHN0YXRpYyByZWFkb25seSBST0JPX01BS0VSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3JvYm9tYWtlcicsICdSb2JvTWFrZXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IFJPTEVTX0FOWVdIRVJFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3JvbGVzYW55d2hlcmUnLCAnUm9sZXNBbnl3aGVyZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgUk9VVEU1MzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyb3V0ZTUzJywgJ1JvdXRlNTMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFJPVVRFNTNfRE9NQUlOUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdyb3V0ZTUzZG9tYWlucycsICdSb3V0ZTUzRG9tYWlucycpO1xuICBzdGF0aWMgcmVhZG9ubHkgUk9VVEU1M19SRUNPVkVSWV9DTFVTVEVSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3JvdXRlNTMtcmVjb3ZlcnktY2x1c3RlcicsICdSb3V0ZTUzUmVjb3ZlcnlDbHVzdGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBST1VURTUzX1JFQ09WRVJZX0NPTlRST0xfQ09ORklHOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3JvdXRlNTMtcmVjb3ZlcnktY29udHJvbC1jb25maWcnLCAnUm91dGU1M1JlY292ZXJ5Q29udHJvbENvbmZpZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgUk9VVEU1M19SRUNPVkVSWV9SRUFESU5FU1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgncm91dGU1My1yZWNvdmVyeS1yZWFkaW5lc3MnLCAnUm91dGU1M1JlY292ZXJ5UmVhZGluZXNzJyk7XG4gIHN0YXRpYyByZWFkb25seSBST1VURTUzX1JFU09MVkVSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3JvdXRlNTNyZXNvbHZlcicsICdSb3V0ZTUzUmVzb2x2ZXInKTtcbiAgc3RhdGljIHJlYWRvbmx5IFJVTTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdydW0nLCAnUlVNJyk7XG4gIHN0YXRpYyByZWFkb25seSBTMzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzMycsICdTMycpO1xuICBzdGF0aWMgcmVhZG9ubHkgUzNfQ09OVFJPTDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzM2NvbnRyb2wnLCAnUzNDb250cm9sJyk7XG4gIHN0YXRpYyByZWFkb25seSBTM19PVVRQT1NUUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzM291dHBvc3RzJywgJ1MzT3V0cG9zdHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNBR0VfTUFLRVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2FnZW1ha2VyJywgJ1NhZ2VNYWtlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgU0FHRU1BS0VSX0VER0U6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2FnZW1ha2VyLWVkZ2UnLCAnU2FnZW1ha2VyRWRnZScpO1xuICBzdGF0aWMgcmVhZG9ubHkgU0FHRV9NQUtFUl9GRUFUVVJFX1NUT1JFX1JVTlRJTUU6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2FnZW1ha2VyLWZlYXR1cmVzdG9yZS1ydW50aW1lJywgJ1NhZ2VNYWtlckZlYXR1cmVTdG9yZVJ1bnRpbWUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNBR0VfTUFLRVJfUlVOVElNRTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzYWdlbWFrZXItcnVudGltZScsICdTYWdlTWFrZXJSdW50aW1lJyk7XG4gIHN0YXRpYyByZWFkb25seSBTQVZJTkdTX1BMQU5TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NhdmluZ3NwbGFucycsICdTYXZpbmdzUGxhbnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNDSEVEVUxFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzY2hlZHVsZXInLCAnU2NoZWR1bGVyJyk7XG4gIHN0YXRpYyByZWFkb25seSBTQ0hFTUFTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NjaGVtYXMnLCAnU2NoZW1hcycpO1xuICBzdGF0aWMgcmVhZG9ubHkgU0VDUkVUU19NQU5BR0VSOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NlY3JldHNtYW5hZ2VyJywgJ1NlY3JldHNNYW5hZ2VyJyk7XG4gIHN0YXRpYyByZWFkb25seSBTRUNVUklUWV9IVUI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2VjdXJpdHlodWInLCAnU2VjdXJpdHlIdWInKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNFUlZJQ0VfQ0FUQUxPRzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzZXJ2aWNlY2F0YWxvZycsICdTZXJ2aWNlQ2F0YWxvZycpO1xuICBzdGF0aWMgcmVhZG9ubHkgU0VSVklDRV9DQVRBTE9HX0FQUF9SRUdJU1RSWTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzZXJ2aWNlY2F0YWxvZy1hcHByZWdpc3RyeScsICdTZXJ2aWNlQ2F0YWxvZ0FwcFJlZ2lzdHJ5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBTRVJWSUNFX0RJU0NPVkVSWTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzZXJ2aWNlZGlzY292ZXJ5JywgJ1NlcnZpY2VEaXNjb3ZlcnknKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNFUlZJQ0VfUVVPVEFTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NlcnZpY2UtcXVvdGFzJywgJ1NlcnZpY2VRdW90YXMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNFUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzZXMnLCAnU0VTJyk7XG4gIHN0YXRpYyByZWFkb25seSBTRVNfVjI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2VzdjInLCAnU0VTVjInKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNISUVMRDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzaGllbGQnLCAnU2hpZWxkJyk7XG4gIHN0YXRpYyByZWFkb25seSBTSUdORVI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc2lnbmVyJywgJ1NpZ25lcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgU01TOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NtcycsICdTTVMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNOT1dCQUxMOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3Nub3diYWxsJywgJ1Nub3diYWxsJyk7XG4gIHN0YXRpYyByZWFkb25seSBTTk9XX0RFVklDRV9NQU5BR0VNRU5UOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3Nub3ctZGV2aWNlLW1hbmFnZW1lbnQnLCAnU25vd0RldmljZU1hbmFnZW1lbnQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNOUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzbnMnLCAnU05TJyk7XG4gIHN0YXRpYyByZWFkb25seSBTUVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc3FzJywgJ1NRUycpO1xuICBzdGF0aWMgcmVhZG9ubHkgU1NNOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3NzbScsICdTU00nKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNTTV9DT05UQUNUUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzc20tY29udGFjdHMnLCAnU1NNQ29udGFjdHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNTTV9JTkNJREVOVFM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc3NtLWluY2lkZW50cycsICdTU01JbmNpZGVudHMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNTTzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzc28nLCAnU1NPJyk7XG4gIHN0YXRpYyByZWFkb25seSBTU09fQURNSU46IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc3NvLWFkbWluJywgJ1NTT0FkbWluJyk7XG4gIHN0YXRpYyByZWFkb25seSBTU09fT0lEQzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzc28tb2lkYycsICdTU09PSURDJyk7XG4gIHN0YXRpYyByZWFkb25seSBTVEVQX0ZVTkNUSU9OUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzdGVwZnVuY3Rpb25zJywgJ1N0ZXBGdW5jdGlvbnMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNUT1JBR0VfR0FURVdBWTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzdG9yYWdlZ2F0ZXdheScsICdTdG9yYWdlR2F0ZXdheScpO1xuICBzdGF0aWMgcmVhZG9ubHkgU1RTOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3N0cycsICdTVFMnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFNVUFBPUlQ6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc3VwcG9ydCcsICdTdXBwb3J0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBTVVBQT1JUX0FQUDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzdXBwb3J0LWFwcCcsICdTdXBwb3J0QXBwJyk7XG4gIHN0YXRpYyByZWFkb25seSBTV0Y6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnc3dmJywgJ1NXRicpO1xuICBzdGF0aWMgcmVhZG9ubHkgU1lOVEhFVElDUzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCdzeW50aGV0aWNzJywgJ1N5bnRoZXRpY3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFRFWFRSQUNUOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3RleHRyYWN0JywgJ1RleHRyYWN0Jyk7XG4gIHN0YXRpYyByZWFkb25seSBUSU1FU1RSRUFNX1FVRVJZOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3RpbWVzdHJlYW0tcXVlcnknLCAnVGltZXN0cmVhbVF1ZXJ5Jyk7XG4gIHN0YXRpYyByZWFkb25seSBUSU1FU1RSRUFNX1dSSVRFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3RpbWVzdHJlYW0td3JpdGUnLCAnVGltZXN0cmVhbVdyaXRlJyk7XG4gIHN0YXRpYyByZWFkb25seSBUUkFOU0ZFUjogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCd0cmFuc2ZlcicsICdUcmFuc2ZlcicpO1xuICBzdGF0aWMgcmVhZG9ubHkgVFJBTlNMQVRFOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3RyYW5zbGF0ZScsICdUcmFuc2xhdGUnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFZPSUNFX0lfRDogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCd2b2ljZS1pZCcsICdWb2ljZUlEJyk7XG4gIHN0YXRpYyByZWFkb25seSBXQUY6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnd2FmJywgJ1dBRicpO1xuICBzdGF0aWMgcmVhZG9ubHkgV0FGX1JFR0lPTkFMOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3dhZi1yZWdpb25hbCcsICdXQUZSZWdpb25hbCcpO1xuICBzdGF0aWMgcmVhZG9ubHkgV0FGX1YyOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3dhZnYyJywgJ1dBRlYyJyk7XG4gIHN0YXRpYyByZWFkb25seSBXRUxMX0FSQ0hJVEVDVEVEOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3dlbGxhcmNoaXRlY3RlZCcsICdXZWxsQXJjaGl0ZWN0ZWQnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFdJU0RPTTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCd3aXNkb20nLCAnV2lzZG9tJyk7XG4gIHN0YXRpYyByZWFkb25seSBXT1JLX0RPQ1M6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnd29ya2RvY3MnLCAnV29ya0RvY3MnKTtcbiAgc3RhdGljIHJlYWRvbmx5IFdPUktfTElOSzogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCd3b3JrbGluaycsICdXb3JrTGluaycpO1xuICBzdGF0aWMgcmVhZG9ubHkgV09SS19NQUlMOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3dvcmttYWlsJywgJ1dvcmtNYWlsJyk7XG4gIHN0YXRpYyByZWFkb25seSBXT1JLX01BSUxfTUVTU0FHRV9GTE9XOiBBd3NTZXJ2aWNlID0gbmV3IEF3c1NlcnZpY2UoJ3dvcmttYWlsbWVzc2FnZWZsb3cnLCAnV29ya01haWxNZXNzYWdlRmxvdycpO1xuICBzdGF0aWMgcmVhZG9ubHkgV09SS19TUEFDRVM6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnd29ya3NwYWNlcycsICdXb3JrU3BhY2VzJyk7XG4gIHN0YXRpYyByZWFkb25seSBXT1JLX1NQQUNFU19XRUI6IEF3c1NlcnZpY2UgPSBuZXcgQXdzU2VydmljZSgnd29ya3NwYWNlcy13ZWInLCAnV29ya1NwYWNlc1dlYicpO1xuICBzdGF0aWMgcmVhZG9ubHkgWFJBWTogQXdzU2VydmljZSA9IG5ldyBBd3NTZXJ2aWNlKCd4cmF5JywgJ1hSYXknKTtcblxuICAvKipcbiAgICogVXNlZCBmb3IgZGVjbGFyYXRpb24gaW4gU1NNIEF1dG9tYXRpb24gZG9jdW1lbnQuXG4gICAqL1xuICByZWFkb25seSBuYW1lc3BhY2U6IHN0cmluZztcbiAgLyoqXG4gICAqIFVzZWQgZm9yIHNpbXVsYXRpb24gb2Ygc2VydmljZSByZXF1ZXN0cyB1c2luZyB0aGUgc2ltdWxhdGVkIGV4ZWN1dGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGphdmFTY3JpcHROYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IobmFtZXNwYWNlOiBzdHJpbmcsIGphdmFTY3JpcHROYW1lOiBzdHJpbmcpIHtcbiAgICB0aGlzLm5hbWVzcGFjZSA9IG5hbWVzcGFjZTtcbiAgICB0aGlzLmphdmFTY3JpcHROYW1lID0gamF2YVNjcmlwdE5hbWU7XG4gIH1cblxuICB0b0pTT04oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5uYW1lc3BhY2U7XG4gIH1cblxufVxuIl19