# Generated by Django 4.1.5 on 2023-01-28 19:12

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import phonenumber_field.modelfields
import project_center.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('title', models.CharField(blank=True, default='', max_length=64, null=True, verbose_name='Title')),
                ('address_1', models.CharField(blank=True, default='', max_length=64, null=True, verbose_name='Address 1')),
                ('city', models.CharField(blank=True, default='', max_length=64, null=True, verbose_name='City')),
                ('postal_code', models.CharField(blank=True, default='', max_length=10, null=True, verbose_name='postal_code')),
                ('zip', models.CharField(blank=True, default='', max_length=10, null=True, verbose_name='postal_code')),
                ('primary_phone', phonenumber_field.modelfields.PhoneNumberField(blank=True, default=None, max_length=50, null=True, region=None, verbose_name='primary_phone')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('hash', models.CharField(max_length=40, verbose_name='hash')),
                ('display', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name_plural': 'Cities',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Company Name')),
            ],
            options={
                'verbose_name': 'Company',
                'verbose_name_plural': 'Companies',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True, verbose_name='Slug')),
                ('title', models.CharField(help_text='Project Title', max_length=255, verbose_name='Title')),
                ('code', models.CharField(blank=True, default=None, help_text='Project Code', max_length=30, null=True, verbose_name='Code/ID')),
                ('internal', models.BooleanField(default=False, verbose_name='Internal')),
                ('description', models.TextField(blank=True, default=None, help_text='Project Description', null=True, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'Project',
                'verbose_name_plural': 'Projects',
            },
        ),
        migrations.CreateModel(
            name='ProjectCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('name', models.CharField(help_text='Category Name', max_length=255, verbose_name='Category Name')),
            ],
            options={
                'verbose_name': 'Project Category',
                'verbose_name_plural': 'Project Categories',
            },
        ),
        migrations.CreateModel(
            name='ProjectStage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('name', models.CharField(help_text='Stage Name', max_length=255, verbose_name='Stage Name')),
            ],
            options={
                'verbose_name': 'Project Stage',
                'verbose_name_plural': 'Project Stages',
            },
        ),
        migrations.CreateModel(
            name='ProjectStatus',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('name', models.CharField(help_text='Status Name', max_length=255, verbose_name='Status Name')),
            ],
            options={
                'verbose_name': 'Project Status',
                'verbose_name_plural': 'Project Statuses',
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('abbrev', models.CharField(blank=True, max_length=2, verbose_name='abbrev')),
                ('hash', models.CharField(blank=True, max_length=40, null=True, verbose_name='hash')),
                ('display', models.BooleanField(default=True)),
                ('atsReference', models.IntegerField(blank=True, default=None, help_text='ATS Reference', null=True, verbose_name='atsReference')),
            ],
            options={
                'verbose_name_plural': 'States',
            },
        ),
        migrations.CreateModel(
            name='Zip',
            fields=[
                ('zipcode', models.CharField(max_length=5, primary_key=True, serialize=False, unique=True)),
                ('approximate_latitude', models.FloatField(blank=True, default=None, null=True)),
                ('approximate_longitude', models.FloatField(blank=True, default=None, null=True)),
                ('population_count', models.IntegerField(blank=True, null=True)),
                ('display', models.BooleanField(default=True)),
                ('city', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='zip', to='project_center.city')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectActivity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('import_id', models.IntegerField(blank=True, default=None, help_text='Import ID', null=True, verbose_name='Import ID')),
                ('name', models.CharField(help_text='Activity Name', max_length=255, verbose_name='Activity Name')),
                ('date', models.DateTimeField(blank=True, help_text='Activity Date', null=True, verbose_name='Activity Date')),
                ('file', models.FileField(blank=True, null=True, upload_to=project_center.models.activity_file_directory_path)),
                ('project', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.project')),
                ('user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Project Activity',
                'verbose_name_plural': 'Project Activities',
            },
        ),
        migrations.AddField(
            model_name='project',
            name='category',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.projectcategory'),
        ),
        migrations.AddField(
            model_name='project',
            name='company',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.company'),
        ),
        migrations.AddField(
            model_name='project',
            name='stage',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.projectstage'),
        ),
        migrations.AddField(
            model_name='project',
            name='status',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.projectstatus'),
        ),
        migrations.AddField(
            model_name='project',
            name='users',
            field=models.ManyToManyField(help_text='Users from the Company that are allowed to access the Project', to=settings.AUTH_USER_MODEL, verbose_name='Project Users'),
        ),
        migrations.AddField(
            model_name='city',
            name='state',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.state'),
        ),
        migrations.AddField(
            model_name='user',
            name='company',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.company'),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='user',
            name='state',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_center.state'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions'),
        ),
    ]
