# -----------------------------------------------------------------------------
# This file was autogenerated by symforce from template:
#     backends/python/templates/cam_package/ops/CLASS/camera_ops.py.jinja
# Do NOT modify by hand.
# -----------------------------------------------------------------------------

import math
import numpy
import typing as T

import sym  # pylint: disable=unused-import


class CameraOps(object):
    """
    Python CameraOps implementation for <class 'symforce.cam.polynomial_camera_cal.PolynomialCameraCal'>.
    """

    @staticmethod
    def focal_length(self):
        # type: (sym.PolynomialCameraCal) -> T.List[float]
        """
        Return the focal length.
        """

        # Total ops: 0

        # Input arrays
        _self = self.data

        # Intermediate terms (0)

        # Output terms
        _focal_length = [0.0] * 2
        _focal_length[0] = _self[0]
        _focal_length[1] = _self[1]
        return _focal_length

    @staticmethod
    def principal_point(self):
        # type: (sym.PolynomialCameraCal) -> T.List[float]
        """
        Return the principal point.
        """

        # Total ops: 0

        # Input arrays
        _self = self.data

        # Intermediate terms (0)

        # Output terms
        _principal_point = [0.0] * 2
        _principal_point[0] = _self[2]
        _principal_point[1] = _self[3]
        return _principal_point

    @staticmethod
    def pixel_from_camera_point(self, point, epsilon):
        # type: (sym.PolynomialCameraCal, T.Sequence[float], float) -> T.Tuple[T.List[float], float]
        """
        Project a 3D point in the camera frame into 2D pixel coordinates.

        Return:
            pixel: (x, y) coordinate in pixels if valid
            is_valid: 1 if the operation is within bounds else 0
        """

        # Total ops: 33

        # Input arrays
        _self = self.data

        # Intermediate terms (4)
        _tmp0 = max(epsilon, abs(point[2]))
        _tmp1 = _tmp0 ** (-2)
        _tmp2 = _tmp1 * point[0] ** 2 + _tmp1 * point[1] ** 2 + epsilon
        _tmp3 = (
            1.0 * _self[5] * _tmp2 + 1.0 * _self[6] * _tmp2 ** 2 + 1.0 * _self[7] * _tmp2 ** 3 + 1.0
        ) / _tmp0

        # Output terms
        _pixel = [0.0] * 2
        _pixel[0] = _self[0] * _tmp3 * point[0] + _self[2]
        _pixel[1] = _self[1] * _tmp3 * point[1] + _self[3]
        _is_valid = max(
            0,
            min(
                (0.0 if point[2] == 0 else math.copysign(1, point[2])),
                (
                    0.0
                    if _self[4] - math.sqrt(_tmp2) == 0
                    else math.copysign(1, _self[4] - math.sqrt(_tmp2))
                ),
            ),
        )
        return _pixel, _is_valid

    @staticmethod
    def pixel_from_camera_point_with_jacobians(self, point, epsilon):
        # type: (sym.PolynomialCameraCal, T.Sequence[float], float) -> T.Tuple[T.List[float], float, numpy.ndarray, numpy.ndarray]
        """
        Project a 3D point in the camera frame into 2D pixel coordinates.

        Return:
            pixel: (x, y) coordinate in pixels if valid
            is_valid: 1 if the operation is within bounds else 0
            pixel_D_cal: Derivative of pixel with respect to intrinsic calibration parameters
            pixel_D_point: Derivative of pixel with respect to point
        """

        # Total ops: 104

        # Input arrays
        _self = self.data

        # Intermediate terms (37)
        _tmp0 = point[0] ** 2
        _tmp1 = abs(point[2])
        _tmp2 = max(_tmp1, epsilon)
        _tmp3 = _tmp2 ** (-2)
        _tmp4 = _tmp0 * _tmp3
        _tmp5 = point[1] ** 2
        _tmp6 = _tmp3 * _tmp5
        _tmp7 = _tmp4 + _tmp6 + epsilon
        _tmp8 = 1.0 * _self[5]
        _tmp9 = 1.0 * _tmp7 ** 3
        _tmp10 = _tmp7 ** 2
        _tmp11 = 1.0 * _tmp10
        _tmp12 = _self[6] * _tmp11 + _self[7] * _tmp9 + _tmp7 * _tmp8 + 1.0
        _tmp13 = _tmp2 ** (-1)
        _tmp14 = _tmp12 * _tmp13
        _tmp15 = _tmp14 * point[0]
        _tmp16 = _self[1] * _tmp14
        _tmp17 = 0.0 if point[2] == 0 else math.copysign(1, point[2])
        _tmp18 = _tmp13 * (1.0 * _tmp4 + 1.0 * _tmp6 + 1.0 * epsilon)
        _tmp19 = _self[0] * point[0]
        _tmp20 = _self[1] * point[1]
        _tmp21 = _tmp13 * _tmp19
        _tmp22 = _tmp13 * _tmp20
        _tmp23 = _tmp3 * point[0]
        _tmp24 = 2.0 * _self[5]
        _tmp25 = _self[6] * _tmp7
        _tmp26 = 4.0 * _tmp25
        _tmp27 = _self[7] * _tmp10
        _tmp28 = 6.0 * _tmp27
        _tmp29 = _tmp13 * (_tmp23 * _tmp24 + _tmp23 * _tmp26 + _tmp23 * _tmp28)
        _tmp30 = _tmp3 * point[1]
        _tmp31 = _tmp13 * (_tmp24 * _tmp30 + _tmp26 * _tmp30 + _tmp28 * _tmp30)
        _tmp32 = _tmp17 * ((0.0 if _tmp1 - epsilon == 0 else math.copysign(1, _tmp1 - epsilon)) + 1)
        _tmp33 = (1.0 / 2.0) * _tmp12 * _tmp3 * _tmp32
        _tmp34 = _tmp32 / _tmp2 ** 3
        _tmp35 = -_tmp0 * _tmp34 - _tmp34 * _tmp5
        _tmp36 = _tmp13 * (2.0 * _tmp25 * _tmp35 + 3.0 * _tmp27 * _tmp35 + _tmp35 * _tmp8)

        # Output terms
        _pixel = [0.0] * 2
        _pixel[0] = _self[0] * _tmp15 + _self[2]
        _pixel[1] = _self[3] + _tmp16 * point[1]
        _is_valid = max(
            0,
            min(
                _tmp17,
                (
                    0.0
                    if _self[4] - math.sqrt(_tmp7) == 0
                    else math.copysign(1, _self[4] - math.sqrt(_tmp7))
                ),
            ),
        )
        _pixel_D_cal = numpy.zeros((2, 7))
        _pixel_D_cal[0, 0] = _tmp15
        _pixel_D_cal[1, 0] = 0
        _pixel_D_cal[0, 1] = 0
        _pixel_D_cal[1, 1] = _tmp14 * point[1]
        _pixel_D_cal[0, 2] = 1
        _pixel_D_cal[1, 2] = 0
        _pixel_D_cal[0, 3] = 0
        _pixel_D_cal[1, 3] = 1
        _pixel_D_cal[0, 4] = _tmp18 * _tmp19
        _pixel_D_cal[1, 4] = _tmp18 * _tmp20
        _pixel_D_cal[0, 5] = _tmp11 * _tmp21
        _pixel_D_cal[1, 5] = _tmp11 * _tmp22
        _pixel_D_cal[0, 6] = _tmp21 * _tmp9
        _pixel_D_cal[1, 6] = _tmp22 * _tmp9
        _pixel_D_point = numpy.zeros((2, 3))
        _pixel_D_point[0, 0] = _self[0] * _tmp14 + _tmp19 * _tmp29
        _pixel_D_point[1, 0] = _tmp20 * _tmp29
        _pixel_D_point[0, 1] = _tmp19 * _tmp31
        _pixel_D_point[1, 1] = _tmp16 + _tmp20 * _tmp31
        _pixel_D_point[0, 2] = -_tmp19 * _tmp33 + _tmp19 * _tmp36
        _pixel_D_point[1, 2] = -_tmp20 * _tmp33 + _tmp20 * _tmp36
        return _pixel, _is_valid, _pixel_D_cal, _pixel_D_point
