<!DOCTYPE html>
<html>
    <body>
        <a href="https://lumerico284.notion.site/lumerico284/LUMA-76330376b0e64cc1b95874c469aeb327">
            <img src="https://github.com/ChanLumerico/LUMA/raw/main/others/luma.png" alt="logo" width="75" height="75">
        </a>
        <h1 class="main-title">LUMA</h1>
        <p class="subtitle">A Comprehensive Python Module for Machine Learning and Data Science</p>
        <div class="module">
            <h3 class="module-header">Submodules</h3>
            <table>
                <tr>
                    <th>Name</th>
                    <th>Description</th>
                </tr>
                <tr>
                    <td>luma.classifier</td>
                    <td>Toolkit for classification models including various algorithms.</td>
                </tr>
                <tr>
                    <td>luma.clustering</td>
                    <td>Focuses on unsupervised learning and clustering algorithms.</td>
                </tr>
                <tr>
                    <td>luma.core</td>
                    <td>Foundational backbone providing essential data structures and utilities.</td>
                </tr>
                <tr>
                    <td>luma.ensemble</td>
                    <td>Ensemble learning methods for improved model performance.</td>
                </tr>
                <tr>
                    <td>luma.interface</td>
                    <td>Protocols and custom data types for internal use within LUMA.</td>
                </tr>
                <tr>
                    <td>luma.metric</td>
                    <td>Performance metrics for evaluating machine learning models.</td>
                </tr>
                <tr>
                    <td>luma.migrate</td>
                    <td>Import and export of machine learning models within LUMA.</td>
                </tr>
                <tr>
                    <td>luma.model_selection</td>
                    <td>Tools for model selection and hyperparameter tuning.</td>
                </tr>
                <tr>
                    <td>luma.pipe</td>
                    <td>Creating and managing machine learning pipelines.</td>
                </tr>
                <tr>
                    <td>luma.preprocessing</td>
                    <td>Data preprocessing functions for machine learning tasks.</td>
                </tr>
                <tr>
                    <td>luma.reduction</td>
                    <td>Dimensionality reduction techniques for high-dimensional datasets.</td>
                </tr>
                <tr>
                    <td>luma.regressor</td>
                    <td>Comprehensive range of regression algorithms.</td>
                </tr>
                <tr>
                    <td>luma.visual</td>
                    <td>Tools for model visualization and data plotting.</td>
                </tr>
            </table>
        </div>
        <h2></h2>
        <div class="others">
            <h3 class="others-header">Others</h3>
            <table>
                <tr>
                    <td>Latest Version</td>
                    <td>0.4.11</td>
                </tr>
                <tr>
                    <td>Lines of Code</td>
                    <td>~7.7K</td>
                </tr>
                <tr>
                    <td>Requirement</td>
                    <td>Python 3.10 or later</td>
                </tr>
                <tr>
                    <td>Dependencies</td>
                    <td>NumPy, SciPy, Pandas, Matplotlib, Seaborn</td>
                </tr>
                <tr>
                    <td>Documentation</td>
                    <td>
                        <a href="https://lumerico284.notion.site/LUMA-76330376b0e64cc1b95874c469aeb327?pvs=4">LUMA Notion Document</a>
                    </td>
                </tr>
            </table>
        </div>
    </body>
</html>
