# coding: utf-8

"""
    MONEI API v1

    <p>The MONEI API is organized around <a href=\"https://en.wikipedia.org/wiki/Representational_State_Transfer\">REST</a>. Our API has predictable resource-oriented URLs, accepts JSON-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.</p> <h4 id=\"base-url\">Base URL:</h4> <p><a href=\"https://api.monei.com/v1\">https://api.monei.com/v1</a></p> <h4 id=\"client-libraries\">Client libraries:</h4> <ul> <li><a href=\"https://github.com/MONEI/monei-php-sdk\">PHP SDK</a></li> <li><a href=\"https://github.com/MONEI/monei-python-sdk\">Python SDK</a></li> <li><a href=\"https://github.com/MONEI/monei-node-sdk\">Node.js SDK</a></li> <li><a href=\"https://postman.monei.com/\">Postman Collection</a></li> </ul> <h4 id=\"important\">Important:</h4> <p><strong>If you are not using our official SDKs, you need to provide a valid <code>User-Agent</code> header in each request, otherwise your requests will be rejected.</strong></p>   # noqa: E501

    The version of the OpenAPI document: 1.2.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from Monei.configuration import Configuration


class Subscription(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'amount': 'int',
        'currency': 'str',
        'description': 'str',
        'account_id': 'str',
        'livemode': 'bool',
        'status': 'SubscriptionStatus',
        'customer': 'PaymentCustomer',
        'billing_details': 'PaymentBillingDetails',
        'shipping_details': 'PaymentShippingDetails',
        'interval': 'SubscriptionInterval',
        'interval_count': 'int',
        'pause_interval_count': 'int',
        'last_order_id': 'str',
        'last_payment': 'SubscriptionLastPayment',
        'payment_method': 'SubscriptionPaymentMethod',
        'current_period_start': 'float',
        'current_period_end': 'float',
        'trial_period_end': 'float',
        'next_payment_at': 'int',
        'retry_count': 'int',
        'cancel_at_period_end': 'bool',
        'pause_at_period_end': 'bool',
        'trace_details': 'PaymentTraceDetails',
        'sequence_id': 'str',
        'callback_url': 'str',
        'payment_callback_url': 'str',
        'created_at': 'int',
        'updated_at': 'int'
    }

    attribute_map = {
        'id': 'id',
        'amount': 'amount',
        'currency': 'currency',
        'description': 'description',
        'account_id': 'accountId',
        'livemode': 'livemode',
        'status': 'status',
        'customer': 'customer',
        'billing_details': 'billingDetails',
        'shipping_details': 'shippingDetails',
        'interval': 'interval',
        'interval_count': 'intervalCount',
        'pause_interval_count': 'pauseIntervalCount',
        'last_order_id': 'lastOrderId',
        'last_payment': 'lastPayment',
        'payment_method': 'paymentMethod',
        'current_period_start': 'currentPeriodStart',
        'current_period_end': 'currentPeriodEnd',
        'trial_period_end': 'trialPeriodEnd',
        'next_payment_at': 'nextPaymentAt',
        'retry_count': 'retryCount',
        'cancel_at_period_end': 'cancelAtPeriodEnd',
        'pause_at_period_end': 'pauseAtPeriodEnd',
        'trace_details': 'traceDetails',
        'sequence_id': 'sequenceId',
        'callback_url': 'callbackUrl',
        'payment_callback_url': 'paymentCallbackUrl',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, amount=None, currency=None, description=None, account_id=None, livemode=None, status=None, customer=None, billing_details=None, shipping_details=None, interval=None, interval_count=None, pause_interval_count=None, last_order_id=None, last_payment=None, payment_method=None, current_period_start=None, current_period_end=None, trial_period_end=None, next_payment_at=None, retry_count=None, cancel_at_period_end=None, pause_at_period_end=None, trace_details=None, sequence_id=None, callback_url=None, payment_callback_url=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Subscription - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._amount = None
        self._currency = None
        self._description = None
        self._account_id = None
        self._livemode = None
        self._status = None
        self._customer = None
        self._billing_details = None
        self._shipping_details = None
        self._interval = None
        self._interval_count = None
        self._pause_interval_count = None
        self._last_order_id = None
        self._last_payment = None
        self._payment_method = None
        self._current_period_start = None
        self._current_period_end = None
        self._trial_period_end = None
        self._next_payment_at = None
        self._retry_count = None
        self._cancel_at_period_end = None
        self._pause_at_period_end = None
        self._trace_details = None
        self._sequence_id = None
        self._callback_url = None
        self._payment_callback_url = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if amount is not None:
            self.amount = amount
        if currency is not None:
            self.currency = currency
        if description is not None:
            self.description = description
        if account_id is not None:
            self.account_id = account_id
        if livemode is not None:
            self.livemode = livemode
        if status is not None:
            self.status = status
        if customer is not None:
            self.customer = customer
        if billing_details is not None:
            self.billing_details = billing_details
        if shipping_details is not None:
            self.shipping_details = shipping_details
        if interval is not None:
            self.interval = interval
        if interval_count is not None:
            self.interval_count = interval_count
        if pause_interval_count is not None:
            self.pause_interval_count = pause_interval_count
        if last_order_id is not None:
            self.last_order_id = last_order_id
        if last_payment is not None:
            self.last_payment = last_payment
        if payment_method is not None:
            self.payment_method = payment_method
        if current_period_start is not None:
            self.current_period_start = current_period_start
        if current_period_end is not None:
            self.current_period_end = current_period_end
        if trial_period_end is not None:
            self.trial_period_end = trial_period_end
        if next_payment_at is not None:
            self.next_payment_at = next_payment_at
        if retry_count is not None:
            self.retry_count = retry_count
        if cancel_at_period_end is not None:
            self.cancel_at_period_end = cancel_at_period_end
        if pause_at_period_end is not None:
            self.pause_at_period_end = pause_at_period_end
        if trace_details is not None:
            self.trace_details = trace_details
        if sequence_id is not None:
            self.sequence_id = sequence_id
        if callback_url is not None:
            self.callback_url = callback_url
        if payment_callback_url is not None:
            self.payment_callback_url = payment_callback_url
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this Subscription.  # noqa: E501

        Unique identifier for the subscription.  # noqa: E501

        :return: The id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Subscription.

        Unique identifier for the subscription.  # noqa: E501

        :param id: The id of this Subscription.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def amount(self):
        """Gets the amount of this Subscription.  # noqa: E501

        Amount intended to be collected by this payment. A positive integer representing how much to charge in the smallest currency unit (e.g., 100 cents to charge 1.00 USD).   # noqa: E501

        :return: The amount of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Subscription.

        Amount intended to be collected by this payment. A positive integer representing how much to charge in the smallest currency unit (e.g., 100 cents to charge 1.00 USD).   # noqa: E501

        :param amount: The amount of this Subscription.  # noqa: E501
        :type: int
        """

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this Subscription.  # noqa: E501

        Three-letter [ISO currency code](https://en.wikipedia.org/wiki/ISO_4217), in uppercase. Must be a supported currency.   # noqa: E501

        :return: The currency of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Subscription.

        Three-letter [ISO currency code](https://en.wikipedia.org/wiki/ISO_4217), in uppercase. Must be a supported currency.   # noqa: E501

        :param currency: The currency of this Subscription.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def description(self):
        """Gets the description of this Subscription.  # noqa: E501

        An arbitrary string attached to the subscription. Often useful for displaying to users.   # noqa: E501

        :return: The description of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Subscription.

        An arbitrary string attached to the subscription. Often useful for displaying to users.   # noqa: E501

        :param description: The description of this Subscription.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def account_id(self):
        """Gets the account_id of this Subscription.  # noqa: E501

        MONEI Account identifier.  # noqa: E501

        :return: The account_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Subscription.

        MONEI Account identifier.  # noqa: E501

        :param account_id: The account_id of this Subscription.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def livemode(self):
        """Gets the livemode of this Subscription.  # noqa: E501

        Has the value `true` if the resource exists in live mode or the value `false` if the resource exists in test mode.  # noqa: E501

        :return: The livemode of this Subscription.  # noqa: E501
        :rtype: bool
        """
        return self._livemode

    @livemode.setter
    def livemode(self, livemode):
        """Sets the livemode of this Subscription.

        Has the value `true` if the resource exists in live mode or the value `false` if the resource exists in test mode.  # noqa: E501

        :param livemode: The livemode of this Subscription.  # noqa: E501
        :type: bool
        """

        self._livemode = livemode

    @property
    def status(self):
        """Gets the status of this Subscription.  # noqa: E501


        :return: The status of this Subscription.  # noqa: E501
        :rtype: SubscriptionStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Subscription.


        :param status: The status of this Subscription.  # noqa: E501
        :type: SubscriptionStatus
        """

        self._status = status

    @property
    def customer(self):
        """Gets the customer of this Subscription.  # noqa: E501


        :return: The customer of this Subscription.  # noqa: E501
        :rtype: PaymentCustomer
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this Subscription.


        :param customer: The customer of this Subscription.  # noqa: E501
        :type: PaymentCustomer
        """

        self._customer = customer

    @property
    def billing_details(self):
        """Gets the billing_details of this Subscription.  # noqa: E501


        :return: The billing_details of this Subscription.  # noqa: E501
        :rtype: PaymentBillingDetails
        """
        return self._billing_details

    @billing_details.setter
    def billing_details(self, billing_details):
        """Sets the billing_details of this Subscription.


        :param billing_details: The billing_details of this Subscription.  # noqa: E501
        :type: PaymentBillingDetails
        """

        self._billing_details = billing_details

    @property
    def shipping_details(self):
        """Gets the shipping_details of this Subscription.  # noqa: E501


        :return: The shipping_details of this Subscription.  # noqa: E501
        :rtype: PaymentShippingDetails
        """
        return self._shipping_details

    @shipping_details.setter
    def shipping_details(self, shipping_details):
        """Sets the shipping_details of this Subscription.


        :param shipping_details: The shipping_details of this Subscription.  # noqa: E501
        :type: PaymentShippingDetails
        """

        self._shipping_details = shipping_details

    @property
    def interval(self):
        """Gets the interval of this Subscription.  # noqa: E501


        :return: The interval of this Subscription.  # noqa: E501
        :rtype: SubscriptionInterval
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this Subscription.


        :param interval: The interval of this Subscription.  # noqa: E501
        :type: SubscriptionInterval
        """

        self._interval = interval

    @property
    def interval_count(self):
        """Gets the interval_count of this Subscription.  # noqa: E501

        Number of intervals between subscription payments.  # noqa: E501

        :return: The interval_count of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._interval_count

    @interval_count.setter
    def interval_count(self, interval_count):
        """Sets the interval_count of this Subscription.

        Number of intervals between subscription payments.  # noqa: E501

        :param interval_count: The interval_count of this Subscription.  # noqa: E501
        :type: int
        """

        self._interval_count = interval_count

    @property
    def pause_interval_count(self):
        """Gets the pause_interval_count of this Subscription.  # noqa: E501

        Number of intervals when subscription will be paused before it activates again.  # noqa: E501

        :return: The pause_interval_count of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._pause_interval_count

    @pause_interval_count.setter
    def pause_interval_count(self, pause_interval_count):
        """Sets the pause_interval_count of this Subscription.

        Number of intervals when subscription will be paused before it activates again.  # noqa: E501

        :param pause_interval_count: The pause_interval_count of this Subscription.  # noqa: E501
        :type: int
        """

        self._pause_interval_count = pause_interval_count

    @property
    def last_order_id(self):
        """Gets the last_order_id of this Subscription.  # noqa: E501

        An order ID from your system. A unique identifier that can be used to reconcile the payment with your internal system.   # noqa: E501

        :return: The last_order_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._last_order_id

    @last_order_id.setter
    def last_order_id(self, last_order_id):
        """Sets the last_order_id of this Subscription.

        An order ID from your system. A unique identifier that can be used to reconcile the payment with your internal system.   # noqa: E501

        :param last_order_id: The last_order_id of this Subscription.  # noqa: E501
        :type: str
        """

        self._last_order_id = last_order_id

    @property
    def last_payment(self):
        """Gets the last_payment of this Subscription.  # noqa: E501


        :return: The last_payment of this Subscription.  # noqa: E501
        :rtype: SubscriptionLastPayment
        """
        return self._last_payment

    @last_payment.setter
    def last_payment(self, last_payment):
        """Sets the last_payment of this Subscription.


        :param last_payment: The last_payment of this Subscription.  # noqa: E501
        :type: SubscriptionLastPayment
        """

        self._last_payment = last_payment

    @property
    def payment_method(self):
        """Gets the payment_method of this Subscription.  # noqa: E501


        :return: The payment_method of this Subscription.  # noqa: E501
        :rtype: SubscriptionPaymentMethod
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this Subscription.


        :param payment_method: The payment_method of this Subscription.  # noqa: E501
        :type: SubscriptionPaymentMethod
        """

        self._payment_method = payment_method

    @property
    def current_period_start(self):
        """Gets the current_period_start of this Subscription.  # noqa: E501

        The start date of the current subscription period. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The current_period_start of this Subscription.  # noqa: E501
        :rtype: float
        """
        return self._current_period_start

    @current_period_start.setter
    def current_period_start(self, current_period_start):
        """Sets the current_period_start of this Subscription.

        The start date of the current subscription period. Measured in seconds since the Unix epoch.  # noqa: E501

        :param current_period_start: The current_period_start of this Subscription.  # noqa: E501
        :type: float
        """

        self._current_period_start = current_period_start

    @property
    def current_period_end(self):
        """Gets the current_period_end of this Subscription.  # noqa: E501

        The end date of the current subscription period. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The current_period_end of this Subscription.  # noqa: E501
        :rtype: float
        """
        return self._current_period_end

    @current_period_end.setter
    def current_period_end(self, current_period_end):
        """Sets the current_period_end of this Subscription.

        The end date of the current subscription period. Measured in seconds since the Unix epoch.  # noqa: E501

        :param current_period_end: The current_period_end of this Subscription.  # noqa: E501
        :type: float
        """

        self._current_period_end = current_period_end

    @property
    def trial_period_end(self):
        """Gets the trial_period_end of this Subscription.  # noqa: E501

        The end date of the trial period. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The trial_period_end of this Subscription.  # noqa: E501
        :rtype: float
        """
        return self._trial_period_end

    @trial_period_end.setter
    def trial_period_end(self, trial_period_end):
        """Sets the trial_period_end of this Subscription.

        The end date of the trial period. Measured in seconds since the Unix epoch.  # noqa: E501

        :param trial_period_end: The trial_period_end of this Subscription.  # noqa: E501
        :type: float
        """

        self._trial_period_end = trial_period_end

    @property
    def next_payment_at(self):
        """Gets the next_payment_at of this Subscription.  # noqa: E501

        The date when the next payment will be made.  # noqa: E501

        :return: The next_payment_at of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._next_payment_at

    @next_payment_at.setter
    def next_payment_at(self, next_payment_at):
        """Sets the next_payment_at of this Subscription.

        The date when the next payment will be made.  # noqa: E501

        :param next_payment_at: The next_payment_at of this Subscription.  # noqa: E501
        :type: int
        """

        self._next_payment_at = next_payment_at

    @property
    def retry_count(self):
        """Gets the retry_count of this Subscription.  # noqa: E501

        Number of retries left for the subscription.  # noqa: E501

        :return: The retry_count of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._retry_count

    @retry_count.setter
    def retry_count(self, retry_count):
        """Sets the retry_count of this Subscription.

        Number of retries left for the subscription.  # noqa: E501

        :param retry_count: The retry_count of this Subscription.  # noqa: E501
        :type: int
        """

        self._retry_count = retry_count

    @property
    def cancel_at_period_end(self):
        """Gets the cancel_at_period_end of this Subscription.  # noqa: E501

        If true, the subscription will be canceled at the end of the current period.   # noqa: E501

        :return: The cancel_at_period_end of this Subscription.  # noqa: E501
        :rtype: bool
        """
        return self._cancel_at_period_end

    @cancel_at_period_end.setter
    def cancel_at_period_end(self, cancel_at_period_end):
        """Sets the cancel_at_period_end of this Subscription.

        If true, the subscription will be canceled at the end of the current period.   # noqa: E501

        :param cancel_at_period_end: The cancel_at_period_end of this Subscription.  # noqa: E501
        :type: bool
        """

        self._cancel_at_period_end = cancel_at_period_end

    @property
    def pause_at_period_end(self):
        """Gets the pause_at_period_end of this Subscription.  # noqa: E501

        If true, the subscription will be paused at the end of the current period.   # noqa: E501

        :return: The pause_at_period_end of this Subscription.  # noqa: E501
        :rtype: bool
        """
        return self._pause_at_period_end

    @pause_at_period_end.setter
    def pause_at_period_end(self, pause_at_period_end):
        """Sets the pause_at_period_end of this Subscription.

        If true, the subscription will be paused at the end of the current period.   # noqa: E501

        :param pause_at_period_end: The pause_at_period_end of this Subscription.  # noqa: E501
        :type: bool
        """

        self._pause_at_period_end = pause_at_period_end

    @property
    def trace_details(self):
        """Gets the trace_details of this Subscription.  # noqa: E501


        :return: The trace_details of this Subscription.  # noqa: E501
        :rtype: PaymentTraceDetails
        """
        return self._trace_details

    @trace_details.setter
    def trace_details(self, trace_details):
        """Sets the trace_details of this Subscription.


        :param trace_details: The trace_details of this Subscription.  # noqa: E501
        :type: PaymentTraceDetails
        """

        self._trace_details = trace_details

    @property
    def sequence_id(self):
        """Gets the sequence_id of this Subscription.  # noqa: E501

        A permanent identifier that refers to the initial payment of a sequence of payments. This value needs to be sent in the path for `RECURRING` payments.   # noqa: E501

        :return: The sequence_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._sequence_id

    @sequence_id.setter
    def sequence_id(self, sequence_id):
        """Sets the sequence_id of this Subscription.

        A permanent identifier that refers to the initial payment of a sequence of payments. This value needs to be sent in the path for `RECURRING` payments.   # noqa: E501

        :param sequence_id: The sequence_id of this Subscription.  # noqa: E501
        :type: str
        """

        self._sequence_id = sequence_id

    @property
    def callback_url(self):
        """Gets the callback_url of this Subscription.  # noqa: E501

        The URL will be called each time subscription status changes.   # noqa: E501

        :return: The callback_url of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._callback_url

    @callback_url.setter
    def callback_url(self, callback_url):
        """Sets the callback_url of this Subscription.

        The URL will be called each time subscription status changes.   # noqa: E501

        :param callback_url: The callback_url of this Subscription.  # noqa: E501
        :type: str
        """

        self._callback_url = callback_url

    @property
    def payment_callback_url(self):
        """Gets the payment_callback_url of this Subscription.  # noqa: E501

        The URL will be called each time subscription creates a new payments.   # noqa: E501

        :return: The payment_callback_url of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._payment_callback_url

    @payment_callback_url.setter
    def payment_callback_url(self, payment_callback_url):
        """Sets the payment_callback_url of this Subscription.

        The URL will be called each time subscription creates a new payments.   # noqa: E501

        :param payment_callback_url: The payment_callback_url of this Subscription.  # noqa: E501
        :type: str
        """

        self._payment_callback_url = payment_callback_url

    @property
    def created_at(self):
        """Gets the created_at of this Subscription.  # noqa: E501

        Time at which the resource was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The created_at of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Subscription.

        Time at which the resource was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :param created_at: The created_at of this Subscription.  # noqa: E501
        :type: int
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Subscription.  # noqa: E501

        Time at which the resource updated last time. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The updated_at of this Subscription.  # noqa: E501
        :rtype: int
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Subscription.

        Time at which the resource updated last time. Measured in seconds since the Unix epoch.  # noqa: E501

        :param updated_at: The updated_at of this Subscription.  # noqa: E501
        :type: int
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Subscription):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Subscription):
            return True

        return self.to_dict() != other.to_dict()
