"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum for representing all the days of the week.
 *
 * @stability stable
 */
var Weekday;
(function (Weekday) {
    Weekday["MONDAY"] = "1";
    Weekday["TUESDAY"] = "2";
    Weekday["WEDNESDAY"] = "3";
    Weekday["THURSDAY"] = "4";
    Weekday["FRIDAY"] = "5";
    Weekday["SATURDAY"] = "6";
    Weekday["SUNDAY"] = "7";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 *
 * @stability stable
 */
class LustreMaintenanceTime {
    /**
     * @stability stable
     */
    constructor(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_fsx_LustreMaintenanceTimeProps(props);
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @stability stable
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
_a = JSII_RTTI_SYMBOL_1;
LustreMaintenanceTime[_a] = { fqn: "@aws-cdk/aws-fsx.LustreMaintenanceTime", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,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