/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.FloatList;
import processing.data.Sort;

public class LongList
implements Iterable<Long> {
    protected int count;
    protected long[] data;

    public LongList() {
        this.data = new long[10];
    }

    public LongList(int length) {
        this.data = new long[length];
    }

    public LongList(int[] source) {
        this.count = source.length;
        this.data = new long[this.count];
        System.arraycopy(source, 0, this.data, 0, this.count);
    }

    public LongList(Iterable<Object> iter) {
        this(10);
        for (Object o : iter) {
            if (o == null) {
                this.append(0L);
                continue;
            }
            if (o instanceof Number) {
                this.append(((Number)o).intValue());
                continue;
            }
            this.append(PApplet.parseInt(o.toString().trim()));
        }
        this.crop();
    }

    public LongList(Object ... items) {
        boolean missingValue = false;
        this.count = items.length;
        this.data = new long[this.count];
        int index = 0;
        for (Object o : items) {
            int value = 0;
            if (o != null) {
                value = o instanceof Number ? ((Number)o).intValue() : PApplet.parseInt(o.toString().trim(), 0);
            }
            this.data[index++] = value;
        }
    }

    public static LongList fromRange(int stop) {
        return LongList.fromRange(0, stop);
    }

    public static LongList fromRange(int start, int stop) {
        int count = stop - start;
        LongList newbie = new LongList(count);
        for (int i = 0; i < count; ++i) {
            newbie.set(i, start + i);
        }
        return newbie;
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            long[] temp = new long[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0L);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public long get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, int what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            for (int i = this.count; i < index; ++i) {
                this.data[i] = 0L;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(int value) {
        this.append(value);
    }

    public long pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        long value = this.get(this.count - 1);
        --this.count;
        return value;
    }

    public long remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        long entry = this.data[index];
        for (int i = index; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int ii = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == (long)value) continue;
            this.data[ii++] = this.data[i];
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public void append(long value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(int[] values) {
        for (int v : values) {
            this.append(v);
        }
    }

    public void append(LongList list) {
        for (long v : list.values()) {
            this.append(v);
        }
    }

    public void appendUnique(int value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, long value) {
        this.insert(index, new long[]{value});
    }

    public void insert(int index, long[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        long[] temp = new long[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, LongList list) {
        this.insert(index, list.values());
    }

    public int index(int what) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != (long)what) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(int value) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != (long)value) continue;
            return true;
        }
        return false;
    }

    public void increment(int index) {
        if (this.count <= index) {
            this.resize(index + 1);
        }
        int n = index;
        this.data[n] = this.data[n] + 1L;
    }

    private void boundsProblem(int index, String method) {
        String msg = String.format("The list size is %d. You cannot %s() to element %d.", this.count, method, index);
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public void add(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] + (long)amount;
        } else {
            this.boundsProblem(index, "add");
        }
    }

    public void sub(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] - (long)amount;
        } else {
            this.boundsProblem(index, "sub");
        }
    }

    public void mult(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] * (long)amount;
        } else {
            this.boundsProblem(index, "mult");
        }
    }

    public void div(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] / (long)amount;
        } else {
            this.boundsProblem(index, "div");
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public long min() {
        this.checkMinMax("min");
        long outgoing = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= outgoing) continue;
            outgoing = this.data[i];
        }
        return outgoing;
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        long value = this.data[0];
        int index = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= value) continue;
            value = this.data[i];
            index = i;
        }
        return index;
    }

    public long max() {
        this.checkMinMax("max");
        long outgoing = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= outgoing) continue;
            outgoing = this.data[i];
        }
        return outgoing;
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        long value = this.data[0];
        int index = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= value) continue;
            value = this.data[i];
            index = i;
        }
        return index;
    }

    public int sum() {
        long amount = this.sumLong();
        if (amount > Integer.MAX_VALUE) {
            throw new RuntimeException("sum() exceeds 2147483647, use sumLong()");
        }
        if (amount < Integer.MIN_VALUE) {
            throw new RuntimeException("sum() less than -2147483648, use sumLong()");
        }
        return (int)amount;
    }

    public long sumLong() {
        long sum = 0L;
        for (int i = 0; i < this.count; ++i) {
            sum += this.data[i];
        }
        return sum;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return LongList.this.count;
            }

            @Override
            public int compare(int a, int b) {
                long diff = LongList.this.data[b] - LongList.this.data[a];
                return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
            }

            @Override
            public void swap(int a, int b) {
                long temp = LongList.this.data[a];
                LongList.this.data[a] = LongList.this.data[b];
                LongList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            long t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            long temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            long temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public LongList copy() {
        LongList outgoing = new LongList(new Object[]{this.data});
        outgoing.count = this.count;
        return outgoing;
    }

    public long[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            int index = -1;

            @Override
            public void remove() {
                LongList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Long next() {
                return LongList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < LongList.this.count;
            }
        };
    }

    public int[] array() {
        return this.array(null);
    }

    public int[] array(int[] array) {
        if (array == null || array.length != this.count) {
            array = new int[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public FloatList getPercent() {
        double sum = 0.0;
        int[] nArray = this.array();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float value = nArray[i];
            sum += (double)value;
        }
        FloatList outgoing = new FloatList(this.count);
        for (int i = 0; i < this.count; ++i) {
            double percent = (double)this.data[i] / sum;
            outgoing.set(i, (float)percent);
        }
        return outgoing;
    }

    public LongList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public LongList getSubset(int start, int num) {
        int[] subset = new int[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new LongList(subset);
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        for (int i = 1; i < this.count; ++i) {
            sb.append(separator);
            sb.append(this.data[i]);
        }
        return sb.toString();
    }

    public void print() {
        for (int i = 0; i < this.count; ++i) {
            System.out.format("[%d] %d%n", i, this.data[i]);
        }
    }

    public void save(File file) {
        PrintWriter writer = PApplet.createWriter(file);
        this.write(writer);
        writer.close();
    }

    public void write(PrintWriter writer) {
        for (int i = 0; i < this.count; ++i) {
            writer.println(this.data[i]);
        }
        writer.flush();
    }

    public String toJSON() {
        return "[ " + this.join(", ") + " ]";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }
}

