import requests
import json

from .helper import Helper


class Actions(Helper):
    def __init__(self, base_url, org_pk, teams_pk, access_token, _csrf_token, headers, pagination):
        super().__init__(base_url, org_pk, teams_pk, access_token, _csrf_token, headers, pagination)

    def get_actions_list(self, page=1):
        """ Get the list of actions """

        route = 'v1/actions/list/{0}/?page_size={1}&page={2}'.format(self.org_pk, self.pagination, page)
        response = self.process_request(requests, 'GET', self.base_url, route, self.headers, None, None)
        return self.process_response(response, True)

    def get_actions_details(self, id):
        """ Get the action details

        Keywords arguments:
        id -- id of the action
        """

        route = 'v1/actions/{0}/'.format(id)
        response = self.process_request(requests, 'GET', self.base_url, route, self.headers, None, None)
        return self.process_response(response)
