"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import feast.core.DataSource_pb2
import feast.core.Feature_pb2
import feast.core.OnlineStore_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class FeatureTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEC_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    @property
    def spec(self) -> global___FeatureTableSpec:
        """User-specified specifications of this feature table."""
    @property
    def meta(self) -> global___FeatureTableMeta:
        """System-populated metadata for this feature table."""
    def __init__(
        self,
        *,
        spec: global___FeatureTableSpec | None = ...,
        meta: global___FeatureTableMeta | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["meta", b"meta", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["meta", b"meta", "spec", b"spec"]) -> None: ...

global___FeatureTable = FeatureTable

class FeatureTableSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    ENTITIES_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MAX_AGE_FIELD_NUMBER: builtins.int
    BATCH_SOURCE_FIELD_NUMBER: builtins.int
    STREAM_SOURCE_FIELD_NUMBER: builtins.int
    STALENESS_THRESHOLD_FIELD_NUMBER: builtins.int
    ONLINE_STORE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the feature table. Must be unique. Not updated."""
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List names of entities to associate with the Features defined in this 
        Feature Table. Not updatable.
        """
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[feast.core.Feature_pb2.FeatureSpec]:
        """List of features specifications for each feature defined with this feature table."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """User defined metadata"""
    @property
    def max_age(self) -> google.protobuf.duration_pb2.Duration:
        """Features in this feature table can only be retrieved from online serving
        younger than max age. Age is measured as the duration of time between 
        the feature's event timestamp and when the feature is retrieved
        Feature values outside max age will be returned as unset values and indicated to end user
        """
    @property
    def batch_source(self) -> feast.core.DataSource_pb2.DataSource:
        """Batch/Offline DataSource to source batch/offline feature data.
        Only batch DataSource can be specified 
        (ie source type should start with 'BATCH_')
        """
    @property
    def stream_source(self) -> feast.core.DataSource_pb2.DataSource:
        """Stream/Online DataSource to source stream/online feature data.
        Only stream DataSource can be specified 
        (ie source type should start with 'STREAM_')
        """
    @property
    def staleness_threshold(self) -> google.protobuf.duration_pb2.Duration:
        """Threshold to detect features that are close to be evicted.
        Used by Feast Serving to indicate that feature is stale.
        Must be less than max_age, since after max_age feature most probably will be garbage collected
        """
    @property
    def online_store(self) -> feast.core.OnlineStore_pb2.OnlineStore:
        """Database where features are stored for online serving"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        entities: collections.abc.Iterable[builtins.str] | None = ...,
        features: collections.abc.Iterable[feast.core.Feature_pb2.FeatureSpec] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        max_age: google.protobuf.duration_pb2.Duration | None = ...,
        batch_source: feast.core.DataSource_pb2.DataSource | None = ...,
        stream_source: feast.core.DataSource_pb2.DataSource | None = ...,
        staleness_threshold: google.protobuf.duration_pb2.Duration | None = ...,
        online_store: feast.core.OnlineStore_pb2.OnlineStore | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_source", b"batch_source", "max_age", b"max_age", "online_store", b"online_store", "staleness_threshold", b"staleness_threshold", "stream_source", b"stream_source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_source", b"batch_source", "entities", b"entities", "features", b"features", "labels", b"labels", "max_age", b"max_age", "name", b"name", "online_store", b"online_store", "staleness_threshold", b"staleness_threshold", "stream_source", b"stream_source"]) -> None: ...

global___FeatureTableSpec = FeatureTableSpec

class FeatureTableMeta(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_TIMESTAMP_FIELD_NUMBER: builtins.int
    LAST_UPDATED_TIMESTAMP_FIELD_NUMBER: builtins.int
    REVISION_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    @property
    def created_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time where this Feature Table is created"""
    @property
    def last_updated_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time where this Feature Table is last updated"""
    revision: builtins.int
    """Auto incrementing revision no. of this Feature Table"""
    hash: builtins.str
    """Hash entities, features, batch_source and stream_source to inform JobService if
    jobs should be restarted should hash change
    """
    def __init__(
        self,
        *,
        created_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_updated_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        revision: builtins.int = ...,
        hash: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_timestamp", b"created_timestamp", "last_updated_timestamp", b"last_updated_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_timestamp", b"created_timestamp", "hash", b"hash", "last_updated_timestamp", b"last_updated_timestamp", "revision", b"revision"]) -> None: ...

global___FeatureTableMeta = FeatureTableMeta
