"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpotInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const iam = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const defaultRuntime = aws_lambda_1.Runtime.NODEJS_16_X;
const defaultLogRetention = aws_logs_1.RetentionDays.THREE_MONTHS;
class SpotReqCanceler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaExcecutionRole = props.lambdaExcecutionRole ??
            new iam.Role(this, "HandlerExecutionRole", {
                assumedBy: new iam.ServicePrincipal("lambda.amazonaws.com"),
                managedPolicies: [
                    iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole"),
                ],
                inlinePolicies: {
                    ec2: new iam.PolicyDocument({
                        statements: [
                            new iam.PolicyStatement({
                                effect: iam.Effect.ALLOW,
                                actions: ["ec2:DescribeInstances", "ec2:CancelSpotInstanceRequests"],
                                resources: ["*"],
                                conditions: {
                                    StringEquals: {
                                        "aws:RequestedRegion": [aws_cdk_lib_1.Stack.of(this).region],
                                    },
                                },
                            }),
                        ],
                    }),
                },
            });
        const logRetention = props.lambdaLogRetention ?? defaultLogRetention;
        const runtime = props.lambdaRuntime ?? defaultRuntime;
        if (runtime.family !== aws_lambda_1.RuntimeFamily.NODEJS) {
            // better-typescript-lib@2.2.0 + @typescript-eslint/no-throw-literal causes error, so temporarily disalbe it
            // eslint-disable-next-line @typescript-eslint/no-throw-literal
            throw new Error("A runtime other than Node.js was specified.");
        }
        const handler = new aws_lambda_nodejs_1.NodejsFunction(this, "Handler", {
            entry: path.join(__dirname, "../../src/lambda/index.ts"),
            runtime,
            architecture: aws_lambda_1.Architecture.ARM_64,
            memorySize: 128,
            role: lambdaExcecutionRole,
            logRetention,
            bundling: {
                tsconfig: "tsconfig.lint-and-lambda.json",
            },
        });
        const provider = new custom_resources_1.Provider(this, "Provider", {
            onEventHandler: handler,
            logRetention,
        });
        new aws_cdk_lib_1.CustomResource(this, "CustomResource", {
            serviceToken: provider.serviceToken,
            properties: {
                ec2InstanceId: props.instanceId,
            },
        });
    }
}
/**
 * This represents a single EC2 Spot instance and other necessary resources.
 */
class SpotInstance extends aws_ec2_1.Instance {
    constructor(scope, id, props) {
        super(scope, id, props);
        const templ = new aws_ec2_1.LaunchTemplate(this, "LaunchTemplateForSpotReq", {
            spotOptions: props.spotOptions ?? {},
        });
        this.instance.launchTemplate = {
            version: templ.versionNumber,
            launchTemplateId: templ.launchTemplateId,
        };
        if (props.spotOptions?.requestType === aws_ec2_1.SpotRequestType.PERSISTENT) {
            // Persistent SpotReq remains after instance or stack destroys.
            // Therefore, create a custom resource to remove SpotReq when the stack is destroyed.
            new SpotReqCanceler(this, "SpotReqCanceler", {
                instanceId: this.instanceId,
                ...props.spotReqCancelerOptions,
            });
        }
    }
}
exports.SpotInstance = SpotInstance;
_a = JSII_RTTI_SYMBOL_1;
SpotInstance[_a] = { fqn: "cdk-ec2-spot-simple.SpotInstance", version: "2.0.1" };
