import type { InstanceProps, LaunchTemplateSpotOptions } from "aws-cdk-lib/aws-ec2";
import { Instance } from "aws-cdk-lib/aws-ec2";
import * as iam from "aws-cdk-lib/aws-iam";
import { Runtime } from "aws-cdk-lib/aws-lambda";
import { RetentionDays } from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";
/**
 * Options related to Lambda functions to cancel spot requests.
 */
export interface SpotReqCancelerProps {
    /**
     * Log retention period for internal Lambda functions logs kept in CloudWatch Logs.
     * @default - Three months
     */
    readonly lambdaLogRetention?: RetentionDays;
    /**
     * Internal Lambda functions execution role.
     * @default - Create a new Role that can do ec2:DescribeInstances and ec2:CancelSpotInstanceRequests and has "service-role/AWSLambdaBasicExecutionRole"
     */
    readonly lambdaExcecutionRole?: iam.IRole;
    /**
     * Runtime environment for the internal Lambda function.
     * If anything other than Node.js is specified, an error will occur.
     * @default - Node.js 16
     */
    readonly lambdaRuntime?: Runtime;
}
/**
 * Properties of `SpotInstance`
 */
export interface SpotInstanceProps extends InstanceProps {
    /**
     * Options related to Lambda functions to cancel spot requests.
     */
    readonly spotReqCancelerOptions?: SpotReqCancelerProps;
    /**
     * The options for the Spot instances.
     * @default - Use the Launch Template's default InstanceMarketOptions.
     */
    readonly spotOptions?: LaunchTemplateSpotOptions;
}
/**
 * This represents a single EC2 Spot instance and other necessary resources.
 */
export declare class SpotInstance extends Instance {
    constructor(scope: Construct, id: string, props: SpotInstanceProps);
}
//# sourceMappingURL=index.d.ts.map