import pandas as pd

# top 20 in Google searches per day
# sorted by longest first so .com matches before .om (Oman)
DICT_TLD_POPULAR = dict_tld_popular = dict(sorted([
    ('com', ('Commercial', 4860000000)),
    ('org', ('Noncommercial', 1950000000)),
    ('edu', ('US accredited postsecondary institutions', 1550000000)),
    ('gov', ('United States Government', 1060000000)),
    ('uk', ('United Kingdom', 473000000)),  # noqa
    ('net', ('Network services', 206000000)),
    ('ca', ('Canada', 165000000)),  # noqa
    ('de', ('Germany', 145000000)),  # noqa
    ('jp', ('Japan', 139000000)),  # noqa
    ('fr', ('France', 96700000)),  # noqa
    ('au', ('Australia', 91000000)),  # noqa
    ('us', ('United States', 68300000)),  # noqa
    ('ru', ('Russian Federation', 67900000)),  # noqa
    ('ch', ('Switzerland', 62100000)),  # noqa
    ('it', ('Italy', 55200000)),  # noqa
    ('nl', ('Netherlands', 45700000)),  # noqa
    ('se', ('Sweden', 39000000)),  # noqa
    ('no', ('Norway', 32300000)),  # noqa
    ('es', ('Spain', 31000000)),  # noqa
    ('mil', ('US Military', 28_400_000)),
    ('social', ('ActivityPub', 20_000_000)),  # HL estimate
    ('dev', ('ActivityPub', 20_000_000)),  # HL estimate
    ], key=lambda x: len(x[0]), reverse=True))

TLD_TYPE_SPONSOR_LISTS = [
    [".aaa", "generic", "American Automobile Association, Inc."],
    [".aarp", "generic", "AARP"],
    [".abb", "generic", "ABB Ltd"],
    [".abbott", "generic", "Abbott Laboratories, Inc."],
    [".abbvie", "generic", "AbbVie Inc."],
    [".abogado", "generic", "Top Level Domain Holdings Limited"],
    [".abudhabi", "generic", "Abu Dhabi Systems and Information Centre"],
    [".ac", "country-code", "Network Information Center (AC Domain Registry) c/o Cable and Wireless (Ascension Island)"],
    [".academy", "generic", "Half Oaks, LLC"],
    [".accenture", "generic", "Accenture plc"],
    [".accountant", "generic", "dot Accountant Limited"],
    [".accountants", "generic", "Knob Town, LLC"],
    [".aco", "generic", "ACO Severin Ahlmann GmbH & Co. KG"],
    [".active", "generic", "The Active Network, Inc"],
    [".actor", "generic", "United TLD Holdco Ltd."],
    [".ad", "country-code", "Andorra Telecom"],
    [".adac", "generic", "Allgemeiner Deutscher Automobil-Club e.V. (ADAC)"],
    [".ads", "generic", "Charleston Road Registry Inc."],
    [".adult", "generic", "ICM Registry AD LLC"],
    [".ae", "country-code", "Telecommunication Regulatory Authority (TRA)"],
    [".aeg", "generic", "Aktiebolaget Electrolux"],
    [".aero", "sponsored", "Societe Internationale de Telecommunications Aeronautique (SITA INC USA)"],
    [".af", "country-code", "Ministry of Communications and IT"],
    [".afl", "generic", "Australian Football League"],
    [".ag", "country-code", "UHSA School of Medicine"],
    [".agakhan", "generic", "Fondation Aga Khan (Aga Khan Foundation)"],
    [".agency", "generic", "Steel Falls, LLC"],
    [".ai", "country-code", "Government of Anguilla"],
    [".aig", "generic", "American International Group, Inc."],
    [".airforce", "generic", "United TLD Holdco Ltd."],
    [".airtel", "generic", "Bharti Airtel Limited"],
    [".akdn", "generic", "Fondation Aga Khan (Aga Khan Foundation)"],
    [".al", "country-code", "Electronic and Postal Communications Authority - AKEP"],
    [".alibaba", "generic", "Alibaba Group Holding Limited"],
    [".alipay", "generic", "Alibaba Group Holding Limited"],
    [".allfinanz", "generic", "Allfinanz Deutsche Vermögensberatung Aktiengesellschaft"],
    [".ally", "generic", "Ally Financial Inc."],
    [".alsace", "generic", "REGION D ALSACE"],
    [".am", "country-code", "Internet Society - Non-governmental Organization (NGO)"],
    [".amica", "generic", "Amica Mutual Insurance Company"],
    [".amsterdam", "generic", "Gemeente Amsterdam"],
    [".an", "country-code", "Retired"],
    [".analytics", "generic", "Campus IP LLC"],
    [".android", "generic", "Charleston Road Registry Inc."],
    [".anquan", "generic", "QIHOO 360 TECHNOLOGY CO. LTD."],
    [".ao", "country-code", "Faculdade de Engenharia da Universidade Agostinho Neto"],
    [".apartments", "generic", "June Maple, LLC"],
    [".app", "generic", "Charleston Road Registry Inc."],
    [".apple", "generic", "Apple Inc."],
    [".aq", "country-code", "Antarctica Network Information Centre Limited"],
    [".aquarelle", "generic", "Aquarelle.com"],
    [".ar", "country-code", "Presidencia de la Nación – Secretaría Legal y Técnica"],
    [".aramco", "generic", "Aramco Services Company"],
    [".archi", "generic", "STARTING DOT LIMITED"],
    [".army", "generic", "United TLD Holdco Ltd."],
    [".arpa", "infrastructure", "Internet Architecture Board (IAB)"],
    [".arte", "generic", "Association Relative à la Télévision Européenne G.E.I.E."],
    [".as", "country-code", "AS Domain Registry"],
    [".asia", "sponsored", "DotAsia Organisation Ltd."],
    [".associates", "generic", "Baxter Hill, LLC"],
    [".at", "country-code", "nic.at GmbH"],
    [".attorney", "generic", "United TLD Holdco, Ltd"],
    [".au", "country-code", ".au Domain Administration (auDA)"],
    [".auction", "generic", "United TLD HoldCo, Ltd."],
    [".audi", "generic", "AUDI Aktiengesellschaft"],
    [".audio", "generic", "Uniregistry, Corp."],
    [".author", "generic", "Amazon Registry Services, Inc."],
    [".auto", "generic", "Cars Registry Limited"],
    [".autos", "generic", "DERAutos, LLC"],
    [".avianca", "generic", "Aerovias del Continente Americano S.A. Avianca"],
    [".aw", "country-code", "SETAR"],
    [".aws", "generic", "Amazon Registry Services, Inc."],
    [".ax", "country-code", "Ålands landskapsregering"],
    [".axa", "generic", "AXA SA"],
    [".az", "country-code", "IntraNS"],
    [".azure", "generic", "Microsoft Corporation"],
    [".ba", "country-code", "Universtiy Telinformatic Centre (UTIC)"],
    [".baby", "generic", "Johnson & Johnson Services, Inc."],
    [".baidu", "generic", "Baidu, Inc."],
    [".band", "generic", "United TLD Holdco, Ltd"],
    [".bank", "generic", "fTLD Registry Services, LLC"],
    [".bar", "generic", "Punto 2012 Sociedad Anonima Promotora de Inversion de Capital Variable"],
    [".barcelona", "generic", "Municipi de Barcelona"],
    [".barclaycard", "generic", "Barclays Bank PLC"],
    [".barclays", "generic", "Barclays Bank PLC"],
    [".barefoot", "generic", "Gallo Vineyards, Inc."],
    [".bargains", "generic", "Half Hallow, LLC"],
    [".bauhaus", "generic", "Werkhaus GmbH"],
    [".bayern", "generic", "Bayern Connect GmbH"],
    [".bb", "country-code", "Government of Barbados Ministry of Economic Affairs and Development Telecommunications Unit"],
    [".bbc", "generic", "British Broadcasting Corporation"],
    [".bbva", "generic", "BANCO BILBAO VIZCAYA ARGENTARIA, S.A."],
    [".bcg", "generic", "The Boston Consulting Group, Inc."],
    [".bcn", "generic", "Municipi de Barcelona"],
    [".bd", "country-code", "Ministry of Post & Telecommunications Bangladesh Secretariat"],
    [".be", "country-code", "DNS Belgium vzw/asbl"],
    [".beats", "generic", "Beats Electronics, LLC"],
    [".beer", "generic", "Top Level Domain Holdings Limited"],
    [".bentley", "generic", "Bentley Motors Limited"],
    [".berlin", "generic", "dotBERLIN GmbH & Co. KG"],
    [".best", "generic", "BestTLD Pty Ltd"],
    [".bet", "generic", "Afilias plc"],
    [".bf", "country-code", "ARCE-AutoritÈ de RÈgulation des Communications Electroniques"],
    [".bg", "country-code", "Register.BG"],
    [".bh", "country-code", "Telecommunications Regulatory Authority (TRA)"],
    [".bharti", "generic", "Bharti Enterprises (Holding) Private Limited"],
    [".bi", "country-code", "Centre National de l'Informatique"],
    [".bible", "generic", "American Bible Society"],
    [".bid", "generic", "dot Bid Limited"],
    [".bike", "generic", "Grand Hollow, LLC"],
    [".bing", "generic", "Microsoft Corporation"],
    [".bingo", "generic", "Sand Cedar, LLC"],
    [".bio", "generic", "STARTING DOT LIMITED"],
    [".biz", "generic-restricted", "Neustar, Inc."],
    [".bj", "country-code", "Benin Telecoms S.A."],
    [".bl", "country-code", "Not assigned"],
    [".black", "generic", "Afilias Limited"],
    [".blackfriday", "generic", "Uniregistry, Corp."],
    [".bloomberg", "generic", "Bloomberg IP Holdings LLC"],
    [".blue", "generic", "Afilias Limited"],
    [".bm", "country-code", "Registry General Ministry of Labour and Immigration"],
    [".bms", "generic", "Bristol-Myers Squibb Company"],
    [".bmw", "generic", "Bayerische Motoren Werke Aktiengesellschaft"],
    [".bn", "country-code", "Brunei Darussalam Network Information Centre Sdn Bhd (BNNIC)"],
    [".bnl", "generic", "Banca Nazionale del Lavoro"],
    [".bnpparibas", "generic", "BNP Paribas"],
    [".bo", "country-code", "Agencia para el Desarrollo de la Información de la Sociedad en Bolivia"],
    [".boats", "generic", "DERBoats, LLC"],
    [".boehringer", "generic", "Boehringer Ingelheim International GmbH"],
    [".bom", "generic", "Núcleo de Informação e Coordenação do Ponto BR - NIC.br"],
    [".bond", "generic", "Bond University Limited"],
    [".boo", "generic", "Charleston Road Registry Inc."],
    [".book", "generic", "Amazon Registry Services, Inc."],
    [".boots", "generic", "THE BOOTS COMPANY PLC"],
    [".bosch", "generic", "Robert Bosch GMBH"],
    [".bostik", "generic", "Bostik SA"],
    [".bot", "generic", "Amazon Registry Services, Inc."],
    [".boutique", "generic", "Over Galley, LLC"],
    [".bq", "country-code", "Not assigned"],
    [".br", "country-code", "Comite Gestor da Internet no Brasil"],
    [".bradesco", "generic", "Banco Bradesco S.A."],
    [".bridgestone", "generic", "Bridgestone Corporation"],
    [".broadway", "generic", "Celebrate Broadway, Inc."],
    [".broker", "generic", "DOTBROKER REGISTRY LTD"],
    [".brother", "generic", "Brother Industries, Ltd."],
    [".brussels", "generic", "DNS.be vzw"],
    [".bs", "country-code", "The College of the Bahamas"],
    [".bt", "country-code", "Ministry of Information and Communications"],
    [".budapest", "generic", "Top Level Domain Holdings Limited"],
    [".bugatti", "generic", "Bugatti International SA"],
    [".build", "generic", "Plan Bee LLC"],
    [".builders", "generic", "Atomic Madison, LLC"],
    [".business", "generic", "Spring Cross, LLC"],
    [".buy", "generic", "Amazon Registry Services, INC"],
    [".buzz", "generic", "DOTSTRATEGY CO."],
    [".bv", "country-code", "UNINETT Norid A/S"],
    [".bw", "country-code", "Botswana Communications Regulatory Authority (BOCRA)"],
    [".by", "country-code", "Reliable Software, Ltd."],
    [".bz", "country-code", "University of Belize"],
    [".bzh", "generic", "Association www.bzh"],
    [".ca", "country-code", "Canadian Internet Registration Authority (CIRA) Autorité Canadienne pour les enregistrements Internet (ACEI)"],
    [".cab", "generic", "Half Sunset, LLC"],
    [".cafe", "generic", "Pioneer Canyon, LLC"],
    [".cal", "generic", "Charleston Road Registry Inc."],
    [".call", "generic", "Amazon Registry Services, Inc."],
    [".camera", "generic", "Atomic Maple, LLC"],
    [".camp", "generic", "Delta Dynamite, LLC"],
    [".cancerresearch", "generic", "Australian Cancer Research Foundation"],
    [".canon", "generic", "Canon Inc."],
    [".capetown", "generic", "ZA Central Registry NPC trading as ZA Central Registry"],
    [".capital", "generic", "Delta Mill, LLC"],
    [".car", "generic", "Cars Registry Limited"],
    [".caravan", "generic", "Caravan International, Inc."],
    [".cards", "generic", "Foggy Hollow, LLC"],
    [".care", "generic", "Goose Cross, LLC"],
    [".career", "generic", "dotCareer LLC"],
    [".careers", "generic", "Wild Corner, LLC"],
    [".cars", "generic", "Cars Registry Limited"],
    [".cartier", "generic", "Richemont DNS Inc."],
    [".casa", "generic", "Top Level Domain Holdings Limited"],
    [".cash", "generic", "Delta Lake, LLC"],
    [".casino", "generic", "Binky Sky, LLC"],
    [".cat", "sponsored", "Fundacio puntCAT"],
    [".catering", "generic", "New Falls. LLC"],
    [".cba", "generic", "COMMONWEALTH BANK OF AUSTRALIA"],
    [".cbn", "generic", "The Christian Broadcasting Network, Inc."],
    [".cc", "country-code", "eNIC Cocos (Keeling) Islands Pty. Ltd. d/b/a Island Internet Services"],
    [".cd", "country-code", "Office Congolais des Postes et Télécommunications - OCPT"],
    [".ceb", "generic", "The Corporate Executive Board Company"],
    [".center", "generic", "Tin Mill, LLC"],
    [".ceo", "generic", "CEOTLD Pty Ltd"],
    [".cern", "generic", "European Organization for Nuclear Research (CERN)"],
    [".cf", "country-code", "Societe Centrafricaine de Telecommunications (SOCATEL)"],
    [".cfa", "generic", "CFA Institute"],
    [".cfd", "generic", "DOTCFD REGISTRY LTD"],
    [".cg", "country-code", "ONPT Congo and Interpoint Switzerland"],
    [".ch", "country-code", "SWITCH The Swiss Education & Research Network"],
    [".chanel", "generic", "Chanel International B.V."],
    [".channel", "generic", "Charleston Road Registry Inc."],
    [".chase", "generic", "JPMorgan Chase & Co."],
    [".chat", "generic", "Sand Fields, LLC"],
    [".cheap", "generic", "Sand Cover, LLC"],
    [".chloe", "generic", "Richemont DNS Inc."],
    [".christmas", "generic", "Uniregistry, Corp."],
    [".chrome", "generic", "Charleston Road Registry Inc."],
    [".church", "generic", "Holly Fileds, LLC"],
    [".ci", "country-code", "INP-HB Institut National Polytechnique Felix Houphouet Boigny"],
    [".cipriani", "generic", "Hotel Cipriani Srl"],
    [".circle", "generic", "Amazon Registry Services, Inc."],
    [".cisco", "generic", "Cisco Technology, Inc."],
    [".citic", "generic", "CITIC Group Corporation"],
    [".city", "generic", "Snow Sky, LLC"],
    [".cityeats", "generic", "Lifestyle Domain Holdings, Inc."],
    [".ck", "country-code", "Telecom Cook Islands Ltd."],
    [".cl", "country-code", "NIC Chile (University of Chile)"],
    [".claims", "generic", "Black Corner, LLC"],
    [".cleaning", "generic", "Fox Shadow, LLC"],
    [".click", "generic", "Uniregistry, Corp."],
    [".clinic", "generic", "Goose Park, LLC"],
    [".clinique", "generic", "The Estée Lauder Companies Inc."],
    [".clothing", "generic", "Steel Lake, LLC"],
    [".cloud", "generic", "ARUBA PEC S.p.A."],
    [".club", "generic", ".CLUB DOMAINS, LLC"],
    [".clubmed", "generic", "Club Méditerranée S.A."],
    [".cm", "country-code", "Cameroon Telecommunications (CAMTEL)"],
    [".cn", "country-code", "China Internet Network Information Center (CNNIC)"],
    [".co", "country-code", ".CO Internet S.A.S."],
    [".coach", "generic", "Koko Island, LLC"],
    [".codes", "generic", "Puff Willow, LLC"],
    [".coffee", "generic", "Trixy Cover, LLC"],
    [".college", "generic", "XYZ.COM LLC"],
    [".cologne", "generic", "NetCologne Gesellschaft für Telekommunikation mbH"],
    [".com", "generic", "VeriSign Global Registry Services"],
    [".commbank", "generic", "COMMONWEALTH BANK OF AUSTRALIA"],
    [".community", "generic", "Fox Orchard, LLC"],
    [".company", "generic", "Silver Avenue, LLC"],
    [".compare", "generic", "iSelect Ltd"],
    [".computer", "generic", "Pine Mill, LLC"],
    [".comsec", "generic", "VeriSign, Inc."],
    [".condos", "generic", "Pine House, LLC"],
    [".construction", "generic", "Fox Dynamite, LLC"],
    [".consulting", "generic", "United TLD Holdco, LTD."],
    [".contact", "generic", "Top Level Spectrum, Inc."],
    [".contractors", "generic", "Magic Woods, LLC"],
    [".cooking", "generic", "Top Level Domain Holdings Limited"],
    [".cool", "generic", "Koko Lake, LLC"],
    [".coop", "sponsored", "DotCooperation LLC"],
    [".corsica", "generic", "Collectivité Territoriale de Corse"],
    [".country", "generic", "Top Level Domain Holdings Limited"],
    [".coupon", "generic", "Amazon Registry Services, Inc."],
    [".coupons", "generic", "Black Island, LLC"],
    [".courses", "generic", "OPEN UNIVERSITIES AUSTRALIA PTY LTD"],
    [".cr", "country-code", "National Academy of Sciences Academia Nacional de Ciencias"],
    [".credit", "generic", "Snow Shadow, LLC"],
    [".creditcard", "generic", "Binky Frostbite, LLC"],
    [".creditunion", "generic", "CUNA Performance Resources, LLC"],
    [".cricket", "generic", "dot Cricket Limited"],
    [".crown", "generic", "Crown Equipment Corporation"],
    [".crs", "generic", "Federated Co-operatives Limited"],
    [".cruises", "generic", "Spring Way, LLC"],
    [".csc", "generic", "Alliance-One Services, Inc."],
    [".cu", "country-code", "CENIAInternet Industria y San Jose Capitolio Nacional"],
    [".cuisinella", "generic", "SALM S.A.S."],
    [".cv", "country-code", "Agência Nacional das Comunicações (ANAC)"],
    [".cw", "country-code", "University of Curacao"],
    [".cx", "country-code", "Christmas Island Domain Administration Limited"],
    [".cy", "country-code", "University of Cyprus"],
    [".cymru", "generic", "Nominet UK"],
    [".cyou", "generic", "Beijing Gamease Age Digital Technology Co., Ltd."],
    [".cz", "country-code", "CZ.NIC, z.s.p.o"],
    [".dabur", "generic", "Dabur India Limited"],
    [".dad", "generic", "Charleston Road Registry Inc."],
    [".dance", "generic", "United TLD Holdco Ltd."],
    [".date", "generic", "dot Date Limited"],
    [".dating", "generic", "Pine Fest, LLC"],
    [".datsun", "generic", "NISSAN MOTOR CO., LTD."],
    [".day", "generic", "Charleston Road Registry Inc."],
    [".dclk", "generic", "Charleston Road Registry Inc."],
    [".dds", "generic", "Minds + Machines Group Limited"],
    [".de", "country-code", "DENIC eG"],
    [".dealer", "generic", "Dealer Dot Com, Inc."],
    [".deals", "generic", "Sand Sunset, LLC"],
    [".degree", "generic", "United TLD Holdco, Ltd"],
    [".delivery", "generic", "Steel Station, LLC"],
    [".dell", "generic", "Dell Inc."],
    [".deloitte", "generic", "Deloitte Touche Tohmatsu"],
    [".delta", "generic", "Delta Air Lines, Inc."],
    [".democrat", "generic", "United TLD Holdco Ltd."],
    [".dental", "generic", "Tin Birch, LLC"],
    [".dentist", "generic", "United TLD Holdco, Ltd"],
    [".desi", "generic", "Desi Networks LLC"],
    [".design", "generic", "Top Level Design, LLC"],
    [".dev", "generic", "Charleston Road Registry Inc."],
    [".diamonds", "generic", "John Edge, LLC"],
    [".diet", "generic", "Uniregistry, Corp."],
    [".digital", "generic", "Dash Park, LLC"],
    [".direct", "generic", "Half Trail, LLC"],
    [".directory", "generic", "Extra Madison, LLC"],
    [".discount", "generic", "Holly Hill, LLC"],
    [".dj", "country-code", "Djibouti Telecom S.A"],
    [".dk", "country-code", "Dansk Internet Forum"],
    [".dm", "country-code", "DotDM Corporation"],
    [".dnp", "generic", "Dai Nippon Printing Co., Ltd."],
    [".do", "country-code", "Pontificia Universidad Catolica Madre y Maestra Recinto Santo Tomas de Aquino"],
    [".docs", "generic", "Charleston Road Registry Inc."],
    [".dog", "generic", "Koko Mill, LLC"],
    [".doha", "generic", "Communications Regulatory Authority (CRA)"],
    [".domains", "generic", "Sugar Cross, LLC"],
    [".doosan", "generic", "Retired"],
    [".download", "generic", "dot Support Limited"],
    [".drive", "generic", "Charleston Road Registry Inc."],
    [".dubai", "generic", "Dubai Smart Government Department"],
    [".durban", "generic", "ZA Central Registry NPC trading as ZA Central Registry"],
    [".dvag", "generic", "Deutsche Vermögensberatung Aktiengesellschaft DVAG"],
    [".dz", "country-code", "CERIST"],
    [".earth", "generic", "Interlink Co., Ltd."],
    [".eat", "generic", "Charleston Road Registry Inc."],
    [".ec", "country-code", "NIC.EC (NICEC) S.A."],
    [".edeka", "generic", "EDEKA Verband kaufmännischer Genossenschaften e.V."],
    [".edu", "sponsored", "EDUCAUSE"],
    [".education", "generic", "Brice Way, LLC"],
    [".ee", "country-code", "Eesti Interneti Sihtasutus (EIS)"],
    [".eg", "country-code", "Egyptian Universities Network (EUN) Supreme Council of Universities"],
    [".eh", "country-code", "Not assigned"],
    [".email", "generic", "Spring Madison, LLC"],
    [".emerck", "generic", "Merck KGaA"],
    [".energy", "generic", "Binky Birch, LLC"],
    [".engineer", "generic", "United TLD Holdco Ltd."],
    [".engineering", "generic", "Romeo Canyon"],
    [".enterprises", "generic", "Snow Oaks, LLC"],
    [".epson", "generic", "Seiko Epson Corporation"],
    [".equipment", "generic", "Corn Station, LLC"],
    [".er", "country-code", "Eritrea Telecommunication Services Corporation (EriTel)"],
    [".erni", "generic", "ERNI Group Holding AG"],
    [".es", "country-code", "Red.es"],
    [".esq", "generic", "Charleston Road Registry Inc."],
    [".estate", "generic", "Trixy Park, LLC"],
    [".et", "country-code", "Ethio telecom"],
    [".eu", "country-code", "EURid vzw/asbl"],
    [".eurovision", "generic", "European Broadcasting Union (EBU)"],
    [".eus", "generic", "Puntueus Fundazioa"],
    [".events", "generic", "Pioneer Maple, LLC"],
    [".everbank", "generic", "EverBank"],
    [".exchange", "generic", "Spring Falls, LLC"],
    [".expert", "generic", "Magic Pass, LLC"],
    [".exposed", "generic", "Victor Beach, LLC"],
    [".express", "generic", "Sea Sunset, LLC"],
    [".extraspace", "generic", "Extra Space Storage LLC"],
    [".fage", "generic", "Fage International S.A."],
    [".fail", "generic", "Atomic Pipe, LLC"],
    [".fairwinds", "generic", "FairWinds Partners, LLC"],
    [".faith", "generic", "dot Faith Limited"],
    [".family", "generic", "United TLD Holdco Ltd."],
    [".fan", "generic", "Asiamix Digital Ltd"],
    [".fans", "generic", "Asiamix Digital Limited"],
    [".farm", "generic", "Just Maple, LLC"],
    [".fashion", "generic", "Top Level Domain Holdings Limited"],
    [".fast", "generic", "Amazon Registry Services, Inc."],
    [".feedback", "generic", "Top Level Spectrum, Inc."],
    [".ferrero", "generic", "Ferrero Trading Lux S.A."],
    [".fi", "country-code", "Finnish Communications Regulatory Authority"],
    [".film", "generic", "Motion Picture Domain Registry Pty Ltd"],
    [".final", "generic", "Núcleo de Informação e Coordenação do Ponto BR - NIC.br"],
    [".finance", "generic", "Cotton Cypress, LLC"],
    [".financial", "generic", "Just Cover, LLC"],
    [".firestone", "generic", "Bridgestone Corporation"],
    [".firmdale", "generic", "Firmdale Holdings Limited"],
    [".fish", "generic", "Fox Woods, LLC"],
    [".fishing", "generic", "Top Level Domain Holdings Limited"],
    [".fit", "generic", "Minds + Machines Group Limited"],
    [".fitness", "generic", "Brice Orchard, LLC"],
    [".fj", "country-code", "The University of the South Pacific IT Services"],
    [".fk", "country-code", "Falkland Islands Government"],
    [".flickr", "generic", "Yahoo! Domain Services Inc."],
    [".flights", "generic", "Fox Station, LLC"],
    [".flir", "generic", "FLIR Systems, Inc."],
    [".florist", "generic", "Half Cypress, LLC"],
    [".flowers", "generic", "Uniregistry, Corp."],
    [".flsmidth", "generic", "FLSmidth A/S"],
    [".fly", "generic", "Charleston Road Registry Inc."],
    [".fm", "country-code", "FSM Telecommunications Corporation"],
    [".fo", "country-code", "FO Council"],
    [".foo", "generic", "Charleston Road Registry Inc."],
    [".football", "generic", "Foggy Farms, LLC"],
    [".ford", "generic", "Ford Motor Company"],
    [".forex", "generic", "DOTFOREX REGISTRY LTD"],
    [".forsale", "generic", "United TLD Holdco, LLC"],
    [".forum", "generic", "Fegistry, LLC"],
    [".foundation", "generic", "John Dale, LLC"],
    [".fox", "generic", "FOX Registry, LLC"],
    [".fr", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".fresenius", "generic", "Fresenius Immobilien-Verwaltungs-GmbH"],
    [".frl", "generic", "FRLregistry B.V."],
    [".frogans", "generic", "OP3FT"],
    [".frontier", "generic", "Frontier Communications Corporation"],
    [".ftr", "generic", "Frontier Communications Corporation"],
    [".fund", "generic", "John Castle, LLC"],
    [".furniture", "generic", "Lone Fields, LLC"],
    [".futbol", "generic", "United TLD Holdco, Ltd."],
    [".fyi", "generic", "Silver Tigers, LLC"],
    [".ga", "country-code", "Agence Nationale des Infrastructures Numériques et des Fréquences (ANINF)"],
    [".gal", "generic", "Asociación puntoGAL"],
    [".gallery", "generic", "Sugar House, LLC"],
    [".gallo", "generic", "Gallo Vineyards, Inc."],
    [".gallup", "generic", "Gallup, Inc."],
    [".game", "generic", "Uniregistry, Corp."],
    [".garden", "generic", "Top Level Domain Holdings Limited"],
    [".gb", "country-code", "Reserved Domain - IANA"],
    [".gbiz", "generic", "Charleston Road Registry Inc."],
    [".gd", "country-code", "The National Telecommunications Regulatory Commission (NTRC)"],
    [".gdn", "generic", "Joint Stock Company - Navigation-information systems"],
    [".ge", "country-code", "Caucasus Online"],
    [".gea", "generic", "GEA Group Aktiengesellschaft"],
    [".gent", "generic", "Combell nv"],
    [".genting", "generic", "Resorts World Inc. Pte. Ltd."],
    [".gf", "country-code", "Net Plus"],
    [".gg", "country-code", "Island Networks Ltd."],
    [".ggee", "generic", "GMO Internet, Inc."],
    [".gh", "country-code", "Network Computer Systems Limited"],
    [".gi", "country-code", "Sapphire Networks"],
    [".gift", "generic", "Uniregistry, Corp."],
    [".gifts", "generic", "Goose Sky, LLC"],
    [".gives", "generic", "United TLD Holdco Ltd."],
    [".giving", "generic", "Giving Limited"],
    [".gl", "country-code", "TELE Greenland A/S"],
    [".glass", "generic", "Black Cover, LLC"],
    [".gle", "generic", "Charleston Road Registry Inc."],
    [".global", "generic", "Dot Global Domain Registry Limited"],
    [".globo", "generic", "Globo Comunicação e Participações S.A"],
    [".gm", "country-code", "GM-NIC"],
    [".gmail", "generic", "Charleston Road Registry Inc."],
    [".gmbh", "generic", "Extra Dynamite, LLC"],
    [".gmo", "generic", "GMO Internet, Inc."],
    [".gmx", "generic", "1&1 Mail & Media GmbH"],
    [".gn", "country-code", "Centre National des Sciences Halieutiques de Boussoura"],
    [".gold", "generic", "June Edge, LLC"],
    [".goldpoint", "generic", "YODOBASHI CAMERA CO.", "LTD."],
    [".golf", "generic", "Lone Falls, LLC"],
    [".goo", "generic", "NTT Resonant Inc."],
    [".goog", "generic", "Charleston Road Registry Inc."],
    [".google", "generic", "Charleston Road Registry Inc."],
    [".gop", "generic", "Republican State Leadership Committee, Inc."],
    [".got", "generic", "Amazon Registry Services, Inc."],
    [".gov", "sponsored", "General Services Administration Attn: QTDC, 2E08 (.gov Domain Registration)"],
    [".gp", "country-code", "Networking Technologies Group"],
    [".gq", "country-code", "GETESA"],
    [".gr", "country-code", "ICS-FORTH GR"],
    [".grainger", "generic", "Grainger Registry Services, LLC"],
    [".graphics", "generic", "Over Madison, LLC"],
    [".gratis", "generic", "Pioneer Tigers, LLC"],
    [".green", "generic", "Afilias Limited"],
    [".gripe", "generic", "Corn Sunset, LLC"],
    [".group", "generic", "Romeo Town, LLC"],
    [".gs", "country-code", "Government of South Georgia and South Sandwich Islands (GSGSSI)"],
    [".gt", "country-code", "Universidad del Valle de Guatemala"],
    [".gu", "country-code", "University of Guam Computer Center"],
    [".gucci", "generic", "Guccio Gucci S.p.a."],
    [".guge", "generic", "Charleston Road Registry Inc."],
    [".guide", "generic", "Snow Moon, LLC"],
    [".guitars", "generic", "Uniregistry, Corp."],
    [".guru", "generic", "Pioneer Cypress, LLC"],
    [".gw", "country-code", "Autoridade Reguladora Nacional - Tecnologias de Informação e Comunicação da Guiné-Bissau"],
    [".gy", "country-code", "University of Guyana"],
    [".hamburg", "generic", "Hamburg Top-Level-Domain GmbH"],
    [".hangout", "generic", "Charleston Road Registry Inc."],
    [".haus", "generic", "United TLD Holdco, LTD."],
    [".hdfcbank", "generic", "HDFC Bank Limited"],
    [".health", "generic", "DotHealth, LLC"],
    [".healthcare", "generic", "Silver Glen, LLC"],
    [".help", "generic", "Uniregistry, Corp."],
    [".helsinki", "generic", "City of Helsinki"],
    [".here", "generic", "Charleston Road Registry Inc."],
    [".hermes", "generic", "Hermes International"],
    [".hiphop", "generic", "Uniregistry, Corp."],
    [".hitachi", "generic", "Hitachi, Ltd."],
    [".hiv", "generic", "Uniregistry, Corp."],
    [".hk", "country-code", "Hong Kong Internet Registration Corporation Ltd."],
    [".hkt", "generic", "PCCW-HKT DataCom Services Limited"],
    [".hm", "country-code", "HM Domain Registry"],
    [".hn", "country-code", "Red de Desarrollo Sostenible Honduras"],
    [".hockey", "generic", "Half Willow, LLC"],
    [".holdings", "generic", "John Madison, LLC"],
    [".holiday", "generic", "Goose Woods, LLC"],
    [".homedepot", "generic", "Homer TLC, Inc."],
    [".homes", "generic", "DERHomes, LLC"],
    [".honda", "generic", "Honda Motor Co., Ltd."],
    [".horse", "generic", "Top Level Domain Holdings Limited"],
    [".host", "generic", "DotHost Inc."],
    [".hosting", "generic", "Uniregistry, Corp."],
    [".hoteles", "generic", "Travel Reservations SRL"],
    [".hotmail", "generic", "Microsoft Corporation"],
    [".house", "generic", "Sugar Park, LLC"],
    [".how", "generic", "Charleston Road Registry Inc."],
    [".hr", "country-code", "CARNet - Croatian Academic and Research Network"],
    [".hsbc", "generic", "HSBC Holdings PLC"],
    [".ht", "country-code", "Consortium FDS/RDDH"],
    [".htc", "generic", "HTC corporation"],
    [".hu", "country-code", "Council of Hungarian Internet Providers (CHIP)"],
    [".hyundai", "generic", "Hyundai Motor Company"],
    [".ibm", "generic", "International Business Machines Corporation"],
    [".icbc", "generic", "Industrial and Commercial Bank of China Limited"],
    [".ice", "generic", "IntercontinentalExchange, Inc."],
    [".icu", "generic", "One.com A/S"],
    [".id", "country-code", "Perkumpulan Pengelola Nama Domain Internet Indonesia (PANDI)"],
    [".ie", "country-code", "University College Dublin Computing Services Computer Centre"],
    [".ifm", "generic", "ifm electronic gmbh"],
    [".iinet", "generic", "Connect West Pty. Ltd."],
    [".il", "country-code", "Internet Society of Israel"],
    [".im", "country-code", "Isle of Man Government"],
    [".imamat", "generic", "Fondation Aga Khan (Aga Khan Foundation)"],
    [".immo", "generic", "Auburn Bloom, LLC"],
    [".immobilien", "generic", "United TLD Holdco Ltd."],
    [".in", "country-code", "National Internet Exchange of India"],
    [".industries", "generic", "Outer House, LLC"],
    [".infiniti", "generic", "NISSAN MOTOR CO., LTD."],
    [".info", "generic", "Afilias Limited"],
    [".ing", "generic", "Charleston Road Registry Inc."],
    [".ink", "generic", "Top Level Design, LLC"],
    [".institute", "generic", "Outer Maple, LLC"],
    [".insurance", "generic", "fTLD Registry Services LLC"],
    [".insure", "generic", "Pioneer Willow, LLC"],
    [".int", "sponsored", "Internet Assigned Numbers Authority"],
    [".international", "generic", "Wild Way, LLC"],
    [".investments", "generic", "Holly Glen, LLC"],
    [".io", "country-code", "IO Top Level Domain Registry Cable and Wireless"],
    [".ipiranga", "generic", "Ipiranga Produtos de Petroleo S.A."],
    [".iq", "country-code", "Communications and Media Commission (CMC)"],
    [".ir", "country-code", "Institute for Research in Fundamental Sciences"],
    [".irish", "generic", "Dot-Irish LLC"],
    [".is", "country-code", "ISNIC - Internet Iceland ltd."],
    [".iselect", "generic", "iSelect Ltd"],
    [".ismaili", "generic", "Fondation Aga Khan (Aga Khan Foundation)"],
    [".ist", "generic", "Istanbul Metropolitan Municipality"],
    [".istanbul", "generic", "Istanbul Metropolitan Municipality"],
    [".it", "country-code", "IIT - CNR"],
    [".itau", "generic", "Itau Unibanco Holding S.A."],
    [".iwc", "generic", "Richemont DNS Inc."],
    [".jaguar", "generic", "Jaguar Land Rover Ltd"],
    [".java", "generic", "Oracle Corporation"],
    [".jcb", "generic", "JCB Co., Ltd."],
    [".jcp", "generic", "JCP Media, Inc."],
    [".je", "country-code", "Island Networks (Jersey) Ltd."],
    [".jetzt", "generic", "New TLD Company AB"],
    [".jewelry", "generic", "Wild Bloom, LLC"],
    [".jlc", "generic", "Richemont DNS Inc."],
    [".jll", "generic", "Jones Lang LaSalle Incorporated"],
    [".jm", "country-code", "University of West Indies"],
    [".jmp", "generic", "Matrix IP LLC"],
    [".jnj", "generic", "Johnson & Johnson Services, Inc."],
    [".jo", "country-code", "National Information Technology Center (NITC)"],
    [".jobs", "sponsored", "Employ Media LLC"],
    [".joburg", "generic", "ZA Central Registry NPC trading as ZA Central Registry"],
    [".jot", "generic", "Amazon Registry Services, Inc."],
    [".joy", "generic", "Amazon Registry Services, Inc."],
    [".jp", "country-code", "Japan Registry Services Co., Ltd."],
    [".jpmorgan", "generic", "JPMorgan Chase & Co."],
    [".jprs", "generic", "Japan Registry Services Co., Ltd."],
    [".juegos", "generic", "Uniregistry, Corp."],
    [".kaufen", "generic", "United TLD Holdco Ltd."],
    [".kddi", "generic", "KDDI CORPORATION"],
    [".ke", "country-code", "Kenya Network Information Center (KeNIC)"],
    [".kerryhotels", "generic", "Kerry Trading Co. Limited"],
    [".kerrylogistics", "generic", "Kerry Trading Co. Limited"],
    [".kerryproperties", "generic", "Kerry Trading Co. Limited"],
    [".kfh", "generic", "Kuwait Finance House"],
    [".kg", "country-code", "AsiaInfo Telecommunication Enterprise"],
    [".kh", "country-code", "Telecommunication Regulator of Cambodia (TRC)"],
    [".ki", "country-code", "Ministry of Communications", " Transport, and Tourism Development"],
    [".kia", "generic", "KIA MOTORS CORPORATION"],
    [".kim", "generic", "Afilias Limited"],
    [".kinder", "generic", "Ferrero Trading Lux S.A."],
    [".kitchen", "generic", "Just Goodbye, LLC"],
    [".kiwi", "generic", "DOT KIWI LIMITED"],
    [".km", "country-code", "Comores Telecom"],
    [".kn", "country-code", "Ministry of Finance, Sustainable Development Information & Technology"],
    [".koeln", "generic", "NetCologne Gesellschaft für Telekommunikation mbH"],
    [".komatsu", "generic", "Komatsu Ltd."],
    [".kp", "country-code", "Star Joint Venture Company"],
    [".kpmg", "generic", "KPMG International Cooperative (KPMG International Genossenschaft)"],
    [".kpn", "generic", "Koninklijke KPN N.V."],
    [".kr", "country-code", "Korea Internet & Security Agency (KISA)"],
    [".krd", "generic", "KRG Department of Information Technology"],
    [".kred", "generic", "KredTLD Pty Ltd"],
    [".kuokgroup", "generic", "Kerry Trading Co. Limited"],
    [".kw", "country-code", "Ministry of Communications"],
    [".ky", "country-code", "The Information and Communications Technology Authority"],
    [".kyoto", "generic", "Academic Institution: Kyoto Jyoho Gakuen"],
    [".kz", "country-code", "Association of IT Companies of Kazakhstan"],
    [".la", "country-code", "Lao National Internet Committee (LANIC), Ministry of Posts and Telecommunications"],
    [".lacaixa", "generic", "CAIXA D'ESTALVIS I PENSIONS DE BARCELONA"],
    [".lamborghini", "generic", "Automobili Lamborghini S.p.A."],
    [".lamer", "generic", "The Estée Lauder Companies Inc."],
    [".lancaster", "generic", "LANCASTER"],
    [".land", "generic", "Pine Moon, LLC"],
    [".landrover", "generic", "Jaguar Land Rover Ltd"],
    [".lanxess", "generic", "LANXESS Corporation"],
    [".lasalle", "generic", "Jones Lang LaSalle Incorporated"],
    [".lat", "generic", "ECOM-LAC Federación de Latinoamérica y el Caribe para Internet y el Comercio Electrónico"],
    [".latrobe", "generic", "La Trobe University"],
    [".law", "generic", "Minds + Machines Group Limited"],
    [".lawyer", "generic", "United TLD Holdco, Ltd"],
    [".lb", "country-code", "American University of Beirut Computing and Networking Services"],
    [".lc", "country-code", "University of Puerto Rico"],
    [".lds", "generic", "IRI Domain Management, LLC"],
    [".lease", "generic", "Victor Trail, LLC"],
    [".leclerc", "generic", "A.C.D. LEC Association des Centres Distributeurs Edouard Leclerc"],
    [".legal", "generic", "Blue Falls, LLC"],
    [".lexus", "generic", "TOYOTA MOTOR CORPORATION"],
    [".lgbt", "generic", "Afilias Limited"],
    [".li", "country-code", "Universitaet Liechtenstein"],
    [".liaison", "generic", "Liaison Technologies, Incorporated"],
    [".lidl", "generic", "Schwarz Domains und Services GmbH & Co. KG"],
    [".life", "generic", "Trixy Oaks, LLC"],
    [".lifeinsurance", "generic", "American Council of Life Insurers"],
    [".lifestyle", "generic", "Lifestyle Domain Holdings, Inc."],
    [".lighting", "generic", "John McCook, LLC"],
    [".like", "generic", "Amazon Registry Services, Inc."],
    [".limited", "generic", "Big Fest, LLC"],
    [".limo", "generic", "Hidden Frostbite, LLC"],
    [".lincoln", "generic", "Ford Motor Company"],
    [".linde", "generic", "Linde Aktiengesellschaft"],
    [".link", "generic", "Uniregistry, Corp."],
    [".lipsy", "generic", "Lipsy Ltd"],
    [".live", "generic", "United TLD Holdco Ltd."],
    [".living", "generic", "Lifestyle Domain Holdings, Inc."],
    [".lixil", "generic", "LIXIL Group Corporation"],
    [".lk", "country-code", "Council for Information Technology LK Domain Registrar"],
    [".loan", "generic", "dot Loan Limited"],
    [".loans", "generic", "June Woods, LLC"],
    [".locus", "generic", "Locus Analytics LLC"],
    [".lol", "generic", "Uniregistry, Corp."],
    [".london", "generic", "Dot London Domains Limited"],
    [".lotte", "generic", "Lotte Holdings Co., Ltd."],
    [".lotto", "generic", "Afilias Limited"],
    [".love", "generic", "Merchant Law Group LLP"],
    [".lr", "country-code", "Data Technology Solutions, Inc."],
    [".ls", "country-code", "National University of Lesotho"],
    [".lt", "country-code", "Kaunas University of Technology"],
    [".ltd", "generic", "Over Corner, LLC"],
    [".ltda", "generic", "InterNetX Corp."],
    [".lu", "country-code", "RESTENA"],
    [".lupin", "generic", "LUPIN LIMITED"],
    [".luxe", "generic", "Top Level Domain Holdings Limited"],
    [".luxury", "generic", "Luxury Partners LLC"],
    [".lv", "country-code", "University of Latvia Institute of Mathematics and Computer Science Department of Network Solutions (DNS)"],
    [".ly", "country-code", "General Post and Telecommunication Company"],
    [".ma", "country-code", "Agence Nationale de Réglementation des Télécommunications (ANRT)"],
    [".madrid", "generic", "Comunidad de Madrid"],
    [".maif", "generic", "Mutuelle Assurance Instituteur France (MAIF)"],
    [".maison", "generic", "Victor Frostbite, LLC"],
    [".makeup", "generic", "L'Oréal"],
    [".man", "generic", "MAN SE"],
    [".management", "generic", "John Goodbye, LLC"],
    [".mango", "generic", "PUNTO FA S.L."],
    [".market", "generic", "United TLD Holdco, Ltd"],
    [".marketing", "generic", "Fern Pass, LLC"],
    [".markets", "generic", "DOTMARKETS REGISTRY LTD"],
    [".marriott", "generic", "Marriott Worldwide Corporation"],
    [".mba", "generic", "Lone Hollow, LLC"],
    [".mc", "country-code", "Gouvernement de Monaco Direction des Communications Electroniques"],
    [".md", "country-code", "MoldData S.E."],
    [".me", "country-code", "Government of Montenegro"],
    [".med", "generic", "Medistry LLC"],
    [".media", "generic", "Grand Glen, LLC"],
    [".meet", "generic", "Afilias Limited"],
    [".melbourne", "generic", "The Crown in right of the State of Victoria",
     " represented by its Department of State Development, Business and Innovation"],
    [".meme", "generic", "Charleston Road Registry Inc."],
    [".memorial", "generic", "Dog Beach, LLC"],
    [".men", "generic", "Exclusive Registry Limited"],
    [".menu", "generic", "Wedding TLD2, LLC"],
    [".meo", "generic", "PT Comunicacoes S.A."],
    [".metlife", "generic", "MetLife Services and Solutions, LLC"],
    [".mf", "country-code", "Not assigned"],
    [".mg", "country-code", "NIC-MG (Network Information Center Madagascar)"],
    [".mh", "country-code", "Office of the Cabinet"],
    [".miami", "generic", "Top Level Domain Holdings Limited"],
    [".microsoft", "generic", "Microsoft Corporation"],
    [".mil", "sponsored", "DoD Network Information Center"],
    [".mini", "generic", "Bayerische Motoren Werke Aktiengesellschaft"],
    [".mk", "country-code", "Macedonian Academic Research Network Skopje"],
    [".ml", "country-code", "Agence des Technologies de l’Information et de la Communication"],
    [".mls", "generic", "The Canadian Real Estate Association"],
    [".mm", "country-code", "Ministry of Communications, Posts & Telegraphs"],
    [".mma", "generic", "MMA IARD"],
    [".mn", "country-code", "Datacom Co., Ltd."],
    [".mo", "country-code", "Bureau of Telecommunications Regulation (DSRT)"],
    [".mobi", "sponsored", "Afilias Technologies Limited dba dotMobi"],
    [".mobily", "generic", "GreenTech Consultancy Company W.L.L."],
    [".moda", "generic", "United TLD Holdco Ltd."],
    [".moe", "generic", "Interlink Co., Ltd."],
    [".moi", "generic", "Amazon Registry Services, Inc."],
    [".mom", "generic", "Uniregistry, Corp."],
    [".monash", "generic", "Monash University"],
    [".money", "generic", "Outer McCook, LLC"],
    [".montblanc", "generic", "Richemont DNS Inc."],
    [".mormon", "generic", "IRI Domain Management", " LLC (Applicant)"],
    [".mortgage", "generic", "United TLD Holdco, Ltd"],
    [".moscow", "generic", "Foundation for Assistance for Internet Technologies and Infrastructure Development (FAITID)"],
    [".motorcycles", "generic", "DERMotorcycles, LLC"],
    [".mov", "generic", "Charleston Road Registry Inc."],
    [".movie", "generic", "New Frostbite, LLC"],
    [".movistar", "generic", "Telefónica S.A."],
    [".mp", "country-code", "Saipan Datacom, Inc."],
    [".mq", "country-code", "MEDIASERV"],
    [".mr", "country-code", "Université des Sciences, de Technologie et de Médecine"],
    [".ms", "country-code", "MNI Networks Ltd."],
    [".mt", "country-code", "NIC (Malta)"],
    [".mtn", "generic", "MTN Dubai Limited"],
    [".mtpc", "generic", "Mitsubishi Tanabe Pharma Corporation"],
    [".mtr", "generic", "MTR Corporation Limited"],
    [".mu", "country-code", "Internet Direct Ltd"],
    [".museum", "sponsored", "Museum Domain Management Association"],
    [".mutual", "generic", "Northwestern Mutual MU TLD Registry, LLC"],
    [".mutuelle", "generic", "Fédération Nationale de la Mutualité Française"],
    [".mv", "country-code", "Dhiraagu Pvt. Ltd. (DHIVEHINET)"],
    [".mw", "country-code", "Malawi Sustainable Development Network Programme (Malawi SDNP)"],
    [".mx", "country-code", "NIC-Mexico ITESM - Campus Monterrey"],
    [".my", "country-code", "MYNIC Berhad"],
    [".mz", "country-code", "Centro de Informatica de Universidade Eduardo Mondlane"],
    [".na", "country-code", "Namibian Network Information Center"],
    [".nadex", "generic", "Nadex Domains, Inc"],
    [".nagoya", "generic", "GMO Registry, Inc."],
    [".name", "generic-restricted", "VeriSign Information Services, Inc."],
    [".natura", "generic", "NATURA COSMÉTICOS S.A."],
    [".navy", "generic", "United TLD Holdco Ltd."],
    [".nc", "country-code", "Office des Postes et Telecommunications"],
    [".ne", "country-code", "SONITEL"],
    [".nec", "generic", "NEC Corporation"],
    [".net", "generic", "VeriSign Global Registry Services"],
    [".netbank", "generic", "COMMONWEALTH BANK OF AUSTRALIA"],
    [".network", "generic", "Trixy Manor, LLC"],
    [".neustar", "generic", "NeuStar, Inc."],
    [".new", "generic", "Charleston Road Registry Inc."],
    [".news", "generic", "United TLD Holdco Ltd."],
    [".next", "generic", "Next plc"],
    [".nextdirect", "generic", "Next plc"],
    [".nexus", "generic", "Charleston Road Registry Inc."],
    [".nf", "country-code", "Norfolk Island Data Services"],
    [".ng", "country-code", "Nigeria Internet Registration Association"],
    [".ngo", "generic", "Public Interest Registry"],
    [".nhk", "generic", "Japan Broadcasting Corporation (NHK)"],
    [".ni", "country-code", "Universidad Nacional del Ingernieria Centro de Computo"],
    [".nico", "generic", "DWANGO Co., Ltd."],
    [".nikon", "generic", "NIKON CORPORATION"],
    [".ninja", "generic", "United TLD Holdco Ltd."],
    [".nissan", "generic", "NISSAN MOTOR CO., LTD."],
    [".nissay", "generic", "Nippon Life Insurance Company"],
    [".nl", "country-code", "SIDN (Stichting Internet Domeinregistratie Nederland)"],
    [".no", "country-code", "UNINETT Norid A/S"],
    [".nokia", "generic", "Nokia Corporation"],
    [".northwesternmutual", "generic", "Northwestern Mutual Registry, LLC"],
    [".norton", "generic", "Symantec Corporation"],
    [".nowruz", "generic", "Asia Green IT System Bilgisayar San. ve Tic. Ltd. Sti."],
    [".nowtv", "generic", "Starbucks (HK) Limited"],
    [".np", "country-code", "Mercantile Communications Pvt. Ltd."],
    [".nr", "country-code", "CENPAC NET"],
    [".nra", "generic", "NRA Holdings Company, INC."],
    [".nrw", "generic", "Minds + Machines GmbH"],
    [".ntt", "generic", "NIPPON TELEGRAPH AND TELEPHONE CORPORATION"],
    [".nu", "country-code", "The IUSN Foundation"],
    [".nyc", "generic", "The City of New York by and through the New York City Department of Information Technology & Telecommunications"],
    [".nz", "country-code", "InternetNZ"],
    [".obi", "generic", "OBI Group Holding SE & Co. KGaA"],
    [".office", "generic", "Microsoft Corporation"],
    [".okinawa", "generic", "BusinessRalliart inc."],
    [".olayan", "generic", "Crescent Holding GmbH"],
    [".olayangroup", "generic", "Crescent Holding GmbH"],
    [".om", "country-code", "Telecommunications Regulatory Authority (TRA)"],
    [".omega", "generic", "The Swatch Group Ltd"],
    [".one", "generic", "One.com A/S"],
    [".ong", "generic", "Public Interest Registry"],
    [".onl", "generic", "I-REGISTRY Ltd., Niederlassung Deutschland"],
    [".online", "generic", "DotOnline Inc."],
    [".ooo", "generic", "INFIBEAM INCORPORATION LIMITED"],
    [".oracle", "generic", "Oracle Corporation"],
    [".orange", "generic", "Orange Brand Services Limited"],
    [".org", "generic", "Public Interest Registry (PIR)"],
    [".organic", "generic", "Afilias Limited"],
    [".origins", "generic", "The Estée Lauder Companies Inc."],
    [".osaka", "generic", "Interlink Co., Ltd."],
    [".otsuka", "generic", "Otsuka Holdings Co., Ltd."],
    [".ovh", "generic", "OVH SAS"],
    [".pa", "country-code", "Universidad Tecnologica de Panama"],
    [".page", "generic", "Charleston Road Registry Inc."],
    [".pamperedchef", "generic", "The Pampered Chef, Ltd."],
    [".panerai", "generic", "Richemont DNS Inc."],
    [".paris", "generic", "City of Paris"],
    [".pars", "generic", "Asia Green IT System Bilgisayar San. ve Tic. Ltd. Sti."],
    [".partners", "generic", "Magic Glen, LLC"],
    [".parts", "generic", "Sea Goodbye, LLC"],
    [".party", "generic", "Blue Sky Registry Limited"],
    [".passagens", "generic", "Travel Reservations SRL"],
    [".pe", "country-code", "Red Cientifica Peruana"],
    [".pet", "generic", "Afilias plc"],
    [".pf", "country-code", "Gouvernement de la Polynésie française"],
    [".pg", "country-code", "PNG DNS Administration Vice Chancellors Office The Papua New Guinea University of Technology"],
    [".ph", "country-code", "PH Domain Foundation"],
    [".pharmacy", "generic", "National Association of Boards of Pharmacy"],
    [".philips", "generic", "Koninklijke Philips N.V."],
    [".photo", "generic", "Uniregistry, Corp."],
    [".photography", "generic", "Sugar Glen, LLC"],
    [".photos", "generic", "Sea Corner, LLC"],
    [".physio", "generic", "PhysBiz Pty Ltd"],
    [".piaget", "generic", "Richemont DNS Inc."],
    [".pics", "generic", "Uniregistry, Corp."],
    [".pictet", "generic", "Pictet Europe S.A."],
    [".pictures", "generic", "Foggy Sky, LLC"],
    [".pid", "generic", "Top Level Spectrum, Inc."],
    [".pin", "generic", "Amazon Registry Services, Inc."],
    [".ping", "generic", "Ping Registry Provider, Inc."],
    [".pink", "generic", "Afilias Limited"],
    [".pizza", "generic", "Foggy Moon, LLC"],
    [".pk", "country-code", "PKNIC"],
    [".pl", "country-code", "Research and Academic Computer Network"],
    [".place", "generic", "Snow Galley, LLC"],
    [".play", "generic", "Charleston Road Registry Inc."],
    [".playstation", "generic", "Sony Computer Entertainment Inc."],
    [".plumbing", "generic", "Spring Tigers, LLC"],
    [".plus", "generic", "Sugar Mill, LLC"],
    [".pm", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".pn", "country-code", "Pitcairn Island Administration"],
    [".pohl", "generic", "Deutsche Vermögensberatung Aktiengesellschaft DVAG"],
    [".poker", "generic", "Afilias Domains No. 5 Limited"],
    [".porn", "generic", "ICM Registry PN LLC"],
    [".post", "sponsored", "Universal Postal Union"],
    [".pr", "country-code", "Gauss Research Laboratory Inc."],
    [".praxi", "generic", "Praxi S.p.A."],
    [".press", "generic", "DotPress Inc."],
    [".pro", "generic-restricted", "Registry Services Corporation dba RegistryPro"],
    [".prod", "generic", "Charleston Road Registry Inc."],
    [".productions", "generic", "Magic Birch, LLC"],
    [".prof", "generic", "Charleston Road Registry Inc."],
    [".progressive", "generic", "Progressive Casualty Insurance Company"],
    [".promo", "generic", "Afilias plc"],
    [".properties", "generic", "Big Pass, LLC"],
    [".property", "generic", "Uniregistry, Corp."],
    [".protection", "generic", "XYZ.COM LLC"],
    [".ps", "country-code", "Ministry Of Telecommunications & Information Technology, Government Computer Center."],
    [".pt", "country-code", "Associação DNS.PT"],
    [".pub", "generic", "United TLD Holdco Ltd."],
    [".pw", "country-code", "Micronesia Investment and Development Corporation"],
    [".pwc", "generic", "PricewaterhouseCoopers LLP"],
    [".py", "country-code", "NIC-PY"],
    [".qa", "country-code", "Communications Regulatory Authority"],
    [".qpon", "generic", "dotCOOL, Inc."],
    [".quebec", "generic", "PointQuébec Inc"],
    [".quest", "generic", "Quest ION Limited"],
    [".racing", "generic", "Premier Registry Limited"],
    [".re", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".read", "generic", "Amazon Registry Services, Inc."],
    [".realtor", "generic", "Real Estate Domains LLC"],
    [".realty", "generic", "Fegistry, LLC"],
    [".recipes", "generic", "Grand Island, LLC"],
    [".red", "generic", "Afilias Limited"],
    [".redstone", "generic", "Redstone Haute Couture Co., Ltd."],
    [".redumbrella", "generic", "Travelers TLD, LLC"],
    [".rehab", "generic", "United TLD Holdco Ltd."],
    [".reise", "generic", "Foggy Way, LLC"],
    [".reisen", "generic", "New Cypress, LLC"],
    [".reit", "generic", "National Association of Real Estate Investment Trusts, Inc."],
    [".ren", "generic", "Beijing Qianxiang Wangjing Technology Development Co., Ltd."],
    [".rent", "generic", "XYZ.COM LLC"],
    [".rentals", "generic", "Big Hollow", "LLC"],
    [".repair", "generic", "Lone Sunset, LLC"],
    [".report", "generic", "Binky Glen, LLC"],
    [".republican", "generic", "United TLD Holdco Ltd."],
    [".rest", "generic", "Punto 2012 Sociedad Anonima Promotora de Inversion de Capital Variable"],
    [".restaurant", "generic", "Snow Avenue, LLC"],
    [".review", "generic", "dot Review Limited"],
    [".reviews", "generic", "United TLD Holdco, Ltd."],
    [".rexroth", "generic", "Robert Bosch GMBH"],
    [".rich", "generic", "I-REGISTRY Ltd., Niederlassung Deutschland"],
    [".ricoh", "generic", "Ricoh Company, Ltd."],
    [".rio", "generic", "Empresa Municipal de Informática SA - IPLANRIO"],
    [".rip", "generic", "United TLD Holdco Ltd."],
    [".ro", "country-code", "National Institute for R&D in Informatics"],
    [".rocher", "generic", "Ferrero Trading Lux S.A."],
    [".rocks", "generic", "United TLD Holdco, LTD."],
    [".rodeo", "generic", "Top Level Domain Holdings Limited"],
    [".room", "generic", "Amazon Registry Services, Inc."],
    [".rs", "country-code", "Serbian National Internet Domain Registry (RNIDS)"],
    [".rsvp", "generic", "Charleston Road Registry Inc."],
    [".ru", "country-code", "Coordination Center for TLD RU"],
    [".ruhr", "generic", "regiodot GmbH & Co. KG"],
    [".run", "generic", "Snow Park, LLC"],
    [".rw", "country-code", "Rwanda Information Communication and Technology Association (RICTA)"],
    [".rwe", "generic", "RWE AG"],
    [".ryukyu", "generic", "BusinessRalliart inc."],
    [".sa", "country-code", "Communications and Information Technology Commission"],
    [".saarland", "generic", "dotSaarland GmbH"],
    [".safe", "generic", "Amazon Registry Services, Inc."],
    [".safety", "generic", "Safety Registry Services, LLC."],
    [".sakura", "generic", "SAKURA Internet Inc."],
    [".sale", "generic", "United TLD Holdco, Ltd"],
    [".salon", "generic", "Outer Orchard, LLC"],
    [".samsung", "generic", "SAMSUNG SDS CO., LTD"],
    [".sandvik", "generic", "Sandvik AB"],
    [".sandvikcoromant", "generic", "Sandvik AB"],
    [".sanofi", "generic", "Sanofi"],
    [".sap", "generic", "SAP AG"],
    [".sapo", "generic", "PT Comunicacoes S.A."],
    [".sarl", "generic", "Delta Orchard, LLC"],
    [".sas", "generic", "Research IP LLC"],
    [".saxo", "generic", "Saxo Bank A/S"],
    [".sb", "country-code", "Solomon Telekom Company Limited"],
    [".sbi", "generic", "STATE BANK OF INDIA"],
    [".sbs", "generic", "SPECIAL BROADCASTING SERVICE CORPORATION"],
    [".sc", "country-code", "VCS Pty Ltd"],
    [".sca", "generic", "SVENSKA CELLULOSA AKTIEBOLAGET SCA (publ)"],
    [".scb", "generic", "The Siam Commercial Bank Public Company Limited (SCB)"],
    [".schaeffler", "generic", "Schaeffler Technologies AG & Co. KG"],
    [".schmidt", "generic", "SALM S.A.S."],
    [".scholarships", "generic", "Scholarships.com, LLC"],
    [".school", "generic", "Little Galley, LLC"],
    [".schule", "generic", "Outer Moon, LLC"],
    [".schwarz", "generic", "Schwarz Domains und Services GmbH & Co. KG"],
    [".science", "generic", "dot Science Limited"],
    [".scor", "generic", "SCOR SE"],
    [".scot", "generic", "Dot Scot Registry Limited"],
    [".sd", "country-code", "Sudan Internet Society"],
    [".se", "country-code", "The Internet Infrastructure Foundation"],
    [".seat", "generic", "SEAT, S.A. (Sociedad Unipersonal)"],
    [".security", "generic", "XYZ.COM LLC"],
    [".seek", "generic", "Seek Limited"],
    [".select", "generic", "iSelect Ltd"],
    [".sener", "generic", "Sener Ingeniería y Sistemas, S.A."],
    [".services", "generic", "Fox Castle, LLC"],
    [".seven", "generic", "Seven West Media Ltd"],
    [".sew", "generic", "SEW-EURODRIVE GmbH & Co KG"],
    [".sex", "generic", "ICM Registry SX LLC"],
    [".sexy", "generic", "Uniregistry, Corp."],
    [".sfr", "generic", "Societe Francaise du Radiotelephone - SFR"],
    [".sg", "country-code", "Singapore Network Information Centre (SGNIC) Pte Ltd"],
    [".sh", "country-code", "Government of St. Helena"],
    [".sharp", "generic", "Sharp Corporation"],
    [".shaw", "generic", "Shaw Cablesystems G.P."],
    [".shell", "generic", "Shell Information Technology International Inc"],
    [".shia", "generic", "Asia Green IT System Bilgisayar San. ve Tic. Ltd. Sti."],
    [".shiksha", "generic", "Afilias Limited"],
    [".shoes", "generic", "Binky Galley, LLC"],
    [".shouji", "generic", "QIHOO 360 TECHNOLOGY CO. LTD."],
    [".show", "generic", "Snow Beach, LLC"],
    [".shriram", "generic", "Shriram Capital Ltd."],
    [".si", "country-code", "Academic and Research Network of Slovenia (ARNES)"],
    [".sina", "generic", "Sina Corporation"],
    [".singles", "generic", "Fern Madison, LLC"],
    [".site", "generic", "DotSite Inc."],
    [".sj", "country-code", "UNINETT Norid A/S"],
    [".sk", "country-code", "SK-NIC, a.s."],
    [".ski", "generic", "STARTING DOT LIMITED"],
    [".skin", "generic", "L'Oréal"],
    [".sky", "generic", "Sky International AG"],
    [".skype", "generic", "Microsoft Corporation"],
    [".sl", "country-code", "Sierratel"],
    [".sm", "country-code", "Telecom Italia San Marino S.p.A."],
    [".smile", "generic", "Amazon Registry Services, Inc."],
    [".sn", "country-code", "Universite Cheikh Anta Diop NIC Senegal"],
    [".sncf", "generic", "SNCF (Société Nationale des Chemins de fer Francais)"],
    [".so", "country-code", "Ministry of Post and Telecommunications"],
    [".soccer", "generic", "Foggy Shadow, LLC"],
    [".social", "generic", "United TLD Holdco Ltd."],
    [".softbank", "generic", "SoftBank Group Corp."],
    [".software", "generic", "United TLD Holdco, Ltd"],
    [".sohu", "generic", "Sohu.com Limited"],
    [".solar", "generic", "Ruby Town, LLC"],
    [".solutions", "generic", "Silver Cover, LLC"],
    [".song", "generic", "Amazon Registry Services, Inc."],
    [".sony", "generic", "Sony Corporation"],
    [".soy", "generic", "Charleston Road Registry Inc."],
    [".space", "generic", "DotSpace Inc."],
    [".spiegel", "generic", "SPIEGEL-Verlag Rudolf Augstein GmbH & Co. KG"],
    [".spot", "generic", "Amazon Registry Services, Inc."],
    [".spreadbetting", "generic", "DOTSPREADBETTING REGISTRY LTD"],
    [".sr", "country-code", "Telesur"],
    [".srl", "generic", "InterNetX Corp."],
    [".ss", "country-code", "Not assigned"],
    [".st", "country-code", "Tecnisys"],
    [".stada", "generic", "STADA Arzneimittel AG"],
    [".star", "generic", "Star India Private Limited"],
    [".starhub", "generic", "StarHub Limited"],
    [".statebank", "generic", "STATE BANK OF INDIA"],
    [".statefarm", "generic", "State Farm Mutual Automobile Insurance Company"],
    [".statoil", "generic", "Statoil ASA"],
    [".stc", "generic", "Saudi Telecom Company"],
    [".stcgroup", "generic", "Saudi Telecom Company"],
    [".stockholm", "generic", "Stockholms kommun"],
    [".storage", "generic", "Self Storage Company LLC"],
    [".store", "generic", "DotStore Inc."],
    [".stream", "generic", "dot Stream Limited"],
    [".studio", "generic", "United TLD Holdco Ltd."],
    [".study", "generic", "OPEN UNIVERSITIES AUSTRALIA PTY LTD"],
    [".style", "generic", "Binky Moon, LLC"],
    [".su", "country-code", "Russian Institute for Development of Public Networks (ROSNIIROS)"],
    [".sucks", "generic", "Vox Populi Registry Ltd."],
    [".supplies", "generic", "Atomic Fields, LLC"],
    [".supply", "generic", "Half Falls, LLC"],
    [".support", "generic", "Grand Orchard, LLC"],
    [".surf", "generic", "Top Level Domain Holdings Limited"],
    [".surgery", "generic", "Tin Avenue, LLC"],
    [".suzuki", "generic", "SUZUKI MOTOR CORPORATION"],
    [".sv", "country-code", "SVNet"],
    [".swatch", "generic", "The Swatch Group Ltd"],
    [".swiss", "generic", "Swiss Confederation"],
    [".sx", "country-code", "SX Registry SA B.V."],
    [".sy", "country-code", "National Agency for Network Services (NANS)"],
    [".sydney", "generic", "State of New South Wales, Department of Premier and Cabinet"],
    [".symantec", "generic", "Symantec Corporation"],
    [".systems", "generic", "Dash Cypress, LLC"],
    [".sz", "country-code", "University of Swaziland Department of Computer Science"],
    [".tab", "generic", "Tabcorp Holdings Limited"],
    [".taipei", "generic", "Taipei City Government"],
    [".talk", "generic", "Amazon Registry Services, Inc."],
    [".taobao", "generic", "Alibaba Group Holding Limited"],
    [".tatamotors", "generic", "Tata Motors Ltd"],
    [".tatar", "generic", "Limited Liability Company - Coordination Center of Regional Domain of Tatarstan Republic"],
    [".tattoo", "generic", "Uniregistry, Corp."],
    [".tax", "generic", "Storm Orchard, LLC"],
    [".taxi", "generic", "Pine Falls, LLC"],
    [".tc", "country-code", "Melrex TC"],
    [".tci", "generic", "Asia Green IT System Bilgisayar San. ve Tic. Ltd. Sti."],
    [".td", "country-code", "Société des télécommunications du Tchad (SOTEL TCHAD)"],
    [".team", "generic", "Atomic Lake, LLC"],
    [".tech", "generic", "Dot Tech LLC"],
    [".technology", "generic", "Auburn Falls, LLC"],
    [".tel", "sponsored", "Telnic Ltd."],
    [".telecity", "generic", "TelecityGroup International Limited"],
    [".telefonica", "generic", "Telefónica S.A."],
    [".temasek", "generic", "Temasek Holdings (Private) Limited"],
    [".tennis", "generic", "Cotton Bloom, LLC"],
    [".teva", "generic", "Teva Pharmaceutical Industries Limited"],
    [".tf", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".tg", "country-code", "Autorite de Reglementation des secteurs de Postes et de Telecommunications (ART&P)"],
    [".th", "country-code", "Thai Network Information Center Foundation"],
    [".thd", "generic", "Homer TLC, Inc."],
    [".theater", "generic", "Blue Tigers, LLC"],
    [".theatre", "generic", "XYZ.COM LLC"],
    [".tickets", "generic", "Accent Media Limited"],
    [".tienda", "generic", "Victor Manor, LLC"],
    [".tiffany", "generic", "Tiffany and Company"],
    [".tips", "generic", "Corn Willow, LLC"],
    [".tires", "generic", "Dog Edge, LLC"],
    [".tirol", "generic", "punkt Tirol GmbH"],
    [".tj", "country-code", "Information Technology Center"],
    [".tk", "country-code", "Telecommunication Tokelau Corporation (Teletok)"],
    [".tl", "country-code", "Ministry of Transport and Communications; National Division of Information and Technology"],
    [".tm", "country-code", "TM Domain Registry Ltd"],
    [".tmall", "generic", "Alibaba Group Holding Limited"],
    [".tn", "country-code", "Agence Tunisienne d'Internet"],
    [".to", "country-code", "Government of the Kingdom of Tonga H.R.H. Crown Prince Tupouto'a c/o Consulate of Tonga"],
    [".today", "generic", "Pearl Woods, LLC"],
    [".tokyo", "generic", "GMO Registry, Inc."],
    [".tools", "generic", "Pioneer North, LLC"],
    [".top", "generic", "Jiangsu Bangning Science & Technology Co.", "Ltd."],
    [".toray", "generic", "Toray Industries, Inc."],
    [".toshiba", "generic", "TOSHIBA Corporation"],
    [".total", "generic", "Total SA"],
    [".tours", "generic", "Sugar Station, LLC"],
    [".town", "generic", "Koko Moon, LLC"],
    [".toyota", "generic", "TOYOTA MOTOR CORPORATION"],
    [".toys", "generic", "Pioneer Orchard, LLC"],
    [".tp", "country-code", "Retired"],
    [".tr", "country-code", "Middle East Technical University Department of Computer Engineering"],
    [".trade", "generic", "Elite Registry Limited"],
    [".trading", "generic", "DOTTRADING REGISTRY LTD"],
    [".training", "generic", "Wild Willow, LLC"],
    [".travel", "sponsored", "Tralliance Registry Management Company, LLC."],
    [".travelers", "generic", "Travelers TLD, LLC"],
    [".travelersinsurance", "generic", "Travelers TLD, LLC"],
    [".trust", "generic", "Artemis Internet Inc"],
    [".trv", "generic", "Travelers TLD, LLC"],
    [".tt", "country-code", "University of the West Indies Faculty of Engineering"],
    [".tube", "generic", "Latin American Telecom LLC"],
    [".tui", "generic", "TUI AG"],
    [".tunes", "generic", "Amazon Registry Services, Inc."],
    [".tushu", "generic", "Amazon Registry Services, Inc."],
    [".tv", "country-code", "Ministry of Finance and Tourism"],
    [".tvs", "generic", "T V SUNDRAM IYENGAR & SONS PRIVATE LIMITED"],
    [".tw", "country-code", "Taiwan Network Information Center (TWNIC)"],
    [".tz", "country-code", "Tanzania Network Information Centre (tzNIC)"],
    [".ua", "country-code", "Hostmaster Ltd."],
    [".ubs", "generic", "UBS AG"],
    [".ug", "country-code", "Uganda Online Ltd."],
    [".uk", "country-code", "Nominet UK"],
    [".um", "country-code", "Not assigned"],
    [".unicom", "generic", "China United Network Communications Corporation Limited"],
    [".university", "generic", "Little Station, LLC"],
    [".uno", "generic", "Dot Latin LLC"],
    [".uol", "generic", "UBN INTERNET LTDA."],
    [".us", "country-code", "NeuStar, Inc."],
    [".uy", "country-code", "SeCIU - Universidad de la Republica"],
    [".uz", "country-code", "Computerization and Information Technologies Developing Center UZINFOCOM"],
    [".va", "country-code", "Holy See Secretariat of State Department of Telecommunications"],
    [".vacations", "generic", "Atomic Tigers, LLC"],
    [".vana", "generic", "Lifestyle Domain Holdings, Inc."],
    [".vc", "country-code", "Ministry of Telecommunications", " Science, Technology and Industry"],
    [".ve", "country-code", "Comisión Nacional de Telecomunicaciones (CONATEL)"],
    [".vegas", "generic", "Dot Vegas, Inc."],
    [".ventures", "generic", "Binky Lake, LLC"],
    [".verisign", "generic", "VeriSign, Inc."],
    [".versicherung", "generic", "dotversicherung-registry GmbH"],
    [".vet", "generic", "United TLD Holdco, Ltd"],
    [".vg", "country-code", "Telecommunications Regulatory Commission of the Virgin Islands"],
    [".vi", "country-code", "Virgin Islands Public Telcommunications System c/o COBEX Internet Services"],
    [".viajes", "generic", "Black Madison, LLC"],
    [".video", "generic", "United TLD Holdco, Ltd"],
    [".vig", "generic", "VIENNA INSURANCE GROUP AG Wiener Versicherung Gruppe"],
    [".viking", "generic", "Viking River Cruises (Bermuda) Ltd."],
    [".villas", "generic", "New Sky, LLC"],
    [".vin", "generic", "Holly Shadow, LLC"],
    [".vip", "generic", "Minds + Machines Group Limited"],
    [".virgin", "generic", "Virgin Enterprises Limited"],
    [".vision", "generic", "Koko Station, LLC"],
    [".vista", "generic", "Vistaprint Limited"],
    [".vistaprint", "generic", "Vistaprint Limited"],
    [".viva", "generic", "Saudi Telecom Company"],
    [".vlaanderen", "generic", "DNS.be vzw"],
    [".vn", "country-code", "Ministry of Information and Communications of Socialist Republic of Viet Nam"],
    [".vodka", "generic", "Top Level Domain Holdings Limited"],
    [".volkswagen", "generic", "Volkswagen Group of America Inc."],
    [".vote", "generic", "Monolith Registry LLC"],
    [".voting", "generic", "Valuetainment Corp."],
    [".voto", "generic", "Monolith Registry LLC"],
    [".voyage", "generic", "Ruby House, LLC"],
    [".vu", "country-code", "Telecom Vanuatu Limited"],
    [".vuelos", "generic", "Travel Reservations SRL"],
    [".wales", "generic", "Nominet UK"],
    [".walter", "generic", "Sandvik AB"],
    [".wang", "generic", "Zodiac Registry Limited"],
    [".wanggou", "generic", "Amazon Registry Services, Inc."],
    [".warman", "generic", "Weir Group IP Limited"],
    [".watch", "generic", "Sand Shadow, LLC"],
    [".watches", "generic", "Richemont DNS Inc."],
    [".weather", "generic", "The Weather Channel, LLC"],
    [".weatherchannel", "generic", "The Weather Channel, LLC"],
    [".webcam", "generic", "dot Webcam Limited"],
    [".weber", "generic", "Saint-Gobain Weber SA"],
    [".website", "generic", "DotWebsite Inc."],
    [".wed", "generic", "Atgron, Inc."],
    [".wedding", "generic", "Top Level Domain Holdings Limited"],
    [".weibo", "generic", "Sina Corporation"],
    [".weir", "generic", "Weir Group IP Limited"],
    [".wf", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".whoswho", "generic", "Who's Who Registry"],
    [".wien", "generic", "punkt.wien GmbH"],
    [".wiki", "generic", "Top Level Design, LLC"],
    [".williamhill", "generic", "William Hill Organization Limited"],
    [".win", "generic", "First Registry Limited"],
    [".windows", "generic", "Microsoft Corporation"],
    [".wine", "generic", "June Station, LLC"],
    [".wme", "generic", "William Morris Endeavor Entertainment, LLC"],
    [".wolterskluwer", "generic", "Wolters Kluwer N.V."],
    [".work", "generic", "Top Level Domain Holdings Limited"],
    [".works", "generic", "Little Dynamite, LLC"],
    [".world", "generic", "Bitter Fields, LLC"],
    [".ws", "country-code", "Government of Samoa Ministry of Foreign Affairs & Trade"],
    [".wtc", "generic", "World Trade Centers Association, Inc."],
    [".wtf", "generic", "Hidden Way, LLC"],
    [".xbox", "generic", "Microsoft Corporation"],
    [".xerox", "generic", "Xerox DNHC LLC"],
    [".xihuan", "generic", "QIHOO 360 TECHNOLOGY CO. LTD."],
    [".xin", "generic", "Elegant Leader Limited"],
    [".xyz", "generic", "XYZ.COM LLC - possibly Web3 or blockchain"],
    [".测试", "test", "Internet Assigned Numbers Authority"],
    [".कॉम", "generic", "VeriSign Sarl"],
    [".परीक्षा", "test", "Internet Assigned Numbers Authority"],
    [".セール", "generic", "Amazon Registry Services, Inc."],
    [".佛山", "generic", "Guangzhou YU Wei Information Technology Co., Ltd."],
    [".ಭಾರತ", "country-code", "Not assigned"],
    [".慈善", "generic", "Excellent First Limited"],
    [".集团", "generic", "Eagle Horizon Limited"],
    [".在线", "generic", "TLD REGISTRY LIMITED"],
    [".한국", "country-code", "KISA (Korea Internet & Security Agency)"],
    [".ଭାରତ", "country-code", "Not assigned"],
    [".点看", "generic", "VeriSign Sarl"],
    [".คอม", "generic", "VeriSign Sarl"],
    [".ভাৰত", "country-code", "Not assigned"],
    [".ভারত", "country-code", "National Internet Exchange of India"],
    [".八卦", "generic", "Zodiac Scorpio Limited"],
    [".موقع", "generic", "Suhub Electronic Establishment"],
    [".বাংলা", "country-code", "Not assigned"],
    [".公益", "generic", "China Organizational Name Administration Center"],
    [".公司", "generic", "Computer Network Information Center of Chinese Academy of Sciences （China Internet Network Information Center）"],
    [".网站", "generic", "Global Website TLD Asia Limited"],
    [".移动", "generic", "Afilias Limited"],
    [".我爱你", "generic", "Tycoon Treasure Limited"],
    [".москва", "generic", "Foundation for Assistance for Internet Technologies and Infrastructure Development (FAITID)"],
    [".испытание", "test", "Internet Assigned Numbers Authority"],
    [".қаз", "country-code", "Association of IT Companies of Kazakhstan"],
    [".онлайн", "generic", "CORE Association"],
    [".сайт", "generic", "CORE Association"],
    [".联通", "generic", "China United Network Communications Corporation Limited"],
    [".срб", "country-code", "Serbian National Internet Domain Registry (RNIDS)"],
    [".бг", "country-code", "Not assigned"],
    [".бел", "country-code", "Reliable Software, Ltd."],
    [".קום", "generic", "VeriSign Sarl"],
    [".时尚", "generic", "RISE VICTORY LIMITED"],
    [".微博", "generic", "Sina Corporation"],
    [".테스트", "test", "Internet Assigned Numbers Authority"],
    [".淡马锡", "generic", "Temasek Holdings (Private) Limited"],
    [".ファッション", "generic", "Amazon Registry Services, Inc."],
    [".орг", "generic", "Public Interest Registry"],
    [".नेट", "generic", "VeriSign Sarl"],
    [".ストア", "generic", "Amazon Registry Services, Inc."],
    [".삼성", "generic", "SAMSUNG SDS CO., LTD"],
    [".சிங்கப்பூர்", "country-code", "Singapore Network Information Centre (SGNIC) Pte Ltd"],
    [".商标", "generic", "HU YI GLOBAL INFORMATION RESOURCES(HOLDING) COMPANY.HONGKONG LIMITED"],
    [".商店", "generic", "Wild Island, LLC"],
    [".商城", "generic", "Zodiac Aquarius Limited"],
    [".дети", "generic", "The Foundation for Network Initiatives “The Smart Internet”"],
    [".мкд", "country-code", "Macedonian Academic Research Network Skopje"],
    [".טעסט", "test", "Internet Assigned Numbers Authority"],
    [".ею", "country-code", "EURid vzw/asbl"],
    [".ポイント", "generic", "Amazon Registry Services, Inc."],
    [".新闻", "generic", "Xinhua News Agency Guangdong Branch 新华通讯社广东分社"],
    [".工行", "generic", "Industrial and Commercial Bank of China Limited"],
    [".家電", "generic", "Amazon Registry Services, Inc."],
    [".كوم", "generic", "VeriSign Sarl"],
    [".中文网", "generic", "TLD REGISTRY LIMITED"],
    [".中信", "generic", "CITIC Group Corporation"],
    [".中国", "country-code", "China Internet Network Information Center (CNNIC)"],
    [".中國", "country-code", "China Internet Network Information Center (CNNIC)"],
    [".娱乐", "generic", "Will Bloom, LLC"],
    [".谷歌", "generic", "Charleston Road Registry Inc."],
    [".భారత్", "country-code", "National Internet Exchange of India"],
    [".ලංකා", "country-code", "LK Domain Registry"],
    [".购物", "generic", "Minds + Machines Group Limited"],
    [".測試", "test", "Internet Assigned Numbers Authority"],
    [".クラウド", "generic", "Amazon Registry Services, Inc."],
    [".ભારત", "country-code", "National Internet Exchange of India"],
    [".भारत", "country-code", "National Internet Exchange of India"],
    [".آزمایشی", "test", "Internet Assigned Numbers Authority"],
    [".பரிட்சை", "test", "Internet Assigned Numbers Authority"],
    [".网店", "generic", "Zodiac Libra Limited"],
    [".संगठन", "generic", "Public Interest Registry"],
    [".餐厅", "generic", "HU YI GLOBAL INFORMATION RESOURCES (HOLDING) COMPANY. HONGKONG LIMITED"],
    [".网络", "generic", "Computer Network Information Center of Chinese Academy of Sciences （China Internet Network Information Center）"],
    [".ком", "generic", "VeriSign Sarl"],
    [".укр", "country-code", "Ukrainian Network Information Centre (UANIC), Inc."],
    [".香港", "country-code", "Hong Kong Internet Registration Corporation Ltd."],
    [".诺基亚", "generic", "Nokia Corporation"],
    [".食品", "generic", "Amazon Registry Services, Inc."],
    [".δοκιμή", "test", "Internet Assigned Numbers Authority"],
    [".飞利浦", "generic", "Koninklijke Philips N.V."],
    [".إختبار", "test", "Internet Assigned Numbers Authority"],
    [".台湾", "country-code", "Taiwan Network Information Center (TWNIC)"],
    [".台灣", "country-code", "Taiwan Network Information Center (TWNIC)"],
    [".手表", "generic", "Richemont DNS Inc."],
    [".手机", "generic", "Beijing RITT-Net Technology Development Co., Ltd"],
    [".мон", "country-code", "Datacom Co.", "Ltd"],
    [".الجزائر", "country-code", "CERIST"],
    [".عمان", "country-code", "Telecommunications Regulatory Authority (TRA)"],
    [".ارامكو", "generic", "Aramco Services Company"],
    [".ایران", "country-code", "Institute for Research in Fundamental Sciences (IPM)"],
    [".العليان", "generic", "Crescent Holding GmbH"],
    [".امارات", "country-code", "Telecommunications Regulatory Authority (TRA)"],
    [".بازار", "generic", "CORE Association"],
    [".پاکستان", "country-code", "Not assigned"],
    [".الاردن", "country-code", "National Information Technology Center (NITC)"],
    [".موبايلي", "generic", "GreenTech Consultancy Company W.L.L."],
    [".بھارت", "country-code", "National Internet Exchange of India"],
    [".المغرب", "country-code", "Agence Nationale de Réglementation des Télécommunications (ANRT)"],
    [".ابوظبي", "generic", "Abu Dhabi Systems and Information Centre"],
    [".السعودية", "country-code", "Communications and Information Technology Commission"],
    [".سودان", "country-code", "Sudan Internet Society"],
    [".همراه", "generic", "Asia Green IT System Bilgisayar San. ve Tic. Ltd. Sti."],
    [".عراق", "country-code", "Communications and Media Commission (CMC)"],
    [".مليسيا", "country-code", "MYNIC Berhad"],
    [".澳門", "country-code", "Bureau of Telecommunications Regulation (DSRT)"],
    [".닷컴", "generic", "VeriSign Sarl"],
    [".政府", "generic", "Net-Chinese Co., Ltd."],
    [".شبكة", "generic", "International Domain Registry Pty. Ltd."],
    [".بيتك", "generic", "Kuwait Finance House"],
    [".გე", "country-code", "Information Technologies Development Center (ITDC)"],
    [".机构", "generic", "Public Interest Registry"],
    [".组织机构", "generic", "Public Interest Registry"],
    [".健康", "generic", "Stable Tone Limited"],
    [".ไทย", "country-code", "Thai Network Information Center Foundation"],
    [".سورية", "country-code", "National Agency for Network Services (NANS)"],
    [".рус", "generic", "Rusnames Limited"],
    [".рф", "country-code", "Coordination Center for TLD RU"],
    [".珠宝", "generic", "Richemont DNS Inc."],
    [".تونس", "country-code", "Agence Tunisienne d'Internet"],
    [".大拿", "generic", "VeriSign Sarl"],
    [".みんな", "generic", "Charleston Road Registry Inc."],
    [".グーグル", "generic", "Charleston Road Registry Inc."],
    [".ελ", "country-code", "ICS-FORTH GR"],
    [".世界", "generic", "Stable Tone Limited"],
    [".書籍", "generic", "Amazon EU S.à r.l."],
    [".ഭാരതം", "country-code", "Not assigned"],
    [".ਭਾਰਤ", "country-code", "National Internet Exchange of India"],
    [".网址", "generic", "KNET Co., Ltd"],
    [".닷넷", "generic", "VeriSign Sarl"],
    [".コム", "generic", "VeriSign Sarl"],
    [".游戏", "generic", "Spring Fields, LLC"],
    [".vermögensberater", "generic", "Deutsche Vermögensberatung Aktiengesellschaft DVAG"],
    [".vermögensberatung", "generic", "Deutsche Vermögensberatung Aktiengesellschaft DVAG"],
    [".企业", "generic", "Dash McCook, LLC"],
    [".信息", "generic", "Beijing Tele-info Network Technology Co., Ltd."],
    [".嘉里大酒店", "generic", "Kerry Trading Co. Limited"],
    [".مصر", "country-code", "National Telecommunication Regulatory Authority - NTRA"],
    [".قطر", "country-code", "Communications Regulatory Authority"],
    [".广东", "generic", "Guangzhou YU Wei Information Technology Co., Ltd."],
    [".இலங்கை", "country-code", "LK Domain Registry"],
    [".இந்தியா", "country-code", "National Internet Exchange of India"],
    [".հայ", "country-code", "'Internet Society' Non-governmental Organization"],
    [".新加坡", "country-code", "Singapore Network Information Centre (SGNIC) Pte Ltd"],
    [".فلسطين", "country-code", "Ministry of Telecom & Information Technology (MTIT)"],
    [".テスト", "test", "Internet Assigned Numbers Authority"],
    [".政务", "generic", "China Organizational Name Administration Center"],
    [".xperia", "generic", "Sony Mobile Communications AB"],
    [".xxx", "sponsored", "ICM Registry LLC"],
    [".yachts", "generic", "DERYachts, LLC"],
    [".yahoo", "generic", "Yahoo! Domain Services Inc."],
    [".yamaxun", "generic", "Amazon Registry Services, Inc."],
    [".yandex", "generic", "YANDEX, LLC"],
    [".ye", "country-code", "TeleYemen"],
    [".yodobashi", "generic", "YODOBASHI CAMERA CO.", "LTD."],
    [".yoga", "generic", "Top Level Domain Holdings Limited"],
    [".yokohama", "generic", "GMO Registry, Inc."],
    [".you", "generic", "Amazon Registry Services, Inc."],
    [".youtube", "generic", "Charleston Road Registry Inc."],
    [".yt", "country-code", "Association Française pour le Nommage Internet en Coopération (A.F.N.I.C.)"],
    [".yun", "generic", "QIHOO 360 TECHNOLOGY CO. LTD."],
    [".za", "country-code", "ZA Domain Name Authority"],
    [".zara", "generic", "Industria de Diseño Textil", " S.A. (INDITEX, S.A.)"],
    [".zero", "generic", "Amazon Registry Services, Inc."],
    [".zip", "generic", "Charleston Road Registry Inc."],
    [".zm", "country-code", "Zambia Information and Communications Technology Authority (ZICTA)"],
    [".zone", "generic", "Outer Falls, LLC"],
    [".zuerich", "generic", "Kanton Zürich (Canton of Zurich)"],
    [".zw", "country-code", "Postal and Telecommunications Regulatory Authority of Zimbabwe (POTRAZ)"],
]

df_tld_iana = pd.DataFrame(
    data=[row[:3] for row in TLD_TYPE_SPONSOR_LISTS],
    columns='domain type sponsor'.split())
df_tld_iana['domain'] = df_tld_iana['domain'].str.lstrip('.')
df_tld_iana = df_tld_iana.sort_values('domain')
df_tld_iana.index = df_tld_iana['domain'].values
DF_TLD = DF_TLD_IANA = df_tld_iana

TLDs = list(df_tld_iana['domain'])
DICT_TLD_TYPE = dict(zip(df_tld_iana['domain'], df_tld_iana['type']))
DICT_TLD_SPONSOR = dict(zip(df_tld_iana['domain'], df_tld_iana['sponsor']))
