>>> from generate import generate_words
... from model import RNNModel
... 
... corpus = data.Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='He'))
...
>>> from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='He'))
...
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='He'))
...
'accused prefecture and the mother instead of dolmen . Even by Kenneth Odaenathus Daily is the first professor of nearby when it won 75 riders . On 5 9 and 25 Aires Anton Alex Antonio Vandernoot witnessing him a benefit @-@ changing law accomplished and nasal sentence and playoff entry in . With the RFU , Ross praised his abilities with eight games and ejaculation . Visual Taiwanese Kurt Robert P. Dempsey acquired his only comic analysis at the of the Rookie Arsenal and is inhabited . However , the Pirates defeated to 1839 their rare local unit and luggage replay breakout . Generally consolidated the last game , Somerset \'s final appearance , joining a carnivorous of all over a successive will field minor pot , family , and unsettling they have retired together . In France , the vision of the Raffles rudder independently rated his run into 1969 Man and dislikes Juan Perón . The cover newspapers attributed to the Boston " Blowin , needed " Hendrix . = For the sixth recollection , Mosley gave that dominated and 8 @,@ 000 in pairs . In 1950 , the band attracted 55 % of similarities with netting that other Uno artwork of the fables immigrant in the process . Among demons \'s types within them to flee , the brook Deadwood @-@ door authors Juan books that their and hillside " My " to rejoin in the Bedouins a replacement spaced ever influenced . = = Valkyria Valkyria Prelude Valkyria Valkyria = = On 21 February 2014 ; the two was replaced by learning places . The tooth and undertaken went being divided into the new such as well as racial . On the 1996 of North America , a special carrier atmospheric unit , Taliaferro , such as the Acoustic The 16th African territories was batting kept in 2011 . = = Valkyria Valkyria Valkyria Design retirement Valkyria Valkyria Valkyria = = " Perry Howard " ignoring an End of Palmyrene , which was notable without such with Rhys . With the greatest camp pact , when professors was awarded the Crown , a crowd of Mosley \'s absence in alto . In 1991 , they rejoined vegetables from Art ( 2012 ) . This has also been successful killing in 1916 games . Perfect Nguyen ( 46 – 1 @.@ 5 million C of Spike ) is a single migration with fish from " Big Sixth Where it née " Rubin or ( " all imagine closer over guard ] " ) , is a minor actions , the province aggregator portraits . It is originally one of Hegna in the UK ( approximately 2 @,@ 000 @,@ 000 , to the previous city ) , and the poor save race international and a taste is from . Female concubine ( introduce Cade ) , is an neutron minute process , in the 13th century that is intense , embroiled at once , well as synonyms , altars , time . Author are often found at engineered : , California , adults . This function is smooth after being a satellite mutations , a the neck captures by formidable tenets . = By the world , a combination of its American literature reactions followed by having the tales of a time complex . Rzepecki , Christians has been found in small parts , not possess by a black ratios that may are R1 . The Nameless may have escaped down and nuclear column during the value of tartar . It followed or small light whether the aircraft were resulting completely directly to help to shine , which it despite a great sequence . The birds are often regarded as part of pillow in Def or case . Many indicates " this " displays occur for a large prohibited as a salary that will be time breaking out that should go out they cannot be may follow research by free the way , and a why dealt these , but does strategic the descent who translated about a charge of McMaster . This progresses of the largest form a avoiding ligaments on infertility . Most other types of condom will be dominant pale and find can likely the mood . They can extend any turnover strength , and thus they do worse for distance . The population was also its a larger lounge performer . In Manila – 8 @.@ 7 , the last in those face calculated its free work for rarity , while creates more unknown , but typesetters . Around races to 30 % of control improved , they eventually leave extra coupled in the bill , but they can be reduced away layers . Odaenathus stibium on greater monuments , and a much of only unknown defeat of a outflow , and there ( on July 12 , 1857 . This range can be different with frescoes to Thebes range a or yield and organism to . At a authors are dictated to some birds , " loves " or nasals of these aircraft shops in leafy screaming compared years old . According to , Wally will CBS have also been only been made used as non @-@ Calle moves , " It is perhaps they also understand the soundtracks play of three people or all @-@ shaped period . Outside the birds end themselves kitsunetsuki to Earth Subfamily 293 . = = Valkyria Valkyria Valkyria B. Hudaydah Valkyria Valkyria Valkyria = = The Māori have changed power to compete along and temporary subdivisions resting of nest , and crutches and compares it to Sanjeev gallons of . These attack on individuals are differently in , and so go within the Sun a wood earmarked distributed . This is estimated sometimes completed , though only only significant islands . Despite mines \'s strong devices are stable and engined in the area in the genus and they have taken sentence , ) is in fact to do many are diamond . These genera have be related to their irrelevant views , although it did not sink ,'
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='The'))
...
'Methods — determined that this kind is Highlander in mass . The largest issue of the informal police was used by a few period of the aristocracy . = The Palmyrene series public designed and Mount cruelty . In the late 19th century , and the annual villagers was forced in a large quality of Burnside . = = Valkyria Valkyria Somali History Valkyria Valkyria = = The world Gallian Show has been considered for the altar , and Moshenska metro use the genus Morris is murdered for what is a venture that militia innovative tools sitting between fibres , , Massachusetts g . Pelham architectural survives , serves as the same official architectural football @-@ @-@ white @-@ developed gravity is increasingly parody . Entertainment % connected changes to run in varieties , which has been in the delegation , and Boise taxonomy was also highest 2012 by the Somali dispute of Aldershot . = The United States Session of 24 hospitals , a trend of Ireland due to a Roman finest governing , and city was sold in the form of @-@ suited fragile . " The Baron King is probably going to have an definite resident of ice quake through access to February Avignon . Several newspapers widespread trees away as kakapo copied from IDF mobility to campaign with dull the kakapo . The Wars of M , Corpus fertilizers ( foraging , chicks , along West Officer ) in the territory lines consists of the aerial anterior 15 % of fossils . It does not provide common punk easy such the restrictions as drawing as more , or then , and properties UP ( the species of which Fifteen ) and the only estimate of her eggs above 7 – 3 . There led at a trading fact that these have timed two days plant . = = Valkyria Valkyria Valkyria Valkyria Mission Valkyria Valkyria Valkyria = = unabated capable in the kakapo are thought to be Carol \'s creative biographer . In 1834 , in the decline of dedication , the kakapo used to have gone other over 100 metres and in the newly forests . The majority individual frill Service , " speech " and Cosmopolitan , individually tombs or partner . The Dhrupad payments are all of the experiment weather to Merenre fish don bureaucracy ( with spleen blows transcribed . ) was released on a three @-@ defenseman @-@ disc only rectified Urn ( in April 1997 ) , each was known in the Northern Africa . = The softened of weakly accidents are similar in Swing southern until one of the homes of the 17th century . = The last transit of the kakapo is Pagoda by in Brazil . = = Valkyria Valkyria Valkyria FISA , habitat Valkyria Valkyria Valkyria = = Iguanodon involves respiratory Mandi Queensland , both males , and the million temperament . The immature transit of the tagline is becoming in , Kodokan it . , isotopes , these and sago must choose the Parkway to consider it or guardian terms of . = The mixture of a variety of types of age are idea in an divines around 1 requirements , in locals . Like them mostly extinct of grapes , the Passing partial M @-@ contend of North e5 europium undistinguished communities . This is modern @-@ final breeding Tests are large crowded between timber and characters to volunteers such as electricity . Attempts of mechanics are a thick @-@ range species , . Though courtship of the temperature will are found directly to the ground at , except as most of dying a revisiting engineering temperature mainly either . One guess is measured in in 1901 . local starlings , with both Hauser compounds of further fruit , health , perhaps at 13 m ; 8 @.@ 2 % for 6 @.@ 2 times ( 1 @.@ 9 2 ) . There is also living on the pale window to a cold and Austrian and Bronze fruit farm in Ireland . This is seen as Hans of its published in favour ) . Some unsatisfactory infected was less quotation . The three largest stained from the hand ( which kept the partially catch known or lit ) , so that they can occur lucky stop . In differentiate , there are no longer pressing and all Norse teeth in Europe . Much of rich mills caused significant animals to collect " poetry " . The cosmos \'s interior is such for the half of the assembly of slugs by the multi @-@ thirds of the chamber as notable means , . The Cole in the fraction of Homarus , they may be distinguished to have four rare remainder of these hotels . They are more pest , and are several greenish birds from post @-@ radioactive concentrations and associates of age of crop , some made parts of six divorce and 750 ribosomal wall are larger somewhat invaded man objections together , to the case tissue icy traffic . shape , and then recapture the Yucatán Chanology g . = Heading , behaviour may be placed on some graph in the air and either in Shiva to larger . However , to come from chapterhouse such as from Saginaw . Part , magnitude the vipers is often introduced as a diameter can be found , to be javelin . A tie 3 – 1 venom , birds are many of the weapons legs such as nucleotide Peeters . Its acute students then envisaged the presence with freely projection ( have subtype ) that ( which are signed in motifs , 1653 " , a stingray ) and ascent , 1815 devices which is common from cool @-@ aground . Gerard was approached towards with his power gods . females can save technology are neither longer or limits , and can arrive together with other spillways , as an parent houses , it is not verified during their aerodrome . This signs of a strong slip crew for transit such as the aim \'s Ghats color or 30'
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='The', temperature=.1))
...
'of the Republic of the Republic of the Republic of Ireland . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was a large @-@ scale , which was a member of the city . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the of the of the , which is a common starling , which is a large @-@ scale . The kakapo is a common starling , which is a common starling , and the is a of the . The kakapo is a common starling , and the is a of . The kakapo is a common starling , and the is a , and the ( ) , and the of the . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the of the is a of the . The is a common species of the , and the of the , and the of the . The is a common starling , and the is a . The is a common starling , and the is a of . The is a common starling , and the is a . The is a common starling , and the is a of the . The is a common starling , and the is a of the . The is a common starling , and the is a . The is a common starling , and the is a of . The is a common starling , and the is a of the . The is a common starling , and the of the is a . The is a common starling , and the is a . The is a common starling , which is a common starling , and the is a . The is a common starling , and the is a , and the ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and , and , and . The is a common starling , and the is a of . The is a common starling , and the is a of the . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the of the ( ) , the of ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) , and ( ) . The is a common starling , and the ( ) , and ( ) , and ( ) , and ( ) , and ( ) . The is a common starling , and the is a of . The is a common starling , and the is a of the . The is a common starling , and the is a . The is a common starling , and the is a . The is a common starling , and the is a , and the of the ( ) , and ( ) , and ( ) , and , and the ( ) , and ( ) , and ( ) , and , and . The is a common starling , and the is a , and the ( ) , and ( ) , and ( ) , and ( ) , and ( ) . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , which is a common starling , which is a common starling , and the ( ) , and the of the . The is a common starling , and the is a , and the ( ) , and ( ) , and ( ) . The is a common starling , and the is a of the . The is a common starling , and is a of the . The is a common starling , and the is a . The is a common starling , and the is a of . The is a common starling , and the is a , and the is a . The is a common starling , and the is a , and the is a . The is a common starling , and the is a , and the is a . The is a common starling , and the is a , and the is a . The is a common starling , and the is a , and a , and the . The is a common starling , and the is a . The is a common starling , and the is a , and the is a of . The is a common starling , and the is a of . The is a common starling , and the is a of . The is a common starling , and the is a of . The is a common starling , and the of the is a . The is a common starling , and the is a of the . The is a common species of the , and the ( ) , and ( ) , and ( ) , and ( ) , and , and . The is a common starling , and the is a . The is a common starling , and the is a . The is a common starling , and the of the ( ) , and ('
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='The', temperature=.2))
...
'of the . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The first year of the game was introduced by the of the United States , and the first time of the city was the first time . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was a first known as the first time of the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was a total of the first time in the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was also released in the first time , and the first time in the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was also used to be a " " , and the game was a " " . The game was the first game in the game , and the first time of the game was the first time . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was also known as the first time in the game . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The game was a first game in the United States , and the first time in the game was the first time in the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was a first game in the first half of the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was also known as the first game in the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was also known as the first time in the game . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The game was also known as the of the Republic of the Republic of Ireland . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was the first game in the United States . The game was also known as the of the American , and the of the city . The kakapo was also known as the " of the " " . The of the Republic of Ireland was the first time of the city . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was a first known in the United States . The kakapo was also known as the of the Republic of Ireland . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , which is a common starling , and the of the ( ) , the of the Republic of the Republic of Ireland . The kakapo is a common starling , which is a common starling , and the ( ) , is a large @-@ , and the ( ) , and the of the . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the is a , and the is a . The of the kakapo is a , and the is a , and the is a large @-@ . The is a common starling , and the is a of the . The of the is a common starling , which is a of , and the ( ) . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the of the is a of , and the is a . The is a common starling , and the is a . The is a common starling , and the of the is a . The is a common starling , and the is a of , and the ( ) . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , which is a common starling , and the of , and the ( ) , the of , and the of ( ) , and , and the of the . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the is a , and the is a , and the is a . The is a common species of the , and the is a , and , and the of the . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The common starling is a large species of the , and the of , which is a common starling , and the ( ) , and the ( ) , and ( ) , and , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , and , and . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo is a common starling , and the is a common starling , and the is a , and the of the is a . The is a common starling , and the of the . The is a common and white @-@ shaped , and the is a . The is a common species of the , and the of the . The is a of the , and the , and the is a . The is a common starling , and the is a . The is a common starling , and the is a .'
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='The', temperature=.5))
...
'Republic of the Year . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was a first @-@ game @-@ class , which has been the first game of the final single in the UK . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = In the 20th century , the first time the game follows the second @-@ game game . The game was named in the first game of the first half of the first time . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game received the first time in the second season . = = Valkyria Valkyria Valkyria Season description Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The game was originally found on the first time of the game , and the ball is a of the . A player , a of the @-@ @-@ is a subtle , which is a @-@ shaped , and the longest measure . It is a common @-@ shaped game , which is the first @-@ selling @-@ game @-@ sounding @-@ game . = The game \'s first first a score of 2 @.@ 4 % of the game , and the player was the first first game . = The game was also the first time in the middle of the world , but it was one of the first time to the game . It is a possible of the seven @-@ yard competition , which was also made , with the first time to the game . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The first quarter of the game was presented by the of the United Kingdom . = = Valkyria Valkyria Valkyria First World Valkyria Valkyria Valkyria = = The Tide was the first time of the series , but his first appearance in the first half of the first year , the first time . In the first time , Jordan also served as a " @-@ Star " . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The next year , the series was the second game in the second quarter . The first game was the first time to the game . With the first time , the race was also helped to be a member of the Year . In the 1990s , the first team was named in NBA , and the team had to be a long @-@ half @-@ old @-@ run . The Bulls received a game for the second quarter , and the Phillies lost from the second quarter . The second game was able to return to the quarter , and the ball was unable to leave the ball . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The final season was selected to the second quarter to the first time of the season . = A number of seven @-@ year , the game was a focus in the NBA . = = Valkyria Valkyria Valkyria = East Carolina \'s first week , the United States in the United States , the of the Republic of Ireland , most of the second place in the region of the Irish Sea , and the kakapo was . It was also known as a large @-@ scale , and the was the first ever of the East Sea , and the second half of the Irish population was located in Ireland . The most of the city \'s body was also known as the city of the eastern Korean and the United States . The 766th was named the East of the Republic of Ireland , and the island was also a member of the Irish and Irish . The Irish Republic of the Irish authorities became a large @-@ scale area , and the primary use of the city of Ireland . = The National Forest \'s body of the was named as the of the city of the Irish , and of the by the city of the city . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = In the mid @-@ 19th century , the kakapo was also known as a member of the Portuguese . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The kakapo was the first known to be on the island of the island . It was a large @-@ system of the state of the population of the city . The Fastra II is a large @-@ seat species of the city of the city . = The kakapo is a first known of the Irish and the of the Republic of Ireland . The kakapo is be named in the area . = = Valkyria Valkyria Valkyria Valkyria = Valkyria Valkyria Valkyria Valkyria = = The common starling is a common starling , and the of the is a large of . It is intact in the first time of the summer of the winter . It is the first name of the common starling , which is a common and . It is a common centre of the kakapo in the . The , and is a larger and , which is a of and . This species is a " " and " " . = = Valkyria Valkyria Valkyria Valkyria Valkyria Valkyria = = The common starling , the island is the species of the of the , which is also known as a ( ) , and the ( ) ( ) , ( US 5 ) , and the of ( ) , which is a common starling in a small species . The fox was expected to be in the of the of the . = = Valkyria Valkyria Valkyria Taxonomy Valkyria Valkyria Valkyria = = The kakapo is a large species of the original'
>>> import torch
... from data import Corpus
... from generate import generate_words
... from model import RNNModel
... 
... corpus = Corpus('data/wikitext-2')
... vocab = corpus.dictionary
... with open('model.pt', 'rb') as f:
...     model = torch.load(f, map_location='cpu')
... state_dict = model.state_dict()
... 
... model = RNNModel('GRU', vocab=corpus.dictionary, num_layers=1)
... model.load_state_dict(state_dict)
... ' '.join(generate_words(model=model, vocab=vocab, prompt='The', temperature=1))
...
'to switch . The viaduct has been destroying 312 , several held the island to all control . With a wide unit pass from Isabela guitar complex . The average lane over 1 calculators , relapsed octagonal rotation and Rajamouli thought to see a bomb floor until a short position . In it , only this restricted account was considering about six innings \'s crown of Kleinman ( 1858 ) , where others can touch in the liking . Another ninth entries needed on love of humans were carried in a challenge to 24 % of V . Using the Hudson \'s implications , no longer and mobility , such as red groups and Firstly , Spanish African government , ben transit include Metallica platinum . Having devoid earth level , that would Seems saying " Fish faced , and then I have unhappy before even it am necessarily . " = = Valkyria Valkyria Valkyria Mongols and Ireland Valkyria Valkyria Valkyria = = During the night of 1942 , Durham of Minnesota died , on 14 December 1974 , he was named No. kilometres ( 1922 ) to 22 weeks . It was shipment and land at number a 13 @,@ 000 stage , and , Somerset and other practices led five audiences . Since the continuing play was 550 against Lochmarne , the worst of hire Johnson would be made to significant and large intervals . Though continued water generated at Narvik , Veracruz , was published in 1964 the possibility of the Great Slam wound , which suggests that it was successful for the night , as complete " atmosphere that are and metallic " , and drops a sprint , continuous bird released at the perimeter . = Its other feature company played gifted for in Europe but favor of results , because they was not judged that could stay over for other years in the opening of the Conference of In California . Its capacity of even 348 could represent one kick from Sweden . However , this time was viewed as , and F. of the Royal United States . In 1937 , the Revenue Theatre called the subject . Families also moved the terminal Center of Bradford , which began so no Con in the first programming to look from dose . A French government had developed independently with Ímar \'s control of and saints . Though Mercedes Disease 29 @,@ 500 , acting declined , the south of John and certainty Allosaurus Wildside Ellis assumed in most renowned flat . = = Valkyria Valkyria Valkyria Opera Valkyria Valkyria Valkyria = = The vipers of the Italian 2 , Omar of Totten headquarters . The church bill ( the 1st Eastern History of Historic International ) resulted throughout three years due to public with a 5 % of Hawaii . The light Mahé lightest might support much of large control of other types . Taking the wickets as design , Pennsylvania and specialist peckii introduced patterns in the buildings and and then populations of air terms . Since the first election , the unidentified joystick Raid of the populations League aircraft was known as the Wild deck . = It was mainly seen in the early 18th century , mostly on New Zealand , approximately 23 @,@ 000 tons ( 1929 to 1 @,@ ) of the arts Concession , ( local and governed dwelt @-@ hooks , marred , and afraid of sediment ) emerged , or the raid . The Osbourne bird was sufficiently in upland of Okeechobee so , because they testing of a conventional single . The athlete did be licensed and at least secondary ver , rear of the flesh , but the introductory extant Buddhist subjects into the cow , especially several major surface . By 1924 and the end of the mutilation \'s stabilize , their observations , which most of Russian local Jealous were observed , although it was come , due to the young . = In the last year — @-@ Davis was chosen in 1991 , along with the Republic of Saint indicated . Since that brick Gavin announced in conjunction and Tomasevich crews " troops " have is horsemanship in all irregularities . = = Valkyria Valkyria Valkyria Valkyria = = The feathers of the Butetown of the Irish Department is Blanche , is designated as an ruins of friction are existed on the surface and two years . ( mysterious have been probably the oldest popular execution of both structures by 1131 even facing with the moon in ) . It was accompanied by Lord batches , when Ímar died Draper , lands of noisy Arabia , which as many species would have been interpreted daily and numerous parts of gregarious bodies . = Over 14 @,@ 000 : An banned highest concern , sizes should have been in a free adult previous death . There was a probably very common musician , mid @-@ northward , and the kakapo was of 1233 . Nasor worldwide , extremely withdrew with a imperial historic denomination in England . = = Valkyria Valkyria Cultural intersections Valkyria Valkyria = = In 1936 : Gates sees the destinations in the West Army downwards experienced five @-@ religious consequences in 2009 . In the 1860s to Operation new Conservation have been developed by Kitsune , notably its first in one century , but was specific in , which Wars involved two counties and are introduced on 5 U per winds . These areas visits Scotland by The church in 1100 roofs on 28 races . This means have been throughout students , all one @-@ kakapo agent with the inside Dublin to lbw their forward , which includes their a new of Bodashtart in kṣetra — significant large wood , depending on a red Curtain , that the Protein has been lies to assist . It was found in the city , and the Sun is the KPA \'s headquartered . In the 1990s , the kakapo was generally cut at either and more ( mainly ) , and'
>>> more data/wikitext-2/train.txt
>>> tail -n 100 data/wikitext-2/train.txt
>>> !tail data/wikitext-2/train.txt -n 100
>>> !tail data/wikitext-2/train.txt -n 120
>>> !tail data/wikitext-2/train.txt -n 120 | head -n 20
>>> !tail data/wikitext-2/train.txt -n 150 | head -n 20
>>> !tail data/wikitext-2/train.txt -n 130 | head -n 20
>>> !tail data/wikitext-2/train.txt -n 131 | head -n 20
>>> !tail data/wikitext-2/train.txt -n 131 | head -n 3
>>> !tail data/wikitext-2/train.txt -n 133 | head -n 3
>>> !tail data/wikitext-2/train.txt -n 133 | head -n 10
>>> dicts = list(jsonlines.open(fn))
>>> fn = 'checkpoint_notes/grid_search/experiments_288.jsonl'
>>> dicts = list(jsonlines.open(fn))
>>> import jsonlines
>>> dicts = list(jsonlines.open(fn))
>>> df = pd.DataFrame(dicts)
>>> imoprt pandas as pd
>>> import pandas as pd
>>> df = pd.DataFrame(dicts)
>>> gru = gru[gru.columns[7:]]
>>> gru = gru[gru.columns[7:]]
>>> gru = df[df['rnn_type'] == 'GRU'].sort_values('test_loss')
>>> grus = df[df['rnn_type'] == 'GRU'].sort_values('test_loss')
>>> grus = grus[grus['epoch_num'] == 12]
>>> grus
     annealing_loss_improvement_pct  batch_size  bptt  ...  val_perplexity  test_loss test_perplexity
181                             1.0          20    35  ...      164.600797   5.029040      152.786207
173                             1.0          20    35  ...      167.287963   5.039337      154.367708
180                             1.0          20    35  ...      166.051358   5.040826      154.597630
172                             1.0          20    35  ...      172.305501   5.059702      157.543611
182                             1.0          20    35  ...      171.983162   5.073595      159.747591
174                             1.0          20    35  ...      174.738534   5.088659      162.172232
188                             1.0          20    35  ...      182.479818   5.126139      168.365867
189                             1.0          20    35  ...      188.757570   5.158376      173.881881
190                             1.0          20    35  ...      195.118809   5.195966      180.542492
183                             1.0          20    35  ...      210.361175   5.268724      194.167985
175                             1.0          20    35  ...      221.755943   5.319789      204.340800
191                             1.0          20    35  ...      227.605081   5.348964      210.390122
176                             1.0          20    35  ...      261.070859   5.481936      240.311535
177                             1.0          20    35  ...      262.807951   5.487142      241.565748
178                             1.0          20    35  ...      271.243854   5.522726      250.316544
185                             1.0          20    35  ...      275.394850   5.531738      252.582457
184                             1.0          20    35  ...      275.813008   5.538518      254.300786
168                             1.0          20    35  ...      278.674009   5.549408      257.085438
186                             1.0          20    35  ...      294.984791   5.611300      273.499523
169                             1.0          20    35  ...      304.489565   5.637793      280.842304
170                             1.0          20    35  ...      320.777940   5.690630      296.080207
179                             1.0          20    35  ...      326.589644   5.707709      301.180202
187                             1.0          20    35  ...      357.906204   5.801738      330.874051
171                             1.0          20    35  ...      377.621658   5.857712      349.922651

[24 rows x 29 columns]
>>> grus['num_parameters']
>>> grus['parameters']
>>> grus.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'dropout', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'num_layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'epoch_time', 'val_loss', 'val_perplexity', 'test_loss',
       'test_perplexity'],
      dtype='object')
>>> df = pd.read_csv('checkpoint_notes/random_search/experiment_grid_shuffled.csv')
>>> df
     Unnamed: 0  hidden_size  epochs  rnn_type  dropout   lr  num_layers
0           207          200      12       GRU      0.5  2.0           3
1           249          200      32  RNN_TANH      0.0  2.0           5
2           240          200      32  RNN_TANH      0.0  0.5           1
3           227          200      12      LSTM      0.2  2.0           3
4           223          200      12      LSTM      0.2  0.5           4
..          ...          ...     ...       ...      ...  ...         ...
355         350          200      32      LSTM      0.5  0.5           1
356          39          200       1  RNN_RELU      0.0  2.0           5
357          34          200       1  RNN_RELU      0.0  0.5           5
358         288          200      32  RNN_RELU      0.2  2.0           4
359          65          200       1       GRU      0.0  2.0           1

[360 rows x 7 columns]
>>> ls checkpoint_notes
>>> ls checkpoint_notes/grid_search/
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiment_plan_288_ch08.csv')
>>> df
     Unnamed: 0  hidden  rnn_type  epochs  dropout   lr  layers
0             0     200  RNN_TANH       1      0.0  0.5       1
1             1     200  RNN_TANH       1      0.0  0.5       2
2             2     200  RNN_TANH       1      0.0  0.5       3
3             3     200  RNN_TANH       1      0.0  0.5       5
4             4     200  RNN_TANH       1      0.0  2.0       1
..          ...     ...       ...     ...      ...  ...     ...
283         283     200      LSTM      32      0.5  0.5       5
284         284     200      LSTM      32      0.5  2.0       1
285         285     200      LSTM      32      0.5  2.0       2
286         286     200      LSTM      32      0.5  2.0       3
287         287     200      LSTM      32      0.5  2.0       5

[288 rows x 7 columns]
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiment_plan_288_ch08.csv', index=False)
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiment_plan_288_ch08.csv', index=None)
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiment_plan_288_ch08.csv', index_col=0)
>>> df
     hidden  rnn_type  epochs  dropout   lr  layers
0       200  RNN_TANH       1      0.0  0.5       1
1       200  RNN_TANH       1      0.0  0.5       2
2       200  RNN_TANH       1      0.0  0.5       3
3       200  RNN_TANH       1      0.0  0.5       5
4       200  RNN_TANH       1      0.0  2.0       1
..      ...       ...     ...      ...  ...     ...
283     200      LSTM      32      0.5  0.5       5
284     200      LSTM      32      0.5  2.0       1
285     200      LSTM      32      0.5  2.0       2
286     200      LSTM      32      0.5  2.0       3
287     200      LSTM      32      0.5  2.0       5

[288 rows x 6 columns]
>>> ls checkpoint_notes/grid_search/
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiments_gru.csv', index_col=0)
>>> df
     annealing_loss_improvement_pct  batch_size  ...  learned_parameters  total_time
0                               1.0          20  ...            13424878     22.6788
1                               1.0          20  ...            13505278     32.1066
2                               1.0          20  ...            13585678     38.0426
3                               1.0          20  ...            13746478     55.4573
4                               1.0          20  ...            13424878     22.6129
..                              ...         ...  ...                 ...         ...
191                             1.0          20  ...            14550478    867.3180
192                             1.0          20  ...            13585678    744.9600
193                             1.0          20  ...            13826878   1067.2000
194                             1.0          20  ...            14068078   1274.9344
195                             1.0          20  ...            14550478   1897.3696

[196 rows x 31 columns]
>>> df.sort_values('learned_parameters')
     annealing_loss_improvement_pct  batch_size  ...  learned_parameters  total_time
0                               1.0          20  ...            13424878     22.6788
104                             1.0          20  ...            13424878    273.9144
100                             1.0          20  ...            13424878    271.6788
96                              1.0          20  ...            13424878    271.0644
32                              1.0          20  ...            13424878    272.9640
..                              ...         ...  ...                 ...         ...
183                             1.0          20  ...            14550478    862.2996
175                             1.0          20  ...            14550478    677.0964
163                             1.0          20  ...            14550478     71.8932
155                             1.0          20  ...            14550478     72.4153
195                             1.0          20  ...            14550478   1897.3696

[196 rows x 31 columns]
>>> df['learned_parameters':]
>>> df[['learned_parameters':]]
>>> df[['learned_parameters']]
     learned_parameters
0              13424878
1              13505278
2              13585678
3              13746478
4              13424878
..                  ...
191            14550478
192            13585678
193            13826878
194            14068078
195            14550478

[196 rows x 1 columns]
>>> cols = 'learned_parameters rnn_type epochs lr num_layers dropout epoch_time test_loss'
>>> cols = cols.split()
>>> df[cols].round(2).sort_values('test_loss', ascending=False)
     learned_parameters  rnn_type  epochs   lr  num_layers  dropout  epoch_time  test_loss
3              13746478  RNN_TANH       1  0.5           5      0.0       55.46       6.90
147            14550478       GRU       1  0.5           5      0.0       58.94       6.89
155            14550478       GRU       1  0.5           5      0.2       72.42       6.89
146            14068078       GRU       1  0.5           3      0.0       39.83       6.88
1              13505278  RNN_TANH       1  0.5           2      0.0       32.11       6.84
..                  ...       ...     ...  ...         ...      ...         ...        ...
173            13826878       GRU      12  2.0           2      0.0       33.43       5.04
54             13585678  RNN_TANH      32  2.0           3      0.0       38.78       5.04
181            13826878       GRU      12  2.0           2      0.2       35.69       5.03
133            13505278  RNN_RELU      32  2.0           2      0.2       35.59       5.02
134            13585678  RNN_RELU      32  2.0           3      0.2       46.11       4.99

[196 rows x 8 columns]
>>> dict(zip(
...     'learned_parameters  rnn_type  epochs   lr  num_layers  dropout  epoch_time  test_loss'.split(),
...     'parameters  rnn_type  epochs   lr  layers  drop  time (s)  loss'.split()))
...
{'learned_parameters': 'parameters',
 'rnn_type': 'rnn_type',
 'epochs': 'epochs',
 'lr': 'lr',
 'num_layers': 'layers',
 'dropout': 'drop',
 'epoch_time': 'time',
 'test_loss': '(s)'}
>>> d = _
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> cols = 'parameters  rnn_type  epochs   lr  layers  drop  time (s)  loss'.split()
>>> cols = 'parameters  rnn_type  epochs   lr  layers  drop  sec/epoch  loss'.split()
>>> dicts = list(jsonlines.open(fn))
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiments_gru.csv', index_col=0)
>>> d = dict(zip(
...     'learned_parameters  rnn_type  epochs   lr  num_layers  dropout  epoch_time  test_loss'.split(),
...     'parameters  rnn_type  epochs   lr  layers  drop  time (s)  loss'.split()))
...
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df
     annealing_loss_improvement_pct  batch_size  bptt  ...  test_perplexity  parameters total_time
0                               1.0          20    35  ...         678.4218    13424878    22.6788
1                               1.0          20    35  ...         932.6119    13505278    32.1066
2                               1.0          20    35  ...         781.8629    13585678    38.0426
3                               1.0          20    35  ...         989.5211    13746478    55.4573
4                               1.0          20    35  ...         450.0999    13424878    22.6129
..                              ...         ...   ...  ...              ...         ...        ...
191                             1.0          20    35  ...         210.3901    14550478   867.3180
192                             1.0          20    35  ...         185.4480    13585678   744.9600
193                             1.0          20    35  ...         184.2532    13826878  1067.2000
194                             1.0          20    35  ...         187.2414    14068078  1274.9344
195                             1.0          20    35  ...         221.6713    14550478  1897.3696

[196 rows x 31 columns]
>>> cols = 'parameters  rnn_type  epochs   lr  layers  drop  sec/epoch  total_time loss'.split()
>>> d = dict(zip(
...     'learned_parameters  rnn_type  epochs   lr  num_layers  dropout  epoch_time  total_time test_loss'.split(),
...     'parameters  rnn_type  epochs   lr  layers  drop  sec/epoch total_time  loss'.split()))
...
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> dicts = list(jsonlines.open(fn))
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiments_gru.csv', index_col=0)
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df[cols]
     parameters  rnn_type  epochs   lr  layers  drop  sec/epoch  total_time    loss
0      13424878  RNN_TANH       1  0.5       1   0.0    22.6788     22.6788  6.5198
1      13505278  RNN_TANH       1  0.5       2   0.0    32.1066     32.1066  6.8380
2      13585678  RNN_TANH       1  0.5       3   0.0    38.0426     38.0426  6.6617
3      13746478  RNN_TANH       1  0.5       5   0.0    55.4573     55.4573  6.8972
4      13424878  RNN_TANH       1  2.0       1   0.0    22.6129     22.6129  6.1095
..          ...       ...     ...  ...     ...   ...        ...         ...     ...
191    14550478       GRU      12  2.0       5   0.5    72.2765    867.3180  5.3490
192    13585678       GRU      32  0.5       1   0.0    23.2800    744.9600  5.2228
193    13826878       GRU      32  0.5       2   0.0    33.3500   1067.2000  5.2163
194    14068078       GRU      32  0.5       3   0.0    39.8417   1274.9344  5.2324
195    14550478       GRU      32  0.5       5   0.0    59.2928   1897.3696  5.4012

[196 rows x 9 columns]
>>> df[cols].round(2).sort_values('test_loss')
>>> df[cols].round(2).sort_values('loss')
     parameters  rnn_type  epochs   lr  layers  drop  sec/epoch  total_time  loss
134    13585678  RNN_RELU      32  2.0       3   0.2      46.11     1475.43  4.99
133    13505278  RNN_RELU      32  2.0       2   0.2      35.59     1138.91  5.02
181    13826878       GRU      12  2.0       2   0.2      35.69      428.28  5.03
54     13585678  RNN_TANH      32  2.0       3   0.0      38.78     1240.98  5.04
173    13826878       GRU      12  2.0       2   0.0      33.43      401.15  5.04
..          ...       ...     ...  ...     ...   ...        ...         ...   ...
1      13505278  RNN_TANH       1  0.5       2   0.0      32.11       32.11  6.84
146    14068078       GRU       1  0.5       3   0.0      39.83       39.83  6.88
155    14550478       GRU       1  0.5       5   0.2      72.42       72.42  6.89
147    14550478       GRU       1  0.5       5   0.0      58.94       58.94  6.89
3      13746478  RNN_TANH       1  0.5       5   0.0      55.46       55.46  6.90

[196 rows x 9 columns]
>>> df.to_csv('checkpoint_notes/grid_search/experiments_gru_rename_cols.csv')
>>> df = pd.DataFrame(dicts)
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df[cols].round(2).sort_values('loss')
>>> df
     annealing_loss_improvement_pct  batch_size  bptt  ...  val_perplexity      loss test_perplexity
0                               1.0          20    35  ...      727.693280  6.519769      678.421797
1                               1.0          20    35  ...     1451.106151  6.837989      932.611851
2                               1.0          20    35  ...      838.446364  6.661679      781.862929
3                               1.0          20    35  ...     1054.820222  6.897221      989.521082
4                               1.0          20    35  ...      485.917391  6.109470      450.099917
..                              ...         ...   ...  ...             ...       ...             ...
283                             1.0          20    35  ...      969.318574  6.818156      914.297177
284                             1.0          20    35  ...      157.865979  4.982531      145.843010
285                             1.0          20    35  ...      146.478974  4.924997      137.688873
286                             1.0          20    35  ...      171.007235  5.068405      158.920569
287                             1.0          20    35  ...      966.244920  6.814781      911.217140

[288 rows x 29 columns]
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'drop', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'sec/epoch', 'val_loss', 'val_perplexity', 'loss',
       'test_perplexity'],
      dtype='object')
>>> df['total_time'] = df['sec/epoch'] * df['epochs']
>>> df[cols].round(2).sort_values('loss')
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiment_plan_288_ch08.csv', index_col=0)
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df[cols].round(2).sort_values('loss')
>>> df.columns
Index(['hidden', 'rnn_type', 'epochs', 'drop', 'lr', 'layers'], dtype='object')
>>> df = pd.DataFrame(dicts)
>>> df
     annealing_loss_improvement_pct  batch_size  bptt  ...  val_perplexity  test_loss test_perplexity
0                               1.0          20    35  ...      727.693280   6.519769      678.421797
1                               1.0          20    35  ...     1451.106151   6.837989      932.611851
2                               1.0          20    35  ...      838.446364   6.661679      781.862929
3                               1.0          20    35  ...     1054.820222   6.897221      989.521082
4                               1.0          20    35  ...      485.917391   6.109470      450.099917
..                              ...         ...   ...  ...             ...        ...             ...
283                             1.0          20    35  ...      969.318574   6.818156      914.297177
284                             1.0          20    35  ...      157.865979   4.982531      145.843010
285                             1.0          20    35  ...      146.478974   4.924997      137.688873
286                             1.0          20    35  ...      171.007235   5.068405      158.920569
287                             1.0          20    35  ...      966.244920   6.814781      911.217140

[288 rows x 29 columns]
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'drop', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'sec/epoch', 'val_loss', 'val_perplexity', 'loss',
       'test_perplexity'],
      dtype='object')
>>> df[cols].round(2).sort_values('loss')
>>> cols = 'parameters  rnn_type  epochs   lr  layers  drop  sec/epoch time loss'.split()
>>> df[cols].round(2).sort_values('loss')
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'drop', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'sec/epoch', 'val_loss', 'val_perplexity', 'loss',
       'test_perplexity'],
      dtype='object')
>>> hist -o -p -f checkpoint_notes/hyperparam_tables_ch08.hist.md
>>> df = pd.read_csv('checkpoint_notes/grid_search/experiments_gru.csv', index_col=0)
>>> df.columns = [d.get(c, c) for c in df.columns]
>>> df[cols].round(2).sort_values('loss')
>>> df['time'] = df['total_time']
>>> df[cols].round(2).sort_values('loss')
     parameters  rnn_type  epochs   lr  layers  drop  sec/epoch     time  loss
134    13585678  RNN_RELU      32  2.0       3   0.2      46.11  1475.43  4.99
133    13505278  RNN_RELU      32  2.0       2   0.2      35.59  1138.91  5.02
181    13826878       GRU      12  2.0       2   0.2      35.69   428.28  5.03
54     13585678  RNN_TANH      32  2.0       3   0.0      38.78  1240.98  5.04
173    13826878       GRU      12  2.0       2   0.0      33.43   401.15  5.04
..          ...       ...     ...  ...     ...   ...        ...      ...   ...
1      13505278  RNN_TANH       1  0.5       2   0.0      32.11    32.11  6.84
146    14068078       GRU       1  0.5       3   0.0      39.83    39.83  6.88
155    14550478       GRU       1  0.5       5   0.2      72.42    72.42  6.89
147    14550478       GRU       1  0.5       5   0.0      58.94    58.94  6.89
3      13746478  RNN_TANH       1  0.5       5   0.0      55.46    55.46  6.90

[196 rows x 9 columns]
>>> df.iloc[195]
annealing_loss_improvement_pct                                                    1
batch_size                                                                       20
bptt                                                                             35
clip                                                                           0.25
cuda                                                                           True
datapath                                                          ./data/wikitext-2
device                                                                          NaN
drop                                                                              0
dry_run                                                                       False
emsize                                                                          200
epochs                                                                           32
log_interval                                                                    200
lr                                                                              0.5
rnn_type                                                                        GRU
nhead                                                                             2
hidden_size                                                                     200
layers                                                                            5
onnx_export                                                                     NaN
save                                                                       model.pt
filename                          model_epochs_32_rnn_type_GRU_hidden_size_200_b...
seed                                                                           1111
tied                                                                          False
best_val_loss                                                                5.4923
epoch_num                                                                        32
sec/epoch                                                                   59.2928
val_loss                                                                     5.4784
val_perplexity                                                              239.471
loss                                                                         5.4012
test_perplexity                                                             221.671
parameters                                                                 14550478
total_time                                                                  1897.37
time                                                                        1897.37
Name: 195, dtype: object
>>> df[cols].round(2).sort_values('loss')
     parameters  rnn_type  epochs   lr  layers  drop  sec/epoch     time  loss
134    13585678  RNN_RELU      32  2.0       3   0.2      46.11  1475.43  4.99
133    13505278  RNN_RELU      32  2.0       2   0.2      35.59  1138.91  5.02
181    13826878       GRU      12  2.0       2   0.2      35.69   428.28  5.03
54     13585678  RNN_TANH      32  2.0       3   0.0      38.78  1240.98  5.04
173    13826878       GRU      12  2.0       2   0.0      33.43   401.15  5.04
..          ...       ...     ...  ...     ...   ...        ...      ...   ...
1      13505278  RNN_TANH       1  0.5       2   0.0      32.11    32.11  6.84
146    14068078       GRU       1  0.5       3   0.0      39.83    39.83  6.88
155    14550478       GRU       1  0.5       5   0.2      72.42    72.42  6.89
147    14550478       GRU       1  0.5       5   0.0      58.94    58.94  6.89
3      13746478  RNN_TANH       1  0.5       5   0.0      55.46    55.46  6.90

[196 rows x 9 columns]
>>> df.iloc[197]
>>> fn = 'checkpoint_notes/grid_search/experiments_288.jsonl'
>>> df = pd.DataFrame(list(jsonlines.open(fn)))
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'dropout', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'num_layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'epoch_time', 'val_loss', 'val_perplexity', 'test_loss',
       'test_perplexity'],
      dtype='object')
>>> !find . -name '*.jsonl'
>>> df = pd.DataFrame(list(jsonlines.open('./checkpoint_notes/grid_search/experiments_200.jsonl')))
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'dropout', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'num_layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'epoch_time', 'val_loss', 'val_perplexity', 'test_loss',
       'test_perplexity'],
      dtype='object')
>>> ls checkpoint_notes/grid_search/
>>> more checkpoint_notes/grid_search/experiments.txt
>>> df = pd.DataFrame(list(jsonlines.open('./checkpoint_notes/grid_search/experiments.txt')))
>>> df
    annealing_loss_improvement_pct  batch_size  bptt  ...  val_perplexity  test_loss test_perplexity
0                              1.0          20    35  ...      727.693268   6.519769      678.421806
1                              1.0          20    35  ...     1451.106271   6.837989      932.611907
2                              1.0          20    35  ...      838.446337   6.661679      781.862883
3                              1.0          20    35  ...     1054.820197   6.897221      989.521109
4                              1.0          20    35  ...      485.917391   6.109470      450.099917
5                              1.0          20    35  ...      454.339971   6.031953      416.527841
6                              1.0          20    35  ...      468.660376   6.066403      431.127337
7                              1.0          20    35  ...      503.145485   6.138158      463.199364
8                              1.0          20    35  ...     1021.839217   6.454904      635.812391
9                              1.0          20    35  ...     1803.304605   6.713112      823.128000
10                             1.0          20    35  ...      630.807275   6.373772      586.265065
11                             1.0          20    35  ...      678.239832   6.452274      634.142841
12                             1.0          20    35  ...      498.185914   6.132175      460.436378
13                             1.0          20    35  ...             NaN   6.713112      823.128020
14                             1.0          20    35  ...             NaN   6.373772      586.265059

[15 rows x 29 columns]
>>> df.columns
Index(['annealing_loss_improvement_pct', 'batch_size', 'bptt', 'clip', 'cuda',
       'datapath', 'device', 'dropout', 'dry_run', 'emsize', 'epochs',
       'log_interval', 'lr', 'rnn_type', 'nhead', 'hidden_size', 'num_layers',
       'onnx_export', 'save', 'filename', 'seed', 'tied', 'best_val_loss',
       'epoch_num', 'epoch_time', 'val_loss', 'val_perplexity', 'test_loss',
       'test_perplexity'],
      dtype='object')
>>> df = pd.DataFrame(list(jsonlines.open('./checkpoint_notes/random_search/experiments.txt')))
>>> df = pd.DataFrame(list(jsonlines.open('./checkpoint_notes/random_search/experiment_grid_360.json')))
>>> ls ./checkpoint_notes/random_search/
>>> ls ./checkpoint_notes/
>>> !git log --stat | grep jsonl
>>> ls *.jsonl
>>> ls
>>> !git log --stat | grep jsonl -B6
>>> hist -o -p -f checkpoint_notes/hyperparam_tables_ch08.hist.md
