import setuptools


long_description = """
# Florence API
A python client to access the Florence API.
Florence is a natural language to SQL engine. It is a SaaS product that can be used to build natural language interfaces to SQL databases.
"""

setuptools.setup(
    name="florence-api",
    version="0.5.0",
    author="admin@owl.works",
    author_email="admin@owl.works",
    description="A python client to access the Florence API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/OwlsAtWork/florence",
    project_urls={
        "Bug Tracker": "https://github.com/OwlsAtWork/florence/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "src"},
    packages=setuptools.find_packages(where="src"),
    python_requires=">=3.9",
    install_requires=["requests==2.31.0", "pydantic==1.10.8"]
)
