# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class FlowRuntimeExecution(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowRuntimeExecution - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'flow_version': 'FlowVersion',
            'date_launched': 'datetime',
            'status': 'str',
            'date_completed': 'datetime',
            'completion_reason': 'str',
            'flow_error_info': 'ErrorBody',
            'output_data': 'dict(str, object)',
            'conversation': 'DomainEntityRef',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'flow_version': 'flowVersion',
            'date_launched': 'dateLaunched',
            'status': 'status',
            'date_completed': 'dateCompleted',
            'completion_reason': 'completionReason',
            'flow_error_info': 'flowErrorInfo',
            'output_data': 'outputData',
            'conversation': 'conversation',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._flow_version = None
        self._date_launched = None
        self._status = None
        self._date_completed = None
        self._completion_reason = None
        self._flow_error_info = None
        self._output_data = None
        self._conversation = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this FlowRuntimeExecution.
        The flow execution ID

        :return: The id of this FlowRuntimeExecution.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowRuntimeExecution.
        The flow execution ID

        :param id: The id of this FlowRuntimeExecution.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FlowRuntimeExecution.
        The flow execution name.

        :return: The name of this FlowRuntimeExecution.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FlowRuntimeExecution.
        The flow execution name.

        :param name: The name of this FlowRuntimeExecution.
        :type: str
        """
        
        self._name = name

    @property
    def flow_version(self):
        """
        Gets the flow_version of this FlowRuntimeExecution.
        The Version of the flow definition of the flow execution.

        :return: The flow_version of this FlowRuntimeExecution.
        :rtype: FlowVersion
        """
        return self._flow_version

    @flow_version.setter
    def flow_version(self, flow_version):
        """
        Sets the flow_version of this FlowRuntimeExecution.
        The Version of the flow definition of the flow execution.

        :param flow_version: The flow_version of this FlowRuntimeExecution.
        :type: FlowVersion
        """
        
        self._flow_version = flow_version

    @property
    def date_launched(self):
        """
        Gets the date_launched of this FlowRuntimeExecution.
        The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_launched of this FlowRuntimeExecution.
        :rtype: datetime
        """
        return self._date_launched

    @date_launched.setter
    def date_launched(self, date_launched):
        """
        Sets the date_launched of this FlowRuntimeExecution.
        The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_launched: The date_launched of this FlowRuntimeExecution.
        :type: datetime
        """
        
        self._date_launched = date_launched

    @property
    def status(self):
        """
        Gets the status of this FlowRuntimeExecution.
        The flow's running status, which indicates whether the flow is running normally or completed, etc.

        :return: The status of this FlowRuntimeExecution.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this FlowRuntimeExecution.
        The flow's running status, which indicates whether the flow is running normally or completed, etc.

        :param status: The status of this FlowRuntimeExecution.
        :type: str
        """
        allowed_values = ["UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED", "FAILED"]
        if status.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for status -> " + status
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def date_completed(self):
        """
        Gets the date_completed of this FlowRuntimeExecution.
        The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_completed of this FlowRuntimeExecution.
        :rtype: datetime
        """
        return self._date_completed

    @date_completed.setter
    def date_completed(self, date_completed):
        """
        Sets the date_completed of this FlowRuntimeExecution.
        The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_completed: The date_completed of this FlowRuntimeExecution.
        :type: datetime
        """
        
        self._date_completed = date_completed

    @property
    def completion_reason(self):
        """
        Gets the completion_reason of this FlowRuntimeExecution.
        The completion reason set at the flow completion time, if applicable.

        :return: The completion_reason of this FlowRuntimeExecution.
        :rtype: str
        """
        return self._completion_reason

    @completion_reason.setter
    def completion_reason(self, completion_reason):
        """
        Sets the completion_reason of this FlowRuntimeExecution.
        The completion reason set at the flow completion time, if applicable.

        :param completion_reason: The completion_reason of this FlowRuntimeExecution.
        :type: str
        """
        
        self._completion_reason = completion_reason

    @property
    def flow_error_info(self):
        """
        Gets the flow_error_info of this FlowRuntimeExecution.
        Additional information if the flow is in error

        :return: The flow_error_info of this FlowRuntimeExecution.
        :rtype: ErrorBody
        """
        return self._flow_error_info

    @flow_error_info.setter
    def flow_error_info(self, flow_error_info):
        """
        Sets the flow_error_info of this FlowRuntimeExecution.
        Additional information if the flow is in error

        :param flow_error_info: The flow_error_info of this FlowRuntimeExecution.
        :type: ErrorBody
        """
        
        self._flow_error_info = flow_error_info

    @property
    def output_data(self):
        """
        Gets the output_data of this FlowRuntimeExecution.
        List of the flow's output variables, if any. Output variables are only supplied for Completed flows.

        :return: The output_data of this FlowRuntimeExecution.
        :rtype: dict(str, object)
        """
        return self._output_data

    @output_data.setter
    def output_data(self, output_data):
        """
        Sets the output_data of this FlowRuntimeExecution.
        List of the flow's output variables, if any. Output variables are only supplied for Completed flows.

        :param output_data: The output_data of this FlowRuntimeExecution.
        :type: dict(str, object)
        """
        
        self._output_data = output_data

    @property
    def conversation(self):
        """
        Gets the conversation of this FlowRuntimeExecution.
        The conversation to which this Flow execution is related

        :return: The conversation of this FlowRuntimeExecution.
        :rtype: DomainEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this FlowRuntimeExecution.
        The conversation to which this Flow execution is related

        :param conversation: The conversation of this FlowRuntimeExecution.
        :type: DomainEntityRef
        """
        
        self._conversation = conversation

    @property
    def self_uri(self):
        """
        Gets the self_uri of this FlowRuntimeExecution.
        The URI for this object

        :return: The self_uri of this FlowRuntimeExecution.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this FlowRuntimeExecution.
        The URI for this object

        :param self_uri: The self_uri of this FlowRuntimeExecution.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

