# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CoachingAppointmentStatusDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CoachingAppointmentStatusDto - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'appointment': 'CoachingAppointmentReference',
            'created_by': 'UserReference',
            'date_created': 'datetime',
            'status': 'str'
        }

        self.attribute_map = {
            'appointment': 'appointment',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'status': 'status'
        }

        self._appointment = None
        self._created_by = None
        self._date_created = None
        self._status = None

    @property
    def appointment(self):
        """
        Gets the appointment of this CoachingAppointmentStatusDto.
        The coaching appointment this status belongs to

        :return: The appointment of this CoachingAppointmentStatusDto.
        :rtype: CoachingAppointmentReference
        """
        return self._appointment

    @appointment.setter
    def appointment(self, appointment):
        """
        Sets the appointment of this CoachingAppointmentStatusDto.
        The coaching appointment this status belongs to

        :param appointment: The appointment of this CoachingAppointmentStatusDto.
        :type: CoachingAppointmentReference
        """
        
        self._appointment = appointment

    @property
    def created_by(self):
        """
        Gets the created_by of this CoachingAppointmentStatusDto.
        User who updated the status

        :return: The created_by of this CoachingAppointmentStatusDto.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this CoachingAppointmentStatusDto.
        User who updated the status

        :param created_by: The created_by of this CoachingAppointmentStatusDto.
        :type: UserReference
        """
        
        self._created_by = created_by

    @property
    def date_created(self):
        """
        Gets the date_created of this CoachingAppointmentStatusDto.
        Creation time of the status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this CoachingAppointmentStatusDto.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this CoachingAppointmentStatusDto.
        Creation time of the status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this CoachingAppointmentStatusDto.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def status(self):
        """
        Gets the status of this CoachingAppointmentStatusDto.
        The status of the coaching appointment

        :return: The status of this CoachingAppointmentStatusDto.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CoachingAppointmentStatusDto.
        The status of the coaching appointment

        :param status: The status of this CoachingAppointmentStatusDto.
        :type: str
        """
        allowed_values = ["Scheduled", "InProgress", "Completed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for status -> " + status
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

