# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AnalyticsMediaEndpointStat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AnalyticsMediaEndpointStat - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'codecs': 'list[str]',
            'min_mos': 'float',
            'min_r_factor': 'float',
            'max_latency_ms': 'int',
            'received_packets': 'int',
            'invalid_packets': 'int',
            'discarded_packets': 'int',
            'duplicate_packets': 'int',
            'overrun_packets': 'int',
            'underrun_packets': 'int'
        }

        self.attribute_map = {
            'codecs': 'codecs',
            'min_mos': 'minMos',
            'min_r_factor': 'minRFactor',
            'max_latency_ms': 'maxLatencyMs',
            'received_packets': 'receivedPackets',
            'invalid_packets': 'invalidPackets',
            'discarded_packets': 'discardedPackets',
            'duplicate_packets': 'duplicatePackets',
            'overrun_packets': 'overrunPackets',
            'underrun_packets': 'underrunPackets'
        }

        self._codecs = None
        self._min_mos = None
        self._min_r_factor = None
        self._max_latency_ms = None
        self._received_packets = None
        self._invalid_packets = None
        self._discarded_packets = None
        self._duplicate_packets = None
        self._overrun_packets = None
        self._underrun_packets = None

    @property
    def codecs(self):
        """
        Gets the codecs of this AnalyticsMediaEndpointStat.
        The MIME types of the audio encodings used by the audio streams belonging to this endpoint

        :return: The codecs of this AnalyticsMediaEndpointStat.
        :rtype: list[str]
        """
        return self._codecs

    @codecs.setter
    def codecs(self, codecs):
        """
        Sets the codecs of this AnalyticsMediaEndpointStat.
        The MIME types of the audio encodings used by the audio streams belonging to this endpoint

        :param codecs: The codecs of this AnalyticsMediaEndpointStat.
        :type: list[str]
        """
        
        self._codecs = codecs

    @property
    def min_mos(self):
        """
        Gets the min_mos of this AnalyticsMediaEndpointStat.
        The lowest estimated average MOS among all the audio streams belonging to this endpoint

        :return: The min_mos of this AnalyticsMediaEndpointStat.
        :rtype: float
        """
        return self._min_mos

    @min_mos.setter
    def min_mos(self, min_mos):
        """
        Sets the min_mos of this AnalyticsMediaEndpointStat.
        The lowest estimated average MOS among all the audio streams belonging to this endpoint

        :param min_mos: The min_mos of this AnalyticsMediaEndpointStat.
        :type: float
        """
        
        self._min_mos = min_mos

    @property
    def min_r_factor(self):
        """
        Gets the min_r_factor of this AnalyticsMediaEndpointStat.
        The lowest R-factor value among all of the audio streams belonging to this endpoint

        :return: The min_r_factor of this AnalyticsMediaEndpointStat.
        :rtype: float
        """
        return self._min_r_factor

    @min_r_factor.setter
    def min_r_factor(self, min_r_factor):
        """
        Sets the min_r_factor of this AnalyticsMediaEndpointStat.
        The lowest R-factor value among all of the audio streams belonging to this endpoint

        :param min_r_factor: The min_r_factor of this AnalyticsMediaEndpointStat.
        :type: float
        """
        
        self._min_r_factor = min_r_factor

    @property
    def max_latency_ms(self):
        """
        Gets the max_latency_ms of this AnalyticsMediaEndpointStat.
        The maximum latency experienced by any audio stream belonging to this endpoint, in milliseconds

        :return: The max_latency_ms of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._max_latency_ms

    @max_latency_ms.setter
    def max_latency_ms(self, max_latency_ms):
        """
        Sets the max_latency_ms of this AnalyticsMediaEndpointStat.
        The maximum latency experienced by any audio stream belonging to this endpoint, in milliseconds

        :param max_latency_ms: The max_latency_ms of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._max_latency_ms = max_latency_ms

    @property
    def received_packets(self):
        """
        Gets the received_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received for all audio streams belonging to this endpoint (includes invalid, duplicate, and discarded packets)

        :return: The received_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._received_packets

    @received_packets.setter
    def received_packets(self, received_packets):
        """
        Sets the received_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received for all audio streams belonging to this endpoint (includes invalid, duplicate, and discarded packets)

        :param received_packets: The received_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._received_packets = received_packets

    @property
    def invalid_packets(self):
        """
        Gets the invalid_packets of this AnalyticsMediaEndpointStat.
        The total number of malformed or not RTP packets, unknown payload type, or discarded probation packets for all audio streams belonging to this endpoint

        :return: The invalid_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._invalid_packets

    @invalid_packets.setter
    def invalid_packets(self, invalid_packets):
        """
        Sets the invalid_packets of this AnalyticsMediaEndpointStat.
        The total number of malformed or not RTP packets, unknown payload type, or discarded probation packets for all audio streams belonging to this endpoint

        :param invalid_packets: The invalid_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._invalid_packets = invalid_packets

    @property
    def discarded_packets(self):
        """
        Gets the discarded_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received too late or too early, jitter queue overrun or underrun, for all audio streams belonging to this endpoint

        :return: The discarded_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._discarded_packets

    @discarded_packets.setter
    def discarded_packets(self, discarded_packets):
        """
        Sets the discarded_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received too late or too early, jitter queue overrun or underrun, for all audio streams belonging to this endpoint

        :param discarded_packets: The discarded_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._discarded_packets = discarded_packets

    @property
    def duplicate_packets(self):
        """
        Gets the duplicate_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received with the same sequence number as another one recently received (window of 64 packets), for all audio streams belonging to this endpoint

        :return: The duplicate_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._duplicate_packets

    @duplicate_packets.setter
    def duplicate_packets(self, duplicate_packets):
        """
        Sets the duplicate_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received with the same sequence number as another one recently received (window of 64 packets), for all audio streams belonging to this endpoint

        :param duplicate_packets: The duplicate_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._duplicate_packets = duplicate_packets

    @property
    def overrun_packets(self):
        """
        Gets the overrun_packets of this AnalyticsMediaEndpointStat.
        The total number of packets for which there was no room in the jitter queue when it was received, for all audio streams belonging to this endpoint (also counted in discarded)

        :return: The overrun_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._overrun_packets

    @overrun_packets.setter
    def overrun_packets(self, overrun_packets):
        """
        Sets the overrun_packets of this AnalyticsMediaEndpointStat.
        The total number of packets for which there was no room in the jitter queue when it was received, for all audio streams belonging to this endpoint (also counted in discarded)

        :param overrun_packets: The overrun_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._overrun_packets = overrun_packets

    @property
    def underrun_packets(self):
        """
        Gets the underrun_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received after their timestamp/seqnum has been played out, for all audio streams belonging to this endpoint (also counted in discarded)

        :return: The underrun_packets of this AnalyticsMediaEndpointStat.
        :rtype: int
        """
        return self._underrun_packets

    @underrun_packets.setter
    def underrun_packets(self, underrun_packets):
        """
        Sets the underrun_packets of this AnalyticsMediaEndpointStat.
        The total number of packets received after their timestamp/seqnum has been played out, for all audio streams belonging to this endpoint (also counted in discarded)

        :param underrun_packets: The underrun_packets of this AnalyticsMediaEndpointStat.
        :type: int
        """
        
        self._underrun_packets = underrun_packets

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

