"""
    Perun RPC API

    Perun Remote Procedure Calls Application Programming Interface  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Contact: perun@cesnet.cz
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from perun.connector.perun_openapi.api_client import ApiClient, Endpoint as _Endpoint
from perun.connector.perun_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from perun.connector.perun_openapi.model.input_create_member_for_candidate import InputCreateMemberForCandidate
from perun.connector.perun_openapi.model.input_create_member_for_user import InputCreateMemberForUser
from perun.connector.perun_openapi.model.input_create_member_from_ext_source import InputCreateMemberFromExtSource
from perun.connector.perun_openapi.model.input_create_sponsored_member import InputCreateSponsoredMember
from perun.connector.perun_openapi.model.input_create_sponsored_member_from_csv import InputCreateSponsoredMemberFromCSV
from perun.connector.perun_openapi.model.input_create_sponsored_members import InputCreateSponsoredMembers
from perun.connector.perun_openapi.model.input_get_paginated_members import InputGetPaginatedMembers
from perun.connector.perun_openapi.model.input_set_sponsored_member import InputSetSponsoredMember
from perun.connector.perun_openapi.model.input_specific_member import InputSpecificMember
from perun.connector.perun_openapi.model.member import Member
from perun.connector.perun_openapi.model.member_with_sponsors import MemberWithSponsors
from perun.connector.perun_openapi.model.namespace_rules import NamespaceRules
from perun.connector.perun_openapi.model.paginated_rich_members import PaginatedRichMembers
from perun.connector.perun_openapi.model.perun_exception import PerunException
from perun.connector.perun_openapi.model.rich_member import RichMember
from perun.connector.perun_openapi.model.rich_user import RichUser
from perun.connector.perun_openapi.model.vo_member_statuses import VoMemberStatuses


class MembersManagerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.can_extend_membership_endpoint = _Endpoint(
            settings={
                'response_type': (bool,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/canExtendMembership',
                'operation_id': 'can_extend_membership',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                ],
                'required': [
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                },
                'attribute_map': {
                    'member': 'member',
                },
                'location_map': {
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_member_for_candidate_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createMember/c',
                'operation_id': 'create_member_for_candidate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_member_for_candidate',
                ],
                'required': [
                    'input_create_member_for_candidate',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_member_for_candidate':
                        (InputCreateMemberForCandidate,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_member_for_candidate': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_member_for_user_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createMember/u',
                'operation_id': 'create_member_for_user',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_member_for_user',
                ],
                'required': [
                    'input_create_member_for_user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_member_for_user':
                        (InputCreateMemberForUser,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_member_for_user': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_member_from_ext_source_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createMember/extSource',
                'operation_id': 'create_member_from_ext_source',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_member_from_ext_source',
                ],
                'required': [
                    'input_create_member_from_ext_source',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_member_from_ext_source':
                        (InputCreateMemberFromExtSource,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_member_from_ext_source': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_specific_member_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createSpecificMember',
                'operation_id': 'create_specific_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_specific_member',
                ],
                'required': [
                    'input_specific_member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_specific_member':
                        (InputSpecificMember,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_specific_member': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sponsored_member_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createSponsoredMember/withFullName',
                'operation_id': 'create_sponsored_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_sponsored_member',
                ],
                'required': [
                    'input_create_sponsored_member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_sponsored_member':
                        (InputCreateSponsoredMember,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_sponsored_member': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sponsored_members_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (str,)}],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createSponsoredMembers',
                'operation_id': 'create_sponsored_members',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_sponsored_members',
                ],
                'required': [
                    'input_create_sponsored_members',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_sponsored_members':
                        (InputCreateSponsoredMembers,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_sponsored_members': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sponsored_members_from_csv_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (str,)}],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/createSponsoredMembersFromCSV',
                'operation_id': 'create_sponsored_members_from_csv',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_create_sponsored_member_from_csv',
                ],
                'required': [
                    'input_create_sponsored_member_from_csv',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_create_sponsored_member_from_csv':
                        (InputCreateSponsoredMemberFromCSV,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_create_sponsored_member_from_csv': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_member_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/deleteMember',
                'operation_id': 'delete_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                ],
                'required': [
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                },
                'attribute_map': {
                    'member': 'member',
                },
                'location_map': {
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_members_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/deleteMembers',
                'operation_id': 'delete_members',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'members',
                ],
                'required': [
                    'members',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'members':
                        ([int],),
                },
                'attribute_map': {
                    'members': 'members[]',
                },
                'location_map': {
                    'members': 'query',
                },
                'collection_format_map': {
                    'members': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.extend_membership_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/extendMembership',
                'operation_id': 'extend_membership',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                ],
                'required': [
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                },
                'attribute_map': {
                    'member': 'member',
                },
                'location_map': {
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_complete_rich_members_by_attributes_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/findCompleteRichMembers/attrs',
                'operation_id': 'find_complete_rich_members_by_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'attrs_names',
                    'search_string',
                    'allowed_statuses',
                ],
                'required': [
                    'attrs_names',
                    'search_string',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'attrs_names':
                        ([str],),
                    'search_string':
                        (str,),
                    'allowed_statuses':
                        ([str],),
                },
                'attribute_map': {
                    'attrs_names': 'attrsNames[]',
                    'search_string': 'searchString',
                    'allowed_statuses': 'allowedStatuses[]',
                },
                'location_map': {
                    'attrs_names': 'query',
                    'search_string': 'query',
                    'allowed_statuses': 'query',
                },
                'collection_format_map': {
                    'attrs_names': 'multi',
                    'allowed_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_complete_rich_members_for_group_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/findCompleteRichMembers/g',
                'operation_id': 'find_complete_rich_members_for_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group',
                    'attrs_names',
                    'search_string',
                    'looking_in_parent_group',
                    'allowed_statuses',
                    'allowed_group_statuses',
                ],
                'required': [
                    'group',
                    'attrs_names',
                    'search_string',
                    'looking_in_parent_group',
                ],
                'nullable': [
                ],
                'enum': [
                    'allowed_group_statuses',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('allowed_group_statuses',): {

                        "VALID": "VALID",
                        "EXPIRED": "EXPIRED"
                    },
                },
                'openapi_types': {
                    'group':
                        (int,),
                    'attrs_names':
                        ([str],),
                    'search_string':
                        (str,),
                    'looking_in_parent_group':
                        (bool,),
                    'allowed_statuses':
                        ([str],),
                    'allowed_group_statuses':
                        ([str],),
                },
                'attribute_map': {
                    'group': 'group',
                    'attrs_names': 'attrsNames[]',
                    'search_string': 'searchString',
                    'looking_in_parent_group': 'lookingInParentGroup',
                    'allowed_statuses': 'allowedStatuses[]',
                    'allowed_group_statuses': 'allowedGroupStatuses[]',
                },
                'location_map': {
                    'group': 'query',
                    'attrs_names': 'query',
                    'search_string': 'query',
                    'looking_in_parent_group': 'query',
                    'allowed_statuses': 'query',
                    'allowed_group_statuses': 'query',
                },
                'collection_format_map': {
                    'attrs_names': 'multi',
                    'allowed_statuses': 'multi',
                    'allowed_group_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_complete_rich_members_for_vo_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/findCompleteRichMembers/v',
                'operation_id': 'find_complete_rich_members_for_vo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'attrs_names',
                    'search_string',
                    'allowed_statuses',
                ],
                'required': [
                    'vo',
                    'attrs_names',
                    'search_string',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'attrs_names':
                        ([str],),
                    'search_string':
                        (str,),
                    'allowed_statuses':
                        ([str],),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'attrs_names': 'attrsNames[]',
                    'search_string': 'searchString',
                    'allowed_statuses': 'allowedStatuses[]',
                },
                'location_map': {
                    'vo': 'query',
                    'attrs_names': 'query',
                    'search_string': 'query',
                    'allowed_statuses': 'query',
                },
                'collection_format_map': {
                    'attrs_names': 'multi',
                    'allowed_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_members_in_vo_endpoint = _Endpoint(
            settings={
                'response_type': ([Member],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/findMembersInVo',
                'operation_id': 'find_members_in_vo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'search_string',
                ],
                'required': [
                    'vo',
                    'search_string',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'search_string':
                        (str,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'search_string': 'searchString',
                },
                'location_map': {
                    'vo': 'query',
                    'search_string': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_sponsored_complete_rich_members_for_vo_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/findCompleteRichMembers/v-sponsored',
                'operation_id': 'find_sponsored_complete_rich_members_for_vo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'attrs_names',
                    'search_string',
                    'only_sponsored',
                ],
                'required': [
                    'vo',
                    'attrs_names',
                    'search_string',
                    'only_sponsored',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'attrs_names':
                        ([str],),
                    'search_string':
                        (str,),
                    'only_sponsored':
                        (bool,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'attrs_names': 'attrsNames[]',
                    'search_string': 'searchString',
                    'only_sponsored': 'onlySponsored',
                },
                'location_map': {
                    'vo': 'query',
                    'attrs_names': 'query',
                    'search_string': 'query',
                    'only_sponsored': 'query',
                },
                'collection_format_map': {
                    'attrs_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_members_endpoint = _Endpoint(
            settings={
                'response_type': ([Member],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getAllMembers',
                'operation_id': 'get_all_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_namespaces_rules_endpoint = _Endpoint(
            settings={
                'response_type': ([NamespaceRules],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getAllNamespacesRules',
                'operation_id': 'get_all_namespaces_rules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_sponsored_members_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getAllSponsoredMembers',
                'operation_id': 'get_all_sponsored_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                },
                'location_map': {
                    'vo': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_sponsored_members_and_their_sponsors_endpoint = _Endpoint(
            settings={
                'response_type': ([MemberWithSponsors],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getAllSponsoredMembersAndTheirSponsors',
                'operation_id': 'get_all_sponsored_members_and_their_sponsors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'attr_names',
                ],
                'required': [
                    'vo',
                    'attr_names',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'attr_names':
                        ([str],),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'attr_names': 'attrNames[]',
                },
                'location_map': {
                    'vo': 'query',
                    'attr_names': 'query',
                },
                'collection_format_map': {
                    'attr_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_complete_rich_members_for_group_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getCompleteRichMembers/g',
                'operation_id': 'get_complete_rich_members_for_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group',
                    'looking_in_parent_group',
                    'allowed_statuses',
                    'allowed_group_statuses',
                    'attrs_names',
                ],
                'required': [
                    'group',
                    'looking_in_parent_group',
                ],
                'nullable': [
                ],
                'enum': [
                    'allowed_group_statuses',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('allowed_group_statuses',): {

                        "VALID": "VALID",
                        "EXPIRED": "EXPIRED"
                    },
                },
                'openapi_types': {
                    'group':
                        (int,),
                    'looking_in_parent_group':
                        (bool,),
                    'allowed_statuses':
                        ([str],),
                    'allowed_group_statuses':
                        ([str],),
                    'attrs_names':
                        ([str],),
                },
                'attribute_map': {
                    'group': 'group',
                    'looking_in_parent_group': 'lookingInParentGroup',
                    'allowed_statuses': 'allowedStatuses[]',
                    'allowed_group_statuses': 'allowedGroupStatuses[]',
                    'attrs_names': 'attrsNames[]',
                },
                'location_map': {
                    'group': 'query',
                    'looking_in_parent_group': 'query',
                    'allowed_statuses': 'query',
                    'allowed_group_statuses': 'query',
                    'attrs_names': 'query',
                },
                'collection_format_map': {
                    'allowed_statuses': 'multi',
                    'allowed_group_statuses': 'multi',
                    'attrs_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_complete_rich_members_for_group_resource_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getCompleteRichMembers/g-r',
                'operation_id': 'get_complete_rich_members_for_group_resource',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group',
                    'resource',
                    'attrs_names',
                    'allowed_statuses',
                ],
                'required': [
                    'group',
                    'resource',
                    'attrs_names',
                    'allowed_statuses',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group':
                        (int,),
                    'resource':
                        (int,),
                    'attrs_names':
                        ([str],),
                    'allowed_statuses':
                        ([str],),
                },
                'attribute_map': {
                    'group': 'group',
                    'resource': 'resource',
                    'attrs_names': 'attrsNames[]',
                    'allowed_statuses': 'allowedStatuses[]',
                },
                'location_map': {
                    'group': 'query',
                    'resource': 'query',
                    'attrs_names': 'query',
                    'allowed_statuses': 'query',
                },
                'collection_format_map': {
                    'attrs_names': 'multi',
                    'allowed_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_complete_rich_members_for_vo_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getCompleteRichMembers/v',
                'operation_id': 'get_complete_rich_members_for_vo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'allowed_statuses',
                    'attrs_names',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'allowed_statuses':
                        ([str],),
                    'attrs_names':
                        ([str],),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'allowed_statuses': 'allowedStatuses[]',
                    'attrs_names': 'attrsNames[]',
                },
                'location_map': {
                    'vo': 'query',
                    'allowed_statuses': 'query',
                    'attrs_names': 'query',
                },
                'collection_format_map': {
                    'allowed_statuses': 'multi',
                    'attrs_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_member_by_ext_source_name_and_ext_login_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMemberByExtSourceNameAndExtLogin',
                'operation_id': 'get_member_by_ext_source_name_and_ext_login',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'ext_login',
                    'ext_source_name',
                ],
                'required': [
                    'vo',
                    'ext_login',
                    'ext_source_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'ext_login':
                        (str,),
                    'ext_source_name':
                        (str,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'ext_login': 'extLogin',
                    'ext_source_name': 'extSourceName',
                },
                'location_map': {
                    'vo': 'query',
                    'ext_login': 'query',
                    'ext_source_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_member_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMemberById',
                'operation_id': 'get_member_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_member_by_user_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMemberByUser',
                'operation_id': 'get_member_by_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'user',
                ],
                'required': [
                    'vo',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'user':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'user': 'user',
                },
                'location_map': {
                    'vo': 'query',
                    'user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_members_endpoint = _Endpoint(
            settings={
                'response_type': ([Member],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembers',
                'operation_id': 'get_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'status',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'status':
                        (VoMemberStatuses,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'status': 'status',
                },
                'location_map': {
                    'vo': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_members_by_ids_endpoint = _Endpoint(
            settings={
                'response_type': ([Member],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembersByIds',
                'operation_id': 'get_members_by_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                ],
                'required': [
                    'ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ids':
                        ([int],),
                },
                'attribute_map': {
                    'ids': 'ids[]',
                },
                'location_map': {
                    'ids': 'query',
                },
                'collection_format_map': {
                    'ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_members_by_user_endpoint = _Endpoint(
            settings={
                'response_type': ([Member],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembersByUser',
                'operation_id': 'get_members_by_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user',
                ],
                'required': [
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user':
                        (int,),
                },
                'attribute_map': {
                    'user': 'user',
                },
                'location_map': {
                    'user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_members_count_endpoint = _Endpoint(
            settings={
                'response_type': (int,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembersCount',
                'operation_id': 'get_members_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                },
                'location_map': {
                    'vo': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_members_page_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedRichMembers,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembersPage',
                'operation_id': 'get_members_page',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_get_paginated_members',
                ],
                'required': [
                    'input_get_paginated_members',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_get_paginated_members':
                        (InputGetPaginatedMembers,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_get_paginated_members': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_members_with_status_count_endpoint = _Endpoint(
            settings={
                'response_type': (int,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getMembersCount/status',
                'operation_id': 'get_members_with_status_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'status',
                ],
                'required': [
                    'vo',
                    'status',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'status': 'status',
                },
                'location_map': {
                    'vo': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_rich_member_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getRichMember',
                'operation_id': 'get_rich_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_rich_member_with_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getRichMemberWithAttributes',
                'operation_id': 'get_rich_member_with_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_rich_members_by_ids_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getRichMembersByIds',
                'operation_id': 'get_rich_members_by_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'attr_names',
                ],
                'required': [
                    'ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ids':
                        ([int],),
                    'attr_names':
                        ([str],),
                },
                'attribute_map': {
                    'ids': 'ids[]',
                    'attr_names': 'attrNames[]',
                },
                'location_map': {
                    'ids': 'query',
                    'attr_names': 'query',
                },
                'collection_format_map': {
                    'ids': 'multi',
                    'attr_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_rich_members_no_user_attributes_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getRichMembersNoUserAttributes',
                'operation_id': 'get_rich_members_no_user_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                },
                'location_map': {
                    'vo': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sponsored_members_endpoint = _Endpoint(
            settings={
                'response_type': ([RichMember],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getSponsoredMembers/v',
                'operation_id': 'get_sponsored_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                ],
                'required': [
                    'vo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                },
                'location_map': {
                    'vo': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sponsored_members_and_their_sponsors_endpoint = _Endpoint(
            settings={
                'response_type': ([MemberWithSponsors],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getSponsoredMembersAndTheirSponsors',
                'operation_id': 'get_sponsored_members_and_their_sponsors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'attr_names',
                ],
                'required': [
                    'vo',
                    'attr_names',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'attr_names':
                        ([str],),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'attr_names': 'attrNames[]',
                },
                'location_map': {
                    'vo': 'query',
                    'attr_names': 'query',
                },
                'collection_format_map': {
                    'attr_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sponsors_by_member_endpoint = _Endpoint(
            settings={
                'response_type': ([RichUser],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getSponsors/member',
                'operation_id': 'get_sponsors_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'attr_names',
                ],
                'required': [
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'attr_names':
                        ([str],),
                },
                'attribute_map': {
                    'member': 'member',
                    'attr_names': 'attrNames[]',
                },
                'location_map': {
                    'member': 'query',
                    'attr_names': 'query',
                },
                'collection_format_map': {
                    'attr_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sponsors_by_vo_endpoint = _Endpoint(
            settings={
                'response_type': ([RichUser],),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/getSponsors/vo',
                'operation_id': 'get_sponsors_by_vo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'ext_source_name',
                    'ext_login',
                    'attr_names',
                ],
                'required': [
                    'vo',
                    'ext_source_name',
                    'ext_login',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'ext_source_name':
                        (str,),
                    'ext_login':
                        (str,),
                    'attr_names':
                        ([str],),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'ext_source_name': 'extSourceName',
                    'ext_login': 'extLogin',
                    'attr_names': 'attrNames[]',
                },
                'location_map': {
                    'vo': 'query',
                    'ext_source_name': 'query',
                    'ext_login': 'query',
                    'attr_names': 'query',
                },
                'collection_format_map': {
                    'attr_names': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.move_membership_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/moveMembership',
                'operation_id': 'move_membership',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo',
                    'source_user',
                    'target_user',
                ],
                'required': [
                    'vo',
                    'source_user',
                    'target_user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo':
                        (int,),
                    'source_user':
                        (int,),
                    'target_user':
                        (int,),
                },
                'attribute_map': {
                    'vo': 'vo',
                    'source_user': 'sourceUser',
                    'target_user': 'targetUser',
                },
                'location_map': {
                    'vo': 'query',
                    'source_user': 'query',
                    'target_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_sponsor_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/removeSponsor',
                'operation_id': 'remove_sponsor',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'sponsor',
                ],
                'required': [
                    'member',
                    'sponsor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'sponsor':
                        (int,),
                },
                'attribute_map': {
                    'member': 'member',
                    'sponsor': 'sponsor',
                },
                'location_map': {
                    'member': 'query',
                    'sponsor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.send_account_activation_link_email_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/sendAccountActivationLinkEmail',
                'operation_id': 'send_account_activation_link_email',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'namespace',
                    'email_attribute_urn',
                    'language',
                ],
                'required': [
                    'member',
                    'namespace',
                    'email_attribute_urn',
                    'language',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'namespace':
                        (str,),
                    'email_attribute_urn':
                        (str,),
                    'language':
                        (str,),
                },
                'attribute_map': {
                    'member': 'member',
                    'namespace': 'namespace',
                    'email_attribute_urn': 'emailAttributeURN',
                    'language': 'language',
                },
                'location_map': {
                    'member': 'query',
                    'namespace': 'query',
                    'email_attribute_urn': 'query',
                    'language': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.send_password_reset_link_email_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/sendPasswordResetLinkEmail',
                'operation_id': 'send_password_reset_link_email',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'namespace',
                    'email_attribute_urn',
                    'language',
                    'base_url',
                ],
                'required': [
                    'member',
                    'namespace',
                    'email_attribute_urn',
                    'language',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'namespace':
                        (str,),
                    'email_attribute_urn':
                        (str,),
                    'language':
                        (str,),
                    'base_url':
                        (str,),
                },
                'attribute_map': {
                    'member': 'member',
                    'namespace': 'namespace',
                    'email_attribute_urn': 'emailAttributeURN',
                    'language': 'language',
                    'base_url': 'baseUrl',
                },
                'location_map': {
                    'member': 'query',
                    'namespace': 'query',
                    'email_attribute_urn': 'query',
                    'language': 'query',
                    'base_url': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.set_sponsored_member_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/json/membersManager/setSponsoredMember',
                'operation_id': 'set_sponsored_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'input_set_sponsored_member',
                ],
                'required': [
                    'input_set_sponsored_member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'input_set_sponsored_member':
                        (InputSetSponsoredMember,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'input_set_sponsored_member': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.set_sponsorship_for_member_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/setSponsorshipForMember',
                'operation_id': 'set_sponsorship_for_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sponsored_member',
                    'sponsor',
                    'validity_to',
                ],
                'required': [
                    'sponsored_member',
                    'sponsor',
                ],
                'nullable': [
                    'validity_to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sponsored_member':
                        (int,),
                    'sponsor':
                        (int,),
                    'validity_to':
                        (str, none_type,),
                },
                'attribute_map': {
                    'sponsored_member': 'sponsoredMember',
                    'sponsor': 'sponsor',
                    'validity_to': 'validityTo',
                },
                'location_map': {
                    'sponsored_member': 'query',
                    'sponsor': 'query',
                    'validity_to': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.set_status_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/setStatus',
                'operation_id': 'set_status',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'status',
                ],
                'required': [
                    'member',
                    'status',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'member': 'member',
                    'status': 'status',
                },
                'location_map': {
                    'member': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sponsor_member_endpoint = _Endpoint(
            settings={
                'response_type': (RichMember,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/sponsorMember',
                'operation_id': 'sponsor_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'sponsor',
                    'validity_to',
                ],
                'required': [
                    'member',
                    'sponsor',
                ],
                'nullable': [
                    'validity_to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'sponsor':
                        (int,),
                    'validity_to':
                        (str, none_type,),
                },
                'attribute_map': {
                    'member': 'member',
                    'sponsor': 'sponsor',
                    'validity_to': 'validityTo',
                },
                'location_map': {
                    'member': 'query',
                    'sponsor': 'query',
                    'validity_to': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_sponsorship_validity_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/updateSponsorshipValidity',
                'operation_id': 'update_sponsorship_validity',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                    'sponsor',
                    'validity_to',
                ],
                'required': [
                    'member',
                    'sponsor',
                ],
                'nullable': [
                    'validity_to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                    'sponsor':
                        (int,),
                    'validity_to':
                        (str, none_type,),
                },
                'attribute_map': {
                    'member': 'member',
                    'sponsor': 'sponsor',
                    'validity_to': 'validityTo',
                },
                'location_map': {
                    'member': 'query',
                    'sponsor': 'query',
                    'validity_to': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.validate_member_async_endpoint = _Endpoint(
            settings={
                'response_type': (Member,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/membersManager/validateMemberAsync',
                'operation_id': 'validate_member_async',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member',
                ],
                'required': [
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member':
                        (int,),
                },
                'attribute_map': {
                    'member': 'member',
                },
                'location_map': {
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def can_extend_membership(
        self,
        member,
        **kwargs
    ):
        """Return true if the membership can be extended or if no rules were set for the membershipExpiration, otherwise false.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.can_extend_membership(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            bool
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        return self.can_extend_membership_endpoint.call_with_http_info(**kwargs)

    def create_member_for_candidate(
        self,
        input_create_member_for_candidate,
        **kwargs
    ):
        """Creates a new member from candidate returned by the method VosManager.findCandidates which fills Candidate.userExtSource. This method also add user to all groups in list. Empty list of groups is ok, the behavior is then same like in the method without list of groups. This method runs asynchronously  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_member_for_candidate(input_create_member_for_candidate, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_member_for_candidate (InputCreateMemberForCandidate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_member_for_candidate'] = \
            input_create_member_for_candidate
        return self.create_member_for_candidate_endpoint.call_with_http_info(**kwargs)

    def create_member_for_user(
        self,
        input_create_member_for_user,
        **kwargs
    ):
        """Creates a new member from user. This method also add user to all groups in list. Empty list of groups is ok, the behavior is then same like in the method without list of groups.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_member_for_user(input_create_member_for_user, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_member_for_user (InputCreateMemberForUser):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_member_for_user'] = \
            input_create_member_for_user
        return self.create_member_for_user_endpoint.call_with_http_info(**kwargs)

    def create_member_from_ext_source(
        self,
        input_create_member_from_ext_source,
        **kwargs
    ):
        """Creates a new member and sets all member's attributes from the candidate. Also stores the associated user if doesn't exist. This method is used by the registrar. This method also add user to all groups in list. Empty list of groups is ok, the behavior is then same like in the method without list of groups.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_member_from_ext_source(input_create_member_from_ext_source, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_member_from_ext_source (InputCreateMemberFromExtSource):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_member_from_ext_source'] = \
            input_create_member_from_ext_source
        return self.create_member_from_ext_source_endpoint.call_with_http_info(**kwargs)

    def create_specific_member(
        self,
        input_specific_member,
        **kwargs
    ):
        """Creates a new member from candidate which is prepared for creating specificUser.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_specific_member(input_specific_member, async_req=True)
        >>> result = thread.get()

        Args:
            input_specific_member (InputSpecificMember):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_specific_member'] = \
            input_specific_member
        return self.create_specific_member_endpoint.call_with_http_info(**kwargs)

    def create_sponsored_member(
        self,
        input_create_sponsored_member,
        **kwargs
    ):
        """Creates a new sponsored member in a given VO and namespace.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sponsored_member(input_create_sponsored_member, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_sponsored_member (InputCreateSponsoredMember):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_sponsored_member'] = \
            input_create_sponsored_member
        return self.create_sponsored_member_endpoint.call_with_http_info(**kwargs)

    def create_sponsored_members(
        self,
        input_create_sponsored_members,
        **kwargs
    ):
        """Creates new sponsored members in a given VO and namespace.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sponsored_members(input_create_sponsored_members, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_sponsored_members (InputCreateSponsoredMembers):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (str,)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_sponsored_members'] = \
            input_create_sponsored_members
        return self.create_sponsored_members_endpoint.call_with_http_info(**kwargs)

    def create_sponsored_members_from_csv(
        self,
        input_create_sponsored_member_from_csv,
        **kwargs
    ):
        """Creates new sponsored members in a given VO and namespace.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sponsored_members_from_csv(input_create_sponsored_member_from_csv, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_sponsored_member_from_csv (InputCreateSponsoredMemberFromCSV):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (str,)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_create_sponsored_member_from_csv'] = \
            input_create_sponsored_member_from_csv
        return self.create_sponsored_members_from_csv_endpoint.call_with_http_info(**kwargs)

    def delete_member(
        self,
        member,
        **kwargs
    ):
        """Deletes only member data appropriated by member id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_member(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        return self.delete_member_endpoint.call_with_http_info(**kwargs)

    def delete_members(
        self,
        members,
        **kwargs
    ):
        """Delete members with given ids. It is possible to delete members from multiple vos.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_members(members, async_req=True)
        >>> result = thread.get()

        Args:
            members ([int]): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['members'] = \
            members
        return self.delete_members_endpoint.call_with_http_info(**kwargs)

    def extend_membership(
        self,
        member,
        **kwargs
    ):
        """Extend member membership using membershipExpirationRules attribute defined at VO.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extend_membership(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        return self.extend_membership_endpoint.call_with_http_info(**kwargs)

    def find_complete_rich_members_by_attributes(
        self,
        attrs_names,
        search_string,
        **kwargs
    ):
        """Return list of richMembers from perun by the searchString with attributes specific for list of attrsNames and who have only status which is contain in list of statuses. If attrsNames is empty or null return all attributes for specific richMembers. If listOfStatuses is empty or null, return all possible statuses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_complete_rich_members_by_attributes(attrs_names, search_string, async_req=True)
        >>> result = thread.get()

        Args:
            attrs_names ([str]): list of attribute names List<String>
            search_string (str): Text to search by

        Keyword Args:
            allowed_statuses ([str]): list of allowed statuses List<String>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['attrs_names'] = \
            attrs_names
        kwargs['search_string'] = \
            search_string
        return self.find_complete_rich_members_by_attributes_endpoint.call_with_http_info(**kwargs)

    def find_complete_rich_members_for_group(
        self,
        group,
        attrs_names,
        search_string,
        looking_in_parent_group,
        **kwargs
    ):
        """Return list of richMembers for specific group by the searchString with attributes specific for list of attrsNames and who have only status which is contain in lists of statuses. If attrsNames is empty or null return all attributes for specific richMembers. If listOfStatuses or listOfGroupStatuses is empty or null, return all possible statuses. If lookingInParentGroup is true, find all these richMembers only for parentGroup of this group. If this group is top level group, so find richMembers from members group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_complete_rich_members_for_group(group, attrs_names, search_string, looking_in_parent_group, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attrs_names ([str]): list of attribute names List<String>
            search_string (str): Text to search by
            looking_in_parent_group (bool): If true, look up in a parent group

        Keyword Args:
            allowed_statuses ([str]): list of allowed statuses List<String>. [optional]
            allowed_group_statuses ([str]): list of allowed group statuses List<String>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['group'] = \
            group
        kwargs['attrs_names'] = \
            attrs_names
        kwargs['search_string'] = \
            search_string
        kwargs['looking_in_parent_group'] = \
            looking_in_parent_group
        return self.find_complete_rich_members_for_group_endpoint.call_with_http_info(**kwargs)

    def find_complete_rich_members_for_vo(
        self,
        vo,
        attrs_names,
        search_string,
        **kwargs
    ):
        """Return list of richMembers for specific vo by the searchString with attributes specific for list of attrsNames and who have only status which is contain in list of statuses. If attrsNames is empty or null return all attributes for specific richMembers. If listOfStatuses is empty or null, return all possible statuses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_complete_rich_members_for_vo(vo, attrs_names, search_string, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attrs_names ([str]): list of attribute names List<String>
            search_string (str): Text to search by

        Keyword Args:
            allowed_statuses ([str]): list of allowed statuses List<String>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['attrs_names'] = \
            attrs_names
        kwargs['search_string'] = \
            search_string
        return self.find_complete_rich_members_for_vo_endpoint.call_with_http_info(**kwargs)

    def find_members_in_vo(
        self,
        vo,
        search_string,
        **kwargs
    ):
        """Searches for members in a VO.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_members_in_vo(vo, search_string, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            search_string (str): Text to search by

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Member]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['search_string'] = \
            search_string
        return self.find_members_in_vo_endpoint.call_with_http_info(**kwargs)

    def find_sponsored_complete_rich_members_for_vo(
        self,
        vo,
        attrs_names,
        search_string,
        only_sponsored,
        **kwargs
    ):
        """Returns list of RichMembers for vo, with reqested attributes, filterd by search string and option to return only sponosred members.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_sponsored_complete_rich_members_for_vo(vo, attrs_names, search_string, only_sponsored, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attrs_names ([str]): list of attribute names List<String>
            search_string (str): Text to search by
            only_sponsored (bool): Boolean specifying if only sponsored members should be returned

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['attrs_names'] = \
            attrs_names
        kwargs['search_string'] = \
            search_string
        kwargs['only_sponsored'] = \
            only_sponsored
        return self.find_sponsored_complete_rich_members_for_vo_endpoint.call_with_http_info(**kwargs)

    def get_all_members(
        self,
        **kwargs
    ):
        """Get all members from all vos.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_members(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Member]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_members_endpoint.call_with_http_info(**kwargs)

    def get_all_namespaces_rules(
        self,
        **kwargs
    ):
        """Return all loaded namespaces rules.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_namespaces_rules(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [NamespaceRules]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_namespaces_rules_endpoint.call_with_http_info(**kwargs)

    def get_all_sponsored_members(
        self,
        vo,
        **kwargs
    ):
        """Gets all sponsored members from VO.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_sponsored_members(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_all_sponsored_members_endpoint.call_with_http_info(**kwargs)

    def get_all_sponsored_members_and_their_sponsors(
        self,
        vo,
        attr_names,
        **kwargs
    ):
        """Gets list of VO's all sponsored members with sponsors.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_sponsored_members_and_their_sponsors(vo, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [MemberWithSponsors]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['attr_names'] = \
            attr_names
        return self.get_all_sponsored_members_and_their_sponsors_endpoint.call_with_http_info(**kwargs)

    def get_complete_rich_members_for_group(
        self,
        group,
        looking_in_parent_group,
        **kwargs
    ):
        """Get all RichMembers with attributes specific for list of attrsNames from the group and have only status which is contain in lists of statuses. If attrsNames is empty or null return all attributes for specific richMembers. If listOfStatuses or listOfGroupStatuses is empty or null, return all possible statuses. If lookingInParentGroup is true, get all these richMembers only for parentGroup of this group. If this group is top level group, so get richMembers from members group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_complete_rich_members_for_group(group, looking_in_parent_group, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            looking_in_parent_group (bool): If true, look up in a parent group

        Keyword Args:
            allowed_statuses ([str]): list of allowed statuses List<String>. [optional]
            allowed_group_statuses ([str]): list of allowed group statuses List<String>. [optional]
            attrs_names ([str]): list of attributes names List<String>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['group'] = \
            group
        kwargs['looking_in_parent_group'] = \
            looking_in_parent_group
        return self.get_complete_rich_members_for_group_endpoint.call_with_http_info(**kwargs)

    def get_complete_rich_members_for_group_resource(
        self,
        group,
        resource,
        attrs_names,
        allowed_statuses,
        **kwargs
    ):
        """Get all RichMembers with attributes specific for list of attrsNames. Attributes are defined by member (user) and resource (facility) objects. It returns also user-facility (in userAttributes of RichMember) and member-resource (in memberAttributes of RichMember) attributes. Members are defined by group and are filtered by list of allowed statuses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_complete_rich_members_for_group_resource(group, resource, attrs_names, allowed_statuses, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attrs_names ([str]): list of attribute names List<String>
            allowed_statuses ([str]): list of allowed statuses List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['group'] = \
            group
        kwargs['resource'] = \
            resource
        kwargs['attrs_names'] = \
            attrs_names
        kwargs['allowed_statuses'] = \
            allowed_statuses
        return self.get_complete_rich_members_for_group_resource_endpoint.call_with_http_info(**kwargs)

    def get_complete_rich_members_for_vo(
        self,
        vo,
        **kwargs
    ):
        """Get all RichMembers with attributes specific for list of attrsNames from the vo and have only status which is contain in list of statuses. If attrsNames is empty or null return all attributes for specific richMembers. If listOfStatuses is empty or null, return all possible statuses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_complete_rich_members_for_vo(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            allowed_statuses ([str]): list of allowed statuses List<String>. [optional]
            attrs_names ([str]): list of attributes names List<String>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_complete_rich_members_for_vo_endpoint.call_with_http_info(**kwargs)

    def get_member_by_ext_source_name_and_ext_login(
        self,
        vo,
        ext_login,
        ext_source_name,
        **kwargs
    ):
        """Searches for members in a VO.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_by_ext_source_name_and_ext_login(vo, ext_login, ext_source_name, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            ext_login (str): external login of user, e.g. john
            ext_source_name (str): external source name, e.g. IdP entityId

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['ext_login'] = \
            ext_login
        kwargs['ext_source_name'] = \
            ext_source_name
        return self.get_member_by_ext_source_name_and_ext_login_endpoint.call_with_http_info(**kwargs)

    def get_member_by_id(
        self,
        id,
        **kwargs
    ):
        """Returns Member by its id.  # noqa: E501

        Gets Member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): numeric id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_member_by_id_endpoint.call_with_http_info(**kwargs)

    def get_member_by_user(
        self,
        vo,
        user,
        **kwargs
    ):
        """Returns a Member specified by VO id and User id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_by_user(vo, user, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['user'] = \
            user
        return self.get_member_by_user_endpoint.call_with_http_info(**kwargs)

    def get_members(
        self,
        vo,
        **kwargs
    ):
        """Returns members of a VO.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            status (VoMemberStatuses): optional status. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Member]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_members_endpoint.call_with_http_info(**kwargs)

    def get_members_by_ids(
        self,
        ids,
        **kwargs
    ):
        """Returns list of Members by their ids.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members_by_ids(ids, async_req=True)
        >>> result = thread.get()

        Args:
            ids ([int]): list of ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Member]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ids'] = \
            ids
        return self.get_members_by_ids_endpoint.call_with_http_info(**kwargs)

    def get_members_by_user(
        self,
        user,
        **kwargs
    ):
        """Returns members for a user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members_by_user(user, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Member]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user'] = \
            user
        return self.get_members_by_user_endpoint.call_with_http_info(**kwargs)

    def get_members_count(
        self,
        vo,
        **kwargs
    ):
        """Returns count of all VO members.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members_count(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            int
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_members_count_endpoint.call_with_http_info(**kwargs)

    def get_members_page(
        self,
        input_get_paginated_members,
        **kwargs
    ):
        """Get page of members from the given vo, with the given attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members_page(input_get_paginated_members, async_req=True)
        >>> result = thread.get()

        Args:
            input_get_paginated_members (InputGetPaginatedMembers):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedRichMembers
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_get_paginated_members'] = \
            input_get_paginated_members
        return self.get_members_page_endpoint.call_with_http_info(**kwargs)

    def get_members_with_status_count(
        self,
        vo,
        status,
        **kwargs
    ):
        """Returns count of VO members with specified status.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_members_with_status_count(vo, status, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            status (str): status (VALID | INVALID | EXPIRED | DISABLED)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            int
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['status'] = \
            status
        return self.get_members_with_status_count_endpoint.call_with_http_info(**kwargs)

    def get_rich_member(
        self,
        id,
        **kwargs
    ):
        """Returns RichMember by member id.  # noqa: E501

        Get RichMember without attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rich_member(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): numeric id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_rich_member_endpoint.call_with_http_info(**kwargs)

    def get_rich_member_with_attributes(
        self,
        id,
        **kwargs
    ):
        """Returns Member by its id.  # noqa: E501

        Get richMember with member/user attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rich_member_with_attributes(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): numeric id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_rich_member_with_attributes_endpoint.call_with_http_info(**kwargs)

    def get_rich_members_by_ids(
        self,
        ids,
        **kwargs
    ):
        """Returns rich members by their IDs with specific attributes. When the list of attribute names is null or empty then rich members will be returned without attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rich_members_by_ids(ids, async_req=True)
        >>> result = thread.get()

        Args:
            ids ([int]): list of ids List<Integer>

        Keyword Args:
            attr_names ([str]): list of attribute names List<String> or null. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ids'] = \
            ids
        return self.get_rich_members_by_ids_endpoint.call_with_http_info(**kwargs)

    def get_rich_members_no_user_attributes(
        self,
        vo,
        **kwargs
    ):
        """Returns list of all RichMembers for specified VO. User attributes aren't included in the returned objects  # noqa: E501

        Get richMembers for VO with member attributes (without user attributes).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rich_members_no_user_attributes(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_rich_members_no_user_attributes_endpoint.call_with_http_info(**kwargs)

    def get_sponsored_members(
        self,
        vo,
        **kwargs
    ):
        """Gets members from VO who are sponsored.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sponsored_members(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichMember]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        return self.get_sponsored_members_endpoint.call_with_http_info(**kwargs)

    def get_sponsored_members_and_their_sponsors(
        self,
        vo,
        attr_names,
        **kwargs
    ):
        """Gets list of members with sponsors.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sponsored_members_and_their_sponsors(vo, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [MemberWithSponsors]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['attr_names'] = \
            attr_names
        return self.get_sponsored_members_and_their_sponsors_endpoint.call_with_http_info(**kwargs)

    def get_sponsors_by_member(
        self,
        member,
        **kwargs
    ):
        """Gets sponsors for given member with optional attribute names.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sponsors_by_member(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            attr_names ([str]): list of attribute names List<String> or null. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichUser]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        return self.get_sponsors_by_member_endpoint.call_with_http_info(**kwargs)

    def get_sponsors_by_vo(
        self,
        vo,
        ext_source_name,
        ext_login,
        **kwargs
    ):
        """Gets sponsors for given VO, extSourceName and extLogin with optional attribute names.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sponsors_by_vo(vo, ext_source_name, ext_login, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            ext_source_name (str): external source name, e.g. IdP entityId
            ext_login (str): external login of user, e.g. john

        Keyword Args:
            attr_names ([str]): list of attribute names List<String> or null. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [RichUser]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['ext_source_name'] = \
            ext_source_name
        kwargs['ext_login'] = \
            ext_login
        return self.get_sponsors_by_vo_endpoint.call_with_http_info(**kwargs)

    def move_membership(
        self,
        vo,
        source_user,
        target_user,
        **kwargs
    ):
        """Moves membership in VO from source user to target user - moves the source user's memberships in non-synchronized groups, member related attributes, bans and sponsorships in the VO. Removes the source user's member object. If VO is member of any hierarchical parent VO, user's membership is moved in parent VOs also. If VO is parent of any hierarchical member VOs, user's membership is not moved in member VOs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_membership(vo, source_user, target_user, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            source_user (int): id of source user
            target_user (int): id of target user

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo'] = \
            vo
        kwargs['source_user'] = \
            source_user
        kwargs['target_user'] = \
            target_user
        return self.move_membership_endpoint.call_with_http_info(**kwargs)

    def remove_sponsor(
        self,
        member,
        sponsor,
        **kwargs
    ):
        """Removes sponsor of existing member.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_sponsor(member, sponsor, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            sponsor (int): id of sponsor

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['sponsor'] = \
            sponsor
        return self.remove_sponsor_endpoint.call_with_http_info(**kwargs)

    def send_account_activation_link_email(
        self,
        member,
        namespace,
        email_attribute_urn,
        language,
        **kwargs
    ):
        """Send mail to user's preferred email address with link for non-authz account activation. Correct authz information is stored in link's URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_account_activation_link_email(member, namespace, email_attribute_urn, language, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            namespace (str): namespace
            email_attribute_urn (str): urn of the attribute with stored mail
            language (str): language of the message

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['namespace'] = \
            namespace
        kwargs['email_attribute_urn'] = \
            email_attribute_urn
        kwargs['language'] = \
            language
        return self.send_account_activation_link_email_endpoint.call_with_http_info(**kwargs)

    def send_password_reset_link_email(
        self,
        member,
        namespace,
        email_attribute_urn,
        language,
        **kwargs
    ):
        """Send mail to user's preferred email address with link for non-authz password reset. Correct authz information is stored in link's URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_password_reset_link_email(member, namespace, email_attribute_urn, language, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            namespace (str): namespace
            email_attribute_urn (str): urn of the attribute with stored mail
            language (str): language of the message

        Keyword Args:
            base_url (str): base url of Perun instance (optional). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['namespace'] = \
            namespace
        kwargs['email_attribute_urn'] = \
            email_attribute_urn
        kwargs['language'] = \
            language
        return self.send_password_reset_link_email_endpoint.call_with_http_info(**kwargs)

    def set_sponsored_member(
        self,
        input_set_sponsored_member,
        **kwargs
    ):
        """Creates a sponsored membership for the given user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_sponsored_member(input_set_sponsored_member, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_sponsored_member (InputSetSponsoredMember):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['input_set_sponsored_member'] = \
            input_set_sponsored_member
        return self.set_sponsored_member_endpoint.call_with_http_info(**kwargs)

    def set_sponsorship_for_member(
        self,
        sponsored_member,
        sponsor,
        **kwargs
    ):
        """Transform non-sponsored member to sponsored one, with defined sponsor and optional sponsorship validity expiration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_sponsorship_for_member(sponsored_member, sponsor, async_req=True)
        >>> result = thread.get()

        Args:
            sponsored_member (int): id of member to be sponsored
            sponsor (int): id of sponsor

        Keyword Args:
            validity_to (str, none_type): date in format yyyy-mm-dd. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['sponsored_member'] = \
            sponsored_member
        kwargs['sponsor'] = \
            sponsor
        return self.set_sponsorship_for_member_endpoint.call_with_http_info(**kwargs)

    def set_status(
        self,
        member,
        status,
        **kwargs
    ):
        """Set membership status of a member.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_status(member, status, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            status (str): status (VALID | INVALID | EXPIRED | DISABLED)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['status'] = \
            status
        return self.set_status_endpoint.call_with_http_info(**kwargs)

    def sponsor_member(
        self,
        member,
        sponsor,
        **kwargs
    ):
        """For an existing member, assigns a new sponsor  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sponsor_member(member, sponsor, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            sponsor (int): id of sponsor

        Keyword Args:
            validity_to (str, none_type): date in format yyyy-mm-dd. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RichMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['sponsor'] = \
            sponsor
        return self.sponsor_member_endpoint.call_with_http_info(**kwargs)

    def update_sponsorship_validity(
        self,
        member,
        sponsor,
        **kwargs
    ):
        """Updates sponsorship validity. To change it to FOREVER, don't pass the validityTo param, or pass it as null.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_sponsorship_validity(member, sponsor, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            sponsor (int): id of sponsor

        Keyword Args:
            validity_to (str, none_type): date in format yyyy-mm-dd. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        kwargs['sponsor'] = \
            sponsor
        return self.update_sponsorship_validity_endpoint.call_with_http_info(**kwargs)

    def validate_member_async(
        self,
        member,
        **kwargs
    ):
        """Validate all attributes for member and set member's status to VALID. This method runs asynchronously. It immediately return member with original status and after asynchronous validation successfully finishes it switch member's status to VALID. If validation ends with error, member keeps his status.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_member_async(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Member
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member'] = \
            member
        return self.validate_member_async_endpoint.call_with_http_info(**kwargs)

