# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-06-02 07:59
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields
import picklefield.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Component',
            fields=[
                ('id', models.CharField(max_length=64, primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z]*$', 'Only alphanumeric characters are allowed.')])),
                ('name', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True, max_length=254, null=True)),
                ('link', models.URLField(max_length=254)),
                ('contact', models.EmailField(max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='Plugin',
            fields=[
                ('id', models.CharField(max_length=64, primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z]*$', 'Only alphanumeric characters are allowed.')])),
                ('name', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True, max_length=254, null=True)),
                ('link', models.URLField(blank=True, max_length=254)),
                ('py_module', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='PluginInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True, max_length=254, null=True)),
                ('config', picklefield.fields.PickledObjectField(editable=False, null=True)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('modified_on', models.DateTimeField(auto_now=True)),
                ('plugin', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='status.Plugin')),
            ],
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('defcon', models.IntegerField(default=5, validators=[django.core.validators.MaxValueValidator(5), django.core.validators.MinValueValidator(1)])),
                ('title', models.CharField(max_length=60)),
                ('description', models.TextField(blank=True, max_length=254, null=True)),
                ('metadata', jsonfield.fields.JSONField(null=True)),
                ('link', models.URLField(max_length=254)),
                ('time_start', models.DateTimeField(auto_now=True)),
                ('time_end', models.DateTimeField(blank=True, null=True)),
                ('override', models.BooleanField(default=False)),
                ('created_on', models.DateTimeField(auto_now_add=True)),
                ('modified_on', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.AddField(
            model_name='plugininstance',
            name='statuses',
            field=models.ManyToManyField(blank=True, to='status.Status'),
        ),
        migrations.AddField(
            model_name='component',
            name='plugins',
            field=models.ManyToManyField(blank=True, to='status.PluginInstance'),
        ),
    ]
