YARP 2.3.72.1 (2018-06-11)                                          {#v2_3_72_1}
==========================

[TOC]

YARP 2.3.72.1 Release Notes
===========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.72.1%22).



Bug Fixes
---------

### Build System

* Fixed build with CMake < 3.4

### CMake Modules

* Removed `IMPORTED_GLOBAL` property from `YarpOSXUtilities.cmake`.

### Libraries

#### `YARP_sig`

* Fixed bug in `yarp::sig::Sound::operator+=`

#### `YARP_dev`

* ControlBoardWrapper now correctly passes on any monitoring to wrapped
  subdevices.
* Subdevices wrapped by ControlBoardWrapper are now identified by their actual
  name by the monitor object, that is, their name will be displayed on the
  command line if `yarpdev` was called with `--verbose`.
  Previously, it used a generic "subdevice" identifier.
* Added missing `IFrameGrabberControl2` to `RGBDSensorWrapper`.
* Fixed `RGBDSensorWrapper` compatibility with `frameGrabberGui2`.
* Fixed joint remapping in method `getRefVelocity()`.
* Fix `VOCAB_CURRENT_REF_GROUP` message parser in ControlBoardWrapper (#1734)


#### `YARP_serversql`

* Added check if `rossrv`, `tcpros` and `xmlrpc` are installed when
yarpserver is launched with `--ros` option. (#722)


#### `YARP_OS`

* Added timeout parameter in `TcpConnector::connect()` to unify behaviour with the
  `ACE_SOCK_Connector`.

### GUIs

#### yarpscope

* Fixed bottle handling.

#### yarpmanager

* Added `checkNetwork` before contacting the nameserver.(#1536)
* Added the ping on `yarprun` nodes.
* Fixed mismatch of port connections when not ordered by ID.(#964)
* Fixed mismatch of resources when not ordered by ID

#### yarpmotorgui

* Fixed compilation on macOS

#### yarplogger

* Fixed compilation on macOS

### Devices

#### `ControlBoardRemapper`

* Fixed `getEncoderAccelerations()` method.

#### `depthCamera`

* Fixed find OpenNI2 in CMakelists.txt.

#### `AnalogWrapper`

* Fixed issue preventing publication of FT sensor data to ROS.


### Bindings

* Fixed out of source builds.
* Added `SWIG_PREPROCESSOR_SHOULD_SKIP_THIS` to avoid the SWIG preprocessor from
  parsing `VOCAB`. Introduced SWIG-compliant working `VOCAB` definitions in
  `yarp.i`, with required checks on target language and SWIG version.
* Removed related hacks required for compilation from YARP internals.
* Added `test_vocab.lua` to catch regressions on `VOCAB` in the future.
* Renamed `test_string.lua` to more representative `test_port.lua`, enabled it to
  run without the `yarpserver`, and integrate it in the test infrastructure.

Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.72..v2.3.72.1`):


```
    55	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    21	Nicolò Genesio <nicolo.genesio@iit.it>
    14	Juan G. Victores <jcgvicto@gmail.com>
     6	Alberto Cardellino <alberto.cardellino@iit.it>
     5	Silvio Traversaro <silvio.traversaro@iit.it>
     3	Damiano Enerli <damiano.enerli@iit.it>
     3	Ugo Pattacini <ugo.pattacini@iit.it>
     2	Bartek Łukawski <bwmn.peter@gmail.com>
     2	Claudio Fantacci <claudio.fantacci@iit.it>
     2	Marco Randazzo <marco.randazzo@iit.it>
     2	Matteo Brunettini <matteo.brunettini@iit.it>
     2	Nuno Guedelha <nuno.guedelha@iit.it>
     1	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     1	Lorenzo Rapetti <lorenzo.rapetti@iit.it>
     1	Prashanth Ramadoss <prashanthramadoss@gmail.com>
```
