YARP 2.3.70 (2017-06-15)                                              {#v2_3_70}
========================

[TOC]

YARP 2.3.70 Release Notes
=========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.70%22).


Important Changes
-----------------

### System Configuration

* The `YARP_CONF` environment variable has been deprecated for a long time
  (since April 2013) and it is no longer used. Since there was not a proper
  warning, the warning is printed now at runtime when the variable is set. See
  [`ResourceFinder::getConfigHome()` documentation](http://yarp.it/classyarp_1_1os_1_1ResourceFinder.html)
  for information about paths used by YARP to detect the configuration files.
  If you still need to use the `YARP_CONF` for some reason, you can use the
  `YARP_CONFIG_HOME` environment variable instead.

### Build System

* A compiler supporting C++11 is now required.
* CMake 3.0 or newer is now required.
* Optional dependency on YCM now requires version 0.4.0 (devel) or later.
* [Robot Testing Framework (RTF)](https://github.com/robotology/robot-testing/)
  1.2.0 is now an optional dependency.

### CMake Modules

* `YarpPlugin`
  * The following commands, deprecated since YARP 2.3.21, were removed:
    * `BEGIN_PLUGIN_LIBRARY`
    * `ADD_PLUGIN_NORMALIZED`
    * `PREPARE_PLUGIN`
    * `PREPARE_DEVICE`
    * `PREPARE_CARRIER`
    * `END_PLUGIN_LIBRARY`
    * `ADD_PLUGIN_LIBRARY_EXECUTABLE`
    * `YARP_ADD_PLUGIN_LIBRARY_EXECUTABLE`
* The `YARP_HAS_NAME_LIB` variable has been removed since `YARP_name` is always
  available, and is considered a private library.
* All CMake targets now export the include directories required to build using
  that library. Using `include_directories(${YARP_INCLUDE_DIRS})` should no
  longer be required.
* `YarpPlugin.cmake` and `YarpInstallationHelpers.cmake` are now automatically
  included from `YARPConfig.cmake`, therefore all commands defined in these
  files are available after `find_package(YARP)`. Including them explicitly is
  now considered deprecated. For the same reason, adding `YARP_MODULE_PATH` to
  the `CMAKE_MODULE_PATH` variable is considered deprecated. If you need some
  modules not available in CMake, please consider using YCM.

### Libraries

* A lot of refactoring was performed in order to improve c++11 usage and to
  simplify porting to other platforms without ACE

#### `YARP_conf`

* Added the new `YARP_conf` header only library target. Formerly these files
  existed but they did not belong to any target.

#### `YARP_OS`

* The `i` command is now enabled only in `Debug` and `DebugFull` builds.
* The following commands have been marked as _deprecated_ and will be removed in
  future version of YARP:
  * `yarp::os::exit()`
  * `yarp::os::abort()`
  * `yarp::os::signal()`
  * `yarp::os::ResourceFinder::setContext(const char* contextName)`

#### `YARP_dev`

* Opening a device using a configuration of type `(device (device (foo bar)))`
  is now deprecated, use `(device (foo bar))` instead.
* Removed some old interfaces methods, deprecated since yarp 2.3.65.
  i.e: `setPositionDirectMode()`, `setPositionMode()`, `setVelocityMode()`,
  `setOpenLoopMode(), `setTorqueMode()`, etc.
* Removed Interface IOpenLoopControl, deprecated since yarp 2.3.65.
* Removed deprecated device ClientControlBoard and related tests.
* Removed deprecated device ServerControlBoard and related tests.
* Major changes to iPIDControl methods. Now they aren't bound anymore to
  Position Control. (#499)
  They accept a new parameter PidControlTypeEnum which defines the PID id
  on which the method will operate.
  For example
  `setPid(const PidControlTypeEnum& pidtype, int j, const Pid &pid)`.
  Currently, pidtype can be one of the following types:
  - `VOCAB_PIDTYPE_POSITION`,
  - `VOCAB_PIDTYPE_VELOCITY`,
  - `VOCAB_PIDTYPE_TORQUE`,
  - `VOCAB_PIDTYPE_CURRENT`.
* All pid-related methods from interfaces different from iPidControl have been
  deprecated.
  To provide backward-compatibility, old methods automatically call the new
  methods (e.g. `setTorquePid(int j, const Pid &pid)` calls
  `setPid(VOCAB_PIDTYPE_TORQUE,int j,const PID &pid)`)
* The following methods have been deprecated, use
  `IControlMode2::setControlMode(int, VOCAB_CM_XXX)` instead:
  - `IControlMode::setPositionMode(int)`
  - `IControlMode::setVelocityMode(int)`
  - `IControlMode::setTorqueMode(int)`
  - `IControlMode::setImpedancePositionMode(int)`
  - `IControlMode::setImpedanceVelocityMode(int)`
  - ...plus their `IControlModeRaw` counterparts

#### `YARP_math`

* `YARP_math` can no longer be built using GSL. The `CREATE_LIB_MATH_USING_GSL`
  option was removed. Only Eigen is supported. `FindGSL.cmake` is no longer
  installed.


New Features
------------

### CMake Modules

* `YarpPlugin`
  * Add QUIET/VERBOSE arguments and YarpPlugin_QUIET/VERBOSE variables.
* `YarpInstallationHelpers`
  *  A new command `yarp_configure_plugins_installation` has been introduced to
     simplify installation of YARP plugins when
     `yarp_configure_external_installation` is not invoked.


### Libraries

* New library `libYARP_rtf` to simplify the creation of unit tests using the
  [Robot Testing Framework (RTF)](https://github.com/robotology/robot-testing/)
  and YARP. This is a slightly modified version of the RTF_YARP_utilities
  library in RTF 1.0.
  It can be enabled with the option `YARP_COMPILE_RTF_ADDONS`.

#### `YARP_OS`

* The following methods were added to the `yarp::os` namespace:
  * `char* yarp::os::getcwd(char *buf, size_t size)`
  * `int yarp::os::fork(void)`
* The following methods were added to the `yarp::os::Publisher` class:
  * `virtual void onRead(T &datum)`
  * `void useCallback(TypedReaderCallback< T > &callback)`
  * `void useCallback()`
  * `void disableCallback()`
* The following methods were added to the `yarp::os::Subscriber` class:
  * `void setStrict(bool strict = true)`
* The following overload method is added to the `yarp::os::ResourceFinder`
  class:
  * `bool setDefaultContext(const yarp::os::ConstString& contextName)`
* Added `clear()` method to PID class.
* The class `yarp::os::Route` was refactored:
  * The following methods were deprecated:
    - `addFromName()`
    - `addToName()`
    - `addCarrierName()`
    - `addToContact()`
  * The following methods were added:
    - `setFromName()`
    - `setToName()`
    - `setCarrierName()`
    - `setToContact()`
    - `swapNames()`

#### `YARP_dev`

* Added `getRgbResolution` and `getRgbSupportedConfigurations` to the
 `IRgbVisualParams` interface.
* Added the new `yarp::dev::IJoypadController` interface and the new
  `JoypadControlClient` and `JoypadControlServer` devices.
* Added rpc port to dialogue with FrameTransformClient.
  The implemented commands are:
  - `get_transform`: print the transform from src to dst
  - `list_frames`: print all the available reference frames
  - `list_ports`: print all the opened ports for transform broadcasting
  - `publish_transform`: opens a port to publish transform from src to dst
  - `unpublish_transform`: closes a previously opened port to publish a
    transform
  - `unpublish_all`: closes a all previously opened ports to publish a transform
* iPIDControl class pulled out from ControlBoardInterfaces yarpdev headers and
  put in separated files. Reimplemented without templates.
* Gaze control: added sync equivalent to lookAt-like methods in order to wait
  for reply.
* Added iRobotDescription interface.
* Added two new motion control interfaces: IPWMControl, ICurrentControl and
  related helpers for units conversions.
* Added `IMap2D` interface.
* Added `yarp::dev::MapGrid2D` data type.
* Added `IHapticDevice` interface.

#### `YARP_math`

* Added methods:
  * `yarp::sig::Vector dcm2ypr(const yarp::sig::Matrix&)`
  * `yarp::sig::Matrix ypr2dcm(const yarp::sig::Vector&)`
* Added template class `Vec2d<>`. can be only instantiated as int or double.
* Added operator*(quaternion, quaternion) overload for quaternion multiplication
* Added normalize method in the quaternion class


### Tools

#### `yarpidl_rosmsg`

* All generated classes now implement the `clear()` method.

### GUIs

#### `yarplaserscannergui`

* Accept --help argument.

#### `yarpview`

* Added `--autosize` and checkbox to force yarpview to resize whenever a frame
  of a different size is received.
* Implemented dragvector function on yarpview. Left-click on the image and keep
  left button pressed: yarpview starts to draw a line.
  When the left button is released, the coordinates of the initial and the final
  point are sent to the 'out' yarp port.

#### `yarpmotorgui`:

* Create an instance of `RobotDescriptionClient` to automatically get the names
  of robot parts.
* New button "idle all parts".
* New button "execute script1/2".
* `yarpmotorgui` now enforces the correct "go to home" behaviour:
  * home is asked to the robot, and, as a consequence, the "Home" button will
    apply the robot home position as specified by the `Calibrator`, see
    [this comment in QA#108](https://github.com/robotology/QA/issues/108#issuecomment-214743789)
  * added possibility to specified custom positions in the configuration file.
    These positions can be executed by newly introduced "Custom positions"
    submenus. Syntax is described in the `yarpmotorgui` documentation.
    [#1160](https://github.com/robotology/yarp/pull/1160)
* Added CurrentPid tab in yarpmotorgui.
* Added new control mode widgets to handle current and pwm control modes.

#### `yarpmanager`

* Handle also wait states upon shutting down the modules of an application
  (#1051).
* Added local and environment variable parsing (#885, #1031).
* Added --add_current_dir option.


### Carriers

* New `zfp` portmonitor for compressing floating point arrays using the ZFP
  library (see http://computation.llnl.gov/projects/floating-point-compression).


### Devices

* Added new `RobotDescriptionServer` device to store devices info.
* Added new `RobotDescriptionClient` device. User module can ask a list of
  registered devices using the iRobotDescription interface.
* Added new device `Map2DServer` to store navigation maps.
* Added new device `Map2DClient`. User module can perform operations on the
  stored maps using the `iMap2D` interface.
* Added new `SDLJoypad` device.
* Added new `rpLidar2` device.
* Added new `fakeDepthCamera` device.
* Added new device `ServerGrabber` to handle one or two camera devices in
  function of the configuration.


#### `AnalogWrapper`

* ROS param was changed from `joint_names` to `jointNames` like the
  `controlBoardWrapper`. The old name is deprecated.
* Deprecated all the constructors except for the one without arguments.

#### `controlboardwrapper`

* Reduced message size of of the stateExt:o port of nearly 30%.

#### `TestFrameGrabber`

* The `TestFrameGrabber` was removed from libYARP_dev and it is now an optional
  plugin.

#### `ovrheadset`

* Ported to the latest Oculus SDK. Compatibility with the old SDK was dropped.
  Supporting both the old and the new SDK is really not worth the effort.
  Therefore, since Linux and macOS are not supported by the latest SDK, only
  Windows is currently supported. If you need support on Linux or macOS you can
  checkout commit `a05fec65e7bc67cceba5c59f26881e98590fccf7` from git history.
* A few options (`--multisample`, `--no-overdrive`, `--no-hqdistortion`, and
  `--no-timewarp`) and the relative toggles were removed, since they can no
  longer be enabled/disabled from the SDK .
* It can now display YARP logo in the bottom-right corner (disable with
  `--no-logo` from command line or toggle with `[T]` while running). This is
  useful to ensure that the device is working while waiting for the connection.
* It can now display a crosshairs at the center of the scene (disable with
 `--no-crosshairs` from command line or toggle with `[C]` while running).
* It can now be connected to a battery and display the status as an overlay
  at the top-right corner (disable with `--no-battery` from command line or
  toggle with `[B]` while running)

#### `RemoteControlBoard`

* Dropped compatibility with `controlboardwrapper2` devices that does not have
  the `stateExt:o` port.
  The `state:o` port in the wrapper is still available for encoder reading.
* The protocol was changed and compatibility for devices using the old protocol
  was dropped.
* added implementation of IPWMControl, ICurrentControl.
* added control modes: VOCAB_CM_CURRENT, VOCAB_CM_PWM.
* Added new values in the statExt : pwmDutycycle, current.
* Removed deprecated value from statExt: PidOutput.

#### `ServerFrameGrabber`

* `ServerFrameGrabber` now implements the interface yarp::dev::IRgbVisualParams
  for parsing rgb camera parameters.

#### `TestFrameGrabber`

* Added new `'mode = size` option to broadcast a simple video with variable
  frame size.
* `TestFrameGrabber` now implements the interface yarp::dev::IRgbVisualParams
  for parsing rgb camera parameters.


### RTF Plugins

* The `yarpmanager` RTF Fixture Managers was imported from
  robotology/robot-testing, and allows one to start a fixture using yarpmanager.
  It can be enabled with the option `YARP_COMPILE_RTF_ADDONS`.
* The `yarpplugin` RTF Fixture Managers was imported from robotology/icub-tests
  (Originally YarpPluginFixture), and allows one to check if a yarp plugin is
  available.
  It can be enabled with the option `YARP_COMPILE_RTF_ADDONS`.


### Bindings

* Add bindings for `yarp/os/Log.h` and `yarp/os/LogStream.h`.
  It allows the following:
```python
import yarp
logger = yarp.Log()
logger.debug('See how cool this is')
```

Bug Fixes
---------

### Libraries

#### `YARP_OS`

* Fixed mcast carrier without ACE.

#### `YARP_dev`

* Fixed `FrameTransformClient::getTransform()` (#1184)
* Fixed an on-closure segfault in `FrameTransformClient` (if running without the
  `FrameTransformServer`)
* Added timeout check for ROS timed transforms in `FrameTransformClient`.
  Beware: we are currently using yarp time, not ros timestamps


### Tools

#### `yarprobotinterface`

* Print a warning when when parenthesis are not balanced and added protection
  against syntax errors (#832).
* Added option `all` to attach to all yarprobotinterface devices (used by
  `RobotDescriptionServer`).

#### `yarpidl_rosmsg`

* Fixed an issues when working with custom, nested ros messages.


### GUIs

* Replaced `QT_DEVICE_PIXEL_RATIO` with `Qt::AA_EnableHighDpiScaling` when
  supported by the installed Qt5 version. (#837, #1122, #1038, #1267)

#### `yarpmotorgui`

* The number of parts is no longer hardcoded.
* It is now possible to close the gui using CTRL+C.
* Fixed issue preventing correct save operation of position sequences.

#### `yarpmanager`

* Sub-folders are now automatically loaded by default.
* Opening single application multiple times is no longer allowed (#1007).


### Devices

#### `laserFromDepth`

* Added horizontal flip to align angle direction.
* Added distortion to simulate RGBD devices distance calculation method.

#### `RGBDSensorWrapper`

* Fixed deadlock when closing device.
* Fixed device failure not detected at startup.

#### `imuBosch_BNO055`

* Fixed the sharing of data between the `run()` and `read()` methods.




Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.68..v2.3.70`):

```
   344	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
   122	Nicolò Genesio <nicolo.genesio@iit.it>
    98	Marco Randazzo <marco.randazzo@iit.it>
    80	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
    40	Alberto Cardellino <alberto.cardellino@iit.it>
    19	Silvio Traversaro <silvio.traversaro@iit.it>
    15	Ali Paikan <ali.paikan@iit.it>
    14	Francesco Romano <francesco.romano@iit.it>
    10	Bartek Łukawski <bwmn.peter@gmail.com>
     9	Claudio Fantacci <claudio.fantacci@iit.it>
     9	Matteo Brunettini <matteo.brunettini@iit.it>
     7	Ugo Pattacini <ugo.pattacini@iit.it>
     6	Diego Ferigo <diego.ferigo@iit.it>
     5	Lorenzo Natale <lorenzo.natale@iit.it>
     5	Massimo Regoli <massimo.regoli@iit.it>
     4	Juan G. Victores <jcgvicto@gmail.com>
     3	Aiko Dinale <aiko.dinale@iit.it>
     3	Tobias Fischer <t.fischer@imperial.ac.uk>
     2	Bertrand Higy <bertrand.higy@iit.it>
     2	Valentina Gaggero <valentina.gaggero@iit.it>
     1	Alessandro Scalzo <alessandro.scalzo@iit.it>
     1	Giovanni Saponaro <gsaponaro@isr.ist.utl.pt>
     1	Giulia Vezzani <giulia.vezzani@iit.it>
     1	Vítor Galvão <info@vitorgalvao.com>
     1	Zero King <l2dy@icloud.com>
```
