# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from akkaserverless.akkaserverless.component.replicatedentity import replicated_entity_pb2 as akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2


class ReplicatedEntitiesStub(object):
    """Replicated Entities Protocol

    Note that while this protocol provides support for replicated entities, the data
    types sent across the protocol are not replicated entities themselves. It is the
    responsibility of the Akka Serverless proxy to implement the replicated entities,
    merge functions, vector clocks etc, not the user function. The user function
    need only hold the current value in memory, and this protocol sends deltas to the
    user function to update its in memory value as necessary. These deltas have no
    way of dealing with conflicts, hence it is important that the Akka Serverless proxy
    always knows what the state of the user function's in memory value is before
    sending a delta. If the Akka Serverless proxy is not sure what the value is, eg
    because it has just sent an operation to the user function which may have updated its
    value as a result, the proxy should wait until it gets the result of the operation
    back, to ensure its in memory value is in sync with the user function so that
    it can calculate deltas that won't conflict.

    The user function is expected to update its value both as the result of
    receiving deltas from the proxy, as well as when it sends deltas. It must not
    update its value in any other circumstance, updating the value in response to
    any other stimuli risks the value becoming out of sync with the Akka
    Serverless proxy. The user function will not be sent back deltas as a result
    of its own changes.

    An invocation of handle is made for each entity being handled. It may be kept
    alive and used to handle multiple commands, and may subsequently be
    terminated if that entity becomes idle, or if the entity is deleted. Shutdown
    is typically done for efficiency reasons, unless the entity is explicitly
    deleted, and a terminated handle stream does not mean the proxy has stopped
    tracking the state of the entity in its memory.

    Special care must be taken when working with maps and sets. The keys/values
    are google.protobuf.Any, which encodes the value as binary protobuf, however,
    serialized protobufs are not stable, two semantically equal objects could
    encode to different bytes. It is the responsibility of the user function to
    ensure that stable encodings are used.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Handle = channel.stream_stream(
                '/akkaserverless.component.replicatedentity.ReplicatedEntities/Handle',
                request_serializer=akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamIn.SerializeToString,
                response_deserializer=akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamOut.FromString,
                )


class ReplicatedEntitiesServicer(object):
    """Replicated Entities Protocol

    Note that while this protocol provides support for replicated entities, the data
    types sent across the protocol are not replicated entities themselves. It is the
    responsibility of the Akka Serverless proxy to implement the replicated entities,
    merge functions, vector clocks etc, not the user function. The user function
    need only hold the current value in memory, and this protocol sends deltas to the
    user function to update its in memory value as necessary. These deltas have no
    way of dealing with conflicts, hence it is important that the Akka Serverless proxy
    always knows what the state of the user function's in memory value is before
    sending a delta. If the Akka Serverless proxy is not sure what the value is, eg
    because it has just sent an operation to the user function which may have updated its
    value as a result, the proxy should wait until it gets the result of the operation
    back, to ensure its in memory value is in sync with the user function so that
    it can calculate deltas that won't conflict.

    The user function is expected to update its value both as the result of
    receiving deltas from the proxy, as well as when it sends deltas. It must not
    update its value in any other circumstance, updating the value in response to
    any other stimuli risks the value becoming out of sync with the Akka
    Serverless proxy. The user function will not be sent back deltas as a result
    of its own changes.

    An invocation of handle is made for each entity being handled. It may be kept
    alive and used to handle multiple commands, and may subsequently be
    terminated if that entity becomes idle, or if the entity is deleted. Shutdown
    is typically done for efficiency reasons, unless the entity is explicitly
    deleted, and a terminated handle stream does not mean the proxy has stopped
    tracking the state of the entity in its memory.

    Special care must be taken when working with maps and sets. The keys/values
    are google.protobuf.Any, which encodes the value as binary protobuf, however,
    serialized protobufs are not stable, two semantically equal objects could
    encode to different bytes. It is the responsibility of the user function to
    ensure that stable encodings are used.
    """

    def Handle(self, request_iterator, context):
        """After invoking handle, the first message sent will always be a
        ReplicatedEntityInit message, containing the entity ID, and, if it exists or
        is available, a delta for the initial state of the entity. After that, one or
        more commands may be sent, as well as deltas as they arrive.

        The user function must respond with one reply per command in. They do not
        necessarily have to be sent in the same order that the commands were sent,
        the command ID is used to correlate commands to replies.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ReplicatedEntitiesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Handle': grpc.stream_stream_rpc_method_handler(
                    servicer.Handle,
                    request_deserializer=akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamIn.FromString,
                    response_serializer=akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamOut.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'akkaserverless.component.replicatedentity.ReplicatedEntities', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ReplicatedEntities(object):
    """Replicated Entities Protocol

    Note that while this protocol provides support for replicated entities, the data
    types sent across the protocol are not replicated entities themselves. It is the
    responsibility of the Akka Serverless proxy to implement the replicated entities,
    merge functions, vector clocks etc, not the user function. The user function
    need only hold the current value in memory, and this protocol sends deltas to the
    user function to update its in memory value as necessary. These deltas have no
    way of dealing with conflicts, hence it is important that the Akka Serverless proxy
    always knows what the state of the user function's in memory value is before
    sending a delta. If the Akka Serverless proxy is not sure what the value is, eg
    because it has just sent an operation to the user function which may have updated its
    value as a result, the proxy should wait until it gets the result of the operation
    back, to ensure its in memory value is in sync with the user function so that
    it can calculate deltas that won't conflict.

    The user function is expected to update its value both as the result of
    receiving deltas from the proxy, as well as when it sends deltas. It must not
    update its value in any other circumstance, updating the value in response to
    any other stimuli risks the value becoming out of sync with the Akka
    Serverless proxy. The user function will not be sent back deltas as a result
    of its own changes.

    An invocation of handle is made for each entity being handled. It may be kept
    alive and used to handle multiple commands, and may subsequently be
    terminated if that entity becomes idle, or if the entity is deleted. Shutdown
    is typically done for efficiency reasons, unless the entity is explicitly
    deleted, and a terminated handle stream does not mean the proxy has stopped
    tracking the state of the entity in its memory.

    Special care must be taken when working with maps and sets. The keys/values
    are google.protobuf.Any, which encodes the value as binary protobuf, however,
    serialized protobufs are not stable, two semantically equal objects could
    encode to different bytes. It is the responsibility of the user function to
    ensure that stable encodings are used.
    """

    @staticmethod
    def Handle(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(request_iterator, target, '/akkaserverless.component.replicatedentity.ReplicatedEntities/Handle',
            akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamIn.SerializeToString,
            akkaserverless_dot_component_dot_replicatedentity_dot_replicated__entity__pb2.ReplicatedEntityStreamOut.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
