/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.StreamDelegator;
import Trace.TraceFile;
import Trace.TraceServerClient;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceLoader
extends Observable
implements Observer {
    public static boolean LOCAL_MODE = false;
    private static int MAX_SIMULTANEOUS_REQUESTS = 3;
    private int slots_available = MAX_SIMULTANEOUS_REQUESTS;
    private boolean finished = false;
    private Iterator<String> iterator;
    private int total_job_size;
    private int jobs_left;
    private TraceServerClient tsc;

    public TraceLoader(Collection<String> traces) {
        this.fetch(traces);
    }

    public TraceLoader(Collection<String> traces, Observer o) {
        this.addObserver(o);
        this.fetch(traces);
    }

    public void fetch(Collection<String> traces) {
        this.tsc = new TraceServerClient();
        this.total_job_size = this.jobs_left = traces.size();
        this.iterator = traces.iterator();
        this.fill_slots();
    }

    private void fill_slots() {
        while (this.slots_available > 0 && this.iterator.hasNext()) {
            String trace = this.iterator.next();
            if (LOCAL_MODE) {
                TraceFile traceFile = new TraceFile(trace, this);
            } else {
                this.tsc.get_trace(Integer.parseInt(trace), this);
            }
            --this.slots_available;
        }
    }

    public static void main(String[] argv) {
        StreamDelegator.set_local(true);
        Vector<String> v = new Vector<String>();
        v.add("ye50d01.s1");
        v.add("ye50d01.r1");
        new TraceLoader(v);
    }

    public boolean is_finished() {
        return this.jobs_left == 0;
    }

    public int get_percent_finished() {
        return (this.total_job_size - this.jobs_left) * 100 / this.total_job_size;
    }

    private void receive_trace(TraceFile t) {
        --this.jobs_left;
        this.setChanged();
        this.notifyObservers(t);
        ++this.slots_available;
        this.fill_slots();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof TraceFile && arg == null) {
            TraceFile t = (TraceFile)o;
            this.receive_trace(t);
        }
    }
}

