/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.CopyNumberSummaryInfo2;
import TCGA.HelpLauncher;
import TCGA.Options;
import TCGA.PopupListener;
import TCGA.SummaryPanelCNSI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class SummaryPanelAnyVariation
extends SummaryPanelCNSI {
    private Color COLOR = Color.black;
    private Color COLOR_BACKGROUND = Color.white;
    private static final String LABEL_HELP = "Help: variation panel";

    public SummaryPanelAnyVariation(CopyNumberSummaryInfo2 cnsi, int raw_width) {
        super(cnsi, raw_width);
        this.setToolTipText("Frequency of any change");
        JPopupMenu jpm = new JPopupMenu();
        jpm.add(HelpLauncher.generate_jmenuitem(LABEL_HELP, "panel_any_variation"));
        new PopupListener(this, jpm);
    }

    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.COLOR_BACKGROUND);
        g.fillRect(0, 0, d.width, d.height);
        float scale_by = (float)d.height / 100.0f;
        ArrayList<Point> any = this.digest_array(this.cnsi.percent_showing_any, this.cnsi.max_percent_showing_any, scale_by, Options.NORMALIZE_SUMMARY_PANEL_PEAKS);
        g.setColor(this.COLOR);
        this.render_array(g, any, d.height, false);
    }

    public String getToolTipText(MouseEvent e) {
        String upper_label = Options.COMMENT_OPTIONS.get("high_label");
        String lower_label = Options.COMMENT_OPTIONS.get("low_label");
        String label = "";
        label = upper_label != null && lower_label != null ? upper_label + " or " + lower_label : "any change";
        return this.generate_tooltip(e.getPoint(), label, this.cnsi.percent_showing_any);
    }
}

