/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomicLocation;
import java.math.BigDecimal;
import java.util.ArrayList;

public class GISTICPeak {
    public String sub_type;
    public String data_type;
    public GenomicLocation peak_pos;
    public ArrayList<String> markers;
    public BigDecimal q;
    public BigDecimal z_score;
    public BigDecimal q_cooked = null;
    private static final String MAGIC_ZSCORE = "_Zsc";

    public GISTICPeak(String s) {
        String[] f = s.split(",");
        this.z_score = null;
        if (f.length >= 5) {
            this.sub_type = f[0];
            this.data_type = f[1];
            this.q = new BigDecimal(f[2]);
            this.peak_pos = new GenomicLocation(f[3]);
            if (this.sub_type == null) {
                this.sub_type = "";
            }
            this.markers = new ArrayList();
            for (int i = 4; i < f.length; ++i) {
                String v = new String(f[i]);
                if (v.equals(MAGIC_ZSCORE)) {
                    this.z_score = new BigDecimal(f[++i]);
                    continue;
                }
                this.markers.add(v);
            }
        } else {
            System.err.println("ERROR: gistic peak must be at least 5");
        }
    }

    public String get_chromosome() {
        return this.peak_pos.chromosome;
    }
}

