/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.BinIndex;
import TCGA.ByteComparator;
import TCGA.ByteComparatorGT;
import TCGA.ChromDecoratorPanel;
import TCGA.DefaultTableModelReadOnly;
import TCGA.GeneDatabase;
import TCGA.GeneInfo;
import TCGA.GenomicSample;
import TCGA.HashMapArrayList;
import TCGA.HeatmapConfiguration;
import TCGA.RubberBandSelection;
import TCGA.TableTools;
import TCGA.URLLauncher;
import TCGA.WebTools;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class FrequencyReporter
extends Observable
implements Runnable {
    private HeatmapConfiguration config;
    private JTable table;
    private Vector marker_list;
    private ChromDecoratorPanel cdp;

    public FrequencyReporter(HeatmapConfiguration config, ChromDecoratorPanel cdp) {
        this.config = config;
        this.cdp = cdp;
        new Thread(this).start();
    }

    public void run() {
        int i;
        ByteComparatorGT bc = new ByteComparatorGT(0);
        HashMapArrayList percent_altered = new HashMapArrayList();
        String[] headers = this.config.gm.get_headers();
        int[] counts = new int[headers.length];
        int row_count = this.config.gm.get_row_count();
        for (GenomicSample gs : this.config.gm.get_rows()) {
            for (i = 0; i < headers.length; ++i) {
                if (!((ByteComparator)bc).compare(gs.copynum_data[i])) continue;
                int n = i;
                counts[n] = counts[n] + 1;
            }
        }
        for (i = 0; i < headers.length; ++i) {
            percent_altered.put(Float.valueOf((float)counts[i] / (float)row_count), headers[i]);
        }
        ArrayList percents = new ArrayList(percent_altered.keySet());
        Collections.sort(percents);
        Collections.reverse(percents);
        int count = 0;
        GeneDatabase db = GeneDatabase.get_gene_database();
        Vector rows = new Vector();
        Vector<String> columns = new Vector<String>();
        this.marker_list = new Vector();
        columns.add("percent");
        columns.add("marker");
        columns.add("description");
        columns.add("Entrez");
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        for (Float percent : percents) {
            if (!(percent.floatValue() > 0.0f)) continue;
            ArrayList markers = percent_altered.get(percent);
            Collections.sort(markers);
            for (String marker : markers) {
                Vector<String> row = new Vector<String>();
                rows.add(row);
                GeneInfo gi = db.get_gene_by_symbol(marker);
                String desc = gi == null ? "UNKNOWN" : gi.description;
                String html = "<html><a href=\"http://www.bogus.com/\">" + marker + "</html>";
                row.add(nf.format(percent.floatValue() * 100.0f));
                row.add(html);
                row.add(desc);
                row.add(html);
                this.marker_list.add(marker);
            }
            ++count;
        }
        JFrame jf = new JFrame("Frequency report");
        jf.setLayout(new BorderLayout());
        this.table = new JTable(new DefaultTableModelReadOnly(rows, (Vector)columns));
        TableTools.calcColumnWidths(this.table);
        this.table.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                int col = FrequencyReporter.this.table.getSelectedColumn();
                int row = FrequencyReporter.this.table.getSelectedRow();
                String marker = (String)FrequencyReporter.this.marker_list.get(row);
                if (col == 1) {
                    BinIndex bi = new BinIndex(((FrequencyReporter)FrequencyReporter.this).config.gm);
                    int wanted = bi.find(marker);
                    if (wanted != -1) {
                        RubberBandSelection rbs = FrequencyReporter.this.cdp.get_selection();
                        rbs.set_selection(((FrequencyReporter)FrequencyReporter.this).config.gm.generate_selection(wanted));
                        FrequencyReporter.this.cdp.zoom_to_selection();
                    }
                } else if (col == 3) {
                    URLLauncher.launch_url(WebTools.entrez_gene_link(marker), "eg");
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        jf.add("Center", new JScrollPane(this.table));
        jf.pack();
        jf.setVisible(true);
    }
}

