/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.ColorManager;
import TCGA.DividerSet;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.Options;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DividerManager {
    private ArrayList<Cluster> cluster_list = null;
    private GenomicMeasurement gm = null;
    private DividerSet cluster_dividers;
    private DividerSet patient_dividers;

    public DividerManager(GenomicMeasurement gm) {
        this.gm = gm;
        this.setup();
    }

    private void setup() {
        this.patient_dividers = new DividerSet();
        this.patient_dividers.color = Color.lightGray;
        this.patient_dividers.min_weight = 0.1f;
        this.patient_dividers.max_weight = 1.0f;
        this.patient_dividers.full_weight_at_zoom = 8.0f;
        this.cluster_dividers = new DividerSet();
        this.cluster_dividers.color = Color.yellow;
        this.cluster_dividers.min_weight = 0.3f;
        this.cluster_dividers.max_weight = 1.1f;
        this.cluster_dividers.full_weight_at_zoom = 8.0f;
    }

    public void set_cluster_list(ArrayList<Cluster> cluster_list) {
        this.cluster_list = cluster_list;
        this.rebuild_cluster_dividers();
    }

    public DividerSet get_cluster_dividers() {
        this.cluster_dividers.color = this.gm.get_color_manager().get_cluster_divider_color();
        return this.cluster_dividers;
    }

    public void clear_cluster_dividers() {
        this.cluster_list = null;
        this.cluster_dividers.clear();
    }

    public DividerSet get_patient_dividers() {
        ColorManager cm = this.gm.get_color_manager();
        if (cm != null) {
            this.patient_dividers.color = cm.get_patient_divider_color();
        }
        return this.patient_dividers;
    }

    public void rebuild_patient_dividers() {
        this.patient_dividers.clear();
        int row = 0;
        String last_id = null;
        int id_count = 0;
        boolean singles_only = true;
        for (GenomicSample gs : this.gm.get_visible_rows()) {
            if (gs.patient_id != null && last_id != null) {
                if (gs.patient_id.equals(last_id)) {
                    ++id_count;
                } else {
                    this.patient_dividers.add(row);
                    if (id_count > 1) {
                        singles_only = false;
                    }
                    id_count = 1;
                }
            }
            last_id = gs.patient_id;
            ++row;
        }
        this.patient_dividers.add(row);
        if (id_count > 1) {
            singles_only = false;
        }
        if (singles_only && Options.SUPPRESS_DIVIDERS_IF_ALL_SINGLETONS) {
            this.patient_dividers.clear();
        }
    }

    public HashSet<String> get_last_patients_in_clusters() {
        HashSet<String> results = new HashSet<String>();
        if (this.cluster_list != null) {
            for (Cluster c : this.cluster_list) {
                ArrayList<GenomicSample> sd = c.get_sample_data();
                results.add(sd.get((int)(sd.size() - 1)).patient_id);
            }
        }
        return results;
    }

    public void rebuild_cluster_dividers() {
        this.cluster_dividers.clear();
        if (this.cluster_list != null) {
            String last_id = null;
            int di = 0;
            HashSet<String> last_patient_in_cluster = this.get_last_patients_in_clusters();
            for (GenomicSample gs : this.gm.get_visible_rows()) {
                if (last_id != null && !gs.patient_id.equals(last_id) && last_patient_in_cluster.contains(last_id)) {
                    this.cluster_dividers.add(di);
                }
                last_id = gs.patient_id;
                ++di;
            }
        }
    }
}

