/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.ButtonLabelCallback;
import TCGA.BooleanOption;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class JMenuHelper {
    private JMenuBar mb = new JMenuBar();
    private HashMap<String, Integer> string2vk;
    private JMenu jm_last = null;
    private ButtonLabelCallback blc = null;
    private ArrayList<JMenu> jmenu_stack = null;

    public JMenuHelper(JFrame jf) {
        jf.setJMenuBar(this.mb);
        this.setup();
    }

    public void set_blc(ButtonLabelCallback blc) {
        this.blc = blc;
    }

    private void setup() {
        this.jmenu_stack = new ArrayList();
        this.string2vk = new HashMap();
        try {
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                String s = Character.toString(c).toUpperCase();
                Field field = Class.forName("java.awt.event.KeyEvent").getField("VK_" + s);
                this.string2vk.put(s, field.getInt(null));
            }
        }
        catch (Exception e) {
            System.err.println("oh the humanity: failed VK lookup!");
        }
    }

    public JMenu enter_submenu(String label) {
        JMenu jm = new JMenu(label);
        this.jm_last.add(jm);
        this.jmenu_stack.add(this.jm_last);
        this.jm_last = jm;
        return jm;
    }

    public void pop_submenu() {
        this.jm_last = this.jmenu_stack.remove(this.jmenu_stack.size() - 1);
    }

    public JMenu add_jmenu(String label, boolean auto_mnemonic) {
        JMenu jm = new JMenu(label);
        if (auto_mnemonic) {
            this.auto_mnemonic(jm, label);
        }
        this.mb.add(jm);
        this.jm_last = jm;
        return jm;
    }

    private void auto_mnemonic(AbstractButton ab, String label) {
        String first = label.substring(0, 1).toUpperCase();
        if (this.string2vk.containsKey(first)) {
            ab.setMnemonic(this.string2vk.get(first));
        } else {
            System.err.println("ERROR: can't find VK for " + first);
        }
    }

    public JMenuItem add_jmenuitem(String label, boolean auto_mnemonic) {
        JMenuItem mi = new JMenuItem(label);
        if (auto_mnemonic) {
            this.auto_mnemonic(mi, label);
        }
        if (this.blc != null) {
            this.blc.add(mi);
        }
        this.jm_last.add(mi);
        return mi;
    }

    public JMenuItem add(JMenuItem jmi) {
        if (this.blc != null) {
            this.blc.add(jmi);
        }
        this.jm_last.add(jmi);
        return jmi;
    }

    public void add_separator() {
        this.jm_last.add(new JSeparator());
    }

    public JCheckBoxMenuItem add_jcheckbox(BooleanOption state, Observer o) {
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(state.get_label(), state.booleanValue());
        state.set_button(cb);
        if (o != null) {
            state.addObserver(o);
        }
        this.jm_last.add(cb);
        return cb;
    }

    public JRadioButtonMenuItem add_jradiobutton(BooleanOption state, ButtonGroup bg, Observer o) {
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem(state.get_label(), state.booleanValue());
        bg.add(rb);
        state.set_button(rb);
        if (o != null) {
            state.addObserver(o);
        }
        this.jm_last.add(rb);
        return rb;
    }
}

