/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Str {
    private static final String valid_number_characters = "0123456789";

    public static String basename(String s) {
        int len = s.length();
        int last = -1;
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != '/') continue;
            last = i;
        }
        if (last == -1) {
            return s;
        }
        return s.substring(last + 1);
    }

    public static String join(Enumeration e) {
        return Str.join(",", e);
    }

    public static String join(String delim, Collection c) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        for (Object o : c) {
            if (count++ > 0) {
                sb.append(delim);
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static String join(String delim, Enumeration e) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            if (count++ > 0) {
                sb.append(delim);
            }
            sb.append(e.nextElement().toString());
        }
        return sb.toString();
    }

    public static String join(String delim, Iterator i) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            if (count++ > 0) {
                sb.append(delim);
            }
            sb.append(i.next().toString());
        }
        return sb.toString();
    }

    public static String join(String delim, String[] list) {
        return Str.join(delim, list, 0);
    }

    public static String join(String delim, String[] list, int max_fields) {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        int max = list.length;
        if (max_fields > 0) {
            max = max_fields;
        }
        for (int i = 0; i < max; ++i) {
            if (count++ > 0) {
                sb.append(delim);
            }
            sb.append(list[i]);
        }
        return sb.toString();
    }

    public static String double_print(double d, int places) {
        String result = new Double(d).toString();
        int max_len = result.indexOf(".") + places + 1;
        if (result.length() > max_len) {
            result = result.substring(0, max_len);
        }
        return result;
    }

    public static boolean is_genbank_accession(String token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            char c = token.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c) && i <= 1) continue;
            if (Character.isDigit(c)) {
                if (i >= 1) continue;
                return false;
            }
            if (c == '_') {
                if (i == 2) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static Vector read_lines(DataInputStream d) {
        Vector<String> lines = new Vector<String>();
        InputStreamReader isr = new InputStreamReader(d);
        BufferedReader d2 = new BufferedReader(isr);
        try {
            String line;
            while ((line = d2.readLine()) != null) {
                lines.addElement(line);
            }
        }
        catch (IOException e) {
            System.out.println("eek: " + e);
        }
        return lines;
    }

    public static String unpadded(String s) {
        StringBuffer sb = new StringBuffer(s);
        StringBuffer unpadded = new StringBuffer();
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '*') continue;
            unpadded.append(c);
        }
        return unpadded.toString();
    }

    public static String reverse_complement(String s) {
        StringBuffer rc = new StringBuffer(s).reverse();
        int len = rc.length();
        for (int i = 0; i < len; ++i) {
            char c;
            switch (rc.charAt(i)) {
                case 'a': {
                    c = 't';
                    break;
                }
                case 'A': {
                    c = 'T';
                    break;
                }
                case 'c': {
                    c = 'g';
                    break;
                }
                case 'C': {
                    c = 'G';
                    break;
                }
                case 'g': {
                    c = 'c';
                    break;
                }
                case 'G': {
                    c = 'C';
                    break;
                }
                case 't': {
                    c = 'a';
                    break;
                }
                case 'T': {
                    c = 'A';
                    break;
                }
                case '*': {
                    c = '*';
                    break;
                }
                case 'n': {
                    c = 'n';
                    break;
                }
                case 'N': {
                    c = 'N';
                    break;
                }
                case 'x': {
                    c = 'x';
                    break;
                }
                case 'X': {
                    c = 'X';
                    break;
                }
                default: {
                    c = rc.charAt(i);
                    System.out.println("reverse: warning, don't know how to rc " + c);
                }
            }
            rc.setCharAt(i, c);
        }
        return rc.toString();
    }

    public static int count_instances_of_char(String s, char c) {
        int index;
        int count = 0;
        int last = 0;
        while ((index = s.indexOf(c, last)) != -1) {
            ++count;
            last = index + 1;
        }
        return count;
    }

    public static void main(String[] argv) {
        System.err.println(Str.comma_format(900000));
        System.err.println(Str.comma_format(1000000));
    }

    public static String comma_format(int v) {
        String vs = Integer.toString(v);
        int len = vs.length();
        int count = 0;
        StringBuffer sb = new StringBuffer();
        boolean comma_needed = false;
        for (int i = len - 1; i >= 0; --i) {
            if (comma_needed) {
                sb.append(',');
                comma_needed = false;
            }
            sb.append(vs.charAt(i));
            if (++count % 3 != 0) continue;
            comma_needed = true;
        }
        return sb.reverse().toString();
    }

    public static int parseInt(String s) throws NumberFormatException {
        int result = 0;
        int len = s.length();
        boolean is_negative = false;
        if (s == null) {
            throw new NumberFormatException("null string");
        }
        if (len == 0) {
            throw new NumberFormatException("empty string");
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int index = valid_number_characters.indexOf(c);
            if (index == -1) {
                if (i == 0) {
                    if (c == '-') {
                        is_negative = true;
                        continue;
                    }
                    if (c == '+') continue;
                    throw new NumberFormatException("invalid character " + c);
                }
                throw new NumberFormatException("invalid character " + c);
            }
            if (result > 0) {
                result *= 10;
            }
            result += index;
        }
        if (is_negative) {
            result *= -1;
        }
        return result;
    }

    public static String trim_whitespace(String s) {
        int end_index;
        char c;
        int start_index;
        int len = s.length();
        for (start_index = 0; start_index < len && ((c = s.charAt(start_index)) == ' ' || c == '\t'); ++start_index) {
        }
        for (end_index = len - 1; end_index >= 0 && ((c = s.charAt(end_index)) == ' ' || c == '\t'); --end_index) {
        }
        return s.substring(start_index, end_index + 1);
    }

    public static String unquote(String s) {
        int first = s.indexOf(34);
        int last = s.lastIndexOf(34);
        int len = s.length();
        if (first == 0 && last == len - 1) {
            return s.substring(first + 1, last);
        }
        first = s.indexOf(39);
        last = s.lastIndexOf(39);
        if (first == 0 && last == len - 1) {
            return s.substring(first + 1, last);
        }
        return s;
    }

    public static Hashtable delimited_string_to_hash(String s, String delimiter) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration e = Str.tokenize_string(s, delimiter);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (e.hasMoreElements()) {
                String value = (String)e.nextElement();
                result.put(key, value);
                continue;
            }
            System.err.println("WARNING: no value for key " + key);
            break;
        }
        return result;
    }

    public static Vector FileToVector(String filename) {
        Vector<String> lines = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            lines = new Vector<String>();
            while ((line = br.readLine()) != null) {
                lines.addElement(line);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("can't find file " + filename + " !");
        }
        catch (IOException e) {
            System.err.println("i/o exception!");
        }
        return lines;
    }

    public static Enumeration tokenize_string(String thing, String token) {
        int delim_len = token.length();
        if (delim_len > 1) {
            Str.die("delim_len > 1 untested");
        }
        Vector<String> tokens = new Vector<String>();
        Vector<Integer> stops = new Vector<Integer>();
        stops.addElement(new Integer(0));
        int i = thing.indexOf(token);
        while (i > -1) {
            stops.addElement(new Integer(i));
            i = thing.indexOf(token, i + 1);
        }
        stops.addElement(new Integer(thing.length()));
        int slen = stops.size();
        for (i = 0; i < slen - 1; ++i) {
            int hither = (Integer)stops.elementAt(i);
            if (i > 0) {
                hither += delim_len;
            }
            int yon = (Integer)stops.elementAt(i + 1);
            tokens.addElement(thing.substring(hither, yon));
        }
        return tokens.elements();
    }

    private static void die(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static String url_query_string(Hashtable params) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + value);
        }
        return sb.toString();
    }

    public static String float_decimal_format(double d, int places) {
        return String.format("%." + places + "f", d);
    }

    public static String float_decimal_format(float f, int places) {
        return String.format("%." + places + "f", Float.valueOf(f));
    }
}

