/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.GridItem;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class Grid
extends Canvas {
    private Vector x_labels;
    private Vector y_labels;
    private FontMetrics fm;
    private int x_cell_width;
    private int y_cell_width;
    private int y_cell_height;
    private int x_cell_origin;
    private int y_cell_origin;
    private int x_cell_count;
    private int y_cell_count;
    private int font_height;
    private int x_label_border;
    private GridItem[][] grid_items = null;
    private static Color BACKGROUND_COLOR = new Color(238, 203, 173);

    public Grid(Vector x_labels, Vector y_labels, Font font) {
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.font_height = this.fm.getHeight();
        this.y_cell_origin = this.y_cell_height = this.font_height * 2;
        this.x_labels = x_labels;
        this.y_labels = y_labels;
        this.x_cell_width = (int)((double)this.get_max_stringlen(x_labels) * 1.2);
        this.y_cell_width = (int)((double)this.get_max_stringlen(y_labels) * 1.8);
        this.x_label_border = (int)((double)this.y_cell_width * 0.1);
        this.x_cell_origin = this.y_cell_width + this.x_label_border;
        this.x_cell_count = x_labels.size();
        this.y_cell_count = y_labels.size();
        int max_x = this.x_cell_origin + this.x_cell_width * (this.x_cell_count + 1);
        int max_y = this.y_cell_origin + this.y_cell_height * (this.y_cell_count + 1);
        this.setSize(max_x, max_y);
    }

    public void paint(Graphics g) {
        String label;
        int i;
        g.setColor(BACKGROUND_COLOR);
        Dimension d = this.getSize();
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        for (i = 0; i < this.x_cell_count; ++i) {
            label = (String)this.x_labels.elementAt(i);
            g.drawString(label, this.center_x_point(i, label), this.y_cell_origin - this.font_height / 2);
        }
        for (i = 0; i < this.y_cell_count; ++i) {
            label = (String)this.y_labels.elementAt(i);
            int x = this.x_cell_origin - this.fm.stringWidth(label) - this.x_label_border;
            int y = this.center_y_point(i);
            g.drawString(label, x, y);
        }
        for (i = 0; i <= this.x_cell_count; ++i) {
            int x = this.x_cell_origin + this.x_cell_width * i;
            g.drawLine(x, this.y_cell_origin, x, this.y_cell_origin + this.y_cell_count * this.y_cell_height);
        }
        for (i = 0; i <= this.y_cell_count; ++i) {
            int y = this.y_cell_origin + this.y_cell_height * i;
            g.drawLine(this.x_cell_origin, y, this.x_cell_origin + this.x_cell_width * this.x_cell_count, y);
        }
        if (this.grid_items != null) {
            for (i = 0; i < this.x_cell_count; ++i) {
                for (int j = 0; j < this.y_cell_count; ++j) {
                    GridItem gi = this.grid_items[i][j];
                    g.setColor(gi.color);
                    g.drawString(gi.data, this.center_x_point(i, gi.data), this.center_y_point(j));
                }
            }
        }
    }

    public void set_grid_items(GridItem[][] grid_items) {
        this.grid_items = grid_items;
        this.repaint();
    }

    private int get_max_stringlen(Vector v) {
        int max = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int i = this.fm.stringWidth(s);
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    private int center_x_point(int index, String s) {
        return this.x_cell_origin + this.x_cell_width * index + this.x_cell_width / 2 - this.fm.stringWidth(s) / 2;
    }

    private int center_y_point(int index) {
        return this.y_cell_origin + this.y_cell_height * index + this.y_cell_height / 2;
    }
}

