/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketMap<V> {
    HashMap<Integer, ArrayList<V>> map = new HashMap();
    private int hash_size = 10000;

    public BucketMap(int hash_size) {
        this.hash_size = hash_size;
    }

    public void add(V value, int pos) {
        int key = pos / this.hash_size;
        this.bucket_add(value, key);
    }

    public void add(V value, int start, int end) {
        int start_key = start / this.hash_size;
        int end_key = end / this.hash_size;
        for (int i = start_key; i <= end_key; ++i) {
            this.bucket_add(value, i);
        }
    }

    private void bucket_add(V value, Integer key) {
        ArrayList<Object> bucket = this.map.get(key);
        if (bucket == null) {
            bucket = new ArrayList();
            this.map.put(key, bucket);
        }
        bucket.add(value);
    }

    public ArrayList<V> find_by_position(int pos) {
        ArrayList<V> results = new ArrayList<V>();
        int key = pos / this.hash_size;
        ArrayList<V> bucket = this.map.get(key);
        if (bucket != null) {
            results.addAll(bucket);
        }
        return results;
    }

    public ArrayList<V> find_by_position(int start, int end) {
        ArrayList<V> results = new ArrayList<V>();
        int start_key = start / this.hash_size;
        int end_key = end / this.hash_size;
        for (int i = start_key; i <= end_key; ++i) {
            ArrayList<V> bucket = this.map.get(i);
            if (bucket == null) continue;
            results.addAll(bucket);
        }
        return results;
    }

    public static void main(String[] argv) {
        BucketMap<String> bm = new BucketMap<String>(10000);
        String test_border = "border";
        bm.add(test_border, 9000, 11000);
        ArrayList hits = bm.find_by_position(80000);
        System.err.println("hits=" + hits);
    }
}

